/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.connection.preload;

import cacheperf.comparisons.connection.preload.TimingClassLoader;
import com.gemstone.gemfire.internal.NanoTimer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Preload {
    String resourceFile;
    PrintWriter pw;
    boolean initializeClasses;
    boolean verbose;
    ClassLoader loader;

    public Preload(String resourceFile, boolean useTimingClassLoader, boolean initializeClasses, String outputFile, boolean verbose) throws IOException {
        this.resourceFile = resourceFile;
        this.initializeClasses = initializeClasses;
        this.pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile, true)));
        this.verbose = verbose;
        this.loader = useTimingClassLoader ? new TimingClassLoader(this.pw, verbose) : this.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadResource() throws IOException {
        this.pw.println("Preloading " + this.resourceFile + " using " + this.loader);
        long start = NanoTimer.getTime();
        try {
            if (this.resourceFile.indexOf(".jar") == -1) {
                this.preloadClassList();
            } else {
                this.preloadJar();
            }
            long elapsed = NanoTimer.getTime() - start;
            if (this.loader instanceof TimingClassLoader) {
                ((TimingClassLoader)this.loader).printBreakdown();
            }
            this.pw.println("Preloaded " + this.resourceFile + " in " + elapsed + " ns");
        }
        finally {
            this.pw.close();
        }
    }

    private void preloadJar() throws IOException {
        JarFile jarFile = new JarFile(this.resourceFile);
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            this.preloadJarEntry(en.nextElement());
        }
    }

    private void preloadJarEntry(Object obj) {
        JarEntry entry = (JarEntry)obj;
        String name = entry.getName();
        int classIndex = name.indexOf(".class");
        if (classIndex != -1) {
            long size = entry.getSize();
            String classFileName = name.replace('/', '.');
            String className = classFileName.substring(0, classIndex);
            this.preloadClass(className, size);
        }
    }

    private void preloadClassList() throws FileNotFoundException, IOException {
        String classList = this.getContentsWithSpace(this.resourceFile);
        StringTokenizer tokenizer = new StringTokenizer(classList, " ", false);
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            this.preloadClass(className, -1L);
        }
    }

    private void preloadClass(String className, long size) {
        if (this.verbose) {
            if (size == -1L) {
                this.pw.println("Loading " + className + "(" + size + " bytes)");
            } else {
                this.pw.println("Loading " + className);
            }
        }
        try {
            if (className.indexOf("AvailablePortTask") == -1 && className.indexOf("VMStats") == -1) {
                long start = NanoTimer.getTime();
                Class.forName(className, this.initializeClasses, this.loader);
                long elapsed = NanoTimer.getTime() - start;
                if (this.verbose) {
                    this.pw.println("Loaded " + className + " in " + elapsed + " ns");
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.pw.println("Class not found: " + className);
        }
    }

    private String getContentsWithSpace(String fn) throws FileNotFoundException, IOException {
        String s;
        StringBuffer buf = new StringBuffer(1000);
        BufferedReader br = new BufferedReader(new FileReader(fn));
        boolean firstLine = true;
        while ((s = br.readLine()) != null) {
            if (!firstLine) {
                buf.append(" ");
            }
            buf.append(s);
            firstLine = false;
        }
        br.close();
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            String usage = "cacheperf.comparisons.connection.preload.Preload <resourceFile> <useTimingClassLoader> <initializeClasses> <outputFile> <verbose>";
            throw new Exception(usage);
        }
        Preload p = new Preload(args[0], Boolean.valueOf(args[1]), Boolean.valueOf(args[2]), args[3], Boolean.valueOf(args[4]));
        p.preloadResource();
    }
}

