/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.dataFeed;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import cacheperf.comparisons.dataFeed.DataFeedPrms;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import java.util.List;
import objects.ObjectHelper;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;

public class DataFeedClient
extends CachePerfClient {
    boolean useFixedKeys;
    boolean useFixedVal;
    Object[] fixedKeys;
    Object fixedVal;
    public NanoTimer timer;
    private static HydraThreadLocal localusefixedkeys = new HydraThreadLocal();
    private static HydraThreadLocal localusefixedval = new HydraThreadLocal();
    private static HydraThreadLocal localfixedkeys = new HydraThreadLocal();
    private static HydraThreadLocal localfixedval = new HydraThreadLocal();
    private static HydraThreadLocal localtimer = new HydraThreadLocal();

    public static void feedDataTask() {
        DataFeedClient c = new DataFeedClient();
        c.initialize(3);
        c.feedData();
    }

    private void feedData() {
        boolean batchDone = false;
        int throttledOpsPerSec = DataFeedPrms.getThrottledOpsPerSec();
        if (throttledOpsPerSec > 0) {
            do {
                this.timer.reset();
                for (int i = 0; i < throttledOpsPerSec; ++i) {
                    batchDone = this.feed();
                }
                long remaining = 1000000000L - this.timer.reset();
                if (remaining <= 0L) continue;
                MasterController.sleepForMs((int)((double)remaining / 1000000.0));
            } while (!batchDone);
        } else {
            while (!(batchDone = this.feed())) {
            }
        }
    }

    private boolean feed() {
        int key = this.getNextKey();
        this.executeTaskTerminator();
        this.executeWarmupTerminator();
        this.feed(key);
        ++this.batchCount;
        ++this.count;
        ++this.keyCount;
        return this.executeBatchTerminator();
    }

    private void feed(int i) {
        long start = this.statistics.startPut();
        if (this.useFixedKeys) {
            if (this.useFixedVal) {
                ObjectHelper.resetTimestamp(this.fixedVal);
                this.cache.put(this.fixedKeys[i], this.fixedVal);
            } else {
                String objectType = CachePerfPrms.getObjectType();
                Object val = ObjectHelper.createObject(objectType, i);
                this.cache.put(this.fixedKeys[i], val);
            }
        } else {
            Object key = ObjectHelper.createName(this.keyType, i);
            if (this.useFixedVal) {
                ObjectHelper.resetTimestamp(this.fixedVal);
                this.cache.put(key, this.fixedVal);
            } else {
                String objectType = CachePerfPrms.getObjectType();
                Object val = ObjectHelper.createObject(objectType, i);
                this.cache.put(key, val);
            }
        }
        this.statistics.endPut(start, this.isMainWorkload, this.histogram);
    }

    public static void validateMessagesFailedQueuedTask() {
        DataFeedClient c = new DataFeedClient();
        c.validateMessagesFailedQueued();
    }

    private void validateMessagesFailedQueued() {
        String type = "CacheClientProxyStatistics";
        String stat = "messagesFailedQueued";
        long failures = this.getStatTotalCount(type, stat);
        String s = type + "." + stat + " = " + failures;
        if (failures != 0L) {
            throw new HydraRuntimeException(s);
        }
        DataFeedClient.log().info(s);
    }

    private long getStatTotalCount(String type, String stat) {
        String spec = "* " + type + " " + "* " + stat + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + "max";
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            Log.getLogWriter().warning("No stats found for " + spec);
            return 0L;
        }
        double failures = 0.0;
        for (int i = 0; i < psvs.size(); ++i) {
            PerfStatValue psv = (PerfStatValue)psvs.get(i);
            failures += psv.getMax();
        }
        return (long)failures;
    }

    @Override
    protected void initialize(int trimInterval) {
        super.initialize(trimInterval);
        this.useFixedKeys = this.useFixedKeys();
        if (this.useFixedKeys) {
            this.fixedKeys = this.getFixedKeys();
        }
        this.useFixedVal = this.useFixedVal();
        if (this.useFixedVal) {
            this.fixedVal = this.getFixedVal();
        }
        this.timer = this.getTimer();
    }

    private boolean useFixedKeys() {
        Boolean b = (Boolean)localusefixedkeys.get();
        if (b == null) {
            b = DataFeedPrms.useFixedKeys();
            localusefixedkeys.set(b);
        }
        return b;
    }

    private boolean useFixedVal() {
        Boolean b = (Boolean)localusefixedval.get();
        if (b == null) {
            b = DataFeedPrms.useFixedVal();
            localusefixedval.set(b);
        }
        return b;
    }

    private Object[] getFixedKeys() {
        Object[] k = (Object[])localfixedkeys.get();
        if (k == null) {
            k = new Object[this.maxKeys];
            for (int i = 0; i < this.maxKeys; ++i) {
                k[i] = ObjectHelper.createName(this.keyType, i);
            }
            localfixedkeys.set(k);
        }
        return k;
    }

    private Object getFixedVal() {
        Object v = localfixedval.get();
        if (v == null) {
            String objectType = CachePerfPrms.getObjectType();
            v = ObjectHelper.createObject(objectType, 0);
            localfixedval.set(v);
        }
        return v;
    }

    private NanoTimer getTimer() {
        NanoTimer t = (NanoTimer)localtimer.get();
        if (t == null) {
            t = new NanoTimer();
            localtimer.set(t);
        }
        return t;
    }
}

