/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.newWan;

import cacheperf.comparisons.newWan.NewWanPerfPrms;
import hydra.GatewaySenderDescription;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;

public class NewWanHelper {
    static int wanSites = new Integer(TestConfig.getInstance().getSystemProperty("wanSites"));
    static int dataHostsPerSite = new Integer(TestConfig.getInstance().getSystemProperty("dataHostsPerSite"));
    static int dataVMsPerHost = new Integer(TestConfig.getInstance().getSystemProperty("dataVMsPerHost"));
    static int dataThreadsPerVM = new Integer(TestConfig.getInstance().getSystemProperty("dataThreadsPerVM"));
    static String groupB = TestConfig.getInstance().getSystemProperty("B");
    static int bHostsPerSite = new Integer(TestConfig.getInstance().getSystemProperty(groupB + "HostsPerSite"));
    static int bVMsPerHost = new Integer(TestConfig.getInstance().getSystemProperty(groupB + "VMsPerHost"));
    static int bThreadsPerVM = new Integer(TestConfig.getInstance().getSystemProperty(groupB + "ThreadsPerVM"));
    static int objectSize = new Integer(TestConfig.getInstance().getSystemProperty("objectSize"));
    static long maxQueuesCapacity = NewWanHelper.getMaxQueuesCapacity();
    static int perEntryOverhead = 600;
    static int inputPutsPerSecPerThread = NewWanPerfPrms.getInputPutsPerSec() / (wanSites * bHostsPerSite * bVMsPerHost * bThreadsPerVM);

    private static long getMaxQueuesCapacity() {
        HydraVector senderNames = TestConfig.tab().vecAt(GatewaySenderPrms.names, null);
        GatewaySenderDescription gsd = GatewaySenderHelper.getGatewaySenderDescription((String)senderNames.get(0));
        boolean isSerial = gsd.getParallel() == false;
        int numOfActiveQueues = isSerial ? wanSites : wanSites * dataHostsPerSite * dataVMsPerHost;
        long perQueueMaxMemory = 100000000L;
        int objSize = objectSize + perEntryOverhead;
        long maxEntries = perQueueMaxMemory * (long)numOfActiveQueues / (long)objSize;
        return maxEntries;
    }

    public static long getEntriesPerThread(int perEntrySize, int totalUserThreads, int numOfQueues, int percFactor) {
        long queueMaxMemory = 100000000L;
        long queueMaxEntries = queueMaxMemory * (long)numOfQueues / (long)(perEntrySize + perEntryOverhead);
        long maxEntriesPerUser = queueMaxEntries / (long)totalUserThreads;
        return maxEntriesPerUser * (long)percFactor / 100L;
    }

    static {
        StringBuffer str = new StringBuffer().append("NewWanHelper: wanSites=").append(wanSites).append(" dataHostsPerSite=").append(dataHostsPerSite).append(" dataVMsPerHost=").append(dataVMsPerHost).append(" dataThreadsPerVM=").append(dataThreadsPerVM).append(" bHostsPerSite=").append(bHostsPerSite).append(" bVMsPerHost=").append(bVMsPerHost).append(" bThreadsPerVM=").append(bThreadsPerVM).append(" objectSize=").append(objectSize).append(" maxQueuesCapacity=").append(maxQueuesCapacity).append(" inputPutsPerSecPerThread=").append(inputPutsPerSecPerThread);
        Log.getLogWriter().info(str.toString());
    }
}

