/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.newWan;

import cacheperf.AbstractLatencyListener;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import hydra.TestConfig;

public class WanLatencyListener
extends AbstractLatencyListener
implements CacheListener {
    public void afterCreate(EntryEvent event) {
        if (!this.isWanRemoteEvent(event)) {
            return;
        }
        Object value = event.getNewValue();
        this.recordLatency(value);
    }

    public void afterUpdate(EntryEvent event) {
        if (!this.isWanRemoteEvent(event)) {
            return;
        }
        Object value = event.getNewValue();
        this.recordLatency(value);
    }

    public void afterInvalidate(EntryEvent event) {
    }

    public void afterDestroy(EntryEvent event) {
    }

    public void afterRegionCreate(RegionEvent event) {
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void afterRegionDestroy(RegionEvent event) {
    }

    public void afterRegionClear(RegionEvent event) {
    }

    public void afterRegionLive(RegionEvent event) {
    }

    public void close() {
    }

    private boolean isWanRemoteEvent(EntryEvent event) {
        int dsid = TestConfig.getInstance().getGemFireDescription(System.getProperty("gemfireName")).getDistributedSystemId();
        Object callback = ((EntryEventImpl)event).getRawCallbackArgument();
        if (callback == null || !(callback instanceof GatewaySenderEventCallbackArgument)) {
            return false;
        }
        GatewaySenderEventCallbackArgument senderCallback = (GatewaySenderEventCallbackArgument)callback;
        if (senderCallback.getOriginatingDSId() < 0) {
            return false;
        }
        if (senderCallback.getOriginatingDSId() == dsid) {
            return false;
        }
        String tName = Thread.currentThread().getName();
        return tName.contains("ServerConnection on port") || tName.contains("PartitionedRegion Message Processor");
    }
}

