/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.parReg;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import com.gemstone.gemfire.cache.Region;
import distcache.gemfire.GemFireCachePrms;
import hydra.ConfigPrms;
import hydra.EdgeHelper;
import hydra.RegionHelper;
import objects.ObjectHelper;

public class MultiRegionClient
extends CachePerfClient {
    public static synchronized void createRegionTask() {
        MultiRegionClient c = new MultiRegionClient();
        c.initHydraThreadLocals();
        c.createRegion();
        c.updateHydraThreadLocals();
    }

    private void createRegion() {
        String regionName = GemFireCachePrms.getRegionName();
        String regionConfig = ConfigPrms.getRegionConfig();
        if (RegionHelper.getRegion(regionName) == null) {
            RegionHelper.createRegion(regionName, regionConfig);
        }
        Region region = RegionHelper.getRegion(regionName);
        EdgeHelper.addThreadLocalConnection(region);
    }

    public static void createDataInRegionTask() {
        MultiRegionClient c = new MultiRegionClient();
        c.initialize(1);
        c.createDataInRegion();
    }

    private void createDataInRegion() {
        String regionName = GemFireCachePrms.getRegionName();
        Region region = RegionHelper.getRegion(regionName);
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.createInRegion(key, region);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void createInRegion(int i, Region region) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startCreate();
        region.create(key, val);
        this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
    }
}

