/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.replicated.cq;

import cacheperf.CachePerfException;

public class Fcns {
    public static String duplicateHeapSize(int heapMB, int heapPercent, int n) {
        if (heapMB <= 0) {
            String s = "Illegal heap MB: " + heapMB;
            throw new CachePerfException(s);
        }
        if (heapPercent <= 0 || heapPercent > 100) {
            String s = "Illegal heap percent: " + heapPercent;
            throw new CachePerfException(s);
        }
        int heapSize = (int)Math.ceil((double)heapPercent / 100.0 * (double)heapMB) + 100;
        String heapString = "-Xms" + heapSize + "m -Xmx" + heapSize + "m ";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buf.append(heapString);
        }
        return buf.toString().trim();
    }
}

