/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.replicated.delta;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfException;
import cacheperf.CachePerfPrms;
import cacheperf.comparisons.replicated.delta.DeltaPrms;
import com.gemstone.gemfire.Delta;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import java.util.List;
import objects.ConfigurableObject;
import objects.ObjectHelper;
import perffmwk.PerfStatException;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;

public class DeltaClient
extends CachePerfClient {
    private static final boolean enforceDeltaObjectsOnly = DeltaPrms.enforceDeltaObjectsOnly();

    public static void updateDeltaDataTask() {
        DeltaClient c = new DeltaClient();
        c.initialize(17);
        c.updateDeltaData();
    }

    private void updateDeltaData() {
        boolean getBeforeUpdate = DeltaPrms.getBeforeUpdate();
        int numUpdates = CachePerfPrms.getNumUpdates();
        if (this.useTransactions) {
            this.begin();
        }
        boolean batchDone = false;
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.updateDelta(key, getBeforeUpdate, numUpdates);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void updateDelta(int i, boolean getBeforeUpdate, int numUpdates) {
        Object key = ObjectHelper.createName(this.keyType, i);
        Object val = null;
        long start = this.statistics.startUpdate();
        if (getBeforeUpdate) {
            val = this.cache.get(key);
            if (val == null) {
                String s = "Key has not been created: " + i;
                throw new HydraRuntimeException(s);
            }
        } else {
            String objectType = CachePerfPrms.getObjectType();
            val = DeltaClient.createUninitializedObject(objectType, i);
        }
        if (enforceDeltaObjectsOnly && !(val instanceof Delta)) {
            String s = val.getClass().getName() + " does not implement Delta";
            throw new HydraRuntimeException(s);
        }
        for (int n = 0; n < numUpdates; ++n) {
            ObjectHelper.update(val);
            this.cache.put(key, val);
        }
        this.statistics.endUpdate(start, numUpdates, this.isMainWorkload, this.histogram);
    }

    private static Object createUninitializedObject(String classname, int index) {
        try {
            Class<?> cls = Class.forName(classname);
            return (ConfigurableObject)cls.newInstance();
        }
        catch (ClassCastException e) {
            String s = classname + " is not a ConfigurableObject";
            throw new HydraConfigException(s, e);
        }
        catch (ClassNotFoundException e) {
            String s = "Unable to find class for type " + classname;
            throw new HydraConfigException(s, e);
        }
        catch (IllegalAccessException e) {
            String s = "Unable to instantiate object of type " + classname;
            throw new HydraConfigException(s, e);
        }
        catch (InstantiationException e) {
            String s = "Unable to instantiate object of type " + classname;
            throw new HydraConfigException(s, e);
        }
    }

    public static void validateDeltaPropagationTask() {
        double deltas = DeltaClient.readStat("CachePerfStats", "deltaUpdates");
        if (deltas < 1.0) {
            String s = "No delta propagation occurred -- CachePerfStats.deltaUpdates=" + deltas;
            throw new HydraRuntimeException(s);
        }
    }

    protected static double readStat(String statType, String statName) {
        String spec = "* " + statType + " " + "* " + statName + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + "max";
        int maxTries = 500;
        String errStr = null;
        for (int tryCount = 1; tryCount <= 500; ++tryCount) {
            List aList = null;
            try {
                aList = PerfStatMgr.getInstance().readStatistics(spec, true);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                errStr = e.toString();
                continue;
            }
            if (aList == null) {
                throw new PerfStatException("Statistics not found: " + spec);
            }
            if (aList.size() == 1) {
                StringBuffer aStr = new StringBuffer();
                PerfStatValue stat = (PerfStatValue)aList.get(0);
                double currValue = stat.getMax();
                aStr.append(statName + ": " + stat + "\n");
                return currValue;
            }
            throw new PerfStatException("Too many statistics: " + aList.size());
        }
        throw new CachePerfException("Could not get stats in 500 attempts; " + errStr);
    }
}

