/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.replicated.execute;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import cacheperf.comparisons.replicated.execute.ExecutePrms;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.Log;
import hydra.MasterController;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import objects.ObjectHelper;

public class ExecuteClient
extends CachePerfClient {
    private static final Function function = ExecutePrms.getFunction();

    public static void registerFunctionTask() {
        FunctionService.registerFunction((Function)function);
    }

    public static void putFunctionExecutionDataTask() throws Exception {
        ExecuteClient c = new ExecuteClient();
        c.initialize(3);
        c.putFunctionExecutionData();
    }

    private void putFunctionExecutionData() throws Exception {
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.putFunctionExecution(r, key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void putFunctionExecution(Region r, int i) throws Exception {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Serializable val = (Serializable)ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startPut();
        FunctionService.onRegion((Region)r).withFilter(Collections.singleton(key)).withArgs((Object)val).execute(function.getId()).getResult();
        this.statistics.endPut(start, 1, this.isMainWorkload, this.histogram);
    }

    public static void getFunctionExecutionDataTask() throws Exception {
        ExecuteClient c = new ExecuteClient();
        c.initialize(4);
        c.getFunctionExecutionData();
    }

    private void getFunctionExecutionData() throws Exception {
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.getFunctionExecution(r, key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void getFunctionExecution(Region r, int i) throws Exception {
        Object key = ObjectHelper.createName(this.keyType, i);
        long start = this.statistics.startGet();
        List resultSet = (List)FunctionService.onRegion((Region)r).withFilter(Collections.singleton(key)).execute(function.getId()).getResult();
        if (resultSet.size() == 0) {
            this.processNullValue(key);
        } else {
            Object val = resultSet.iterator().next();
            if (this.validateObjects) {
                this.validate(i, val);
            }
        }
        this.statistics.endGet(start, 1, this.isMainWorkload, this.histogram);
    }

    public static void putAndGetFunctionExecutionDataTask() throws Exception {
        ExecuteClient c = new ExecuteClient();
        c.initialize(4);
        c.putAndGetFunctionExecutionData();
    }

    private void putAndGetFunctionExecutionData() throws Exception {
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.putAndGetFunctionExecution(r, key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void putAndGetFunctionExecution(Region r, int i) throws Exception {
        Serializable key = (Serializable)ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        for (int j = 0; j < 4; ++j) {
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
            }
            long start = this.statistics.startPut();
            r.put((Object)key, val);
            this.statistics.endPut(start, 1, this.isMainWorkload, this.histogram);
            start = this.statistics.startGet();
            Object result = this.retrieveUsingRegionFunction(r, key);
            this.statistics.endGet(start, 1, this.isMainWorkload, this.histogram);
        }
    }

    private Object retrieveUsingRegionFunction(Region r, Serializable key) {
        HashSet<Serializable> keys = new HashSet<Serializable>();
        keys.add(key);
        Execution execution = FunctionService.onRegion((Region)r).withFilter(keys);
        Object result = null;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                result = this.retrieveWithFunction(execution);
                break;
            }
            catch (ServerConnectivityException e) {
                this.handleException(key, e);
                continue;
            }
        }
        return result;
    }

    private Object retrieveWithFunction(Execution execution) {
        ResultCollector collector = execution.execute(function.getId(), true, true, true);
        List allResults = (List)collector.getResult();
        return allResults.get(0);
    }

    private void handleException(Object key, ServerConnectivityException e) {
        if (!(e.getCause() instanceof IOException)) {
            throw e;
        }
        String message = "Caught exception attempting to execute function on " + key + ". Retrying.";
        Log.getLogWriter().warning(message, (Throwable)e);
    }
}

