/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.snapshot;

import cacheperf.CachePerfClient;
import cacheperf.comparisons.snapshot.SnapshotBlackboard;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.Log;
import java.io.File;
import java.io.IOException;
import util.TestException;

public class SnapshotClient
extends CachePerfClient {
    static final String snapshotFileBase = "snapshot";

    public static synchronized void exportRegionSnapshot() {
        SnapshotClient c = new SnapshotClient();
        c.exportRegion();
    }

    protected void exportRegion() {
        long leader = SnapshotBlackboard.getInstance().getSharedCounters().incrementAndRead(SnapshotBlackboard.leader);
        if (leader == 1L) {
            Region aRegion = CacheHelper.getCache().getRegion("DefaultRegion");
            RegionSnapshotService snapshot = aRegion.getSnapshotService();
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            String currDirName = new File(gfd.getSystemDirectoryStr()).getParent();
            String snapshotFilename = currDirName + File.separator + snapshotFileBase;
            try {
                Log.getLogWriter().info("Exporting " + aRegion.getName() + " containing " + aRegion.size() + " entries");
                snapshot.save(new File(snapshotFilename), SnapshotOptions.SnapshotFormat.GEMFIRE);
                Log.getLogWriter().info("Exported " + aRegion.getName() + " containing " + aRegion.size() + " entries");
                SnapshotBlackboard bb = SnapshotBlackboard.getInstance();
                bb.getSharedCounters().zero(SnapshotBlackboard.leader);
                bb.getSharedCounters().setIfLarger(SnapshotBlackboard.regionSize, aRegion.size());
                bb.getSharedMap().put("exportHost", HostHelper.getLocalHost());
            }
            catch (IOException ioe) {
                throw new TestException("Caught " + ioe + " on export of " + aRegion.getFullPath());
            }
        }
    }

    public static synchronized void importRegionSnapshot() {
        SnapshotClient c = new SnapshotClient();
        c.importRegion();
    }

    protected void importRegion() {
        long leader;
        SnapshotBlackboard bb = SnapshotBlackboard.getInstance();
        String exportHost = (String)bb.getSharedMap().get("exportHost");
        if (exportHost.equalsIgnoreCase(HostHelper.getLocalHost()) && (leader = SnapshotBlackboard.getInstance().getSharedCounters().incrementAndRead(SnapshotBlackboard.leader)) == 1L) {
            Region aRegion = CacheHelper.getCache().getRegion("DefaultRegion");
            Log.getLogWriter().info("before import, region contains " + aRegion.size() + " entries");
            RegionSnapshotService snapshot = aRegion.getSnapshotService();
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            String currDirName = new File(gfd.getSystemDirectoryStr()).getParent();
            String snapshotFilename = currDirName + File.separator + snapshotFileBase;
            Log.getLogWriter().info("Importing snapshot from " + snapshotFilename);
            try {
                snapshot.load(new File(snapshotFilename), SnapshotOptions.SnapshotFormat.GEMFIRE);
                Log.getLogWriter().info("After import " + aRegion.getName() + " contains " + aRegion.size() + " entries");
            }
            catch (Exception e) {
                throw new TestException("Caught " + e + " on import of " + aRegion.getFullPath());
            }
        }
    }

    public static synchronized void verifyRegionSnapshot() {
        SnapshotClient c = new SnapshotClient();
        c.verify();
    }

    protected void verify() {
        Region aRegion = CacheHelper.getCache().getRegion("DefaultRegion");
        long expectedRegionSize = SnapshotBlackboard.getInstance().getSharedCounters().read(SnapshotBlackboard.regionSize);
        int actualRegionSize = aRegion.size();
        if ((long)actualRegionSize != expectedRegionSize) {
            throw new TestException("Region size (" + actualRegionSize + " is not equal to expectedRegionSize (" + expectedRegionSize);
        }
    }
}

