/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire;

import cacheperf.gemfire.GemFireCachePrms;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import hydra.Log;

public class SimpleListener
extends CacheListenerAdapter {
    private static final String AFTER_CREATE = "afterCreate";
    private static final String AFTER_UPDATE = "afterUpdate";
    private static final String AFTER_INVALIDATE = "afterInvalidate";
    private static final String AFTER_DESTROY = "afterDestroy";
    private static final String AFTER_REGION_INVALIDATE = "afterRegionInvalidate";
    private static final String AFTER_REGION_DESTROY = "afterRegionDestroy";
    private static final String CLOSE = "close";
    private boolean processEvents = GemFireCachePrms.processListenerEvents();
    private boolean logEvents = GemFireCachePrms.logListenerEvents();

    public void afterCreate(EntryEvent event) {
        if (this.processEvents) {
            this.processEntryEvent(event, AFTER_CREATE);
        }
    }

    public void afterUpdate(EntryEvent event) {
        if (this.processEvents) {
            this.processEntryEvent(event, AFTER_UPDATE);
        }
    }

    public void afterInvalidate(EntryEvent event) {
        if (this.processEvents) {
            this.processEntryEvent(event, AFTER_INVALIDATE);
        }
    }

    public void afterDestroy(EntryEvent event) {
        if (this.processEvents) {
            this.processEntryEvent(event, AFTER_DESTROY);
        }
    }

    public void afterRegionInvalidate(RegionEvent event) {
        if (this.processEvents) {
            this.processRegionEvent(event, AFTER_REGION_INVALIDATE);
        }
    }

    public void afterRegionDestroy(RegionEvent event) {
        if (this.processEvents) {
            this.processRegionEvent(event, AFTER_REGION_DESTROY);
        }
    }

    public void close() {
        if (this.processEvents) {
            this.processEvent(CLOSE);
        }
    }

    private void processEntryEvent(EntryEvent event, String eventType) {
        Object name = event.getKey();
        Object value = event.getNewValue();
        if (this.logEvents) {
            Log.getLogWriter().info(eventType + " " + name + "=" + value);
        }
    }

    private void processRegionEvent(RegionEvent event, String eventType) {
        if (this.logEvents) {
            Log.getLogWriter().info(eventType);
        }
    }

    private void processEvent(String eventType) {
        if (this.logEvents) {
            Log.getLogWriter().info(eventType);
        }
    }
}

