/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire.query;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import cacheperf.gemfire.query.QueryPerfPrms;
import cacheperf.gemfire.query.QueryPerfStats;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import distcache.DistCacheException;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import perffmwk.PerfReportPrms;
import query.QueryPrms;
import util.TestException;

public class QueryPerfClient
extends CachePerfClient
implements Serializable {
    static Query[] queries = null;
    static boolean queriesRead = false;
    static boolean individualQueryStats = false;
    protected static final int PUT_OPERATION = 1;
    protected static final int DESTROY_OPERATION = 2;
    protected static final int GET_OPERATION = 3;
    protected static final int QUERY_OPERATION = 4;
    protected static final int CREATE_OPERATION = 5;

    @Override
    protected String nameFor(int name) {
        switch (name) {
            default: 
        }
        return super.nameFor(name);
    }

    public static void readQueries() {
        HydraVector hvQueries;
        Map nameToPoolMap = PoolManager.getAll();
        String poolName = TestConfig.tab().stringAt(PoolPrms.names, null);
        QueryService qs = CacheHelper.getCache().getQueryService();
        if (poolName != null && nameToPoolMap.get(poolName) != null) {
            qs = ((Pool)nameToPoolMap.get(poolName)).getQueryService();
        }
        if ((hvQueries = TestConfig.tab().vecAt(QueryPerfPrms.query, null)) != null) {
            queries = new Query[hvQueries.size()];
            for (int i = 0; i < hvQueries.size(); ++i) {
                QueryPerfClient.queries[i] = qs.newQuery((String)hvQueries.get(i));
            }
        }
        queriesRead = true;
    }

    public static synchronized void HydraTask_attachQueryObserver() {
        QueryObserverImpl observer = new QueryObserverImpl();
        QueryObserverHolder.setInstance((QueryObserver)observer);
    }

    public static void openStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.statistics == null) {
            this.statistics = QueryPerfStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
    }

    public static void closeStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs(2000);
        if (this.statistics != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.statistics.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryTask() {
        QueryPerfClient qpc = new QueryPerfClient();
        Class<QueryPerfClient> clazz = QueryPerfClient.class;
        synchronized (QueryPerfClient.class) {
            if (!queriesRead) {
                Object obj = TestConfig.tab().get(PerfReportPrms.useAutoGeneratedStatisticsSpecification);
                individualQueryStats = obj == null ? false : Boolean.valueOf((String)obj);
                QueryPerfClient.readQueries();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            qpc.initialize(15);
            qpc.queryBatch();
            return;
        }
    }

    protected void queryBatch() {
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.query();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void query() {
        if (queries != null) {
            for (int i = 0; i < queries.length; ++i) {
                this.query(queries[i], null, i + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entryOpsAndQueryTask() {
        QueryPerfClient qpc = new QueryPerfClient();
        Class<QueryPerfClient> clazz = QueryPerfClient.class;
        synchronized (QueryPerfClient.class) {
            if (!queriesRead) {
                QueryPerfClient.readQueries();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            qpc.initialize(15);
            qpc.doEntryOpsAndQueryBatch();
            return;
        }
    }

    protected void doEntryOpsAndQueryBatch() {
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.doEntryOpsAndQuery();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void doEntryOpsAndQuery() {
        int key = -1;
        int whichOp = this.getOperation(QueryPrms.entryAndQueryOperations);
        switch (whichOp) {
            case 5: {
                key = this.getNextKey();
                this.create(key);
                break;
            }
            case 1: {
                key = this.getNextKey();
                this.put(key);
                break;
            }
            case 2: {
                key = this.getNextKey();
                try {
                    this.destroy(key);
                    break;
                }
                catch (DistCacheException e) {
                    if (e.getCause() instanceof EntryNotFoundException) break;
                    throw e;
                }
            }
            case 3: {
                key = this.getNextKey();
                try {
                    this.get(key);
                    break;
                }
                catch (HydraRuntimeException e) {
                    if (e.getMessage().startsWith("Got null at key=")) break;
                    throw e;
                }
            }
            case 4: {
                this.query();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichOp);
            }
        }
    }

    public static void entryOpsTask() {
        QueryPerfClient qpc = new QueryPerfClient();
        qpc.initialize(13);
        qpc.doEntryOpsAndQueryBatch();
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("put")) {
            op = 1;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 3;
        } else if (operation.equals("query")) {
            op = 4;
        } else if (operation.equals("create")) {
            op = 5;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    public static void HydraTask_initRegisterFunction() {
        QueryFunction prQueryFunction1 = new QueryPerfClient().new QueryFunction();
        FunctionService.registerFunction((Function)prQueryFunction1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryContextTask() {
        QueryPerfClient qpc = new QueryPerfClient();
        Class<QueryPerfClient> clazz = QueryPerfClient.class;
        synchronized (QueryPerfClient.class) {
            if (!queriesRead) {
                QueryPerfClient.readQueries();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            qpc.initialize(15);
            qpc.queryContextBatch();
            return;
        }
    }

    protected void queryContextBatch() {
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.queryContext();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void queryContext() {
        if (queries != null) {
            for (int i = 0; i < queries.length; ++i) {
                this.queryContext(queries[i], null);
            }
        }
    }

    protected void queryContext(Query query, Object[] bindParameters) {
        try {
            QueryPerfStats stat = (QueryPerfStats)this.statistics;
            Region region = ((GemFireCacheTestImpl)this.cache).getRegion();
            QueryFunction function = new QueryFunction();
            long start = this.statistics.startQuery();
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(query.getQueryString());
            argList.add(RemoteTestModule.getCurrentThread().getThreadId());
            if (bindParameters != null) {
                argList.add(bindParameters);
            }
            Object result = FunctionService.onRegion((Region)region).withArgs(argList).execute((Function)function).getResult();
            ArrayList resultList = (ArrayList)result;
            resultList.trimToSize();
            ArrayList queryResults = null;
            Log.getLogWriter().info("Size of the resultsList: " + resultList.size());
            if (resultList.size() != 0) {
                queryResults = new ArrayList();
                for (Object obj : resultList) {
                    if (obj == null) continue;
                    queryResults.addAll((ArrayList)obj);
                }
            }
            int numResults = queryResults.size();
            stat.endQuery(NanoTimer.getTime() - start, numResults, this.isMainWorkload, this.histogram);
            if (QueryPerfClient.log().fineEnabled()) {
                if (bindParameters != null) {
                    Log.getLogWriter().info("Bindparameters: ");
                    for (int i = 0; i < bindParameters.length; ++i) {
                        Log.getLogWriter().info("param[" + i + "] = " + bindParameters[i]);
                    }
                }
                QueryPerfClient.log().info("Query " + query.getQueryString() + " returned " + queryResults.size());
                QueryPerfClient.log().fine("Query " + query.getQueryString() + " returned followin results: ");
                QueryPerfClient.log().fine(((Object)queryResults).toString());
            }
        }
        catch (FunctionException e) {
            String s = "Problem executing query: " + query;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    protected void query(Query query, Object[] bindParameters, int queryNum) {
        if (bindParameters == null) {
            this.query(query, queryNum);
        } else {
            try {
                long start = this.statistics.startQuery();
                QueryPerfStats stat = (QueryPerfStats)this.statistics;
                SelectResults results = (SelectResults)query.execute(bindParameters);
                int numResults = results.size();
                if (individualQueryStats) {
                    stat.endQuery(NanoTimer.getTime() - start, numResults, this.isMainWorkload, this.histogram, queryNum);
                } else {
                    stat.endQuery(NanoTimer.getTime() - start, numResults, this.isMainWorkload, this.histogram);
                }
                if (QueryPerfClient.log().fineEnabled()) {
                    Log.getLogWriter().fine("Bindparameters: ");
                    for (int i = 0; i < bindParameters.length; ++i) {
                        Log.getLogWriter().fine("param[" + i + "] = " + bindParameters[i]);
                    }
                    QueryPerfClient.log().fine("Query " + query.getQueryString() + " returned " + numResults);
                    QueryPerfClient.log().fine(this.getResultString(results));
                }
            }
            catch (QueryException e) {
                String s = "Problem executing query: " + query;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
        }
    }

    protected void query(Query query, int queryNum) {
        try {
            long start = this.statistics.startQuery();
            QueryPerfStats stat = (QueryPerfStats)this.statistics;
            SelectResults results = (SelectResults)query.execute();
            int numResults = results.size();
            if (individualQueryStats) {
                stat.endQuery(NanoTimer.getTime() - start, numResults, this.isMainWorkload, this.histogram, queryNum);
            } else {
                stat.endQuery(NanoTimer.getTime() - start, numResults, this.isMainWorkload, this.histogram);
            }
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("Query " + query + " returned " + numResults);
                QueryPerfClient.log().fine(this.getResultString(results));
            }
        }
        catch (QueryException e) {
            String s = "Problem executing query: " + query;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    public static void indexDataTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.indexData();
    }

    @Override
    protected void indexData() {
        int i;
        HydraVector hvIndexesFromClauses;
        String[] indexes = null;
        String[] indexFromClauses = null;
        HydraVector hvIndexesExprs = TestConfig.tab().vecAt(CachePerfPrms.queryIndex, null);
        if (hvIndexesExprs != null) {
            indexes = new String[hvIndexesExprs.size()];
            for (int i2 = 0; i2 < hvIndexesExprs.size(); ++i2) {
                indexes[i2] = (String)hvIndexesExprs.get(i2);
            }
        }
        if ((hvIndexesFromClauses = TestConfig.tab().vecAt(CachePerfPrms.queryFromClause, null)) != null) {
            indexFromClauses = new String[hvIndexesFromClauses.size()];
            for (i = 0; i < hvIndexesFromClauses.size(); ++i) {
                indexFromClauses[i] = (String)hvIndexesFromClauses.get(i);
            }
        }
        if (hvIndexesExprs != null) {
            Assert.assertTrue((indexFromClauses.length == indexes.length ? 1 : 0) != 0, (Object)"Number of index expressions and index fromclauses in conf file are not same.");
            for (i = 0; i < indexes.length; ++i) {
                try {
                    QueryPerfClient.log().info("Creating index: indexedExpression: " + indexes[i] + " fromClause: " + indexFromClauses[i]);
                    CacheHelper.getCache().getQueryService().createIndex("index" + i, IndexType.FUNCTIONAL, indexes[i], indexFromClauses[i]);
                    continue;
                }
                catch (IndexExistsException e) {
                    QueryPerfClient.log().info("index already created");
                    continue;
                }
                catch (IndexNameConflictException e) {
                    QueryPerfClient.log().info("index already created");
                    continue;
                }
                catch (QueryException e) {
                    String s = "Problem creating index: " + indexes[i] + " " + indexFromClauses[i];
                    throw new HydraRuntimeException(s, (Exception)((Object)e));
                }
            }
        }
    }

    public class QueryFunction
    extends FunctionAdapter {
        public void execute(FunctionContext context) {
            Log.getLogWriter().info("QueryFunction.execute()::Executing QueryFunction on context ");
            Cache cache = CacheFactory.getAnyInstance();
            QueryService queryService = cache.getQueryService();
            ArrayList allQueryResults = new ArrayList();
            ArrayList arguments = (ArrayList)context.getArguments();
            String qstr = (String)arguments.get(0);
            Object initiatingThreadID = arguments.get(1);
            Object[] bindParams = null;
            if (arguments.size() > 2) {
                bindParams = (Object[])arguments.get(2);
            }
            String aStr = "In execute with context " + context + " with query " + qstr + " initiated in hydra thread thr_" + initiatingThreadID + "_";
            for (int i = 2; i < arguments.size(); ++i) {
                aStr = aStr + " additional arg: " + arguments.get(i);
            }
            Log.getLogWriter().info(aStr);
            Log.getLogWriter().info("QueryFunction.execute()::Executing query:: " + qstr);
            try {
                Query query = queryService.newQuery(qstr);
                SelectResults result = null;
                result = bindParams != null ? (SelectResults)query.execute((RegionFunctionContext)context, bindParams) : (SelectResults)query.execute((RegionFunctionContext)context);
                Log.getLogWriter().info("QueryFunction.execute()::Context arguments :: " + context.getArguments().toString());
                Set filter = ((RegionFunctionContext)context).getFilter();
                if (filter != null) {
                    Log.getLogWriter().info("QueryFunction.execute()::Context FILTER on server side :: " + filter.toString());
                }
                context.getResultSender().sendResult((Object)((ArrayList)result.asList()));
                context.getResultSender().lastResult(null);
            }
            catch (Exception e) {
                throw new FunctionException((Throwable)e);
            }
        }

        public String getId() {
            return "QueryFunction";
        }
    }

    static class QueryObserverImpl
    extends QueryObserverAdapter {
        String indexName = null;

        QueryObserverImpl() {
        }

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexName = index.getName();
            Log.getLogWriter().info("BeforeIndexLoopkup :" + index.getName());
        }

        public void afterIndexLookup(Collection results) {
            Log.getLogWriter().info("AfterIndexLoopkup :" + this.indexName);
        }
    }
}

