/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire.query;

import cacheperf.CachePerfStats;
import cacheperf.gemfire.query.QueryPerfPrms;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import perffmwk.HistogramStats;
import perffmwk.PerfReportPrms;
import util.TestException;

public class QueryPerfStats
extends CachePerfStats {
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean individualQueryStats;
        boolean largerIsBetter = true;
        HydraVector hvQueries = TestConfig.tab().vecAt(QueryPerfPrms.query, null);
        Object obj = TestConfig.tab().get(PerfReportPrms.useAutoGeneratedStatisticsSpecification);
        boolean bl = individualQueryStats = obj == null ? false : Boolean.valueOf((String)obj);
        if (individualQueryStats) {
            String statsSpecFile = System.getProperty("user.dir") + "/" + "autoGenerate.spec";
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(new File(statsSpecFile)));
                pw.write("include $JTESTS/smoketest/perf/common.spec;\n\n");
                pw.write("statspec queriesPerSecond * cacheperf.gemfire.query.QueryPerfStats * queries\n");
                pw.write("filter=perSecond combine=combineAcrossArchives ops=mean? trimspec=queries;\n");
                pw.write("\n");
                pw.write("statspec totalQueryExecutions * cacheperf.gemfire.query.QueryPerfStats * queries\n");
                pw.write("filter=none combine=combineAcrossArchives ops=max-min? trimspec=queries;\n");
                pw.write("\n");
                pw.write("statspec totalQueryExecutionTimeMillis * cacheperf.gemfire.query.QueryPerfStats * queryTime\n");
                pw.write("filter=none combine=combineAcrossArchives ops=max-min? trimspec=queries;\n");
                pw.write("\n");
                pw.write("expr overallQueryResponseTimeMillis = totalQueryExecutionTimeMillis / totalQueryExecutions ops=max-min?\n");
                pw.write(";\n");
                pw.write("expr overallQueryThroughPut = totalQueryExecutions / totalQueryExecutionTimeMillis ops=max-min?\n");
                pw.write(";\n");
                pw.write("\n");
                for (int i = 0; i < hvQueries.size(); ++i) {
                    pw.write("\n");
                    pw.write("statspec totalQuery" + (i < 9 ? "0" : "") + (i + 1) + "Executions" + " * cacheperf.gemfire.query.QueryPerfStats * query" + (i + 1) + " \n");
                    pw.write("filter=none combine=combineAcrossArchives ops=max-min? trimspec=queries;\n");
                    pw.write("\n");
                    pw.write("statspec totalQuery" + (i < 9 ? "0" : "") + (i + 1) + "ExecutionTimeMillis * cacheperf.gemfire.query.QueryPerfStats * query" + (i + 1) + "Time \n");
                    pw.write("filter=none combine=combineAcrossArchives ops=max-min? trimspec=queries;\n");
                    pw.write("\n");
                    pw.write("expr query" + (i < 9 ? "0" : "") + (i + 1) + "ResponseTimeMillis = totalQuery" + (i < 9 ? "0" : "") + (i + 1) + "ExecutionTimeMillis / totalQuery" + (i < 9 ? "0" : "") + (i + 1) + "Executions ops=max-min?\n");
                    pw.write(";\n");
                    pw.write("expr query" + (i < 9 ? "0" : "") + (i + 1) + "PerMilliSecond = totalQuery" + (i < 9 ? "0" : "") + (i + 1) + "Executions / totalQuery" + (i < 9 ? "0" : "") + (i + 1) + "ExecutionTimeMillis ops=max-min?\n");
                    pw.write(";\n");
                    pw.write("\n");
                }
                pw.close();
            }
            catch (IOException e) {
                String s = "Unable to open file: " + statsSpecFile;
                throw new TestException(s, e);
            }
        }
        StatisticDescriptor[] finalSd = null;
        StatisticDescriptor[] sd1 = CachePerfStats.getStatisticDescriptors();
        Log.getLogWriter().info("hvQueries: " + hvQueries);
        Log.getLogWriter().info("sd1: " + sd1);
        finalSd = sd1;
        if (individualQueryStats) {
            StatisticDescriptor[] sd = new StatisticDescriptor[sd1.length + 3 * hvQueries.size()];
            System.arraycopy(sd1, 0, sd, 0, sd1.length);
            for (int i = 0; i < hvQueries.size(); ++i) {
                sd[sd1.length + i * 3] = QueryPerfStats.factory().createIntCounter("query" + (i + 1), "Number of queries completed.", "operations", largerIsBetter);
                sd[sd1.length + i * 3 + 1] = QueryPerfStats.factory().createIntCounter("query" + (i + 1) + "Results", "Size of query result set.", "entries", largerIsBetter);
                sd[sd1.length + i * 3 + 2] = QueryPerfStats.factory().createLongCounter("query" + (i + 1) + "Time", "Total time spent doing queries.", "nanoseconds", !largerIsBetter);
            }
            finalSd = sd;
        }
        return finalSd;
    }

    @Override
    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt("vmCount", 1);
            VMCounted = true;
        }
    }

    public static QueryPerfStats getInstance() {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, 0);
        Log.getLogWriter().info("QueryPerfStats getInstance qps Statistics class name: " + qps.getClass().getName());
        return qps;
    }

    public static QueryPerfStats getInstance(int scope) {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, scope);
        return qps;
    }

    public static QueryPerfStats getInstance(String name) {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, 0, name);
        return qps;
    }

    public static QueryPerfStats getInstance(String name, String trimspecName) {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, 0, name, trimspecName);
        return qps;
    }

    public QueryPerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getQuery(int queryNum) {
        return this.statistics().getInt("query" + queryNum);
    }

    public int getQueryResults(int queryNum) {
        return this.statistics().getInt("query" + queryNum + "querieResults");
    }

    public long getQueryTime(int queryNum) {
        return this.statistics().getLong("query" + queryNum + "queryTime");
    }

    @Override
    public void incQueries(boolean isMainWorkload) {
        this.incQueries(1, isMainWorkload);
    }

    @Override
    public void incQueries(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt("operations", amount);
        }
        this.statistics().incInt("queries", amount);
    }

    @Override
    public void incQueryResults(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt("operations", amount);
        }
        this.statistics().incInt("querieResults", amount);
    }

    @Override
    public void incQueryTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong("operationTime", amount);
        }
        this.statistics().incLong("queryTime", amount);
    }

    public void incQueries(boolean isMainWorkload, int queryNum) {
        this.incQueries(1, isMainWorkload, queryNum);
    }

    public void incQueries(int amount, boolean isMainWorkload, int queryNum) {
        if (isMainWorkload) {
            this.statistics().incInt("operations", amount);
        }
        this.statistics().incInt("query" + queryNum, amount);
    }

    public void incQueryResults(int amount, boolean isMainWorkload, int queryNum) {
        if (isMainWorkload) {
            this.statistics().incInt("operations", amount);
        }
        this.statistics().incInt("query" + queryNum + "Results", amount);
    }

    public void incQueryTime(long amount, boolean isMainWorkload, int queryNum) {
        if (isMainWorkload) {
            this.statistics().incLong("operationTime", amount);
        }
        this.statistics().incLong("query" + queryNum + "Time", amount);
    }

    @Override
    public long startQuery() {
        return NanoTimer.getTime();
    }

    @Override
    public void endQuery(long timeElapsed, int results, boolean isMainWorkload, HistogramStats histogram) {
        this.incQueries(1, isMainWorkload);
        this.incQueryResults(results, isMainWorkload);
        this.incQueryTime(timeElapsed / 1000000L, isMainWorkload);
        this.incHistogram(histogram, timeElapsed);
    }

    public long startQuery(int queryNum) {
        return NanoTimer.getTime();
    }

    public void endQuery(long timeElapsed, int results, boolean isMainWorkload, HistogramStats histogram, int queryNum) {
        this.endQuery(timeElapsed, results, isMainWorkload, histogram);
        this.incQueries(1, isMainWorkload, queryNum);
        this.incQueryResults(results, isMainWorkload, queryNum);
        this.incQueryTime(timeElapsed / 1000000L, isMainWorkload, queryNum);
        this.incHistogram(histogram, timeElapsed);
    }
}

