/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire.slowRecv;

import cacheperf.CachePerfClient;
import cacheperf.gemfire.slowRecv.SlowRecvPrms;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.DistributedSystemHelper;
import hydra.GemFirePrms;
import hydra.Log;
import hydra.TestConfig;
import util.TestException;

public class SlowRecvClient
extends CachePerfClient {
    public static void verifySlowReceiverDetectedTask() {
        SlowRecvClient sr = new SlowRecvClient();
        sr.initHydraThreadLocals();
        sr.verifySlowReceiverDetected();
        sr.updateHydraThreadLocals();
    }

    protected void verifySlowReceiverDetected() {
        Long key = GemFirePrms.asyncDistributionTimeout;
        int distributionTimeout = TestConfig.tasktab().intAt(key, TestConfig.tab().intAt(key, 0));
        if (distributionTimeout == 0) {
            Log.getLogWriter().info("asyncDistributionTimeout == 0, no async messaging configured");
            return;
        }
        if (!SlowRecvPrms.expectQueuing()) {
            Log.getLogWriter().info("SlowRecvPrms.expectQueuing is set to false, no checks done to ensure queuing occurred");
            return;
        }
        StringBuffer aStr = new StringBuffer();
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        DM dm = ((InternalDistributedSystem)ds).getDistributionManager();
        DMStats dmStats = dm.getStats();
        long queuedMessages = dmStats.getAsyncQueuedMsgs();
        Log.getLogWriter().info("asyncQueuedMsgs = " + queuedMessages);
        aStr.append("asyncQueuedMsgs = " + queuedMessages + "\n");
        int flushesCompleted = dmStats.getAsyncQueueFlushesCompleted();
        Log.getLogWriter().info("queueFlushesCompleted = " + flushesCompleted);
        aStr.append("asyncQueueFlushesCompleted = " + flushesCompleted + "\n");
        if (queuedMessages <= 0L || flushesCompleted <= 0) {
            throw new TestException("TuningRequired: Test did not detect async messaging queuing, stats = \n" + aStr.toString());
        }
    }
}

