/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.memory;

import cacheperf.memory.CacheSizePrms;
import cacheperf.memory.CacheSizeStats;
import cacheperf.memory.TestObject;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.size.ObjectGraphSizer;
import distcache.DistCache;
import distcache.DistCacheFactory;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.CacheHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.AnyCyclicBarrier;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import perffmwk.PerfStatMgr;
import perffmwk.TrimInterval;

public class CacheSizeClient {
    private static final LogWriter LOG = Log.getLogWriter();
    private static final HydraThreadLocal threadLocalInstance = new HydraThreadLocal();
    private static final ObjectGraphSizer.ObjectFilter FILTER = new ObjectGraphSizer.ObjectFilter(){

        public boolean accept(Object parent, Object object) {
            boolean exclude = object instanceof TestObject || parent instanceof CachedDeserializable && object instanceof byte[];
            return !exclude;
        }
    };
    private DistCache cache;
    private CacheSizeStats statistics;
    private long emptyCacheMemSize;
    private long warmedUpCacheMemSize;
    private int warmedUpCacheSize;
    private final Writer dataFile;
    private final Map trimIntervals = new HashMap();
    private int cacheSize;
    private long cacheMemSize;
    private long perEntryOverhead;
    private final AnyCyclicBarrier barrier;

    public CacheSizeClient() throws IOException {
        this.trimIntervals.put("cacheSize", new TrimInterval());
        this.dataFile = new BufferedWriter(new FileWriter(Thread.currentThread().getName() + "_cache_size_data.csv", false));
        int numThreads = TestConfig.getInstance().getTotalThreads() - TestConfig.getInstance().getThreadGroup("locator").getTotalThreads();
        LOG.info("configuring barrier with " + numThreads + " parties");
        this.barrier = AnyCyclicBarrier.lookup(numThreads, "CacheSize");
    }

    public static CacheSizeClient getInstance() throws IOException {
        CacheSizeClient instance = (CacheSizeClient)threadLocalInstance.get();
        if (instance == null) {
            instance = new CacheSizeClient();
            threadLocalInstance.set(instance);
        }
        return instance;
    }

    public static void openCacheTask() throws IOException {
        CacheSizeClient.getInstance().openCache();
    }

    public static void closeCacheTask() throws IOException {
        CacheSizeClient.getInstance().closeCache();
    }

    public static void openStatisticsTask() throws IOException {
        CacheSizeClient.getInstance().openStatistics();
    }

    public static void closeStatisticsTask() throws IOException, IllegalArgumentException, InterruptedException, IllegalAccessException {
        CacheSizeClient.getInstance().closeStatistics();
    }

    public static void createIndexTask() throws IOException, RegionNotFoundException, IndexInvalidException, IndexNameConflictException, IndexExistsException, UnsupportedOperationException {
        CacheSizeClient.getInstance().createIndex();
    }

    public static void putDataTask() throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        CacheSizeClient.getInstance().putData();
    }

    public static void watchDataTask() throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        CacheSizeClient.getInstance().watchData();
    }

    public synchronized void openCache() {
        if (this.cache == null) {
            LOG.info("Opening cache");
            this.cache = DistCacheFactory.createInstance();
            this.cache.open();
            LOG.info("Opened cache");
        }
    }

    public synchronized void openStatistics() throws IOException {
        if (this.statistics == null) {
            LOG.info("Opening application statistics");
            this.statistics = CacheSizeStats.getInstance(RemoteTestModule.getCurrentThread().getThreadGroupName());
            this.dataFile.write("Time,Num Entries,Cache Mem Size,Per Entry Overhead from Sizer\n");
            LOG.info("Opened application statistics");
        }
    }

    public synchronized void closeCache() {
        if (this.cache != null) {
            LOG.info("Closing cache");
            this.cache.close();
            this.cache = null;
            LOG.info("Cache closed");
        }
    }

    public synchronized void closeStatistics() throws IOException, InterruptedException, IllegalArgumentException, IllegalAccessException {
        if (this.statistics != null) {
            LOG.info("Recording stats");
            this.writeStats();
            LOG.info("Closing stats");
            this.statistics.close();
            this.statistics = null;
            this.dataFile.close();
            LOG.info("Stats closed");
        }
    }

    private void createIndex() throws RegionNotFoundException, IndexInvalidException, IndexNameConflictException, IndexExistsException, UnsupportedOperationException {
        LOG.info("Creating Index");
        QueryService query = CacheHelper.getCache().getQueryService();
        Region region = ((GemFireCacheTestImpl)this.cache).getRegion();
        int indexCardinality = CacheSizePrms.getIndexCardinality();
        int numIndexedValues = CacheSizePrms.getNumIndexedValues();
        TestObject.uniqueValues = indexCardinality;
        TestObject.averageCollectionSize = numIndexedValues;
        if (numIndexedValues == 1) {
            query.createIndex("index", CacheSizePrms.getIndexType(), "indexValue", region.getFullPath());
        } else {
            query.createIndex("index", CacheSizePrms.getIndexType(), "val", region.getFullPath() + " region1, region1.indexCollection val TYPE int");
        }
        LOG.info("Index Created");
    }

    public void putData() throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        int numberOfEntries = CacheSizePrms.getNumberOfEntries();
        int sampleInterval = CacheSizePrms.getSampleInterval();
        int trimStart = CacheSizePrms.getTrimStart();
        CacheSizePrms.KeyType keyType = CacheSizePrms.getKeyType();
        this.recordInitialSize();
        for (int i = 0; i <= numberOfEntries; ++i) {
            if (i % sampleInterval == 0) {
                this.record();
            }
            if (i == trimStart) {
                this.setWarmedUp();
            }
            Object key = null;
            switch (keyType) {
                case testobject: {
                    key = new TestObject(i);
                    break;
                }
                case string: {
                    key = String.valueOf(i);
                    break;
                }
                case integer: {
                    key = i;
                    break;
                }
                default: {
                    String s = "Should not happen";
                    throw new IllegalArgumentException(s);
                }
            }
            TestObject value = new TestObject(i + numberOfEntries);
            this.cache.put(key, value);
        }
        this.recordFinalSize();
    }

    public void watchData() throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        int numberOfEntries = CacheSizePrms.getNumberOfEntries();
        int sampleInterval = CacheSizePrms.getSampleInterval();
        int trimStart = CacheSizePrms.getTrimStart();
        this.recordInitialSize();
        for (int i = 0; i <= numberOfEntries / sampleInterval; ++i) {
            this.record();
            if (i != trimStart / sampleInterval) continue;
            this.setWarmedUp();
        }
        this.recordFinalSize();
    }

    private void recordInitialSize() throws IllegalArgumentException, IllegalAccessException {
        Assert.assertTrue((this.cache.size() == 0 ? 1 : 0) != 0, (Object)"Cache size should be 0");
        this.emptyCacheMemSize = ObjectGraphSizer.size((Object)this.cache, (ObjectGraphSizer.ObjectFilter)FILTER, (boolean)true);
        LOG.info("Waiting for all threads to size empty cache");
        this.barrier.await();
        LOG.info("Done Waiting");
    }

    private void recordFinalSize() throws IllegalArgumentException, IllegalAccessException, FileNotFoundException {
        LOG.info("Waiting for all threads to complete");
        this.barrier.await();
        LOG.info("Done Waiting");
    }

    private void writeStats() throws InterruptedException, IllegalArgumentException, IllegalAccessException {
        long start = System.currentTimeMillis();
        for (TrimInterval interval : this.trimIntervals.values()) {
            interval.setStart(start);
        }
        int objectSize = (int)ObjectGraphSizer.size((Object)new TestObject(0), (boolean)true);
        this.statistics.setEmptyCacheMemSize(this.emptyCacheMemSize);
        this.statistics.setWarmedUpCacheMemSize(this.warmedUpCacheMemSize);
        this.statistics.setObjectSize(objectSize);
        this.statistics.setCacheSize(this.cacheSize);
        this.statistics.setCacheMemSize(this.cacheMemSize);
        this.statistics.setPerEntryOverhead(this.perEntryOverhead);
        Thread.sleep(1000L);
        long end = System.currentTimeMillis();
        for (TrimInterval interval : this.trimIntervals.values()) {
            interval.setEnd(end);
        }
        PerfStatMgr.getInstance().reportTrimIntervals(this.trimIntervals);
    }

    private void setWarmedUp() throws IllegalArgumentException, IllegalAccessException {
        this.warmedUpCacheSize = this.cache.size();
        this.warmedUpCacheMemSize = ObjectGraphSizer.size((Object)this.cache, (ObjectGraphSizer.ObjectFilter)FILTER, (boolean)true);
    }

    private void record() throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        LOG.info("Waiting for all threads to get to record method");
        this.barrier.await();
        LOG.info("Done Waiting");
        this.cacheSize = this.cache.size();
        this.cacheMemSize = ObjectGraphSizer.size((Object)this.cache, (ObjectGraphSizer.ObjectFilter)FILTER, (boolean)true);
        long cacheMemChange = this.cacheMemSize - this.warmedUpCacheMemSize;
        this.perEntryOverhead = this.warmedUpCacheSize == 0 || this.warmedUpCacheMemSize == 0L ? 0L : cacheMemChange / (long)(this.cacheSize - this.warmedUpCacheSize);
        this.dataFile.write(System.currentTimeMillis() + "," + this.cacheSize + "," + this.cacheMemSize + "," + this.perEntryOverhead + "\n");
        LOG.info("Waiting for all threads to finish record method");
        this.barrier.await();
        LOG.info("Done Waiting");
    }
}

