/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.memory;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

class TestObject
implements DataSerializable {
    private static final long serialVersionUID = 6232127232791545838L;
    static int averageCollectionSize = 5;
    static int uniqueValues = 5;
    private int id;

    private TestObject() {
    }

    public TestObject(int id) {
        this.id = id;
    }

    public int indexValue() {
        return this.id % uniqueValues;
    }

    public Collection indexCollection() {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < averageCollectionSize; ++i) {
            result.add(new Float((double)this.indexValue() + 1.0 / (double)(i + 1)));
        }
        return result;
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestObject other = (TestObject)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "TestObject[" + this.id + "]";
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(TestObject.class, 22){

            public DataSerializable newInstance() {
                return new TestObject();
            }
        });
    }
}

