/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.poc.useCase3_2;

import cacheperf.CachePerfException;
import cacheperf.poc.useCase3_2.TaskSyncBlackboard;
import cacheperf.poc.useCase3_2.UseCase3Prms;
import cacheperf.poc.useCase3_2.UseCase3Stats;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import hydra.AgentHelper;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientDescription;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.MethExecutor;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.TestTask;
import hydra.blackboard.AnyCyclicBarrier;
import hydra.blackboard.SharedMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import objects.ObjectHelper;
import util.TestHelper;

public class UseCase3Client {
    private static LogWriter log = Log.getLogWriter();
    private static final String WORKLOAD_START_TIME = "workload_start_time";
    private static final InterestResultPolicy policy = InterestResultPolicy.NONE;
    private static Cache cache;
    private static boolean VMCounted;
    private static final long TOTAL_OPS = 100000000L;
    public int tid;
    public int tgid;
    public int ttgid;
    public int numThreads;
    public List interestListBatch;
    public long batchStartTime;
    public boolean allowNulls;
    public Map<UseCase3Prms.RegionName, Integer> regionSpec;
    public int batchSeconds;
    public int keyAllocation;
    public int keyAllocationChunkSize;
    public int maxKeys;
    public Method batchTerminator;
    public Method taskTerminator;
    public Object[] terminatorArgs;
    public TestTask task;
    public UseCase3Stats statistics;
    public GsRandom rng;
    public int count;
    public long startTime;
    public int keyCount;
    public int currentKey;
    public String keyType;
    public long lastTaskTerminatorTime;
    public long workloadStartTime;
    private static HydraThreadLocal localtask;
    private static HydraThreadLocal localstatistics;
    private static HydraThreadLocal localrng;
    private static HydraThreadLocal localcount;
    private static HydraThreadLocal localkeycount;
    private static HydraThreadLocal localcurrentkey;
    private static HydraThreadLocal localkeytype;
    private static HydraThreadLocal locallasttaskterminatortime;
    private static HydraThreadLocal localstarttime;
    private static HydraThreadLocal localworkloadstarttime;
    private static HydraThreadLocal localtm;

    public static void createAndStartLocatorTask() {
        DistributedSystemHelper.createLocator();
        int parties = UseCase3Client.numThreads();
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup(parties, "locator");
        log.info("Waiting for " + parties + " to meet at locator barrier");
        barrier.await();
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void createAndStartAgentTask() {
        String agentConfig = ConfigPrms.getAgentConfig();
        AgentHelper.startConnectedAgent(agentConfig);
    }

    public static void connectTask() {
        DistributedSystemHelper.connect();
    }

    public static void disconnectTask() {
        DistributedSystemHelper.disconnect();
    }

    public static void openStatisticsTask() {
        UseCase3Client c = new UseCase3Client();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.statistics == null) {
            this.statistics = UseCase3Stats.getInstance();
            UseCase3Client.incVMCount(this.statistics);
            RemoteTestModule.openClockSkewStatistics();
        }
    }

    private static synchronized void incVMCount(UseCase3Stats s) {
        if (!VMCounted) {
            s.incVMCount();
            VMCounted = true;
        }
    }

    public static void closeStatisticsTask() {
        UseCase3Client c = new UseCase3Client();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    protected void closeStatistics() {
        MasterController.sleepForMs(2000);
        if (this.statistics != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.statistics.close();
        }
    }

    public static synchronized void createCacheTask() {
        String cacheConfig = ConfigPrms.getCacheConfig();
        cache = CacheHelper.createCache(cacheConfig);
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
        cache = null;
    }

    public static synchronized void createRegionsTask() {
        List regionConfigs = UseCase3Prms.getRegionConfigs();
        log.info("Creating regions using configs: " + regionConfigs);
        for (String regionConfig : regionConfigs) {
            RegionHelper.createRegion(regionConfig);
        }
    }

    public static void startServerTask() {
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        BridgeHelper.startBridgeServer(bridgeConfig);
    }

    public static void createPoolTask() {
        String poolConfig = ConfigPrms.getPoolConfig();
        PoolHelper.createPool(poolConfig);
    }

    public static void registerInterestTask() {
        UseCase3Client c = new UseCase3Client();
        c.initialize();
        if (c.tid() % c.numThreadsInVM() == 0) {
            c.registerInterest();
        }
    }

    private void registerInterest() {
        UseCase3Prms.RegionName regionName = UseCase3Prms.getRegionName();
        this.maxKeys = this.regionSpec.get((Object)regionName);
        Region region = cache.getRegion(regionName.toString());
        int interestTotalKeys = UseCase3Prms.getInterestTotalKeys();
        int interestBatchSize = UseCase3Prms.getInterestBatchSize();
        log.info("Registering interest in " + interestTotalKeys + " out of " + this.maxKeys + " keys in region " + (Object)((Object)regionName) + " using batches of size " + interestBatchSize);
        int bins = interestTotalKeys;
        int keysPerBin = this.maxKeys / bins;
        int remainder = this.maxKeys - bins * keysPerBin;
        if (log.finerEnabled()) {
            log.finer("region: " + (Object)((Object)regionName) + " maxKeys: " + this.maxKeys + " bins: " + bins + "keysPerBin: " + keysPerBin + " remainder " + remainder);
        }
        int totalKeys = 0;
        int registeredKeys = 0;
        ArrayList<Object> keys = new ArrayList<Object>();
        for (int bin = 0; bin < bins; ++bin) {
            int keysInThisBin = bin < remainder ? keysPerBin + 1 : keysPerBin;
            totalKeys += keysInThisBin;
            int rkey = this.rng.nextInt(0, keysInThisBin - 1);
            int key = rkey * bins + bin;
            keys.add(ObjectHelper.createName(this.keyType, key));
            if (log.finerEnabled()) {
                log.finer("bin #" + bin + " has " + keysInThisBin + " keys, selected rkey " + rkey + " key " + key);
            }
            if (keys.size() != interestBatchSize) continue;
            registeredKeys += keys.size();
            this.registerInterest(keys, region, regionName);
        }
        if (keys.size() > 0) {
            registeredKeys += keys.size();
            this.registerInterest(keys, region, regionName);
        }
        if (registeredKeys != interestTotalKeys) {
            String s = "Registered wrong number of keys: " + registeredKeys;
            throw new CachePerfException(s);
        }
        log.info("Registered " + registeredKeys + " total keys");
        if (totalKeys != this.maxKeys) {
            throw new CachePerfException("Wrong number of keys allocated to bins");
        }
    }

    private void registerInterest(List keys, Region region, UseCase3Prms.RegionName regionName) {
        if (log.fineEnabled()) {
            log.fine("REGION=" + (Object)((Object)regionName) + " OP=registerInterest KEYS=" + keys);
        }
        long start = this.statistics.startRegisterInterest();
        region.registerInterest((Object)keys, policy, false);
        this.statistics.endRegisterInterest(start, keys.size(), regionName);
        keys.clear();
    }

    public static void registerInterestRegexAllTask() {
        UseCase3Client c = new UseCase3Client();
        c.initialize();
        if (c.tid() % c.numThreadsInVM() == 0) {
            c.registerInterestRegexAll();
        }
    }

    private void registerInterestRegexAll() {
        UseCase3Prms.RegionName regionName = UseCase3Prms.getRegionName();
        this.maxKeys = this.regionSpec.get((Object)regionName);
        Region region = cache.getRegion(regionName.toString());
        String regex = ".*";
        log.info("Registering interest in all " + this.maxKeys + " keys in region " + (Object)((Object)regionName));
        long start = this.statistics.startRegisterInterest();
        region.registerInterestRegex(regex, policy, false);
        this.statistics.endRegisterInterest(start, this.maxKeys, regionName);
    }

    public static void createDataTask() {
        UseCase3Client c = new UseCase3Client();
        c.initialize();
        c.createData();
    }

    private void createData() {
        UseCase3Prms.RegionName regionName = UseCase3Prms.getRegionName();
        this.maxKeys = this.regionSpec.get((Object)regionName);
        log.info("Creating data in region " + (Object)((Object)regionName) + " with " + this.maxKeys + " keys");
        Region region = cache.getRegion(regionName.toString());
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.create(key, region, regionName);
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void create(int i, Region region, UseCase3Prms.RegionName regionName) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = UseCase3Prms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        if (log.fineEnabled()) {
            log.fine("REGION=" + (Object)((Object)regionName) + " OP=create KEY=" + key);
        }
        long start = this.statistics.startCreate();
        region.create(key, val);
        this.statistics.endCreate(start, 1, regionName);
    }

    public static void putDataTask() {
        UseCase3Client c = new UseCase3Client();
        c.initialize();
        c.putData();
    }

    private void putData() {
        UseCase3Prms.RegionName regionName = UseCase3Prms.getRegionName();
        this.maxKeys = this.regionSpec.get((Object)regionName);
        log.info("Putting data in region " + (Object)((Object)regionName) + " with " + this.maxKeys + " keys");
        Region region = cache.getRegion(regionName.toString());
        boolean batchDone = false;
        int sleepAfterOpMs = UseCase3Prms.getSleepAfterOpMs();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.put(key, region, regionName);
            ++this.count;
            ++this.keyCount;
            if (sleepAfterOpMs <= 0) continue;
            MasterController.sleepForMs(sleepAfterOpMs);
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    public static void mixDataTask() {
        UseCase3Client c = new UseCase3Client();
        c.initialize();
        c.mixData();
    }

    private void mixData() {
        boolean batchDone = false;
        Map<UseCase3Prms.CacheOp, Double> cacheOpSpec = UseCase3Prms.getCacheOpSpec();
        int sleepAfterOpMs = UseCase3Prms.getSleepAfterOpMs();
        do {
            UseCase3Prms.RegionName regionName = UseCase3Prms.getRegionName();
            Region region = cache.getRegion(regionName.toString());
            this.maxKeys = this.regionSpec.get((Object)regionName);
            int key = this.getNextKey();
            this.executeTaskTerminator();
            UseCase3Prms.CacheOp op = this.getCacheOp(cacheOpSpec);
            int sz = 1;
            switch (op) {
                case get: {
                    this.get(key, region, regionName);
                    break;
                }
                case put: {
                    this.put(key, region, regionName);
                    break;
                }
                case getAll: {
                    sz = this.getAll(key, region, regionName);
                    break;
                }
                case putAll: {
                    sz = this.putAll(key, region, regionName);
                    break;
                }
                default: {
                    throw new CachePerfException("Unsupported cacheOp: " + (Object)((Object)op));
                }
            }
            this.count += sz;
            this.keyCount += sz;
            if (sleepAfterOpMs <= 0) continue;
            MasterController.sleepForMs(sleepAfterOpMs);
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private UseCase3Prms.CacheOp getCacheOp(Map<UseCase3Prms.CacheOp, Double> cacheOpSpec) {
        long n = this.rng.nextLong(0L, 99999999L);
        double weight = 0.0;
        for (UseCase3Prms.CacheOp cacheOp : cacheOpSpec.keySet()) {
            if (!((double)n < (weight += cacheOpSpec.get((Object)cacheOp).doubleValue()) * 1.0E8)) continue;
            return cacheOp;
        }
        throw new CachePerfException("Should not happen");
    }

    private void get(int i, Region region, UseCase3Prms.RegionName regionName) {
        Object key = ObjectHelper.createName(this.keyType, i);
        if (log.fineEnabled()) {
            log.fine("REGION=" + (Object)((Object)regionName) + " OP=get KEY=" + key);
        }
        long start = this.statistics.startGet(regionName, 1);
        Object val = region.get(key);
        if (val == null) {
            if (this.allowNulls) {
                this.statistics.incNulls(regionName);
            } else {
                String s = "Got null at key=" + key + " of maxKeys=" + this.maxKeys + " for region " + (Object)((Object)regionName);
                throw new CachePerfException(s);
            }
        }
        this.statistics.endGet(start, 1, regionName);
    }

    private void put(int i, Region region, UseCase3Prms.RegionName regionName) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = UseCase3Prms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        if (log.fineEnabled()) {
            log.fine("REGION=" + (Object)((Object)regionName) + " OP=put KEY=" + key);
        }
        long start = this.statistics.startPut(regionName, 1);
        region.put(key, val);
        this.statistics.endPut(start, 1, regionName);
    }

    private int getAll(int i, Region region, UseCase3Prms.RegionName regionName) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(ObjectHelper.createName(this.keyType, i));
        for (int j = 1; j < UseCase3Prms.getBulkOpMapSize(); ++j) {
            int k = this.getNextKey();
            l.add(ObjectHelper.createName(this.keyType, k));
        }
        if (log.fineEnabled()) {
            log.fine("REGION=" + (Object)((Object)regionName) + " OP=getAll KEYS=" + l);
        }
        int sz = l.size();
        long start = this.statistics.startGetAll(regionName, sz);
        region.getAll(l);
        this.statistics.endGetAll(start, sz, regionName);
        return sz;
    }

    private int putAll(int i, Region region, UseCase3Prms.RegionName regionName) {
        String objectType = UseCase3Prms.getObjectType();
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(ObjectHelper.createName(this.keyType, i), ObjectHelper.createObject(objectType, i));
        for (int j = 1; j < UseCase3Prms.getBulkOpMapSize(); ++j) {
            int k = this.getNextKey();
            m.put(ObjectHelper.createName(this.keyType, k), ObjectHelper.createObject(objectType, k));
        }
        if (log.fineEnabled()) {
            log.fine("REGION=" + (Object)((Object)regionName) + " OP=putAll KEYS=" + m.keySet());
        }
        int sz = m.size();
        long start = this.statistics.startPutAll(regionName, sz);
        region.putAll(m);
        this.statistics.endPutAll(start, sz, regionName);
        return sz;
    }

    public static void bounceTask() throws ClientVmNotFoundException {
        UseCase3Client c = new UseCase3Client();
        c.initHydraThreadLocals();
        c.bounce();
    }

    private void bounce() throws ClientVmNotFoundException {
        int stopWaitSec = UseCase3Prms.getStopWaitSec();
        int restartWaitSec = UseCase3Prms.getRestartWaitSec();
        int killType = UseCase3Prms.useMeanKill() ? -21 : -22;
        UseCase3Prms.ClientName clientNameToBounce = UseCase3Prms.getClientNameToBounce();
        Map<String, ClientDescription> cds = TestConfig.getInstance().getClientDescriptions();
        ArrayList<String> clientNames = new ArrayList<String>();
        for (ClientDescription cd : cds.values()) {
            if (!cd.getName().startsWith(clientNameToBounce.toString())) continue;
            clientNames.add(cd.getName());
        }
        GsRandom rng = TestConfig.tab().getRandGen();
        String clientName = (String)clientNames.get(rng.nextInt(0, clientNames.size() - 1));
        ClientVmInfo info = new ClientVmInfo(null, clientName, null);
        log.info("Bouncing " + clientName + "...");
        if (stopWaitSec > 0) {
            log.info("Sleeping " + stopWaitSec + " sec before bouncing " + info);
            long startSleep = this.statistics.startSleep();
            MasterController.sleepForMs(stopWaitSec * 1000);
            this.statistics.endSleep(startSleep);
        }
        long startStop = this.statistics.startStop(clientNameToBounce);
        info = ClientVmMgr.stop("Stopping " + info, killType, -31, info);
        this.statistics.endStop(startStop, clientNameToBounce);
        if (restartWaitSec > 0) {
            log.info("Sleeping " + restartWaitSec + " sec before restarting " + info);
            long startSleep = this.statistics.startSleep();
            MasterController.sleepForMs(restartWaitSec * 1000);
            this.statistics.endSleep(startSleep);
        }
        long startStart = this.statistics.startStart(clientNameToBounce);
        info = ClientVmMgr.start("Restarting " + info, info);
        this.statistics.endStart(startStart, clientNameToBounce);
        log.info("Bounced " + clientName);
    }

    public static void rebalanceTask() throws InterruptedException {
        UseCase3Client c = new UseCase3Client();
        c.initHydraThreadLocals();
        c.rebalance();
    }

    private void rebalance() throws InterruptedException {
        log.info("Rebalancing buckets...");
        long start = this.statistics.startRebalance();
        RebalanceFactory rf = CacheHelper.getCache().getResourceManager().createRebalanceFactory();
        RebalanceOperation ro = rf.start();
        RebalanceResults results = ro.getResults();
        this.statistics.endRebalance(start);
        log.info("Rebalanced buckets");
    }

    protected int getNextKey() {
        int key;
        switch (this.keyAllocation) {
            case 0: {
                key = 0;
                break;
            }
            case 1: {
                key = this.keyCount;
                break;
            }
            case 2: {
                key = this.keyCount % this.maxKeys;
                break;
            }
            case 3: {
                key = this.rng.nextInt(0, this.maxKeys - 1);
                break;
            }
            case 4: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                    break;
                }
                key = this.currentKey;
                break;
            }
            case 5: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                    break;
                }
                key = this.currentKey + this.numThreads;
                break;
            }
            case 6: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                } else {
                    key = this.currentKey + this.numThreads;
                }
                if (key < this.maxKeys) break;
                key = this.ttgid;
                break;
            }
            case 7: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                }
                int numKeys = (int)Math.ceil(this.maxKeys / this.numThreads);
                if (this.ttgid >= this.maxKeys % this.numThreads) {
                    --numKeys;
                }
                key = this.ttgid + this.numThreads * this.rng.nextInt(0, numKeys);
                break;
            }
            case 8: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid * this.keyAllocationChunkSize;
                    break;
                }
                if ((this.currentKey + 1) % this.keyAllocationChunkSize == 0) {
                    key = this.currentKey + 1 + (this.numThreads - 1) * this.keyAllocationChunkSize;
                    break;
                }
                key = this.currentKey + 1;
                break;
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
        this.currentKey = key;
        return key;
    }

    private void checkSufficientKeys() {
        if (this.numThreads > this.maxKeys) {
            throw new HydraConfigException(this.maxKeys + " keys are not enough for " + this.numThreads + " threads to have their own keys");
        }
    }

    protected boolean executeBatchTerminator() {
        Object o;
        if (this.batchTerminator != null && ((Boolean)(o = this.executeTerminator(this.batchTerminator))).booleanValue()) {
            this.updateHydraThreadLocals();
            DistributedSystem.releaseThreadsSockets();
            return true;
        }
        return false;
    }

    protected void executeTaskTerminator() {
        Object o;
        if (this.taskTerminator != null && ((Boolean)(o = this.executeTerminator(this.taskTerminator))).booleanValue()) {
            this.updateHydraThreadLocals();
            throw new StopSchedulingTaskOnClientOrder();
        }
    }

    protected Method getMethod(String className, String methodName) {
        if (methodName == null || methodName.equals("null")) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(className);
            Class[] prmTypes = new Class[]{UseCase3Client.class};
            return MethExecutor.getMethod(cls, methodName, prmTypes);
        }
        catch (ClassNotFoundException e) {
            throw new HydraConfigException(className + " not found", e);
        }
        catch (NoSuchMethodException e) {
            throw new HydraConfigException(className + "." + methodName + "(UseCase3Client) not found", e);
        }
    }

    protected Object executeTerminator(Method m) {
        try {
            return m.invoke(null, this.terminatorArgs);
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(m + " does not return a String", e);
        }
        catch (IllegalAccessException e) {
            throw new HydraConfigException(m + " cannot be accessed", e);
        }
        catch (InvocationTargetException e) {
            throw new HydraConfigException(m + " cannot be invoked. " + "Exception is " + TestHelper.getStackTrace(e.getTargetException()), e);
        }
    }

    protected void initialize() {
        this.initLocalVariables();
        this.initLocalParameters();
        this.initHydraThreadLocals();
        this.initBatchVariables();
    }

    protected void initLocalVariables() {
        this.tid = this.tid();
        this.tgid = this.tgid();
        this.ttgid = this.ttgid();
        this.numThreads = UseCase3Client.numThreads();
        Assert.assertTrue((this.numThreads > 0 ? 1 : 0) != 0, (Object)("Have " + this.numThreads + " threads"));
    }

    protected void initBatchVariables() {
        this.batchStartTime = System.currentTimeMillis();
    }

    protected void initLocalParameters() {
        this.allowNulls = UseCase3Prms.allowNulls();
        this.regionSpec = UseCase3Prms.getRegionSpec();
        this.batchSeconds = UseCase3Prms.getBatchSeconds();
        this.keyAllocation = UseCase3Prms.getKeyAllocation();
        this.keyAllocationChunkSize = UseCase3Prms.getKeyAllocationChunkSize();
        this.batchTerminator = this.getMethod(UseCase3Prms.getBatchTerminatorClass(), UseCase3Prms.getBatchTerminatorMethod());
        this.taskTerminator = this.getMethod(UseCase3Prms.getTaskTerminatorClass(), UseCase3Prms.getTaskTerminatorMethod());
        this.terminatorArgs = new Object[]{this};
    }

    protected void initHydraThreadLocals() {
        this.task = this.getTask();
        this.rng = this.getRNG();
        this.statistics = this.getStatistics();
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        this.count = this.getCount();
        this.keyCount = this.getKeyCount();
        this.currentKey = this.getCurrentKey();
        this.keyType = this.getKeyType();
        this.lastTaskTerminatorTime = this.getLastTaskTerminatorTime();
        this.startTime = this.getStartTime();
        this.workloadStartTime = task.getTaskTypeString().equals("TASK") ? this.getWorkloadStartTime() : -1L;
    }

    protected void resetHydraThreadLocals() {
        localcount.set(null);
        localkeycount.set(null);
        localcurrentkey.set(null);
        locallasttaskterminatortime.set(null);
        localstarttime.set(null);
    }

    protected void updateHydraThreadLocals() {
        this.setStatistics(this.statistics);
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        this.setCount(this.count);
        this.setKeyCount(this.keyCount);
        this.setCurrentKey(this.currentKey);
        this.setKeyType(this.keyType);
        this.setLastTaskTerminatorTime(this.lastTaskTerminatorTime);
        this.setStartTime(this.startTime);
        if (this.workloadStartTime != -1L) {
            this.setWorkloadStartTime(this.workloadStartTime);
        }
    }

    protected TestTask getTask() {
        TestTask oldTask = (TestTask)localtask.get();
        TestTask newTask = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (oldTask == null) {
            localtask.set(newTask);
        } else if (!oldTask.equals(newTask)) {
            localtask.set(newTask);
            this.resetHydraThreadLocals();
        }
        return newTask;
    }

    protected UseCase3Stats getStatistics() {
        UseCase3Stats stats = (UseCase3Stats)localstatistics.get();
        return stats;
    }

    protected void setStatistics(UseCase3Stats stats) {
        localstatistics.set(stats);
    }

    protected int getCount() {
        Integer n = (Integer)localcount.get();
        if (n == null) {
            n = 0;
            localcount.set(n);
        }
        return n;
    }

    protected void setCount(int n) {
        localcount.set(n);
    }

    protected int getKeyCount() {
        Integer n = (Integer)localkeycount.get();
        if (n == null) {
            n = 0;
            localkeycount.set(n);
        }
        return n;
    }

    protected void setKeyCount(int n) {
        localkeycount.set(n);
    }

    protected int getCurrentKey() {
        Integer n = (Integer)localcurrentkey.get();
        if (n == null) {
            n = -1;
            localcurrentkey.set(n);
        }
        return n;
    }

    protected void setCurrentKey(int n) {
        localcurrentkey.set(n);
    }

    protected String getKeyType() {
        String t = (String)localkeytype.get();
        if (t == null) {
            t = UseCase3Prms.getKeyType();
            localkeytype.set(t);
        }
        return t;
    }

    protected void setKeyType(String t) {
        localkeytype.set(t);
    }

    protected long getLastTaskTerminatorTime() {
        Long t = (Long)locallasttaskterminatortime.get();
        if (t == null) {
            t = System.currentTimeMillis();
            locallasttaskterminatortime.set(t);
        }
        return t;
    }

    protected void setLastTaskTerminatorTime(long t) {
        locallasttaskterminatortime.set(t);
    }

    protected long getStartTime() {
        Long t = (Long)localstarttime.get();
        if (t == null) {
            t = System.currentTimeMillis();
            localstarttime.set(t);
        }
        return t;
    }

    protected void setStartTime(long t) {
        localstarttime.set(t);
    }

    protected long getWorkloadStartTime() {
        Long t = (Long)localworkloadstarttime.get();
        if (t == null) {
            SharedMap map = TaskSyncBlackboard.getInstance().getSharedMap();
            t = (Long)map.get(WORKLOAD_START_TIME);
            if (t == null) {
                t = System.currentTimeMillis();
                map.put(WORKLOAD_START_TIME, t);
                log.info("Posted WORKLOAD_START_TIME=" + t);
            }
            localworkloadstarttime.set(t);
        }
        return t;
    }

    protected void setWorkloadStartTime(long t) {
        localworkloadstarttime.set(t);
    }

    protected GsRandom getRNG() {
        GsRandom r = (GsRandom)localrng.get();
        if (r == null) {
            r = TestConfig.getInstance().getParameters().getRandGen();
            localrng.set(r);
        }
        return r;
    }

    public static String subset(String prefix, int n, int subsetSize1, String regionConfigs1, int subsetSize2, String regionConfigs2) {
        List<String> names = UseCase3Client.generateNames(prefix, n);
        List<String> configs1 = UseCase3Client.getTokens(regionConfigs1);
        if (configs1.size() < subsetSize1) {
            String s = "Cannot create a subset of size " + subsetSize1 + " from " + configs1;
            throw new HydraConfigException(s);
        }
        List<String> configs2 = UseCase3Client.getTokens(regionConfigs2);
        if (configs2.size() < subsetSize2) {
            String s = "Cannot create a subset of size " + subsetSize2 + " from " + configs2;
            throw new HydraConfigException(s);
        }
        return UseCase3Client.subset(names, subsetSize1, configs1, subsetSize2, configs2);
    }

    private static String subset(List<String> names, int subsetSize1, List<String> regionConfigs1, int subsetSize2, List<String> regionConfigs2) {
        String map = "";
        int j1 = 0;
        int j2 = 0;
        for (String name : names) {
            int i;
            if (map.length() != 0) {
                map = map + ", ";
            }
            String configs = "";
            for (i = 0; i < subsetSize1; ++i) {
                configs = configs + regionConfigs1.get(j1++ % regionConfigs1.size()) + " ";
            }
            for (i = 0; i < subsetSize2; ++i) {
                configs = configs + regionConfigs2.get(j2++ % regionConfigs2.size()) + " ";
            }
            map = map + name + " " + configs.trim();
        }
        return map;
    }

    public static String all(String prefix, int n, String regionConfigs) {
        List<String> names = UseCase3Client.generateNames(prefix, n);
        String map = "";
        for (String name : names) {
            if (map.length() != 0) {
                map = map + ", ";
            }
            map = map + name + " " + regionConfigs.trim();
        }
        return map;
    }

    private static List<String> generateNames(String prefix, int n) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 1; i <= n; ++i) {
            names.add(prefix + i);
        }
        return names;
    }

    public static List<String> getTokens(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, " ", false);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken().trim());
        }
        return tokens;
    }

    protected int tid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    protected int tgid() {
        return RemoteTestModule.getCurrentThread().getThreadGroupId();
    }

    protected int ttgid() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        int id = task.getTaskThreadGroupId(tgname, this.tgid());
        return id;
    }

    protected static int numThreadsInVM() {
        return TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmThreads();
    }

    protected static int numThreads() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        int t = task.getTotalThreads();
        return t;
    }

    static {
        VMCounted = false;
        localtask = new HydraThreadLocal();
        localstatistics = new HydraThreadLocal();
        localrng = new HydraThreadLocal();
        localcount = new HydraThreadLocal();
        localkeycount = new HydraThreadLocal();
        localcurrentkey = new HydraThreadLocal();
        localkeytype = new HydraThreadLocal();
        locallasttaskterminatortime = new HydraThreadLocal();
        localstarttime = new HydraThreadLocal();
        localworkloadstarttime = new HydraThreadLocal();
        localtm = new HydraThreadLocal();
    }
}

