/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.poc.useCase3_2;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UseCase3Prms
extends BasePrms {
    private static final String CACHE_PERF_NONE = "none";
    public static Long keyType;
    private static final String DEFAULT_KEY_ALLOCATION = "sameKeysWrap";
    public static Long keyAllocation;
    public static final int SAME_KEY = 0;
    public static final int SAME_KEYS = 1;
    public static final int SAME_KEYS_WRAP = 2;
    public static final int SAME_KEYS_RANDOM_WRAP = 3;
    public static final int OWN_KEY = 4;
    public static final int OWN_KEYS = 5;
    public static final int OWN_KEYS_WRAP = 6;
    public static final int OWN_KEYS_RANDOM_WRAP = 7;
    public static final int OWN_KEYS_CHUNKED = 8;
    public static Long keyAllocationChunkSize;
    public static Long objectType;
    public static Long allowNulls;
    private static final String DEFAULT_CLASS = "cacheperf.poc.useCase3_2.Terminators";
    public static Long batchSeconds;
    public static Long batchTerminatorClass;
    public static Long batchTerminatorMethod;
    public static Long taskTerminatorClass;
    public static Long taskTerminatorMethod;
    public static Long clientNameToBounce;
    public static Long useMeanKill;
    public static Long stopWaitSec;
    public static Long restartWaitSec;
    public static Long sleepAfterOpMs;
    public static Long interestTotalKeys;
    public static Long interestBatchSize;
    public static Long regionConfigs;
    public static Long regionSpec;
    public static Long regionName;
    public static Long cacheOpSpec;
    public static Long bulkOpMapSize;

    public static String getKeyType() {
        Long key = keyType;
        return UseCase3Prms.tab().stringAt(key, "java.lang.String");
    }

    public static int getKeyAllocation() {
        Long key = keyAllocation;
        String val = UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, DEFAULT_KEY_ALLOCATION));
        if (val.equalsIgnoreCase("sameKey")) {
            return 0;
        }
        if (val.equalsIgnoreCase("sameKeys")) {
            return 1;
        }
        if (val.equalsIgnoreCase(DEFAULT_KEY_ALLOCATION)) {
            return 2;
        }
        if (val.equalsIgnoreCase("sameKeysRandomWrap")) {
            return 3;
        }
        if (val.equalsIgnoreCase("ownKey")) {
            return 4;
        }
        if (val.equalsIgnoreCase("ownKeys")) {
            return 5;
        }
        if (val.equalsIgnoreCase("ownKeysWrap")) {
            return 6;
        }
        if (val.equalsIgnoreCase("ownKeysRandomWrap")) {
            return 7;
        }
        if (val.equalsIgnoreCase("ownKeysChunked")) {
            return 8;
        }
        throw new HydraConfigException("Illegal value for " + UseCase3Prms.nameForKey(key) + ": " + val);
    }

    public static int getKeyAllocationChunkSize() {
        Long key = keyAllocationChunkSize;
        return UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 1));
    }

    public static String getObjectType() {
        Long key = objectType;
        return UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, "objects.SizedString"));
    }

    public static boolean allowNulls() {
        Long key = allowNulls;
        return UseCase3Prms.tasktab().booleanAt(key, UseCase3Prms.tab().booleanAt(key, false));
    }

    public static int getBatchSeconds() {
        Long key = batchSeconds;
        int val = UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, -1));
        return val;
    }

    public static String getBatchTerminatorClass() {
        Long key = batchTerminatorClass;
        return UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, DEFAULT_CLASS));
    }

    public static String getBatchTerminatorMethod() {
        return UseCase3Prms.getTerminatorMethod(batchTerminatorMethod, "terminateOnBatchSecodns");
    }

    public static String getTaskTerminatorClass() {
        Long key = taskTerminatorClass;
        return UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, DEFAULT_CLASS));
    }

    public static String getTaskTerminatorMethod() {
        return UseCase3Prms.getTerminatorMethod(taskTerminatorMethod, "terminateOnTotalTaskTimeSec");
    }

    private static String getTerminatorMethod(Long key, String dfault) {
        String val = UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, dfault));
        return val == null || val.equalsIgnoreCase(CACHE_PERF_NONE) ? null : val;
    }

    public static ClientName getClientNameToBounce() {
        Long key = clientNameToBounce;
        String val = UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, null));
        if (val == null) {
            String s = "Missing " + UseCase3Prms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return ClientName.toClientName(val);
    }

    public static boolean useMeanKill() {
        Long key = useMeanKill;
        return UseCase3Prms.tasktab().booleanAt(key, UseCase3Prms.tab().booleanAt(key, false));
    }

    public static int getStopWaitSec() {
        Long key = stopWaitSec;
        int val = UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 0));
        if (val < 0 && val != -1) {
            String s = "Illegal value for " + UseCase3Prms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getRestartWaitSec() {
        Long key = restartWaitSec;
        int val = UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 0));
        if (val < 0 && val != -1) {
            String s = "Illegal value for " + UseCase3Prms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getSleepAfterOpMs() {
        Long key = sleepAfterOpMs;
        return UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 1000));
    }

    public static int getInterestTotalKeys() {
        Long key = interestTotalKeys;
        int val = UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 1));
        if (val <= 0) {
            String s = BasePrms.nameForKey(key) + "=" + val + "  must be greater than 0";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getInterestBatchSize() {
        Long key = interestBatchSize;
        int val = UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 10));
        if (val <= 1) {
            String s = BasePrms.nameForKey(key) + "=" + val + "  must be greater than 1";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static List getRegionConfigs() {
        Long key = regionConfigs;
        return UseCase3Prms.tasktab().vecAt(key, UseCase3Prms.tab().vecAt(key, null));
    }

    public static Map<RegionName, Integer> getRegionSpec() {
        Long key = regionSpec;
        HydraVector vv = UseCase3Prms.tasktab().vecAt(key, UseCase3Prms.tab().vecAt(key, null));
        if (vv == null) {
            String s = "Missing " + UseCase3Prms.nameForKey(key) + ": " + vv;
            throw new HydraConfigException(s);
        }
        HashMap<RegionName, Integer> map = new HashMap<RegionName, Integer>();
        for (Vector v : vv) {
            int mkey;
            if (v.size() != 2) {
                String s = "Malformed " + UseCase3Prms.nameForKey(key) + ": " + vv;
                throw new HydraConfigException(s);
            }
            RegionName rname = RegionName.toRegionName((String)v.get(0));
            try {
                mkey = Integer.parseInt((String)v.get(1));
            }
            catch (NumberFormatException e) {
                String s = "Malformed " + UseCase3Prms.nameForKey(key) + ": " + vv;
                throw new HydraConfigException(s);
            }
            map.put(rname, mkey);
        }
        return map;
    }

    public static RegionName getRegionName() {
        Long key = regionName;
        String val = UseCase3Prms.tasktab().stringAt(key, UseCase3Prms.tab().stringAt(key, null));
        if (val == null) {
            String s = "Missing " + UseCase3Prms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return RegionName.toRegionName(val);
    }

    public static Map<CacheOp, Double> getCacheOpSpec() {
        Long key = cacheOpSpec;
        HydraVector vv = UseCase3Prms.tasktab().vecAt(key, UseCase3Prms.tab().vecAt(key, null));
        if (vv == null) {
            String s = "Missing " + UseCase3Prms.nameForKey(key) + ": " + vv;
            throw new HydraConfigException(s);
        }
        double total = 0.0;
        HashMap<CacheOp, Double> map = new HashMap<CacheOp, Double>();
        for (Vector v : vv) {
            double weight;
            if (v.size() != 2) {
                String s = "Malformed " + UseCase3Prms.nameForKey(key) + ": " + vv;
                throw new HydraConfigException(s);
            }
            CacheOp op = CacheOp.toCacheOp((String)v.get(0));
            try {
                weight = Double.parseDouble((String)v.get(1)) / 100.0;
            }
            catch (NumberFormatException e) {
                String s = "Malformed " + UseCase3Prms.nameForKey(key) + ": " + vv;
                throw new HydraConfigException(s);
            }
            total += weight;
            map.put(op, weight);
        }
        if (total != 1.0) {
            String s = UseCase3Prms.nameForKey(key) + " percentages do not add up to 100: " + vv;
            throw new HydraConfigException(s);
        }
        return map;
    }

    public static int getBulkOpMapSize() {
        Long key = bulkOpMapSize;
        int val = UseCase3Prms.tasktab().intAt(key, UseCase3Prms.tab().intAt(key, 1));
        if (val <= 0) {
            String s = BasePrms.nameForKey(key) + " must be greater than 0: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static void main(String[] args) {
        UseCase3Prms.dumpKeys();
    }

    static {
        UseCase3Prms.setValues(UseCase3Prms.class);
    }

    public static enum RegionName {
        Par,
        ParPersist,
        Rep,
        RepPersist;


        public static RegionName toRegionName(String regionName) {
            if (regionName.equalsIgnoreCase("Par")) {
                return Par;
            }
            if (regionName.equalsIgnoreCase("ParPersist")) {
                return ParPersist;
            }
            if (regionName.equalsIgnoreCase("Rep")) {
                return Rep;
            }
            if (regionName.equalsIgnoreCase("RepPersist")) {
                return RepPersist;
            }
            throw new HydraConfigException("Unknown region: " + regionName);
        }
    }

    public static enum ClientName {
        data,
        server;


        public static ClientName toClientName(String clientName) {
            if (clientName.equalsIgnoreCase("data")) {
                return data;
            }
            if (clientName.equalsIgnoreCase("server")) {
                return server;
            }
            throw new HydraConfigException("Unknown clientName: " + clientName);
        }
    }

    public static enum CacheOp {
        get,
        put,
        getAll,
        putAll;


        public static CacheOp toCacheOp(String cacheOp) {
            if (cacheOp.equalsIgnoreCase("get")) {
                return get;
            }
            if (cacheOp.equalsIgnoreCase("put")) {
                return put;
            }
            if (cacheOp.equalsIgnoreCase("getAll")) {
                return getAll;
            }
            if (cacheOp.equalsIgnoreCase("putAll")) {
                return putAll;
            }
            throw new HydraConfigException("Unknown cacheOp: " + cacheOp);
        }
    }
}

