/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConLoader;
import capCon.CapConPrms;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.ClientDescription;
import hydra.GsRandom;
import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import util.CacheUtil;
import util.RandomValues;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public abstract class CapConTest
implements Serializable {
    protected static final String REGION_NAME = "capConRegion";
    public static CapConTest testInstance;
    protected RandomValues randomValues;
    protected static NanoTimer nt;
    protected int LRUAllowance = -1;
    protected int numVMs = -1;
    protected int numThreads = -1;
    protected boolean useTransactions;

    public abstract Object getNewKey();

    public abstract Object getNewValue();

    public abstract CacheListener getEventListener();

    public abstract Object getPreviousKey();

    protected void initialize() {
        this.useTransactions = TestConfig.tab().booleanAt(CapConPrms.useTransactions, false);
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        this.numVMs = cd.getVmQuantity();
        this.numThreads = cd.getVmThreads();
        this.randomValues = new RandomValues();
        Cache myCache = CacheUtil.createCache();
        CacheListener aListener = this.getEventListener();
        CapConLoader cacheLoader = new CapConLoader();
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        Log.getLogWriter().info("Using RegionDefinition " + regDef + " to create region");
        regDef.createRootRegion(myCache, REGION_NAME, aListener, cacheLoader, null);
        CapConBB.getBB().printSharedCounters();
    }

    protected void addEntries() {
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In addEntries, adding for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        boolean inTrans = false;
        if (this.useTransactions) {
            TxHelper.begin();
            inTrans = true;
        }
        GsRandom rand = TestConfig.tab().getRandGen();
        do {
            if (rand.nextBoolean()) {
                this.addEntry();
                continue;
            }
            this.randomGet();
        } while (timeToRunSec != 0L && System.currentTimeMillis() - startTime < timeToRunMS);
        if (inTrans) {
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    Log.getLogWriter().info("addEntries caught ConflictException " + (Object)((Object)e) + ", expected with concurrent execution tests (loads can now cause conflicts), continuing with test");
                }
            } else {
                TxHelper.rollback();
            }
        }
        Log.getLogWriter().info("In addEntries, done running for " + timeToRunSec + " seconds");
    }

    protected Object[] addEntry() {
        Region workRegion = this.getWorkRegion();
        Object key = this.getNewKey();
        boolean useCacheLoader = this.useCacheLoader();
        Object value = null;
        if (useCacheLoader) {
            String aStr = key + " in " + TestHelper.regionToString(workRegion, false);
            Log.getLogWriter().info("Getting " + aStr + " with callback object " + this);
            try {
                nt.reset();
                value = workRegion.get(key, (Object)this);
                long duration = nt.reset();
                Log.getLogWriter().info("Done getting " + aStr + "; get took " + TestHelper.nanosToString(duration));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        value = this.getNewValue();
        try {
            String aStr = key + " with value " + TestHelper.toString(value) + " in " + TestHelper.regionToString(workRegion, false);
            Log.getLogWriter().info("Putting " + aStr);
            nt.reset();
            workRegion.put(key, value);
            long duration = nt.reset();
            Log.getLogWriter().info("Done putting " + aStr + "; put took " + TestHelper.nanosToString(duration));
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        CapConTest.checkForEventError();
        return new Object[]{key, value};
    }

    protected void randomGet() {
        Region workRegion = this.getWorkRegion();
        Object key = this.getPreviousKey();
        String aStr = key + " in " + TestHelper.regionToString(workRegion, false);
        Log.getLogWriter().info("Getting previous key " + aStr + " with callback object " + this);
        try {
            nt.reset();
            workRegion.get(key, (Object)this);
            long duration = nt.reset();
            Log.getLogWriter().info("Done getting " + aStr + "; get took " + TestHelper.nanosToString(duration));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static void checkForEventError() {
        TestHelper.checkForEventError(CapConBB.getBB());
    }

    protected Region getWorkRegion() {
        Region workRegion = CacheUtil.getCache().getRegion(REGION_NAME);
        return workRegion;
    }

    public static void HydraTask_endTask() {
        CapConBB.getBB().printSharedCounters();
        CapConTest.checkForEventError();
        double numEvictions = TestHelper.getNumLRUEvictions();
        Log.getLogWriter().info("Number of lru evictions during test: " + numEvictions);
    }

    public boolean useCacheLoader() {
        if (CapConBB.fixUseCacheLoader()) {
            return CapConBB.useCacheLoader();
        }
        return TestConfig.tab().booleanAt(CapConPrms.useCacheLoader);
    }

    static {
        nt = new NanoTimer();
    }
}

