/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConPrms;
import capCon.CapConTest;
import capCon.LRUEvict;
import capCon.MemLRUEvict;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class EvictTest {
    static boolean scopeIsLocal;

    static void initEvictTest(Region workRegion) {
        Scope scope = workRegion.getAttributes().getScope();
        scopeIsLocal = scope.isLocal();
        Log.getLogWriter().info("Setting scopeIsLocal to " + scopeIsLocal + ", scope is " + scope);
    }

    static void serialEvictTest(CapConTest testInstance, Region workRegion) {
        HashSet afterKeySet;
        long destroyCounter;
        long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        if (exeNum == 0L && (destroyCounter = EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterDestroyEvents_isNotExp)) != 0L) {
            throw new TestException("Expected no destroys to have occurred on the first serial execution, but execution number is " + exeNum + " and numAfterDestroyEvents_isNotExp is " + destroyCounter);
        }
        SharedCounters counters = EventCountersBB.getBB().getSharedCounters();
        long numEvicted = 0L;
        long before_afterCreateEvents = counters.read(EventCountersBB.numAfterCreateEvents_isNotExp);
        long before_afterDestroyEvents = counters.read(EventCountersBB.numAfterDestroyEvents_isNotExp);
        HashSet beforeKeySet = new HashSet(workRegion.keys());
        Log.getLogWriter().info("Before add, keySet size is " + beforeKeySet.size() + "before_afterCreateEvents is " + before_afterCreateEvents + ", before_afterDestroyEvents is " + before_afterDestroyEvents + ", scopeIsLocal is " + scopeIsLocal);
        Object[] nameAddedArr = null;
        if (testInstance.useTransactions) {
            TxHelper.begin();
            int numToAddInTx = TestConfig.tab().intAt(CapConPrms.numToAddInTx);
            Log.getLogWriter().info("Adding " + numToAddInTx + " entries to region during transaction");
            nameAddedArr = new Object[numToAddInTx];
            for (int i = 0; i < numToAddInTx; ++i) {
                Object nameAdded;
                nameAddedArr[i] = nameAdded = testInstance.addEntry()[0];
            }
            beforeKeySet = new HashSet(workRegion.keys());
            Log.getLogWriter().info("Before commit, keySet size is " + beforeKeySet.size());
            TxHelper.commitExpectSuccess();
            afterKeySet = new HashSet(workRegion.keys());
            if (afterKeySet.size() <= beforeKeySet.size()) {
                numEvicted = beforeKeySet.size() - afterKeySet.size();
            }
        } else {
            nameAddedArr = new Object[]{testInstance.addEntry()[0]};
            afterKeySet = new HashSet(workRegion.keys());
            if (afterKeySet.size() <= beforeKeySet.size()) {
                numEvicted = beforeKeySet.size() - afterKeySet.size() + 1;
            }
        }
        Log.getLogWriter().info("After add, keySet size is " + afterKeySet.size() + ", numEvicted is " + numEvicted);
        long expectedAfterCreateEvents = 0L;
        if (scopeIsLocal) {
            expectedAfterCreateEvents = before_afterCreateEvents + (long)nameAddedArr.length;
            Log.getLogWriter().info("scopeIsLocal is " + scopeIsLocal + ", incrementing expectedAfterCreateEvents by one, now is " + expectedAfterCreateEvents);
        } else {
            expectedAfterCreateEvents = before_afterCreateEvents + (long)(testInstance.numVMs * nameAddedArr.length);
            Log.getLogWriter().info("scopeIsLocal is " + scopeIsLocal + ", incrementing expectedAfterCreateEvents by " + testInstance.numVMs + ", now is " + expectedAfterCreateEvents);
        }
        TestHelper.waitForCounter(EventCountersBB.getBB(), "EventCountersBB.numAfterCreateEvents_isNotExp", EventCountersBB.numAfterCreateEvents_isNotExp, expectedAfterCreateEvents, true, 60000L);
        long expectedAfterDestroyEvents = before_afterDestroyEvents + numEvicted;
        TestHelper.waitForCounter(EventCountersBB.getBB(), "EventCountersBB.numAfterDestroyEvents_isNotExp", EventCountersBB.numAfterDestroyEvents_isNotExp, expectedAfterDestroyEvents, true, 60000L);
        for (int i = 0; i < nameAddedArr.length; ++i) {
            EvictTest.checkEvictions(workRegion, beforeKeySet, afterKeySet, nameAddedArr[i], testInstance);
        }
        if (testInstance instanceof LRUEvict) {
            ((LRUEvict)testInstance).verifyNumKeys();
        } else if (testInstance instanceof MemLRUEvict) {
            MemLRUEvict aTest = (MemLRUEvict)testInstance;
            aTest.verifyMemCapacity(aTest.memLRUParams.getTotalAllowableBytes());
        } else {
            throw new TestException("Unknown testInstance " + testInstance);
        }
        CapConTest.checkForEventError();
    }

    static void checkEvictions(Region workRegion, Set beforeKeySet, Set afterKeySet, Object nameAdded, CapConTest testInstance) {
        boolean newNameIsPresent = afterKeySet.contains(nameAdded);
        if (!newNameIsPresent) {
            throw new TestException("After adding " + nameAdded + ", it is not present in " + TestHelper.regionToString(workRegion, false));
        }
        Log.getLogWriter().info(nameAdded + " is present in the afterKeySet");
        HashSet afterTmpSet = new HashSet(afterKeySet);
        afterTmpSet.remove(nameAdded);
        if (afterTmpSet.contains(nameAdded)) {
            throw new TestException("After removing " + nameAdded + " it is still in " + afterTmpSet);
        }
        boolean containsAll = beforeKeySet.containsAll(afterTmpSet);
        if (!containsAll) {
            StringBuffer aStr = new StringBuffer();
            aStr.append("Before key set: ");
            int count = 0;
            Iterator it = beforeKeySet.iterator();
            while (it.hasNext()) {
                aStr.append(it.next() + " ");
                if (count % 10 == 0) {
                    aStr.append("\n   ");
                }
                ++count;
            }
            aStr.append("After key set:\n");
            count = 0;
            it = afterTmpSet.iterator();
            while (it.hasNext()) {
                aStr.append(it.next() + " ");
                if (count % 10 == 0) {
                    aStr.append("\n   ");
                }
                ++count;
            }
            throw new TestException("Expected beforeKeySet to be a superset of afterTmpSet: \n" + aStr);
        }
        HashSet evictedSet = new HashSet(beforeKeySet);
        evictedSet.removeAll(afterKeySet);
        Log.getLogWriter().info("evictedSet is " + evictedSet);
    }
}

