/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConLoader;
import capCon.CapConPrms;
import capCon.EvictListener;
import capCon.EvictTest;
import capCon.LRUTest;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import event.LogListener;
import hydra.ClientDescription;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import util.CacheUtil;
import util.EventCountersBB;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class LRUEvict
extends LRUTest {
    public static synchronized void HydraTask_initializeWithLogListener() {
        if (testInstance == null) {
            testInstance = new LRUEvict();
            ((LRUEvict)testInstance).initialize(new LogListener());
            ((LRUEvict)LRUEvict.testInstance).maximumEntries = CacheUtil.getRegion("capConRegion").getAttributes().getEvictionAttributes().getMaximum();
            ((LRUEvict)testInstance).initFields();
            Log.getLogWriter().info(testInstance.toString());
        }
    }

    public static synchronized void HydraTask_initializeWithEvictListener() {
        if (testInstance == null) {
            testInstance = new LRUEvict();
            ((LRUEvict)testInstance).initialize(new EvictListener());
            ((LRUEvict)LRUEvict.testInstance).maximumEntries = CacheUtil.getRegion("capConRegion").getAttributes().getEvictionAttributes().getMaximum();
            ((LRUEvict)testInstance).initFields();
            EvictTest.initEvictTest(testInstance.getWorkRegion());
            Log.getLogWriter().info(testInstance.toString());
        }
    }

    public static void HydraTask_serialEvictTest() {
        Region workRegion = testInstance.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_serialEvictTest, adding for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            EvictTest.serialEvictTest(testInstance, workRegion);
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
    }

    public static void HydraTask_fill() {
        ((LRUEvict)testInstance).fill();
    }

    protected synchronized void initialize(CacheListener aListener) {
        this.useTransactions = TestConfig.tab().booleanAt(CapConPrms.useTransactions, false);
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        this.numVMs = cd.getVmQuantity();
        this.numThreads = cd.getVmThreads();
        this.randomValues = new RandomValues();
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        regDef.createRootRegion(CacheUtil.createCache(), "capConRegion", aListener, new CapConLoader(), null);
    }

    @Override
    protected void initFields() {
        this.LRUAllowance = TestConfig.tab().intAt(CapConPrms.LRUAllowance);
        super.initFields();
    }

    @Override
    public CacheListener getEventListener() {
        return new EvictListener();
    }

    public static void HydraTask_endTask() {
        NameBB.getBB().printSharedCounters();
        CapConBB.getBB().printSharedCounters();
        SharedCounters counters = EventCountersBB.getBB().getSharedCounters();
        long numAfterCreateEvents = counters.read(EventCountersBB.numAfterCreateEvents_isNotExp);
        long numAfterDestroyEvents = counters.read(EventCountersBB.numAfterDestroyEvents_isNotExp);
        long numAfterInvalidateEvents = counters.read(EventCountersBB.numAfterInvalidateEvents_isNotExp);
        long numAfterUpdateEvents = counters.read(EventCountersBB.numAfterUpdateEvents_isNotExp);
        long currentNameCounter = NameFactory.getPositiveNameCounter();
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        long expectedAfterCreateEvents = currentNameCounter;
        if (!regDef.getScope().isLocal()) {
            String clientName = System.getProperty("clientName");
            ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
            int numVMs = cd.getVmQuantity();
            expectedAfterCreateEvents = currentNameCounter * (long)numVMs;
            Log.getLogWriter().info("ExpectedAfterCreateEvents is currentNameCounter " + currentNameCounter + " * numVMs " + numVMs + ": " + expectedAfterCreateEvents);
        } else {
            Log.getLogWriter().info("ExpectedAfterCreateEvents is currentNameCounter " + currentNameCounter);
        }
        StringBuffer errStr = new StringBuffer();
        if (numAfterCreateEvents != expectedAfterCreateEvents) {
            errStr.append("Expected NUM_OBJECT_ADDED_EVENTS " + numAfterCreateEvents + " to be equal to expectedAfterCreateEvents " + expectedAfterCreateEvents + "\n");
        }
        if (numAfterInvalidateEvents != 0L) {
            errStr.append("Expected NUM_OBJECT_INVALIDATED_EVENTS " + numAfterInvalidateEvents + " to be 0\n");
        }
        if (numAfterUpdateEvents != 0L) {
            errStr.append("Expected NUM_OBJECT_REPLACED_EVENTS " + numAfterUpdateEvents + " to be 0\n");
        }
        if (numAfterDestroyEvents <= 0L) {
            errStr.append("Expected NUM_OBJECT_DESTROYED_EVENTS " + numAfterDestroyEvents + " to be > 0");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        double numEvictions = TestHelper.getNumLRUEvictions();
        Log.getLogWriter().info("Number of lru evictions during test: " + numEvictions);
    }

    protected void fill() {
        Log.getLogWriter().info("Filling with " + this.maximumEntries + " entries...");
        for (int i = 1; i <= this.maximumEntries; ++i) {
            testInstance.addEntry();
            ((LRUEvict)testInstance).verifyNumKeys();
        }
    }
}

