/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConPrms;
import capCon.MemLRUListener;
import capCon.MemLRUParameters;
import capCon.MemLRUTest;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EvictionAttributesMutator;
import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import util.Bounds;
import util.BoundsPrms;
import util.CacheUtil;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class MemLRUDynamicTest
extends MemLRUTest {
    private int boundsMultiplier = -1;
    private Bounds regionBounds = null;
    private boolean randomCapacityChanges = false;
    final long NUM_EVICTIONS_BEFORE_CHANGE = 200L;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new MemLRUDynamicTest();
            ((MemLRUDynamicTest)testInstance).initFields();
            testInstance.initialize();
            Log.getLogWriter().info(testInstance.toString());
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        Region aRegion = CacheUtil.getRegion("capConRegion");
        int currentPoint = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.CURRENT_POINT);
        int mm = currentPoint * this.boundsMultiplier;
        EvictionAttributesMutator mutator = aRegion.getAttributesMutator().getEvictionAttributesMutator();
        mutator.setMaximum(mm);
        Log.getLogWriter().info("Memory evictor is set to " + mm + " megabytes");
        this.memLRUParams = new MemLRUParameters(20, 1 * this.boundsMultiplier, aRegion);
        CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, this.memLRUParams);
    }

    protected void initFields() {
        this.boundsMultiplier = TestConfig.tab().intAt(CapConPrms.boundsMultiplier);
        int targetLowPoint = TestConfig.tab().intAt(BoundsPrms.targetLowPoint);
        int targetHighPoint = TestConfig.tab().intAt(BoundsPrms.targetHighPoint);
        this.regionBounds = new Bounds(targetLowPoint, targetHighPoint, true, CapConBB.class, CapConBB.CAPCON_BB_NAME, CapConBB.CAPCON_BB_TYPE);
        CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(1));
        this.randomCapacityChanges = (Boolean)CapConBB.getBB().getSharedMap().get(CapConBB.RANDOM_CAPACITY_CHANGES);
        CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE, 200L);
    }

    public static void HydraTask_serialTest() {
        ((MemLRUDynamicTest)testInstance).doDynamicTest(true);
    }

    public static void HydraTask_serialTxTest() {
        ((MemLRUDynamicTest)testInstance).doSerialDynamicTxTest();
    }

    public static void HydraTask_concTxTest() {
        ((MemLRUDynamicTest)testInstance).doConcDynamicTxTest();
    }

    public static void HydraTask_concTest() {
        ((MemLRUDynamicTest)testInstance).doDynamicTest(false);
    }

    public static void HydraTask_endTask() {
        MemLRUDynamicTest.checkForEventError();
        long numCapacityChanges = CapConBB.getBB().getSharedCounters().read(CapConBB.NUM_CAPACITY_CHANGES);
        Log.getLogWriter().warning("Number of capacity changes: " + numCapacityChanges);
    }

    private void doDynamicTest(boolean isSerialExecution) {
        if (isSerialExecution) {
            long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
            Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        }
        this.memLRUParams = (MemLRUParameters)CapConBB.getBB().getSharedMap().get(CapConBB.TEST_SETTINGS);
        long checkForCapacityChangeInterval = 10000L;
        Region workRegion = this.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In MemLRUDynamicTest.doDynamicTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        long lastCapacityChangeCheck = 0L;
        do {
            MemLRUDynamicTest.checkForEventError();
            boolean newCapacity = false;
            boolean newCapacityIsLower = false;
            if (System.currentTimeMillis() - lastCapacityChangeCheck >= 10000L) {
                lastCapacityChangeCheck = System.currentTimeMillis();
                double currentNumLRUEvictions = TestHelper.getNumLRUEvictions();
                long numLRUEvictionsToTriggerCapacityChange = CapConBB.getBB().getSharedCounters().read(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE);
                Log.getLogWriter().info("Checking for capacity change, currentNumLRUEvictions = " + currentNumLRUEvictions + ", numLRUEvictionsToTriggerCapacityChange " + numLRUEvictionsToTriggerCapacityChange);
                if (currentNumLRUEvictions >= (double)numLRUEvictionsToTriggerCapacityChange) {
                    int currentPoint = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.CURRENT_POINT);
                    int newMaximumMegabytes = -1;
                    int oldCurrentPoint = currentPoint;
                    currentPoint = this.randomCapacityChanges ? TestConfig.tab().getRandGen().nextInt(this.regionBounds.getTargetLowPoint(), this.regionBounds.getTargetHighPoint()) : (this.regionBounds.getDirection(currentPoint) == 0 ? ++currentPoint : --currentPoint);
                    newMaximumMegabytes = currentPoint * this.boundsMultiplier;
                    Region aRegion = CacheUtil.getRegion("capConRegion");
                    Log.getLogWriter().info("Setting new capacity (maximumMegabytes) " + newMaximumMegabytes + " on " + aRegion.getFullPath());
                    EvictionAttributesMutator mutator = aRegion.getAttributesMutator().getEvictionAttributesMutator();
                    mutator.setMaximum(newMaximumMegabytes);
                    CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(currentPoint));
                    long cntr = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.NUM_CAPACITY_CHANGES);
                    Log.getLogWriter().info("CapConBB.NUM_CAPACITY_CHANGES is now " + cntr);
                    newCapacity = true;
                    newCapacityIsLower = currentPoint < oldCurrentPoint;
                    this.memLRUParams = new MemLRUParameters(20, newMaximumMegabytes, aRegion);
                    CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, this.memLRUParams);
                }
            }
            long beforeDestroyNotExp = EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterDestroyEvents_isNotExp);
            int beforeNumKeys = workRegion.keys().size();
            int afterNumKeys = 0;
            if (this.useTransactions) {
                TxHelper.begin();
            }
            testInstance.addEntry();
            if (TxHelper.exists()) {
                TxHelper.commitExpectSuccess();
            }
            ++count;
            afterNumKeys = workRegion.keys().size();
            CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, afterNumKeys);
            Log.getLogWriter().info("After adding an entry: beforeNumKeys = " + beforeNumKeys + ", afterNumKeys = " + afterNumKeys);
            if (newCapacity) {
                double currentNumLRUEvictions = TestHelper.getNumLRUEvictions();
                CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE, (long)currentNumLRUEvictions + 200L);
            }
            if (!isSerialExecution) continue;
            int numEvicted = beforeNumKeys - afterNumKeys + 1;
            if (numEvicted < 0) {
                numEvicted = 0;
            }
            Log.getLogWriter().info("Adding to the region evicted " + numEvicted + " entries");
            if (numEvicted > 0) {
                long expectedDestroys = beforeDestroyNotExp + (long)numEvicted;
                TestHelper.waitForCounter(EventCountersBB.getBB(), "EventCountersBB.numAfterDestroyEvents_isNotExp", EventCountersBB.numAfterDestroyEvents_isNotExp, expectedDestroys, true, 60000L);
            }
            this.verifyMemCapacity(this.memLRUParams.getTotalAllowableBytes());
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In doDynamicTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false) + "; " + TestHelper.regionToString(workRegion, false) + " has " + workRegion.keys().size() + " entries");
    }

    private void doSerialDynamicTxTest() {
        long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        Region workRegion = this.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In MemLRUDynamicTest.doDynamicTxTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        this.memLRUParams = (MemLRUParameters)CapConBB.getBB().getSharedMap().get(CapConBB.TEST_SETTINGS);
        long totalBytesPerEntry = this.memLRUParams.getTotalBytesPerEntry();
        int currentNumEntries = workRegion.keys().size();
        long currentNumBytes = (long)currentNumEntries * totalBytesPerEntry;
        int maxEntries = (int)(this.memLRUParams.getRegionByteLimit() / totalBytesPerEntry);
        long numBytesToChangeCapacity = (long)TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, maxEntries + 100) * totalBytesPerEntry;
        int randy = TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, maxEntries + 100);
        long numBytesToEndTx = (long)randy * totalBytesPerEntry;
        Log.getLogWriter().info("Setting numBytesToChangeCapacity to " + numBytesToChangeCapacity + " numBytesToEndTx to " + numBytesToEndTx + ", current num entries is " + currentNumEntries + ", current num bytes is " + currentNumBytes + ", randy=" + randy + ", maxEntries is " + maxEntries + ", totalBytesPerEntry is " + totalBytesPerEntry);
        if (numBytesToEndTx == 0L) {
            throw new TestException("numBytesToEndTx is 0, currentNumEntries is " + currentNumEntries + ", maxEntries is " + maxEntries);
        }
        TxHelper.begin();
        int numEntriesWhenTxBegan = currentNumEntries;
        boolean done = false;
        do {
            MemLRUDynamicTest.checkForEventError();
            testInstance.addEntry();
            currentNumEntries = workRegion.keys().size();
            currentNumBytes = (long)currentNumEntries * totalBytesPerEntry;
            Log.getLogWriter().info("Current number of entries is " + currentNumEntries + ", current number of bytes is " + currentNumBytes + ", numBytesToChangeCapacity is " + numBytesToChangeCapacity + ", numBytesToEndTx is " + numBytesToEndTx + ", current MemLRU maximum bytes is " + this.memLRUParams.getRegionByteLimit());
            if (currentNumBytes == numBytesToChangeCapacity) {
                int currentPoint = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.CURRENT_POINT);
                currentPoint = this.randomCapacityChanges ? TestConfig.tab().getRandGen().nextInt(this.regionBounds.getTargetLowPoint(), this.regionBounds.getTargetHighPoint()) : (this.regionBounds.getDirection(currentPoint) == 0 ? ++currentPoint : --currentPoint);
                CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(currentPoint));
                int newMaximumMegabytes = currentPoint * this.boundsMultiplier;
                Region aRegion = CacheUtil.getRegion("capConRegion");
                Log.getLogWriter().info("Setting new capacity (maximumMegabytes) " + newMaximumMegabytes + " on " + aRegion.getFullPath() + ", current num entries is " + currentNumEntries + ", current num bytes is " + currentNumBytes);
                EvictionAttributesMutator mutator = aRegion.getAttributesMutator().getEvictionAttributesMutator();
                mutator.setMaximum(newMaximumMegabytes);
                long cntr = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.NUM_CAPACITY_CHANGES);
                this.memLRUParams = new MemLRUParameters(20, newMaximumMegabytes, aRegion);
                CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, this.memLRUParams);
                maxEntries = (int)(this.memLRUParams.getRegionByteLimit() / totalBytesPerEntry);
                int regSizeAfterChangingCap = workRegion.keys().size();
                if (currentNumEntries != regSizeAfterChangingCap) {
                    throw new TestException("Expected number of entries before changing capacity " + currentNumEntries + " to be equal to num entries after changing capacity " + regSizeAfterChangingCap);
                }
            }
            boolean bl = done = System.currentTimeMillis() - startTime > timeToRunMS;
            if (!done && currentNumBytes != numBytesToEndTx) continue;
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
                int beforeCommitNumEntries = currentNumEntries;
                long beforeCommitNumBytes = currentNumBytes;
                Log.getLogWriter().info("Before commit, num entries is " + beforeCommitNumEntries + ", num bytes is " + beforeCommitNumBytes);
                TxHelper.commitExpectSuccess();
                int afterCommitNumEntries = workRegion.keys().size();
                long afterCommitNumBytes = (long)afterCommitNumEntries * totalBytesPerEntry;
                if (beforeCommitNumBytes <= this.memLRUParams.getRegionByteLimit()) {
                    if (beforeCommitNumBytes != afterCommitNumBytes) {
                        throw new TestException("Before commit num entries was " + beforeCommitNumEntries + " and numBytes was " + beforeCommitNumBytes + ", after commit num entries was " + afterCommitNumEntries + " and numBytes was " + afterCommitNumBytes);
                    }
                } else {
                    testInstance.addEntry();
                    afterCommitNumEntries = workRegion.size();
                    afterCommitNumBytes = (long)afterCommitNumEntries * totalBytesPerEntry;
                    if (afterCommitNumBytes > this.memLRUParams.getRegionByteLimit()) {
                        throw new TestException("After committing, num entries is " + afterCommitNumEntries + " and numBytes is " + afterCommitNumBytes + ", but currentCapacity maximumMegabytes is " + this.memLRUParams.getRegionByteLimit());
                    }
                }
            } else {
                int numEntriesBeforeRollback = currentNumEntries;
                TxHelper.rollback();
                int numEntriesAfterRollback = workRegion.keys().size();
                long afterRollbackNumBytes = (long)numEntriesAfterRollback * totalBytesPerEntry;
                Log.getLogWriter().info("After rollback, numEntries is " + numEntriesAfterRollback + ", afterRollbackNumBytes is " + afterRollbackNumBytes + ", maxEntries is " + maxEntries);
                if (numEntriesAfterRollback <= maxEntries) {
                    Log.getLogWriter().info("No eviction expected");
                    if (numEntriesAfterRollback != numEntriesWhenTxBegan) {
                        throw new TestException("When transaction began num entries was " + numEntriesWhenTxBegan + ", before rollback num entries was " + numEntriesBeforeRollback + ", after rollback num entries was " + numEntriesAfterRollback);
                    }
                } else {
                    Log.getLogWriter().info("Adding an entry to trigger eviction");
                    testInstance.addEntry();
                    numEntriesAfterRollback = workRegion.keys().size();
                    afterRollbackNumBytes = (long)numEntriesAfterRollback * totalBytesPerEntry;
                    Log.getLogWriter().info("After adding an entry to trigger eviction region size is " + numEntriesAfterRollback + ", numBytes is " + afterRollbackNumBytes);
                    if (afterRollbackNumBytes > this.memLRUParams.getTotalAllowableBytes()) {
                        throw new TestException("After rollback, num entries is " + numEntriesAfterRollback + " and numBytes is " + afterRollbackNumBytes + ", but currentCapacity allowable bytes is " + this.memLRUParams.getTotalAllowableBytes() + "\n" + this.memLRUParams);
                    }
                }
            }
            currentNumEntries = workRegion.keys().size();
            currentNumBytes = (long)currentNumEntries * totalBytesPerEntry;
            maxEntries = (int)(this.memLRUParams.getRegionByteLimit() / totalBytesPerEntry);
            numBytesToChangeCapacity = (long)TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, maxEntries + 100) * totalBytesPerEntry;
            randy = TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, maxEntries + 100);
            numBytesToEndTx = (long)randy * totalBytesPerEntry;
            Log.getLogWriter().info("Setting numBytesToChangeCapacity to " + numBytesToChangeCapacity + " numBytesToEndTx to " + numBytesToEndTx + ", current num entries is " + currentNumEntries + ", current num bytes is " + currentNumBytes + ", randy=" + randy + ", maxEntries is " + maxEntries + ", totalBytesPerEntry is " + totalBytesPerEntry);
            if (numBytesToEndTx == 0L) {
                throw new TestException("numBytesToEndTx is 0, currentNumEntries is " + currentNumEntries + ", maxEntries is " + maxEntries);
            }
            if (done) continue;
            TxHelper.begin();
            numEntriesWhenTxBegan = currentNumEntries;
        } while (!done);
        Log.getLogWriter().info("In doDynamicTxTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false) + "; " + TestHelper.regionToString(workRegion, false) + " has " + currentNumEntries + " entries and " + currentNumBytes + " bytes");
    }

    private void doConcDynamicTxTest() {
        long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        Region workRegion = this.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In MemLRUDynamicTest.doDynamicTxTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        this.memLRUParams = (MemLRUParameters)CapConBB.getBB().getSharedMap().get(CapConBB.TEST_SETTINGS);
        long timeToChangeCapacity = System.currentTimeMillis() + 5000L;
        do {
            MemLRUDynamicTest.checkForEventError();
            TxHelper.begin();
            testInstance.addEntry();
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
                TxHelper.commitExpectSuccess();
            } else {
                TxHelper.rollback();
            }
            if (System.currentTimeMillis() >= timeToChangeCapacity) {
                int currentPoint = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.CURRENT_POINT);
                currentPoint = this.randomCapacityChanges ? TestConfig.tab().getRandGen().nextInt(this.regionBounds.getTargetLowPoint(), this.regionBounds.getTargetHighPoint()) : (this.regionBounds.getDirection(currentPoint) == 0 ? ++currentPoint : --currentPoint);
                CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(currentPoint));
                int newMaximumMegabytes = currentPoint * this.boundsMultiplier;
                Region aRegion = CacheUtil.getRegion("capConRegion");
                Log.getLogWriter().info("Setting new capacity (maximumMegabytes) " + newMaximumMegabytes + " on " + aRegion.getFullPath());
                EvictionAttributesMutator mutator = aRegion.getAttributesMutator().getEvictionAttributesMutator();
                mutator.setMaximum(newMaximumMegabytes);
                long cntr = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.NUM_CAPACITY_CHANGES);
                this.memLRUParams = new MemLRUParameters(20, newMaximumMegabytes, aRegion);
                CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, this.memLRUParams);
                timeToChangeCapacity = System.currentTimeMillis() + 5000L;
            }
            this.verifyMemCapacity(this.memLRUParams.getTotalAllowableBytes());
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In doDynamicTxTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false));
    }

    @Override
    public CacheListener getEventListener() {
        if (TestConfig.tab().booleanAt(Prms.serialExecution)) {
            return new MemLRUListener();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(super.toString() + "\n");
        aStr.append("   Region bounds:\n");
        aStr.append("      boundsMultiplier: " + this.boundsMultiplier + "\n");
        aStr.append("      regionBounds: " + this.regionBounds + "\n");
        aStr.append("      randomCapacityChanges: " + this.randomCapacityChanges + "\n");
        return aStr.toString();
    }
}

