/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConPrms;
import capCon.EvictListener;
import capCon.EvictTest;
import capCon.MemLRUParameters;
import capCon.MemLRUTest;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.TestConfig;
import util.CacheUtil;
import util.TestHelperPrms;

public class MemLRUEvict
extends MemLRUTest {
    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new MemLRUEvict();
            ((MemLRUEvict)testInstance).initFields();
            testInstance.initialize();
            Region aRegion = CacheUtil.getRegion("capConRegion");
            maximumMegabytes = aRegion.getAttributes().getEvictionAttributes().getMaximum();
            ((MemLRUTest)MemLRUEvict.testInstance).memLRUParams = new MemLRUParameters(20, maximumMegabytes, CacheUtil.getRegion("capConRegion"));
            CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, ((MemLRUTest)MemLRUEvict.testInstance).memLRUParams);
            EvictTest.initEvictTest(testInstance.getWorkRegion());
            Log.getLogWriter().info(testInstance.toString());
        }
    }

    public static void HydraTask_serialEvictTest() {
        Region workRegion = testInstance.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_monitorCapacity, adding for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            EvictTest.serialEvictTest(testInstance, workRegion);
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
    }

    public static void HydraTask_fill() {
        ((MemLRUEvict)testInstance).fill();
    }

    @Override
    public CacheListener getEventListener() {
        return new EvictListener();
    }

    protected void initFields() {
        this.LRUAllowance = TestConfig.tab().intAt(CapConPrms.LRUAllowance);
        Log.getLogWriter().info("Set LRUAllowance to " + this.LRUAllowance);
    }

    protected void fill() {
        int maxEntries = this.memLRUParams.getMaxEntries();
        Log.getLogWriter().info("Filling with " + maxEntries + " entries...");
        MemLRUEvict aTest = (MemLRUEvict)testInstance;
        for (long i = 1L; i <= (long)maxEntries; ++i) {
            testInstance.addEntry();
            aTest.verifyMemCapacity(aTest.memLRUParams.getRegionByteLimit());
        }
    }
}

