/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConPrms;
import capCon.CapConTest;
import capCon.MemLRUListener;
import capCon.MemLRUParameters;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import hydra.GsRandom;
import hydra.Log;
import hydra.TestConfig;
import java.util.Set;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.RegionDefBB;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class MemLRUTest
extends CapConTest {
    protected static final int KEY_LENGTH = 20;
    protected static int maximumMegabytes;
    public MemLRUParameters memLRUParams;
    private static String spaceKey;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new MemLRUTest();
            testInstance.initialize();
            RegionDefinition regDef = RegionDefinition.createRegionDefinition();
            maximumMegabytes = regDef.getEvictionLimit();
            ((MemLRUTest)MemLRUTest.testInstance).memLRUParams = new MemLRUParameters(20, maximumMegabytes, CacheUtil.getRegion("capConRegion"));
            CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, ((MemLRUTest)MemLRUTest.testInstance).memLRUParams);
            String aStr = testInstance.toString();
            Log.getLogWriter().info(aStr);
        }
    }

    @Override
    public Object getNewKey() {
        String key = MemLRUTest.getFixedLengthKeyForName(NameFactory.getNextPositiveObjectName());
        return key;
    }

    @Override
    public Object getNewValue() {
        boolean fillByteArray = TestConfig.tab().booleanAt(CapConPrms.fillByteArray);
        int byteArraySize = this.memLRUParams.getByteArraySize();
        if (byteArraySize == MemLRUParameters.UNKNOWN) {
            byteArraySize = TestConfig.tab().intAt(CapConPrms.byteArraySize);
        }
        byte[] byteArr = new byte[byteArraySize];
        if (fillByteArray) {
            TestConfig.tab().getRandGen().nextBytes(byteArr);
        }
        return byteArr;
    }

    @Override
    public CacheListener getEventListener() {
        return new MemLRUListener();
    }

    @Override
    public Object getPreviousKey() {
        long RANGE = 20L;
        long currentNameCounter = NameFactory.getPositiveNameCounter();
        long lowEnd = currentNameCounter - RANGE;
        if (lowEnd < 0L) {
            lowEnd = 0L;
        }
        long previousNameCounter = TestConfig.tab().getRandGen().nextLong(lowEnd, currentNameCounter);
        return MemLRUTest.getFixedLengthKeyForName(NameFactory.getObjectNameForCounter(previousNameCounter));
    }

    public static void HydraTask_addEntries() {
        testInstance.addEntries();
    }

    public void sync() {
        CapConBB.getBB().getSharedCounters().increment(CapConBB.SyncCounter);
        TestHelper.waitForCounter(CapConBB.getBB(), "CapConBB.SyncCounter", CapConBB.SyncCounter, TestHelper.getNumThreads() - TestHelper.getNumVMs(), true, 3600000L);
        try {
            Log.getLogWriter().info("Reached sync point, sleeping for 30 seconds...");
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Checking capacity after sleeping");
        MemLRUTest aTest = (MemLRUTest)testInstance;
        long totalAllowableBytes = aTest.memLRUParams.getTotalAllowableBytes();
        aTest.verifyMemCapacity(totalAllowableBytes);
        CapConBB.getBB().getSharedCounters().zero(CapConBB.SyncCounter);
        Log.getLogWriter().info("Returning from sync");
    }

    public static void HydraTask_monitorCapacity() {
        MemLRUTest aTest = (MemLRUTest)testInstance;
        long totalAllowableBytes = aTest.memLRUParams.getTotalAllowableBytes();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_monitorCapacity, adding for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            aTest.verifyMemCapacity(totalAllowableBytes);
            MemLRUTest.checkForEventError();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In HydraTask_monitorCapacity, done running for " + timeToRunSec + " seconds");
    }

    public static void HydraTask_serialTest() {
        ((MemLRUTest)testInstance).doSerialTest();
    }

    private long getRegSizeForTxBoundary() {
        long currentRegSizeInBytes = this.getRegionSizeInBytes();
        GsRandom rand = TestConfig.tab().getRandGen();
        long minBytes = this.memLRUParams.getMinEvictionBytes();
        long maxBytes = this.memLRUParams.getTotalAllowableBytes();
        if (currentRegSizeInBytes < minBytes) {
            return rand.nextLong(currentRegSizeInBytes + 1L, minBytes);
        }
        if (rand.nextBoolean()) {
            return rand.nextLong(minBytes, maxBytes);
        }
        return rand.nextLong(maxBytes + 1L, maxBytes + 0x100000L);
    }

    @Override
    protected Object[] addEntry() {
        Object[] tmpArr = super.addEntry();
        return tmpArr;
    }

    protected void doSerialTest() {
        Region workRegion = this.getWorkRegion();
        long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In doSerialTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        boolean inTrans = false;
        long txBoundary = -1L;
        boolean done = false;
        long sizeWhenTxBegan = -1L;
        do {
            long currentSize = this.getRegionSizeInBytes();
            int beforeNumKeys = workRegion.keys().size();
            if (this.useTransactions && !inTrans) {
                TxHelper.begin();
                inTrans = true;
                txBoundary = this.getRegSizeForTxBoundary();
                Log.getLogWriter().info("Targeting a transaction boundary when region size is " + txBoundary + " bytes, current size is " + currentSize + " bytes");
                sizeWhenTxBegan = currentSize;
            }
            testInstance.addEntry();
            int afterNumKeys = workRegion.keys().size();
            currentSize = this.getRegionSizeInBytes();
            boolean timeToEndTrans = currentSize >= txBoundary;
            boolean bl = done = System.currentTimeMillis() - startTime > timeToRunMS;
            if (inTrans && (timeToEndTrans || done)) {
                Log.getLogWriter().info("Before ending transaction current region size is " + currentSize + " bytes, size when transaction began: " + sizeWhenTxBegan + " bytes");
                if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
                    TxHelper.commitExpectSuccess();
                } else {
                    TxHelper.rollback();
                    long sizeAfterRollback = this.getRegionSizeInBytes();
                    if (sizeAfterRollback != sizeWhenTxBegan) {
                        throw new TestException("When transaction began size was " + sizeWhenTxBegan + " bytes, " + "before rollback size was " + currentSize + " bytes, after rollback size is " + sizeAfterRollback + " bytes");
                    }
                }
                inTrans = false;
                currentSize = this.getRegionSizeInBytes();
                Log.getLogWriter().info("After ending transaction, region size is " + currentSize + " bytes");
            }
            if (inTrans) {
                if (beforeNumKeys + 1 != afterNumKeys) {
                    throw new TestException("Before adding to " + TestHelper.regionToString(workRegion, false) + ", num keys was " + beforeNumKeys + ", but after adding " + " num keys was " + afterNumKeys + "; expected num keys to be " + (beforeNumKeys + 1) + ", " + this.toString());
                }
            } else {
                this.verifyMemCapacity(this.memLRUParams.getTotalAllowableBytes());
            }
            MemLRUTest.checkForEventError();
        } while (!(done = System.currentTimeMillis() - startTime > timeToRunMS));
        Log.getLogWriter().info("In doSerialTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false) + "; " + TestHelper.regionToString(workRegion, false) + " is size " + this.getRegionSizeInBytes() + " bytes");
    }

    public static void HydraTask_endTask() {
        Cache myCache = CacheUtil.createCache();
        NameBB.getBB().printSharedCounters();
        CapConBB.getBB().printSharedMap();
        CapConBB.getBB().printSharedCounters();
        RegionDefBB.printBB();
        MemLRUTest.checkForEventError();
        MemLRUTest aTest = new MemLRUTest();
        aTest.memLRUParams = (MemLRUParameters)CapConBB.getBB().getSharedMap().get(CapConBB.TEST_SETTINGS);
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        Region workRegion = regDef.createRootRegion(myCache, "capConRegion", null, null, null);
        aTest.verifyMemCapacity(aTest.memLRUParams.getTotalAllowableBytes());
        int numEntries = TestHelper.getTotalNumKeys(workRegion);
        if (numEntries != 0) {
            throw new TestException("With MIRROR_NONE, expected 0 entries in region but got " + numEntries);
        }
        double numEvictions = TestHelper.getNumLRUEvictions();
        Log.getLogWriter().info("Number of lru evictions during test: " + numEvictions);
    }

    protected long getRegionSizeInBytes() {
        Region workRegion = this.getWorkRegion();
        int numKeys = workRegion.keys().size();
        CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, numKeys);
        if (workRegion.getAttributes().getEnableOffHeapMemory()) {
            GemFireCacheImpl gfCache = (GemFireCacheImpl)CacheUtil.getCache();
            return gfCache.getOffHeapStore().getStats().getUsedMemory();
        }
        return this.memLRUParams.getTotalBytesPerEntry() * (long)numKeys;
    }

    public void verifyMemCapacity(long byteLimit) {
        Region workRegion = this.getWorkRegion();
        if (workRegion.getAttributes().getEnableOffHeapMemory()) {
            Cache theCache = CacheUtil.getCache();
            if (!(theCache instanceof GemFireCacheImpl)) {
                throw new TestException("Cache cannot be cast to GemFireCacheImpl");
            }
            GemFireCacheImpl gfCache = (GemFireCacheImpl)theCache;
            OffHeapMemoryStats offHeapStats = gfCache.getOffHeapStore().getStats();
            long usedOffHeapMemory = offHeapStats.getUsedMemory();
            Log.getLogWriter().info("Off-heap memory, used bytes: " + usedOffHeapMemory + ", byteLimit: " + byteLimit);
            if (usedOffHeapMemory > byteLimit) {
                String aStr = "Expected current used off-heap memory (bytes) " + usedOffHeapMemory + " to be <= byteLimit " + byteLimit;
                Log.getLogWriter().info(aStr);
                throw new TestException(aStr);
            }
        } else {
            Set keys = workRegion.keys();
            int numKeys = keys.size();
            CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, numKeys);
            long currentRegSizeInBytes = this.memLRUParams.getTotalBytesPerEntry() * (long)numKeys;
            CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_REGION_SIZE_IN_BYTES, currentRegSizeInBytes);
            String logStr = "In verifyMemCapacity,\n" + this.memLRUParams.toString() + "\n" + "Current conditions\n" + "   num keys                    : " + numKeys + "\n" + "   checking against byte limit : " + byteLimit + "\n" + "   bytes in region (test view) : " + currentRegSizeInBytes;
            Log.getLogWriter().info(logStr);
            if (currentRegSizeInBytes > byteLimit) {
                String aStr = "Expected currentRegSizeInBytes " + currentRegSizeInBytes + " to be <= byteLimit " + byteLimit + "\n" + "MAX_REGION_SIZE_IN_BYTES: " + CapConBB.getBB().getSharedCounters().read(CapConBB.MAX_REGION_SIZE_IN_BYTES) + " " + "MAX_NUM_KEYS: " + CapConBB.getBB().getSharedCounters().read(CapConBB.MAX_NUM_KEYS) + "\n" + logStr;
                Log.getLogWriter().info(aStr);
                throw new TestException(aStr);
            }
        }
    }

    protected void verifyEviction() {
        Region workRegion = this.getWorkRegion();
        int numKeys = workRegion.keys().size();
        CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, numKeys);
        long currentRegSizeInBytes = this.getRegionSizeInBytes();
        CapConBB.getBB().getSharedCounters().setIfSmaller(CapConBB.MIN_REGION_BYTES_AT_MEMLRU_EVICTION, currentRegSizeInBytes);
        long minEvictionBytes = this.memLRUParams.getMinEvictionBytes();
        String logStr = "In verifyEviction,\n" + this.memLRUParams.toString() + "\n" + "Current conditions\n" + "   num keys                   : " + numKeys + "\n" + "   bytes in region (test view): " + currentRegSizeInBytes;
        Log.getLogWriter().info(logStr);
        if (currentRegSizeInBytes < minEvictionBytes) {
            String aStr = "Early eviction detected: Expected currentRegSizeInBytes " + currentRegSizeInBytes + " to be >= minEvictionBytes " + minEvictionBytes + "\n" + "MAX_REGION_SIZE_IN_BYTES: " + CapConBB.getBB().getSharedCounters().read(CapConBB.MAX_REGION_SIZE_IN_BYTES) + " " + "MAX_NUM_KEYS: " + CapConBB.getBB().getSharedCounters().read(CapConBB.MAX_NUM_KEYS) + "\n" + logStr;
            Log.getLogWriter().info(aStr);
            CapConBB.getBB().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, aStr);
        }
    }

    private static String getFixedLengthKeyForName(String name) {
        StringBuffer sb = new StringBuffer(spaceKey);
        sb.replace(0, name.length(), name);
        if (sb.length() != 20) {
            throw new TestException("Expected key to be length 20, but it is " + TestHelper.toString(sb));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(super.toString() + "\n");
        aStr.append(this.memLRUParams.toString() + "=\n");
        return aStr.toString();
    }

    static {
        spaceKey = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            sb.append(" ");
        }
        spaceKey = sb.toString();
    }
}

