/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import com.gemstone.gemfire.cache.Region;
import event.EventTest;
import hydra.Log;
import hydra.TestConfig;
import util.EventCountersBB;
import util.TestHelper;

public abstract class RegEventCapCon
extends EventTest {
    public static void HydraTask_invalidateRegion() {
        ((RegEventCapCon)eventTest).doInvalidate();
        ((RegEventCapCon)eventTest).writeMyRegionNames();
    }

    private void doInvalidate() {
        if (this.isSerialExecution) {
            RegEventCapCon.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventCountersBB.getBB());
        Log.getLogWriter().info("Faulting in available regions...");
        this.faultInNewRegions();
        Log.getLogWriter().info("Done faulting in available regions.");
        this.invalidateRegion(TestConfig.tab().getRandGen().nextBoolean());
    }

    public static void HydraTask_destroyRegions() {
        ((RegEventCapCon)eventTest).doDestroys();
        ((RegEventCapCon)eventTest).writeMyRegionNames();
    }

    private void doDestroys() {
        if (this.isSerialExecution) {
            RegEventCapCon.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventCountersBB.getBB());
        Log.getLogWriter().info("Faulting in available regions...");
        this.faultInNewRegions();
        Log.getLogWriter().info("Done faulting in available regions.");
        while (this.getNumNonRootRegions() > (long)this.maxRegions) {
            this.destroyRegion(TestConfig.tab().getRandGen().nextBoolean());
        }
    }

    public static void HydraTask_addRegionsAndObjects() {
        ((RegEventCapCon)eventTest).doAddRegionsAndObjects();
        ((RegEventCapCon)eventTest).writeMyRegionNames();
    }

    private void doAddRegionsAndObjects() {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            RegEventCapCon.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventCountersBB.getBB());
        do {
            Log.getLogWriter().info("Faulting in available regions...");
            this.faultInNewRegions();
            Log.getLogWriter().info("Done faulting in available regions.");
            long numRegions = this.getNumNonRootRegions();
            if (numRegions < (long)this.maxRegions) {
                this.addRegion();
                ((RegEventCapCon)eventTest).writeMyRegionNames();
            }
            Log.getLogWriter().info("Adding objects to regions...");
            long addTimeMS = 10000L;
            long startAddTime = System.currentTimeMillis();
            do {
                Region aRegion;
                if ((aRegion = this.getRandomRegion(false)) == null) continue;
                this.addObject(aRegion, false);
            } while (System.currentTimeMillis() - startAddTime < 10000L);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    @Override
    protected Object getObjectToAdd(String name) {
        return this.randomValues.getRandomObjectGraph();
    }
}

