/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.JMXHelper;
import com.gemstone.gemfire.admin.jmx.internal.AgentConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.FlowControlParams;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.Config;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.VM;
import hydra.GemFireDescription;
import hydra.HydraConfigException;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.net.ssl.SSLHandshakeException;
import security.CredentialGenerator;

public class AdminDSSecurityDUnitTest
extends AdminDUnitTestCase {
    protected static final int LOCATOR_VM = 1;
    private static VM locatorVM = null;
    private static boolean hookRegistered = false;
    protected String locators;
    private Properties dsProperties = new Properties();
    private Properties javaProperties;
    private static final String[] expectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), GemFireSecurityException.class.getName(), SSLHandshakeException.class.getName(), ClassNotFoundException.class.getName(), NoSuchObjectException.class.getName(), NameNotFoundException.class.getName()};

    public AdminDSSecurityDUnitTest(String name) {
        super(name);
    }

    @Override
    public boolean isJMX() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        boolean setUpFailed = true;
        try {
            DistributionManager.isDedicatedAdminVM = true;
            AdminDSSecurityDUnitTest.disconnectAllFromDS();
            setUpFailed = false;
        }
        finally {
            if (setUpFailed) {
                try {
                    AdminDSSecurityDUnitTest.disconnectAllFromDS();
                }
                finally {
                    DistributionManager.isDedicatedAdminVM = false;
                }
            }
        }
        Host host = Host.getHost(0);
        locatorVM = host.getVM(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            AdminDSSecurityDUnitTest.disconnectAllFromDS();
        }
        finally {
            DistributionManager.isDedicatedAdminVM = false;
        }
    }

    @Override
    protected void startAgent() throws Exception {
        if (this.isJMX()) {
            AdminDSSecurityDUnitTest.getLogWriter().info("[startAgent]");
            if (!hookRegistered) {
                Runtime.getRuntime().addShutdownHook(shutdownThread);
                hookRegistered = true;
            }
            int pid = ProcessMgr.getProcessId();
            String cwd = System.getProperty("user.dir");
            String propFileName = "agent.properties";
            File agentProps = new File(cwd + File.separator + propFileName);
            FileOutputStream outS = new FileOutputStream(agentProps);
            this.dsProperties.store(outS, "Store Agent Properties");
            outS.flush();
            ((OutputStream)outS).close();
            SecurityTestUtil.clearStaticSSLContext();
            SecurityTestUtil.setJavaProps(this.javaProperties);
            AgentConfigImpl config = new AgentConfigImpl(this.dsProperties);
            config.setAutoConnect(false);
            this.agent = JMXHelper.startAgent(this, (AgentConfig)config, this.getDSConfig(), pid);
        }
    }

    private void clearSecurityProperties() {
        Properties props = System.getProperties();
        Properties newProps = new Properties();
        for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
            String propKey = (String)propEntry.getKey();
            if (propKey.startsWith("gemfire.sys.security-")) continue;
            newProps.put(propKey, propEntry.getValue());
        }
        System.setProperties(newProps);
    }

    @Override
    protected void stopAgent() throws Exception {
        if (this.isJMX()) {
            AdminDSSecurityDUnitTest.getLogWriter().info("[stopAgent]");
            super.stopAgent();
            if (hookRegistered) {
                Runtime.getRuntime().removeShutdownHook(shutdownThread);
                hookRegistered = false;
            }
            this.clearSecurityProperties();
        }
    }

    @Override
    protected void assertAgent() throws Exception {
        if (this.isJMX()) {
            super.assertAgent();
            AdminDSSecurityDUnitTest.getLogWriter().info("Assert Agent " + this.tcSystem);
        }
    }

    private DistributionConfig getDSConfig() {
        AdminDSSecurityDUnitTest.getLogWriter().info("Using test specific Distributed System Properties ");
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        final GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        return new DistributionConfig(){

            public void close() {
            }

            public int getAckWaitThreshold() {
                return 0;
            }

            public int getArchiveDiskSpaceLimit() {
                return 0;
            }

            public int getArchiveFileSizeLimit() {
                return 0;
            }

            public int getAsyncDistributionTimeout() {
                return 0;
            }

            public int getAsyncMaxQueueSize() {
                return 0;
            }

            public int getAsyncQueueTimeout() {
                return 0;
            }

            public String getBindAddress() {
                return null;
            }

            public File getCacheXmlFile() {
                return null;
            }

            public boolean getConserveSockets() {
                return false;
            }

            public boolean getDisableTcp() {
                return false;
            }

            public String getClientConflation() {
                return null;
            }

            public String getDurableClientId() {
                return null;
            }

            public int getDurableClientTimeout() {
                return 0;
            }

            public boolean getEnableTimeStatistics() {
                return false;
            }

            public String getLicenseDataManagement() {
                return null;
            }

            public String getLicenseApplicationCache() {
                return null;
            }

            public File getLicenseWorkingDir() {
                return null;
            }

            public File getDeployWorkingDir() {
                return null;
            }

            public int getLicenseServerTimeout() {
                return 0;
            }

            public String getLocators() {
                return AdminDSSecurityDUnitTest.this.locators;
            }

            public int getLogDiskSpaceLimit() {
                return 0;
            }

            public File getLogFile() {
                String testName = "AdminDSSecurityDUnitTest";
                File file = new File(testName + "_" + ProcessMgr.getProcessId() + "_jmxagent.log");
                return file;
            }

            public int getLogFileSizeLimit() {
                return 0;
            }

            public int getLogLevel() {
                return LogWriterImpl.levelNameToCode((String)DistributedTestCase.getDUnitLogLevel());
            }

            public int getMaxNumReconnectTries() {
                return 0;
            }

            public int getMaxWaitTimeForReconnect() {
                return 0;
            }

            public InetAddress getMcastAddress() {
                try {
                    return InetAddress.getByName(gfd.getMcastAddress());
                }
                catch (UnknownHostException ex) {
                    DistributedTestCase.getLogWriter().error((Throwable)ex);
                    return null;
                }
            }

            public FlowControlParams getMcastFlowControl() {
                return null;
            }

            public int getMcastPort() {
                return 0;
            }

            public int getMcastRecvBufferSize() {
                return 0;
            }

            public int getMcastSendBufferSize() {
                return 0;
            }

            public int getMcastTtl() {
                return 0;
            }

            public int getMemberTimeout() {
                return 0;
            }

            public String getName() {
                return null;
            }

            public String getRoles() {
                return null;
            }

            public String getSSLCiphers() {
                return null;
            }

            public boolean getSSLEnabled() {
                return false;
            }

            public String getSSLProtocols() {
                return null;
            }

            public boolean getSSLRequireAuthentication() {
                return false;
            }

            public String getSecurity(String attName) {
                return null;
            }

            public String getSecurityClientAccessor() {
                return null;
            }

            public String getSecurityClientAccessorPP() {
                return null;
            }

            public String getSecurityClientAuthInit() {
                return null;
            }

            public String getSecurityClientAuthenticator() {
                return null;
            }

            public String getSecurityClientDHAlgo() {
                return null;
            }

            public File getSecurityLogFile() {
                return null;
            }

            public int getSecurityLogLevel() {
                return 0;
            }

            public String getSecurityPeerAuthInit() {
                return null;
            }

            public String getSecurityPeerAuthenticator() {
                return null;
            }

            public int getSecurityPeerMembershipTimeout() {
                return 0;
            }

            public Properties getSecurityProps() {
                return null;
            }

            public String getServerBindAddress() {
                return null;
            }

            public int getSocketBufferSize() {
                return 0;
            }

            public int getSocketLeaseTime() {
                return 0;
            }

            public String getStartLocator() {
                return null;
            }

            public File getStatisticArchiveFile() {
                return null;
            }

            public int getStatisticSampleRate() {
                return 0;
            }

            public boolean getStatisticSamplingEnabled() {
                return false;
            }

            public boolean getStatusMonitoringEnabled() {
                return false;
            }

            public int getStatusMonitoringPort() {
                return 0;
            }

            public int getTcpPort() {
                return 0;
            }

            public int getUdpFragmentSize() {
                return 0;
            }

            public int getUdpRecvBufferSize() {
                return 0;
            }

            public int getUdpSendBufferSize() {
                return 0;
            }

            public String getUserCommandPackages() {
                return null;
            }

            public boolean isAckWaitThresholdModifiable() {
                return false;
            }

            public boolean isArchiveDiskSpaceLimitModifiable() {
                return false;
            }

            public boolean isArchiveFileSizeLimitModifiable() {
                return false;
            }

            public boolean isAsyncDistributionTimeoutModifiable() {
                return false;
            }

            public boolean isAsyncMaxQueueSizeModifiable() {
                return false;
            }

            public boolean isAsyncQueueTimeoutModifiable() {
                return false;
            }

            public boolean isBindAddressModifiable() {
                return false;
            }

            public boolean isCacheXmlFileModifiable() {
                return false;
            }

            public boolean isConserveSocketsModifiable() {
                return false;
            }

            public boolean isDisableTcpModifiable() {
                return false;
            }

            public boolean isClientConflationModifiable() {
                return false;
            }

            public boolean isDurableClientIdModifiable() {
                return false;
            }

            public boolean isDurableClientTimeoutModifiable() {
                return false;
            }

            public boolean isDeployWorkingDirModifiable() {
                return false;
            }

            public boolean isLicenseDataManagementModifiable() {
                return false;
            }

            public boolean isLicenseApplicationCacheModifiable() {
                return false;
            }

            public boolean isLicenseWorkingDirModifiable() {
                return false;
            }

            public boolean isLicenseServerTimeoutModifiable() {
                return false;
            }

            public boolean isLocatorsModifiable() {
                return false;
            }

            public boolean isLogDiskSpaceLimitModifiable() {
                return false;
            }

            public boolean isLogFileModifiable() {
                return false;
            }

            public boolean isLogFileSizeLimitModifiable() {
                return false;
            }

            public boolean isLogLevelModifiable() {
                return false;
            }

            public boolean isMcastAddressModifiable() {
                return false;
            }

            public boolean isMcastFlowControlModifiable() {
                return false;
            }

            public boolean isMcastPortModifiable() {
                return false;
            }

            public boolean isMcastRecvBufferSizeModifiable() {
                return false;
            }

            public boolean isMcastSendBufferSizeModifiable() {
                return false;
            }

            public boolean isMcastTtlModifiable() {
                return false;
            }

            public boolean isMemberTimeoutModifiable() {
                return false;
            }

            public boolean isNameModifiable() {
                return false;
            }

            public boolean isSecurityClientAuthInitModifiable() {
                return false;
            }

            public boolean isSecurityClientAuthenticatorModifiable() {
                return false;
            }

            public boolean isSecurityClientDHAlgoModifiable() {
                return false;
            }

            public boolean isSecurityLogFileModifiable() {
                return false;
            }

            public boolean isSecurityLogLevelModifiable() {
                return false;
            }

            public boolean isSecurityModifiable() {
                return false;
            }

            public boolean isSecurityPeerAuthInitModifiable() {
                return false;
            }

            public boolean isSecurityPeerAuthenticatorModifiable() {
                return false;
            }

            public boolean isSecurityPeerMembershipTimeoutModifiable() {
                return false;
            }

            public boolean isServerBindAddressModifiable() {
                return false;
            }

            public boolean isSocketBufferSizeModifiable() {
                return false;
            }

            public boolean isSocketLeaseTimeModifiable() {
                return false;
            }

            public boolean isStartLocatorModifiable() {
                return false;
            }

            public boolean isStatisticArchiveFileModifiable() {
                return false;
            }

            public boolean isStatisticSampleRateModifiable() {
                return false;
            }

            public boolean isStatisticSamplingEnabledModifiable() {
                return false;
            }

            public boolean isTcpPortModifiable() {
                return false;
            }

            public boolean isUdpFragmentSizeModifiable() {
                return false;
            }

            public boolean isUdpRecvBufferSizeModifiable() {
                return false;
            }

            public boolean isUdpSendBufferSizeModifiable() {
                return false;
            }

            public boolean isUserCommandPackagesModifiable() {
                return false;
            }

            public void setAckWaitThreshold(int newThreshold) {
            }

            public void setArchiveDiskSpaceLimit(int value) {
            }

            public void setArchiveFileSizeLimit(int value) {
            }

            public void setAsyncDistributionTimeout(int newValue) {
            }

            public void setAsyncMaxQueueSize(int newValue) {
            }

            public void setAsyncQueueTimeout(int newValue) {
            }

            public void setBindAddress(String value) {
            }

            public void setCacheXmlFile(File value) {
            }

            public void setConserveSockets(boolean newValue) {
            }

            public void setDisableTcp(boolean newValue) {
            }

            public void setClientConflation(String clientConflation) {
            }

            public void setDurableClientId(String durableClientId) {
            }

            public void setDurableClientTimeout(int durableClientTimeout) {
            }

            public void setEnableTimeStatistics(boolean newValue) {
            }

            public void setDeployWorkingDir(File value) {
            }

            public void setLicenseDataManagement(String value) {
            }

            public void setLicenseApplicationCache(String value) {
            }

            public void setLicenseWorkingDir(File value) {
            }

            public void setLicenseServerTimeout(int value) {
            }

            public void setLocators(String value) {
            }

            public void setLogDiskSpaceLimit(int value) {
            }

            public void setLogFile(File value) {
            }

            public void setLogFileSizeLimit(int value) {
            }

            public void setLogLevel(int value) {
            }

            public void setMaxNumReconnectTries(int tries) {
            }

            public void setMaxWaitTimeForReconnect(int timeOut) {
            }

            public void setMcastAddress(InetAddress value) {
            }

            public void setMcastFlowControl(FlowControlParams values) {
            }

            public void setMcastPort(int value) {
            }

            public void setMcastRecvBufferSize(int value) {
            }

            public void setMcastSendBufferSize(int value) {
            }

            public void setMcastTtl(int value) {
            }

            public void setMemberTimeout(int value) {
            }

            public void setName(String value) {
            }

            public void setRoles(String roles) {
            }

            public void setSSLCiphers(String ciphers) {
            }

            public void setSSLEnabled(boolean enabled) {
            }

            public void setSSLProtocols(String protocols) {
            }

            public void setSSLRequireAuthentication(boolean ciphers) {
            }

            public void setSecurity(String attName, String attValue) {
            }

            public void setSecurityClientAccessor(String attValue) {
            }

            public void setSecurityClientAccessorPP(String attValue) {
            }

            public void setSecurityClientAuthInit(String attValue) {
            }

            public void setSecurityClientAuthenticator(String attValue) {
            }

            public void setSecurityClientDHAlgo(String attValue) {
            }

            public void setSecurityLogFile(File value) {
            }

            public void setSecurityLogLevel(int level) {
            }

            public void setSecurityPeerAuthInit(String attValue) {
            }

            public void setSecurityPeerAuthenticator(String attValue) {
            }

            public void setSecurityPeerMembershipTimeout(int attValue) {
            }

            public void setServerBindAddress(String value) {
            }

            public void setSocketBufferSize(int value) {
            }

            public void setSocketLeaseTime(int value) {
            }

            public void setStartLocator(String value) {
            }

            public void setStatisticArchiveFile(File value) {
            }

            public void setStatisticSampleRate(int value) {
            }

            public void setStatisticSamplingEnabled(boolean newValue) {
            }

            public void setTcpPort(int value) {
            }

            public void setUdpFragmentSize(int value) {
            }

            public void setUdpRecvBufferSize(int value) {
            }

            public void setUdpSendBufferSize(int value) {
            }

            public void setUserCommandPackages(String value) {
            }

            public String getAttribute(String attName) {
                return null;
            }

            public String getAttributeDescription(String attName) {
                return null;
            }

            public String[] getAttributeNames() {
                return null;
            }

            public Object getAttributeObject(String attName) {
                return null;
            }

            public Class getAttributeType(String attName) {
                return null;
            }

            public String[] getSpecificAttributeNames() {
                return null;
            }

            public boolean isAttributeModifiable(String attName) {
                return false;
            }

            public boolean sameAs(Config v) {
                return false;
            }

            public void setAttribute(String attName, String attValue, ConfigSource source) {
            }

            public void setAttributeObject(String attName, Object attValue, ConfigSource source) {
            }

            public void toFile(File f) throws IOException {
            }

            public Properties toProperties() {
                return null;
            }

            public boolean getEnableNetworkPartitionDetection() {
                return false;
            }

            public void setEnableNetworkPartitionDetection(boolean v) {
            }

            public boolean getDisableAutoReconnect() {
                return false;
            }

            public void setDisableAutoReconnect(boolean v) {
            }

            public boolean isEnableNetworkPartitionDetectionModifiable() {
                return false;
            }

            public int getAckSevereAlertThreshold() {
                return 0;
            }

            public void setAckSevereAlertThreshold(int i) {
            }

            public boolean isAckSevereAlertThresholdModifiable() {
                return false;
            }

            public boolean isDeltaPropagationModifiable() {
                return false;
            }

            public void setDeltaPropagation(boolean b) {
            }

            public boolean getDeltaPropagation() {
                return true;
            }

            public boolean getRemoveUnresponsiveClient() {
                return false;
            }

            public void setRemoveUnresponsiveClient(boolean v) {
            }

            public boolean isRemoveUnresponsiveClientModifiable() {
                return false;
            }

            public int[] getMembershipPortRange() {
                return null;
            }

            public void setMembershipPortRange(int[] range) {
            }

            public void setRemoteLocators(String locators) {
            }

            public String getRemoteLocators() {
                return null;
            }

            public void setDistributedSystemId(int distributedSystemId) {
            }

            public int getDistributedSystemId() {
                return -1;
            }

            public boolean getEnforceUniqueHost() {
                return false;
            }

            public String getRedundancyZone() {
                return null;
            }

            public Properties getUserDefinedProps() {
                return null;
            }

            public void setEnforceUniqueHost(boolean enforceUniqueHost) {
            }

            public void setRedundancyZone(String redundancyZone) {
            }

            public void setWritableWorkingDir(File value) {
            }

            public File getWritableWorkingDir() {
                return null;
            }

            public void setSSLProperty(String attName, String attValue) {
            }

            public Properties getSSLProperties() {
                return null;
            }

            public Properties getJmxSSLProperties() {
                return null;
            }

            public String getGroups() {
                return null;
            }

            public void setGroups(String value) {
            }

            public boolean isGroupsModifiable() {
                return false;
            }

            public ConfigSource getAttributeSource(String attName) {
                return null;
            }

            public String toLoggerString() {
                return "";
            }

            public boolean getJmxManager() {
                return false;
            }

            public void setJmxManager(boolean value) {
            }

            public boolean isJmxManagerModifiable() {
                return false;
            }

            public boolean getJmxManagerStart() {
                return false;
            }

            public void setJmxManagerStart(boolean value) {
            }

            public boolean isJmxManagerStartModifiable() {
                return false;
            }

            public int getJmxManagerPort() {
                return 0;
            }

            public void setJmxManagerPort(int value) {
            }

            public boolean isJmxManagerPortModifiable() {
                return false;
            }

            public boolean getJmxManagerSSL() {
                return false;
            }

            public void setJmxManagerSSL(boolean value) {
            }

            public boolean isJmxManagerSSLModifiable() {
                return false;
            }

            public String getJmxManagerBindAddress() {
                return "";
            }

            public void setJmxManagerBindAddress(String value) {
            }

            public boolean isJmxManagerBindAddressModifiable() {
                return false;
            }

            public String getJmxManagerPasswordFile() {
                return "";
            }

            public void setJmxManagerPasswordFile(String value) {
            }

            public boolean isJmxManagerPasswordFileModifiable() {
                return false;
            }

            public String getJmxManagerAccessFile() {
                return "";
            }

            public void setJmxManagerAccessFile(String value) {
            }

            public boolean isJmxManagerAccessFileModifiable() {
                return false;
            }

            public int getJmxManagerHttpPort() {
                return 0;
            }

            public void setJmxManagerHttpPort(int value) {
            }

            public boolean isJmxManagerHttpPortModifiable() {
                return false;
            }

            public int getMemcachedPort() {
                return 0;
            }

            public void setMemcachedPort(int value) {
            }

            public boolean isMemcachedPortModifiable() {
                return false;
            }

            public String getJmxManagerHostnameForClients() {
                return "";
            }

            public void setJmxManagerHostnameForClients(String value) {
            }

            public boolean isJmxManagerHostnameForClientsModifiable() {
                return false;
            }

            public int getJmxManagerUpdateRate() {
                return 0;
            }

            public void setJmxManagerUpdateRate(int value) {
            }

            public boolean isJmxManagerUpdateRateModifiable() {
                return false;
            }

            public String getMemcachedProtocol() {
                return "ASCII";
            }

            public void setMemcachedProtocol(String protocol) {
            }

            public boolean isMemcachedProtocolModifiable() {
                return false;
            }

            public String getOffHeapMemorySize() {
                return null;
            }

            public void setOffHeapMemorySize(String value) {
            }

            public boolean isOffHeapMemorySizeModifiable() {
                return false;
            }

            public boolean getJmxManagerSSLRequireAuthentication() {
                return false;
            }

            public void setJmxManagerSSLRequireAuthentication(boolean value) {
            }

            public boolean isJmxManagerSSLRequireAuthenticationModifiable() {
                return false;
            }

            public String getJmxManagerSSLProtocols() {
                return null;
            }

            public void setJmxManagerSSLProtocols(String protocols) {
            }

            public boolean isJmxManagerSSLProtocolsModifiable() {
                return false;
            }

            public String getJmxManagerSSLCiphers() {
                return null;
            }

            public void setJmxManagerSSLCiphers(String ciphers) {
            }

            public boolean isJmxManagerSSLCiphersModifiable() {
                return false;
            }

            public boolean getLockMemory() {
                return false;
            }

            public void setLockMemory(boolean value) {
            }

            public boolean isLockMemoryModifiable() {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testNoCredentials() throws Exception {
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        int port = -1;
        while (iter.hasNext()) {
            block15: {
                try {
                    CredentialGenerator gen = (CredentialGenerator)iter.next();
                    port = -1;
                    this.dsProperties = new Properties();
                    this.dsProperties.put("mcast-port", "" + AvailablePort.getRandomAvailablePort((int)1));
                    this.javaProperties = new Properties();
                    port = this.startLocator(gen, this.dsProperties, this.javaProperties);
                    this.javaProperties = null;
                    this.startAgent();
                    SecurityTestUtil.addExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                    try {
                        this.agent.connectToSystem();
                        AdminDSSecurityDUnitTest.getLogWriter().info("locators for agent = " + this.agent.getDistributedSystem().getLocators());
                        AdminDSSecurityDUnitTest.pause(10000);
                    }
                    catch (Throwable throwable) {
                        SecurityTestUtil.removeExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                        throw throwable;
                    }
                    SecurityTestUtil.removeExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                    if (this.agent != null && this.agent.isConnected()) {
                        AdminDSSecurityDUnitTest.fail((String)"AuthenticationFailedException was expected as the AuthInitialize object not passed");
                    } else {
                        AdminDSSecurityDUnitTest.getLogWriter().info("Agent is not connected as expected.");
                    }
                    if (this.agent == null) break block15;
                }
                catch (RMIException remoteEx) {
                    block16: {
                        if (!(remoteEx.getCause() instanceof AuthenticationFailedException)) {
                            throw remoteEx;
                        }
                        if (this.agent == null) break block16;
                        this.stopAgent();
                    }
                    if (port == -1) continue;
                    locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                    continue;
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    if (this.agent != null) {
                        this.stopAgent();
                    }
                    if (port == -1) continue;
                    locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                    continue;
                    {
                        catch (Throwable throwable) {
                            if (this.agent != null) {
                                this.stopAgent();
                            }
                            if (port != -1) {
                                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                            }
                            throw throwable;
                        }
                    }
                }
                this.stopAgent();
            }
            if (port == -1) continue;
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidCredentials() throws Exception {
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        int port = -1;
        while (iter.hasNext()) {
            block9: {
                try {
                    CredentialGenerator gen = (CredentialGenerator)iter.next();
                    this.dsProperties = new Properties();
                    this.dsProperties.putAll((Map<?, ?>)gen.getInvalidCredentials(4));
                    this.javaProperties = new Properties();
                    port = this.startLocator(gen, this.dsProperties, this.javaProperties);
                    this.startAgent();
                    SecurityTestUtil.addExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                    try {
                        this.agent.connectToSystem();
                        AdminDSSecurityDUnitTest.pause(10000);
                    }
                    catch (Throwable throwable) {
                        SecurityTestUtil.removeExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                        throw throwable;
                    }
                    SecurityTestUtil.removeExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                    if (this.agent != null && this.agent.isConnected()) {
                        AdminDSSecurityDUnitTest.fail((String)"AuthenticationFailedException was expected as the incorrect credentials were passed");
                    } else {
                        AdminDSSecurityDUnitTest.getLogWriter().info("Agent is now not connected ");
                    }
                    if (this.agent == null) break block9;
                }
                catch (Throwable throwable) {
                    if (this.agent != null) {
                        this.stopAgent();
                    }
                    if (port != -1) {
                        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                    }
                    throw throwable;
                }
                this.stopAgent();
            }
            if (port == -1) continue;
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCredentials() throws Exception {
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        int port = -1;
        while (iter.hasNext()) {
            block7: {
                try {
                    CredentialGenerator gen = (CredentialGenerator)iter.next();
                    this.dsProperties = new Properties();
                    this.dsProperties.putAll((Map<?, ?>)gen.getValidCredentials(1));
                    this.javaProperties = new Properties();
                    port = this.startLocator(gen, this.dsProperties, this.javaProperties);
                    this.startAgent();
                    SecurityTestUtil.addExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                    try {
                        this.agent.connectToSystem();
                        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                            String excuse;

                            @Override
                            public boolean done() {
                                if (AdminDSSecurityDUnitTest.this.agent == null) {
                                    this.excuse = "agent is null";
                                    return false;
                                }
                                if (!AdminDSSecurityDUnitTest.this.agent.isConnected()) {
                                    this.excuse = "agent not connected";
                                    return false;
                                }
                                return true;
                            }

                            @Override
                            public String description() {
                                return this.excuse;
                            }
                        };
                        DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
                        AdminDSSecurityDUnitTest.getLogWriter().info("Agent is now connected ");
                    }
                    catch (Throwable throwable) {
                        SecurityTestUtil.removeExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                        throw throwable;
                    }
                    SecurityTestUtil.removeExpectedExceptions(new String[]{AuthenticationFailedException.class.getName()}, this.agent.getLogWriter());
                    if (this.agent == null) break block7;
                }
                catch (Throwable throwable) {
                    if (this.agent != null) {
                        this.stopAgent();
                    }
                    if (port != -1) {
                        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                    }
                    throw throwable;
                }
                this.stopAgent();
            }
            if (port == -1) continue;
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    private int startLocator(CredentialGenerator gen, Properties propsSet, Properties javaPropsSet) {
        AdminDSSecurityDUnitTest.getLogWriter().info("Start locator for CredentialGenerator " + gen);
        int port = -1;
        Properties extraProps = gen.getSystemProperties();
        Properties javaProps = gen.getJavaProperties();
        String authenticator = gen.getAuthenticator();
        String authInit = gen.getAuthInit();
        if (extraProps == null) {
            extraProps = new Properties();
        }
        port = AvailablePort.getRandomAvailablePort((int)0);
        this.locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
        propsSet.putAll((Map<?, ?>)extraProps);
        propsSet.setProperty("mcast-port", "0");
        propsSet.setProperty("locators", this.locators);
        this.setProperty(propsSet, "security-peer-auth-init", authInit);
        this.setProperty(propsSet, "security-peer-authenticator", authenticator);
        if (javaProps != null) {
            javaPropsSet.putAll((Map<?, ?>)javaProps);
        }
        locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), propsSet, javaProps, expectedExceptions});
        return port;
    }

    private void setProperty(Properties props, String key, String value) {
        if (key != null && value != null) {
            props.setProperty(key, value);
        }
    }
}

