/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.JMXAdminDistributedSystem;
import com.gemstone.gemfire.admin.jmx.JMXHelper;
import com.gemstone.gemfire.admin.jmx.internal.MX4JServerSocketFactory;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.LogFileParser;
import dunit.DistributedTestCase;
import dunit.Host;
import hydra.HostHelper;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public abstract class AdminDUnitTestCase
extends CacheTestCase {
    protected static final int AGENT_VM = 3;
    protected transient AdminDistributedSystem tcSystem;
    protected final transient boolean debug = false;
    protected static final Thread shutdownThread = new ShutdownThread();
    protected transient Agent agent = null;
    protected String urlString;
    public static final int NUM_RETRY = 10;
    public static final int RETRY_INTERVAL = 100;
    private static boolean hookRegistered = false;

    public AdminDUnitTestCase(String name) {
        super(name);
    }

    public void reconnectToSystem() {
        try {
            String locators;
            DistributionConfig config = super.getSystem().getConfig();
            AdminDUnitTestCase.assertFalse((config.getMcastPort() == 10334 ? 1 : 0) != 0);
            AdminDUnitTestCase.disconnectAllFromDS();
            if (this.tcSystem instanceof JMXAdminDistributedSystem) {
                AdminDUnitTestCase.getLogWriter().info("[disconnectRMIConnection]");
                ((JMXAdminDistributedSystem)this.tcSystem).closeRmiConnection();
            }
            if ((locators = this.getLocators(config)) != null && locators.length() > 0) {
                this.tcSystem = this.createDistributedSystem(DistributedSystemConfig.DEFAULT_MCAST_ADDRESS, 0, locators, "rsh -n {HOST} {CMD}");
            } else {
                String address = HostHelper.getHostAddress(config.getMcastAddress());
                int port = config.getMcastPort();
                this.tcSystem = this.createDistributedSystem(address, port, "", "rsh -n {HOST} {CMD}");
            }
        }
        catch (Exception e) {
            AdminDUnitTestCase.fail("unexpected reconnect failure", e);
        }
    }

    protected String getLocators(DistributionConfig config) {
        return config.getLocators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        AdminDUnitTestCase.getLogWriter().info("Entering AdminDUnitTestCase#setUp");
        boolean setUpFailed = true;
        try {
            if (this.isJMX()) {
                if (!hookRegistered) {
                    Runtime.getRuntime().addShutdownHook(shutdownThread);
                    hookRegistered = true;
                }
                this.startAgent();
            }
            DistributionManager.isDedicatedAdminVM = true;
            AdminDUnitTestCase.disconnectAllFromDS();
            if (this.tcSystem != null && this.tcSystem.isConnected()) {
                this.disconnect();
            }
            super.setUp();
            this.reconnectToSystem();
            if (this.isJMX()) {
                this.assertAgent();
            }
            setUpFailed = false;
        }
        finally {
            if (setUpFailed) {
                try {
                    AdminDUnitTestCase.disconnectAllFromDS();
                }
                finally {
                    DistributionManager.isDedicatedAdminVM = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            if (this.isJMX()) {
                AdminDUnitTestCase.getLogWriter().info("[tearDown]");
                this.disconnect();
                this.stopAgent();
                AdminDUnitTestCase.getLogWriter().info("[calling super.tearDown...]");
            }
            if (this.tcSystem != null) {
                this.tcSystem.disconnect();
                this.tcSystem = null;
            }
            if (this.isJMX() && hookRegistered) {
                Runtime.getRuntime().removeShutdownHook(shutdownThread);
                hookRegistered = false;
            }
        }
        finally {
            try {
                AdminDUnitTestCase.disconnectAllFromDS();
            }
            finally {
                DistributionManager.isDedicatedAdminVM = false;
            }
        }
    }

    public synchronized AdminDistributedSystem getAdminDistributedSystem() throws Exception {
        if (this.tcSystem == null) {
            this.setUp();
        }
        return this.tcSystem;
    }

    protected static DistributedMember getDistributedMember() {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        return system.getDistributedMember();
    }

    public DistributionConfig getDistributionConfig() {
        return this.getSystem().getConfig();
    }

    protected void startAgent() throws Exception {
        if (this.isRMI()) {
            if (this.isSSL()) {
                String JTESTS = System.getProperty("JTESTS");
                String keyStore = JTESTS + File.separator + "ssl" + File.separator + "trusted.keystore";
                System.setProperty("javax.net.ssl.keyStore", keyStore);
                System.setProperty("javax.net.ssl.keyStorePassword", "password");
                System.setProperty("javax.net.ssl.trustStore", keyStore);
                System.setProperty("javax.net.ssl.trustStorePassword", "password");
                this.urlString = JMXHelper.startRMISSLAgent((DistributedTestCase)this, Host.getHost(0).getVM(3));
                AdminDUnitTestCase.assertNotNull((Object)this.urlString);
            } else {
                this.urlString = JMXHelper.startRMIAgent((DistributedTestCase)this, Host.getHost(0).getVM(3));
                AdminDUnitTestCase.assertNotNull((Object)this.urlString);
            }
        } else {
            int pid = ProcessMgr.getProcessId();
            this.agent = JMXHelper.startAgent(this, pid);
        }
    }

    protected void disconnect() {
        AdminDUnitTestCase.getLogWriter().info("[disconnect]");
        try {
            if (this.tcSystem != null) {
                this.tcSystem.disconnect();
                if (this.tcSystem instanceof JMXAdminDistributedSystem) {
                    AdminDUnitTestCase.getLogWriter().info("[disconnectRMIConnection]");
                    JMXAdminDistributedSystem sys = (JMXAdminDistributedSystem)this.tcSystem;
                    sys.closeRmiConnection();
                }
                this.tcSystem = null;
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            AdminDUnitTestCase.getLogWriter().info("Failed to disconnect", t);
        }
    }

    protected void stopAgent() throws Exception {
        if (this.isRMI()) {
            JMXHelper.stopRMIAgent(this, Host.getHost(0).getVM(3));
        } else {
            AdminDUnitTestCase.getLogWriter().info("[stopAgent]");
            try {
                JMXHelper.stopAgent(this.agent);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                AdminDUnitTestCase.getLogWriter().info("Failed to stop agent", t);
            }
        }
    }

    protected void assertAgent() throws Exception {
        if (this.isRMI()) {
            if (this.isSSL()) {
                AdminDUnitTestCase.assertNotNull((Object)this.urlString);
                JMXConnector conn = this.createJMXConnector();
                MBeanServerConnection mbs = conn.getMBeanServerConnection();
                AdminDUnitTestCase.assertNotNull((Object)mbs);
                ObjectName agent = new ObjectName("GemFire:type=Agent");
                AdminDUnitTestCase.assertTrue((boolean)mbs.isRegistered(agent));
                Boolean connected = (Boolean)mbs.getAttribute(agent, "connected");
                AdminDUnitTestCase.assertTrue((boolean)connected);
                ObjectName system = (ObjectName)mbs.invoke(agent, "manageDistributedSystem", new Object[0], new String[0]);
                AdminDUnitTestCase.assertTrue((boolean)mbs.isRegistered(system));
                conn.close();
            } else {
                AdminDUnitTestCase.assertNotNull((Object)this.urlString);
                JMXServiceURL url = new JMXServiceURL(this.urlString);
                JMXConnector conn = JMXConnectorFactory.connect(url);
                MBeanServerConnection mbs = conn.getMBeanServerConnection();
                AdminDUnitTestCase.assertNotNull((Object)mbs);
                ObjectName agent = new ObjectName("GemFire:type=Agent");
                AdminDUnitTestCase.assertTrue((boolean)mbs.isRegistered(agent));
                Boolean connected = (Boolean)mbs.getAttribute(agent, "connected");
                AdminDUnitTestCase.assertTrue((boolean)connected);
                ObjectName system = (ObjectName)mbs.invoke(agent, "manageDistributedSystem", new Object[0], new String[0]);
                AdminDUnitTestCase.assertTrue((boolean)mbs.isRegistered(system));
                conn.close();
            }
        } else {
            AdminDUnitTestCase.assertNotNull((Object)this.agent);
            AdminDUnitTestCase.assertTrue((boolean)this.agent.isConnected());
            MBeanServer mbs = this.agent.getMBeanServer();
            AdminDUnitTestCase.assertNotNull((Object)mbs);
            ObjectName sys = this.agent.manageDistributedSystem();
            AdminDUnitTestCase.assertNotNull((Object)sys);
            AdminDUnitTestCase.assertTrue((boolean)mbs.isRegistered(sys));
        }
    }

    private JMXConnector createJMXConnector() throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.urlString);
        MX4JServerSocketFactory ssf = new MX4JServerSocketFactory(true, true, "any", "any", (LogWriterI18n)new LocalLogWriter(500), new Properties());
        SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.rmi.server.socket.factory", ssf);
        env.put("jmx.remote.rmi.client.socket.factory", csf);
        return JMXConnectorFactory.connect(url, env);
    }

    protected AdminDistributedSystem createDistributedSystem(String mcastAddress, int mcastPort, String locators, String remoteCommand) throws AdminException {
        String bindAddress = null;
        if (System.getProperty("gemfire.bind-address") != null) {
            bindAddress = System.getProperty("gemfire.bind-address");
        }
        if (this.isJMX()) {
            if (this.isRMI()) {
                if (this.isSSL()) {
                    try {
                        JMXConnector conn = this.createJMXConnector();
                        MBeanServerConnection mbs = conn.getMBeanServerConnection();
                        ObjectName objectName = new ObjectName("GemFire:type=Agent");
                        return new JMXAdminDistributedSystem(mcastAddress, mcastPort, locators, bindAddress, remoteCommand, mbs, conn, objectName);
                    }
                    catch (Exception ex) {
                        String s = "While connecting to JMX RMI agent";
                        throw new AdminException(s, (Throwable)ex);
                    }
                }
                try {
                    JMXServiceURL url = new JMXServiceURL(this.urlString);
                    JMXConnector conn = JMXConnectorFactory.connect(url);
                    MBeanServerConnection mbs = conn.getMBeanServerConnection();
                    ObjectName objectName = new ObjectName("GemFire:type=Agent");
                    return new JMXAdminDistributedSystem(mcastAddress, mcastPort, locators, bindAddress, remoteCommand, mbs, conn, objectName);
                }
                catch (Exception ex) {
                    String s = "While connecting to JMX RMI agent on " + this.urlString;
                    throw new AdminException(s, (Throwable)ex);
                }
            }
            AdminDUnitTestCase.assertNotNull((Object)this.agent);
            return new JMXAdminDistributedSystem(mcastAddress, mcastPort, locators, bindAddress, remoteCommand, this.agent.getMBeanServer(), null, this.agent.getObjectName());
        }
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem();
        config.setMcastAddress(mcastAddress);
        config.setMcastPort(mcastPort);
        config.setLocators(locators);
        config.setRemoteCommand(remoteCommand);
        config.setBindAddress(bindAddress);
        config.setServerBindAddress(bindAddress);
        final AdminDistributedSystem system = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        ((AdminDistributedSystemImpl)system).connect(DistributedTestCase.getLogWriter().convertToLogWriterI18n());
        this.tcSystem = system;
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return system.isConnected();
            }

            @Override
            public String description() {
                return "system never connected:" + system;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
        return system;
    }

    protected boolean isJMX() {
        return false;
    }

    protected boolean isRMI() {
        return false;
    }

    protected boolean isSSL() {
        return false;
    }

    protected static void assertLog(String log, int minEntries) throws IOException {
        StringReader sr = new StringReader(log);
        BufferedReader br = new BufferedReader(sr);
        LogFileParser parser = new LogFileParser(null, br);
        int entries = 0;
        while (parser.hasMoreEntries()) {
            parser.getNextEntry();
            ++entries;
        }
        if (entries < minEntries) {
            String s = "Log file " + log + " must contain at least " + minEntries + " entries.  It only contains " + entries + " entries.\n\n";
            s = s + log;
            AdminDUnitTestCase.fail((String)s);
        }
    }

    static class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        @Override
        public void run() {
            System.err.println("VM IS SHUTTING DOWN but hasn't done tearDown yet!!");
        }
    }
}

