/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class GemFireHealthDUnitTest
extends AdminDUnitTestCase {
    private static final int HEALTH_TIME = 45000;

    public GemFireHealthDUnitTest(String name) {
        super(name);
    }

    private void waitForHealthChange(final GemFireHealth health, final GemFireHealth.Health desiredHealth) {
        GemFireHealth.Health current = health.getHealth();
        if (current == desiredHealth) {
            return;
        }
        GemFireHealthDUnitTest.getLogWriter().info("waiting for health to change from " + current + " to " + desiredHealth);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return health.getHealth() == desiredHealth;
            }

            @Override
            public String description() {
                return "health never became " + desiredHealth;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 45000L, 200L, true);
    }

    public void testSetGetMaxDepartedApplications() throws Exception {
        AdminDistributedSystem system = this.tcSystem;
        GemFireHealth health = system.getGemFireHealth();
        DistributedSystemHealthConfig config = health.getDistributedSystemHealthConfig();
        GemFireHealthDUnitTest.assertEquals((long)10L, (long)config.getMaxDepartedApplications());
        long newValue = 42L;
        config.setMaxDepartedApplications(newValue);
        GemFireHealthDUnitTest.assertEquals((long)newValue, (long)config.getMaxDepartedApplications());
    }

    public void testMaxLoadTime() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        GemFireHealth health = system.getGemFireHealth();
        this.waitForHealthChange(health, GemFireHealth.GOOD_HEALTH);
        GemFireHealthConfig config = health.getDefaultGemFireHealthConfig();
        config.setHealthEvaluationInterval(1);
        config.setMaxLoadTime(50L);
        health.setDefaultGemFireHealthConfig(config);
        GemFireHealthDUnitTest.pause(1000);
        GemFireHealthDUnitTest.assertEquals((Object)GemFireHealth.GOOD_HEALTH, (Object)health.getHealth());
        final String name = this.getUniqueName();
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        return "Loaded value";
                    }

                    public void close() {
                    }
                });
                GemFireHealthDUnitTest.this.createRegion(name, factory.create());
            }
        });
        GemFireHealthDUnitTest.pause(1500);
        GemFireHealthDUnitTest.assertEquals((String)("Diagnosis of poor health: " + health.getDiagnosis()), (Object)GemFireHealth.GOOD_HEALTH, (Object)health.getHealth());
        vm.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = GemFireHealthDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.get((Object)("Test1 " + i));
                }
            }
        });
        GemFireHealthDUnitTest.pause(1000);
        GemFireHealthDUnitTest.assertEquals((Object)GemFireHealth.GOOD_HEALTH, (Object)health.getHealth());
        vm.invoke(new CacheSerializableRunnable("Slow cache loader"){

            @Override
            public void run2() throws CacheException {
                Region region = GemFireHealthDUnitTest.this.getRootRegion().getSubregion(name);
                region.getAttributesMutator().setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            TestCase.fail((String)"Why was I interrupted?");
                        }
                        return "Slowly loaded value";
                    }

                    public void close() {
                    }
                });
                for (int i = 0; i < 50; ++i) {
                    region.get((Object)("Test2 " + i));
                }
            }
        });
        this.waitForHealthChange(health, GemFireHealth.OKAY_HEALTH);
        String diagnosis = health.getDiagnosis();
        GemFireHealthDUnitTest.assertNotNull((Object)diagnosis);
        String s = "The average duration of a Cache load";
        GemFireHealthDUnitTest.assertTrue((diagnosis.indexOf(s) != -1 ? 1 : 0) != 0);
        GemFireHealthDUnitTest.pause(1500);
        health.resetHealth();
        GemFireHealthDUnitTest.assertEquals((String)("Diagnosis is: " + health.getDiagnosis()), (Object)GemFireHealth.GOOD_HEALTH, (Object)health.getHealth());
        GemFireHealth.Health newHealth = health.getHealth();
        long totalTime = 2000L;
        long begin = System.currentTimeMillis();
        while (System.currentTimeMillis() - begin < totalTime) {
            GemFireHealthDUnitTest.pause(100);
            newHealth = health.getHealth();
            if (newHealth.equals(GemFireHealth.GOOD_HEALTH)) continue;
        }
        GemFireHealthDUnitTest.assertEquals((String)("Didn't become healthy after " + totalTime + " ms: " + health.getDiagnosis()), (Object)GemFireHealth.GOOD_HEALTH, (Object)health.getHealth());
    }

    public void testHealthWithRoleLossNoAccess() throws Exception {
        String rr1 = "RoleA";
        final String[] requiredRoles = new String[]{"RoleA"};
        String regionName = "MyRegion";
        AdminDistributedSystem system = this.tcSystem;
        VM vm = Host.getHost(0).getVM(0);
        CacheSerializableRunnable roleLoss = new CacheSerializableRunnable("RoleMissingAndPoorHealth"){

            @Override
            public void run2() {
                MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
                AttributesFactory fac = new AttributesFactory();
                fac.setMembershipAttributes(ra);
                fac.setScope(Scope.DISTRIBUTED_ACK);
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                try {
                    GemFireHealthDUnitTest.this.createRootRegion("MyRegion", attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DistributedTestCase.fail("Exception in VM0 : ", ex);
                }
                DistributedTestCase.pause(1000);
            }
        };
        vm.invoke(roleLoss);
        GemFireHealth health = system.getGemFireHealth();
        this.waitForHealthChange(health, GemFireHealth.POOR_HEALTH);
        GemFireHealthDUnitTest.getLogWriter().info("THE MEMBER HEALTH 1 : " + health.getHealth());
        GemFireHealthDUnitTest.assertEquals((Object)GemFireHealth.POOR_HEALTH, (Object)health.getHealth());
    }

    public void testHealthWithRoleLossLimitedAccess() throws Exception {
        String rr1 = "RoleA";
        final String[] requiredRoles = new String[]{"RoleA"};
        String regionName = "MyRegion";
        AdminDistributedSystem system = this.tcSystem;
        VM vm = Host.getHost(0).getVM(0);
        CacheSerializableRunnable roleLoss = new CacheSerializableRunnable("RoleMissingAndPoorHealth"){

            @Override
            public void run2() {
                MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.LIMITED_ACCESS, ResumptionAction.NONE);
                AttributesFactory fac = new AttributesFactory();
                fac.setMembershipAttributes(ra);
                fac.setScope(Scope.DISTRIBUTED_ACK);
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                try {
                    GemFireHealthDUnitTest.this.createRootRegion("MyRegion", attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DistributedTestCase.fail("Exception in VM0 : ", ex);
                }
                DistributedTestCase.pause(1000);
            }
        };
        vm.invoke(roleLoss);
        GemFireHealth health = system.getGemFireHealth();
        this.waitForHealthChange(health, GemFireHealth.POOR_HEALTH);
        GemFireHealthDUnitTest.getLogWriter().info("THE MEMBER HEALTH POOR2 : " + health.getHealth());
        GemFireHealthDUnitTest.assertEquals((Object)GemFireHealth.POOR_HEALTH, (Object)health.getHealth());
    }

    public void testHealthWithRoleLossFullAccess() throws Exception {
        String rr1 = "RoleA";
        final String[] requiredRoles = new String[]{"RoleA"};
        String regionName = "MyRegion";
        AdminDistributedSystem system = this.tcSystem;
        VM vm = Host.getHost(0).getVM(0);
        CacheSerializableRunnable roleLoss = new CacheSerializableRunnable("RoleMissingAndPoorHealth"){

            @Override
            public void run2() {
                MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
                AttributesFactory fac = new AttributesFactory();
                fac.setMembershipAttributes(ra);
                fac.setScope(Scope.DISTRIBUTED_ACK);
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                try {
                    GemFireHealthDUnitTest.this.createRootRegion("MyRegion", attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DistributedTestCase.fail("Exception in VM0 : ", ex);
                }
                DistributedTestCase.pause(1000);
            }
        };
        vm.invoke(roleLoss);
        GemFireHealth health = system.getGemFireHealth();
        this.waitForHealthChange(health, GemFireHealth.OKAY_HEALTH);
        GemFireHealthDUnitTest.getLogWriter().info("THE MEMBER HEALTH OKAY : " + health.getHealth());
        GemFireHealthDUnitTest.assertEquals((Object)GemFireHealth.OKAY_HEALTH, (Object)health.getHealth());
    }
}

