/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DistributedCacheTestCase;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Set;
import util.TestException;

public class SystemFailureAdminDUnitTest
extends DistributedCacheTestCase {
    protected static ArrayList pesky;

    public SystemFailureAdminDUnitTest(String name) {
        super(name);
    }

    protected static void connectAdminSystem() throws Exception {
        SystemFailureAdminDUnitTest.assertTrue((!system.getConfig().getLocators().equals("") ? 1 : 0) != 0);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        SystemFailureAdminDUnitTest.assertEquals((String)system.getConfig().getLocators(), (String)config.getLocators());
        SystemFailureAdminDUnitTest.assertEquals((int)system.getConfig().getMcastPort(), (int)config.getMcastPort());
        SystemFailureAdminDUnitTest.getLogWriter().info("Locators are: " + config.getLocators() + ", mcast port is: " + config.getMcastPort());
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        SystemFailureAdminDUnitTest.assertTrue((boolean)admin.waitToBeConnected(5000L));
    }

    protected static void crashMe() {
        pesky = new ArrayList();
        SystemFailure.setFailureMemoryThreshold((long)0L);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        pesky.add(new int[1000]);
                    }
                }
                catch (OutOfMemoryError e) {
                    SystemFailure.setFailure((Error)e);
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e2) {
                        throw new TestException("interrupted");
                    }
                    return;
                }
            }
        };
        new Thread(r, "crashMe").start();
    }

    private void waitForDeath(GemFireCacheImpl c, int numBefore) {
        InternalDistributedSystem ids = c.getDistributedSystem();
        long start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - start > 90000L) {
                SystemFailureAdminDUnitTest.fail((String)"Peer did not recuse");
                break;
            }
            Set membersAfter = ids.getDistributionManager().getNormalDistributionManagerIds();
            int numAfter = membersAfter.size();
            if (numAfter == numBefore - 1) break;
            SystemFailureAdminDUnitTest.pause(5000);
        }
        c.getLogger().info("Passed recusal test");
    }

    public void _testAdminRecuses() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        GemFireCacheImpl c = (GemFireCacheImpl)cache;
        InternalDistributedSystem ids = c.getDistributedSystem();
        vm0.invoke(this.getClass(), "connectAdminSystem");
        int numBefore = ids.getDistributionManager().getNormalDistributionManagerIds().size();
        vm0.invokeAsync(this.getClass(), "crashMe");
        this.waitForDeath(c, numBefore);
        this.resetVm(vm0);
    }

    public void testNull() {
        SystemFailureAdminDUnitTest.getLogWriter().info("TODO: this test needs to use VM#bounce");
    }

    private void resetVm(VM vm) {
        throw new TestException("not implemented");
    }
}

