/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.internal.AbstractHealthEvaluator;
import com.gemstone.gemfire.admin.internal.CacheHealthEvaluator;
import com.gemstone.gemfire.admin.internal.GemFireHealthConfigImpl;
import com.gemstone.gemfire.admin.internal.HealthEvaluatorTestCase;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.util.ArrayList;
import junit.framework.TestCase;

public class CacheHealthEvaluatorTest
extends HealthEvaluatorTestCase {
    public CacheHealthEvaluatorTest(String name) {
        super(name);
    }

    public void testCheckLoadTime() throws CacheException {
        Cache cache = CacheFactory.create((DistributedSystem)this.system);
        CachePerfStats stats = ((GemFireCacheImpl)cache).getCachePerfStats();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                return "Loaded";
            }

            public void close() {
            }
        });
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(this.getName(), attrs);
        GemFireHealthConfigImpl config = new GemFireHealthConfigImpl(null);
        config.setMaxLoadTime(100L);
        CacheHealthEvaluator eval = new CacheHealthEvaluator((GemFireHealthConfig)config, this.system.getDistributionManager());
        for (int i = 0; i < 10; ++i) {
            region.get((Object)("Test1 " + i));
        }
        long firstLoadTime = stats.getLoadTime();
        long firstLoadsCompleted = stats.getLoadsCompleted();
        CacheHealthEvaluatorTest.assertTrue((firstLoadTime >= 0L ? 1 : 0) != 0);
        CacheHealthEvaluatorTest.assertTrue((firstLoadsCompleted > 0L ? 1 : 0) != 0);
        ArrayList status = new ArrayList();
        eval.evaluate(status);
        CacheHealthEvaluatorTest.assertEquals((int)0, (int)status.size());
        config = new GemFireHealthConfigImpl(null);
        config.setMaxLoadTime(10L);
        eval = new CacheHealthEvaluator((GemFireHealthConfig)config, this.system.getDistributionManager());
        eval.evaluate(status);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            region.get((Object)("Test2 " + i));
        }
        CacheHealthEvaluatorTest.assertTrue((System.currentTimeMillis() - start < 1000L ? 1 : 0) != 0);
        long secondLoadTime = stats.getLoadTime();
        long secondLoadsCompleted = stats.getLoadsCompleted();
        CacheHealthEvaluatorTest.assertTrue((String)("firstLoadTime=" + firstLoadTime + ", secondLoadTime=" + secondLoadTime), (secondLoadTime >= firstLoadTime ? 1 : 0) != 0);
        CacheHealthEvaluatorTest.assertTrue((secondLoadsCompleted > firstLoadsCompleted ? 1 : 0) != 0);
        status = new ArrayList();
        eval.evaluate(status);
        CacheHealthEvaluatorTest.assertEquals((int)0, (int)status.size());
        region.getAttributesMutator().setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ex) {
                    TestCase.fail((String)"Why was I interrupted?");
                }
                return "Loaded";
            }

            public void close() {
            }
        });
        for (int i = 0; i < 50; ++i) {
            region.get((Object)("Test3 " + i));
        }
        long thirdLoadTime = stats.getLoadTime();
        long thirdLoadsCompleted = stats.getLoadsCompleted();
        CacheHealthEvaluatorTest.assertTrue((thirdLoadTime > secondLoadTime ? 1 : 0) != 0);
        CacheHealthEvaluatorTest.assertTrue((thirdLoadsCompleted > secondLoadsCompleted ? 1 : 0) != 0);
        status = new ArrayList();
        eval.evaluate(status);
        CacheHealthEvaluatorTest.assertEquals((int)1, (int)status.size());
        AbstractHealthEvaluator.HealthStatus ill = (AbstractHealthEvaluator.HealthStatus)status.get(0);
        CacheHealthEvaluatorTest.assertEquals((Object)GemFireHealth.OKAY_HEALTH, (Object)ill.getHealthCode());
        String s = "The average duration of a Cache load";
        CacheHealthEvaluatorTest.assertTrue((ill.getDiagnosis().indexOf(s) != -1 ? 1 : 0) != 0);
    }

    public void testCheckHitRatio() throws CacheException {
        Cache cache = CacheFactory.create((DistributedSystem)this.system);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                return "Loaded";
            }

            public void close() {
            }
        });
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(this.getName(), attrs);
        GemFireHealthConfigImpl config = new GemFireHealthConfigImpl(null);
        config.setMinHitRatio(0.5);
        CacheHealthEvaluator eval = new CacheHealthEvaluator((GemFireHealthConfig)config, this.system.getDistributionManager());
        ArrayList status = new ArrayList();
        eval.evaluate(status);
        CacheHealthEvaluatorTest.assertEquals((int)0, (int)status.size());
        region.get((Object)"One");
        region.get((Object)"One");
        region.get((Object)"One");
        status = new ArrayList();
        eval.evaluate(status);
        CacheHealthEvaluatorTest.assertEquals((int)0, (int)status.size());
        for (int i = 0; i < 50; ++i) {
            region.get((Object)("Miss " + i));
        }
        status = new ArrayList();
        eval.evaluate(status);
        AbstractHealthEvaluator.HealthStatus ill = (AbstractHealthEvaluator.HealthStatus)status.get(0);
        CacheHealthEvaluatorTest.assertEquals((Object)GemFireHealth.OKAY_HEALTH, (Object)ill.getHealthCode());
        String s = "The hit ratio of this Cache";
        CacheHealthEvaluatorTest.assertTrue((ill.getDiagnosis().indexOf(s) != -1 ? 1 : 0) != 0);
    }
}

