/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.jmx.JMXAdminDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import javax.management.Notification;
import javax.management.NotificationListener;

public class AdminDistributedSystemDisconnectDUnitTest
extends AdminDUnitTestCase {
    public AdminDistributedSystemDisconnectDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    @Override
    protected boolean isRMI() {
        return true;
    }

    public void testDisconnectListenerForAdminDistributedSystem() throws Exception {
        AdminDistributedSystemDisconnectDUnitTest.assertTrue((this.tcSystem != null && this.tcSystem.isConnected() ? 1 : 0) != 0);
        DisconnectNotificationListener listener = new DisconnectNotificationListener();
        JMXAdminDistributedSystem sys = (JMXAdminDistributedSystem)this.tcSystem;
        sys.addJMXNotificationListener(listener);
        Host host = Host.getHost(0);
        VM vm = host.getVM(3);
        vm.invoke(new SerializableRunnable("disconnect from distributed system"){

            @Override
            public void run() {
                InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                system.disconnect();
            }
        });
        for (int attempts = 0; attempts < 5 && !listener.isNotifReceived(); ++attempts) {
            AdminDistributedSystemDisconnectDUnitTest.pause(1000);
        }
        Log.getLogWriter().info("AdminDistributedSystem disconnect event received ::" + listener.isNotifReceived());
        AdminDistributedSystemDisconnectDUnitTest.assertTrue((boolean)listener.isNotifReceived());
        sys.removeJMXNotificationListener(listener);
    }

    static class DisconnectNotificationListener
    implements NotificationListener {
        private volatile boolean notifReceived = false;

        DisconnectNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if ("gemfire.distributedsystem.disconnect".equals(notification.getType())) {
                this.notifReceived = true;
                Log.getLogWriter().info("Received AdminDistributedSystem disconnect event...");
            }
        }

        public boolean isNotifReceived() {
            return this.notifReceived;
        }
    }
}

