/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.DistributedSystemDUnitTest;
import com.gemstone.gemfire.admin.Statistic;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.jmx.JMXSystemMember;
import com.gemstone.gemfire.admin.jmx.JMXSystemMemberCache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import junit.framework.TestCase;

public class DistributedSystemJMXDUnitTest
extends DistributedSystemDUnitTest {
    public DistributedSystemJMXDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    @Override
    protected void subTestGetSystemMemberApplications() throws Exception {
        this.doTestSystemMemberCacheGetStatistics();
        this.doTestGetMBeanInfo();
        this.doTestMutationOfConfigurationParameter();
    }

    protected void doTestGetMBeanInfo() throws Exception {
        DistributedSystemJMXDUnitTest.getLogWriter().info("[doTestGetMBeanInfo]");
        SystemMember[] apps = this.tcSystem.getSystemMemberApplications();
        Collection members = this.arrayToCollection(apps);
        for (SystemMember member : members) {
            JMXSystemMember jmxMember = (JMXSystemMember)member;
            MBeanInfo mbeanInfo = jmxMember.getMBeanInfo();
            DistributedSystemJMXDUnitTest.assertNotNull((Object)mbeanInfo);
            MBeanAttributeInfo[] attributes = mbeanInfo.getAttributes();
            DistributedSystemJMXDUnitTest.assertNotNull((Object)attributes);
            int nonNullAttributes = 0;
            for (int i = 0; i < attributes.length; ++i) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attributes[i];
                Descriptor desc = attr.getDescriptor();
                String attrName = (String)desc.getFieldValue("name");
                try {
                    if (jmxMember.getAttribute(attrName) != null) {
                        ++nonNullAttributes;
                    }
                }
                catch (MBeanException e) {
                    throw new Error("getAttribute " + attrName, e);
                }
                if (!attrName.equals("distributedMember")) continue;
                DistributedMember distributedMember = (DistributedMember)jmxMember.getAttribute(attrName);
                DistributedSystemJMXDUnitTest.assertNotNull((Object)distributedMember);
                DistributedSystemJMXDUnitTest.assertEquals((Object)jmxMember.getDistributedMember(), (Object)distributedMember);
                Set roles = distributedMember.getRoles();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)roles);
                DistributedSystemJMXDUnitTest.assertEquals((int)1, (int)roles.size());
                Role role = (Role)roles.toArray()[0];
                DistributedSystemJMXDUnitTest.assertTrue((role.getName().indexOf("VM") == 0 ? 1 : 0) != 0);
                String[] jmxMemberRoles = jmxMember.getRoles();
                DistributedSystemJMXDUnitTest.assertEquals((int)jmxMemberRoles.length, (int)roles.size());
                DistributedSystemJMXDUnitTest.assertEquals((String)jmxMemberRoles[0], (String)role.getName());
            }
            DistributedSystemJMXDUnitTest.assertTrue((nonNullAttributes > 0 ? 1 : 0) != 0);
            MBeanConstructorInfo[] constructors = mbeanInfo.getConstructors();
            DistributedSystemJMXDUnitTest.assertNotNull((Object)constructors);
            for (int i = 0; i < constructors.length; ++i) {
                MBeanParameterInfo[] signature = constructors[i].getSignature();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)signature);
            }
            MBeanNotificationInfo[] notifications = mbeanInfo.getNotifications();
            DistributedSystemJMXDUnitTest.assertNotNull((Object)notifications);
            MBeanOperationInfo[] operations = mbeanInfo.getOperations();
            DistributedSystemJMXDUnitTest.assertNotNull((Object)operations);
            for (int i = 0; i < operations.length; ++i) {
                MBeanParameterInfo[] signature = operations[i].getSignature();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)signature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestMutationOfConfigurationParameter() throws Exception {
        DistributedSystemJMXDUnitTest.getLogWriter().info("[doTestMutationOfConfigurationParameter]");
        SystemMember[] apps = this.tcSystem.getSystemMemberApplications();
        Collection members = this.arrayToCollection(apps);
        for (SystemMember member : members) {
            JMXSystemMember jmxMember = (JMXSystemMember)member;
            String memberName = (String)jmxMember.getAttribute("name");
            DistributedSystemJMXDUnitTest.assertTrue((memberName.indexOf("VM") > -1 ? 1 : 0) != 0);
            String lastCharOfMemberName = memberName.substring(memberName.length() - 1);
            DistributedSystemJMXDUnitTest.assertNotNull((Object)lastCharOfMemberName);
            DistributedSystemJMXDUnitTest.assertTrue((lastCharOfMemberName.length() > 0 ? 1 : 0) != 0);
            int whichVM = Integer.parseInt(lastCharOfMemberName);
            VM vm = Host.getHost(0).getVM(whichVM);
            String oldLogLevel = (String)jmxMember.getAttribute("log-level");
            DistributedSystemJMXDUnitTest.assertFalse((boolean)"warning".equals(oldLogLevel));
            jmxMember.setAttribute("log-level", "warning");
            try {
                DistributedSystemJMXDUnitTest.assertEquals((Object)"warning", (Object)jmxMember.getAttribute("log-level"));
                vm.invoke(new SerializableRunnable("Validate log-level changed"){

                    @Override
                    public void run() {
                        InternalDistributedSystem sys = DistributedSystemJMXDUnitTest.this.getSystem();
                        DistributionConfig conf = sys.getConfig();
                        Object value = conf.getAttributeObject("log-level");
                        TestCase.assertEquals((Object)"warning", (Object)value);
                        LogWriter logWriter = sys.getLogWriter();
                        TestCase.assertTrue((boolean)logWriter.warningEnabled());
                        TestCase.assertFalse((boolean)logWriter.infoEnabled());
                    }
                });
            }
            catch (Throwable throwable) {
                jmxMember.setAttribute("log-level", oldLogLevel);
                vm.invoke(new SerializableRunnable("Validate log-level restored", oldLogLevel){
                    final /* synthetic */ String val$oldLogLevel;
                    {
                        this.val$oldLogLevel = string;
                        super(x0);
                    }

                    @Override
                    public void run() {
                        InternalDistributedSystem sys = DistributedSystemJMXDUnitTest.this.getSystem();
                        DistributionConfig conf = sys.getConfig();
                        Object value = conf.getAttributeObject("log-level");
                        TestCase.assertEquals((Object)this.val$oldLogLevel, (Object)value);
                        LogWriter logWriter = sys.getLogWriter();
                        TestCase.assertTrue((boolean)logWriter.warningEnabled());
                        TestCase.assertTrue((boolean)logWriter.infoEnabled());
                    }
                });
                throw throwable;
            }
            jmxMember.setAttribute("log-level", oldLogLevel);
            vm.invoke(new /* invalid duplicate definition of identical inner class */);
        }
    }

    protected void doTestSystemMemberCacheGetStatistics() throws Exception {
        DistributedSystemJMXDUnitTest.getLogWriter().info("[doTestSystemMemberCacheGetStatistics]");
        SystemMember[] apps = this.tcSystem.getSystemMemberApplications();
        Collection members = this.arrayToCollection(apps);
        int cacheCount = 0;
        for (SystemMember member : members) {
            JMXSystemMember jmxMember = (JMXSystemMember)member;
            JMXSystemMemberCache jmxCache = (JMXSystemMemberCache)jmxMember.getCache();
            if (jmxCache == null) continue;
            ++cacheCount;
            Statistic[] stats = jmxCache.getStatistics();
            DistributedSystemJMXDUnitTest.assertNotNull((Object)stats);
            DistributedSystemJMXDUnitTest.assertTrue((stats.length > 0 ? 1 : 0) != 0);
            for (int i = 0; i < stats.length; ++i) {
                Statistic stat = stats[i];
                DistributedSystemJMXDUnitTest.assertNotNull((Object)stat);
                String name = stat.getName();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)name);
                Number value = stat.getValue();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)value);
                String units = stat.getUnits();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)units);
                String desc = stat.getDescription();
                DistributedSystemJMXDUnitTest.assertNotNull((Object)desc);
            }
        }
        DistributedSystemJMXDUnitTest.assertTrue((cacheCount > 0 ? 1 : 0) != 0);
    }

    private Collection arrayToCollection(SystemMember[] members) {
        ArrayList<SystemMember> collection = new ArrayList<SystemMember>();
        collection.addAll(Arrays.asList(members));
        return collection;
    }
}

