/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.internal.Assert;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXDistributedSystemHealthConfig
extends JMXAdminImpl
implements DistributedSystemHealthConfig {
    JMXDistributedSystemHealthConfig(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    public long getMaxDepartedApplications() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Long value = (Long)this.mbs.getAttribute(this.objectName, "maxDepartedApplications");
            return value;
        }
        catch (Exception ex) {
            String s = "While getting the maxDepartedApplications";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void setMaxDepartedApplications(long maxDepartedApplications) {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("maxDepartedApplications", new Long(maxDepartedApplications)));
        }
        catch (Exception ex) {
            String s = "While setting the maxDepartedApplications";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }
}

