/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.admin.DistributionLocatorConfig;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.admin.jmx.JMXManagedEntityConfig;
import com.gemstone.gemfire.internal.Assert;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXDistributionLocator
extends JMXAdminImpl
implements DistributionLocator {
    JMXDistributionLocator(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    public void start() throws AdminException {
        try {
            this.mbs.invoke(this.objectName, "start", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While starting";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void stop() throws AdminException {
        try {
            this.mbs.invoke(this.objectName, "stop", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While stopping";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean waitToStart(long timeout) throws InterruptedException {
        try {
            Boolean b = (Boolean)this.mbs.invoke(this.objectName, "waitToStart", new Object[]{new Long(timeout)}, new String[]{Long.TYPE.getName()});
            return b;
        }
        catch (Exception ex) {
            String s = "While waiting to start";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean waitToStop(long timeout) throws InterruptedException {
        try {
            Boolean b = (Boolean)this.mbs.invoke(this.objectName, "waitToStop", new Object[]{new Long(timeout)}, new String[]{Long.TYPE.getName()});
            return b;
        }
        catch (Exception ex) {
            String s = "While waiting to start";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean isRunning() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "running");
        }
        catch (Exception ex) {
            String s = "While calling getLog";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String getLog() throws AdminException {
        try {
            return (String)this.mbs.invoke(this.objectName, "getLog", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While calling getLog";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String getId() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "id");
        }
        catch (Exception ex) {
            String s = "While calling getLog";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public DistributionLocatorConfig getConfig() {
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
        return new JMXDistributionLocatorConfig(this.mbs, this.objectName);
    }

    static class JMXDistributionLocatorConfig
    extends JMXManagedEntityConfig
    implements DistributionLocatorConfig {
        JMXDistributionLocatorConfig(MBeanServerConnection mbs, ObjectName objectName) {
            super(mbs, objectName);
            Assert.assertTrue((objectName != null ? 1 : 0) != 0);
        }

        public int getPort() {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                return (Integer)this.mbs.getAttribute(this.objectName, "port");
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public void setPort(int port) {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                this.mbs.setAttribute(this.objectName, new Attribute("port", new Integer(port)));
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public String getBindAddress() {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                return (String)this.mbs.getAttribute(this.objectName, "bindAddress");
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public void setBindAddress(String bindAddress) {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                this.mbs.setAttribute(this.objectName, new Attribute("bindAddress", bindAddress));
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public void setDistributedSystemProperties(Properties props) {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                this.mbs.setAttribute(this.objectName, new Attribute("gemfire-properties", props));
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public Properties getDistributedSystemProperties() {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                return (Properties)this.mbs.getAttribute(this.objectName, "gemfire-properties");
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }
    }
}

