/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.admin.jmx.JMXDistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.jmx.JMXGemFireHealthConfig;
import com.gemstone.gemfire.internal.Assert;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXGemFireHealth
extends JMXAdminImpl
implements GemFireHealth {
    private JMXDistributedSystemHealthConfig dsHealthConfig = null;
    private JMXGemFireHealthConfig defaultHealthConfig = null;
    private final Map hostHealthConfigs = new HashMap();

    JMXGemFireHealth(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    public GemFireHealth.Health getHealth() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (GemFireHealth.Health)this.mbs.getAttribute(this.objectName, "health");
        }
        catch (Exception ex) {
            String s = "While getting the health";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void resetHealth() {
        try {
            this.mbs.invoke(this.objectName, "resetHealth", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While resetting the health";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String getDiagnosis() {
        try {
            return (String)this.mbs.invoke(this.objectName, "getDiagnosis", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While getting the diagnosis";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedSystemHealthConfig getDistributedSystemHealthConfig() {
        JMXGemFireHealth jMXGemFireHealth = this;
        synchronized (jMXGemFireHealth) {
            if (this.dsHealthConfig == null) {
                try {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    props.put("type", "DistributedSystemHealthConfig");
                    props.put("id", this.objectName.getKeyProperty("id"));
                    ObjectName dsHealthConfigName = new ObjectName("GemFire", props);
                    this.dsHealthConfig = new JMXDistributedSystemHealthConfig(this.mbs, dsHealthConfigName);
                }
                catch (Exception ex) {
                    String s = "While getting the DistributedSystemHealthConfig";
                    throw new InternalGemFireException(s, (Throwable)ex);
                }
            }
            return this.dsHealthConfig;
        }
    }

    public void setDistributedSystemHealthConfig(DistributedSystemHealthConfig config) {
        try {
            this.mbs.invoke(this.dsHealthConfig.getObjectName(), "applyChanges", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While setting the DistributedSystemHealthConfig";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    private JMXGemFireHealthConfig createHealthConfig(String hostName) throws Exception {
        ObjectName configName = (ObjectName)this.mbs.invoke(this.objectName, "manageGemFireHealthConfig", new Object[]{hostName}, new String[]{String.class.getName()});
        return new JMXGemFireHealthConfig(this.mbs, configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GemFireHealthConfig getDefaultGemFireHealthConfig() {
        JMXGemFireHealth jMXGemFireHealth = this;
        synchronized (jMXGemFireHealth) {
            if (this.defaultHealthConfig == null) {
                try {
                    this.defaultHealthConfig = this.createHealthConfig(null);
                }
                catch (Exception ex) {
                    String s = "While getting the DistributedSystemHealthConfig";
                    throw new InternalGemFireException(s, (Throwable)ex);
                }
            }
            return this.defaultHealthConfig;
        }
    }

    public void setDefaultGemFireHealthConfig(GemFireHealthConfig config) {
        try {
            this.mbs.invoke(this.defaultHealthConfig.getObjectName(), "applyChanges", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While setting the default GemFireHealthConfig";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GemFireHealthConfig getGemFireHealthConfig(String hostName) {
        try {
            Map map = this.hostHealthConfigs;
            synchronized (map) {
                JMXGemFireHealthConfig config = (JMXGemFireHealthConfig)this.hostHealthConfigs.get(hostName);
                if (config == null) {
                    config = this.createHealthConfig(hostName);
                    this.hostHealthConfigs.put(hostName, config);
                }
                return config;
            }
        }
        catch (Exception ex) {
            String s = "While setting the GemFireHealthConfig for " + hostName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void setGemFireHealthConfig(String hostName, GemFireHealthConfig config) {
        JMXGemFireHealthConfig jmxConfig = (JMXGemFireHealthConfig)config;
        try {
            this.mbs.invoke(jmxConfig.getObjectName(), "applyChanges", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While setting the GemFireHealthConfig for " + hostName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void close() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

