/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.ConfigurationParameter;
import com.gemstone.gemfire.admin.StatisticResource;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberType;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.admin.jmx.JMXStatisticResource;
import com.gemstone.gemfire.admin.jmx.JMXSystemMemberCache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.Assert;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXSystemMember
extends JMXAdminImpl
implements SystemMember {
    JMXSystemMember(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    public AdminDistributedSystem getDistributedSystem() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String getId() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "id");
        }
        catch (Exception ex) {
            String s = "While calling getId";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String getName() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "name");
        }
        catch (Exception ex) {
            String s = "While getting the name";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberType getType() {
        return SystemMemberType.APPLICATION;
    }

    public String getHost() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "host");
        }
        catch (Exception ex) {
            String s = "While calling getHost";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public InetAddress getHostAddress() {
        try {
            return InetAddress.getByName(this.getHost());
        }
        catch (Exception ex) {
            String s = "While calling getHost";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean isRunning() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "running");
        }
        catch (Exception ex) {
            String s = "While calling getLog";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String getVersion() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "version");
        }
        catch (Exception ex) {
            String s = "While calling getVersion";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public DistributedMember getDistributedMember() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (DistributedMember)this.mbs.getAttribute(this.objectName, "distributedMember");
        }
        catch (Exception ex) {
            String s = "While calling getDistributedMember";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String[] getRoles() {
        try {
            return (String[])this.mbs.invoke(this.objectName, "getRoles", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While calling getRoles";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public String getLog() {
        try {
            return (String)this.mbs.invoke(this.objectName, "getLog", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While calling getLog";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public Properties getLicense() {
        try {
            return (Properties)this.mbs.invoke(this.objectName, "getLicense", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While calling getLicense";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public ConfigurationParameter[] getConfiguration() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ConfigurationParameter[] setConfiguration(ConfigurationParameter[] parms) throws AdminException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void refreshConfig() throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.invoke(this.objectName, "refreshConfig", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While calling refreshConfig";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public StatisticResource[] getStats() throws AdminException {
        try {
            ObjectName[] names = (ObjectName[])this.mbs.invoke(this.objectName, "manageStats", new Object[0], new String[0]);
            StatisticResource[] stats = new StatisticResource[names.length];
            for (int i = 0; i < names.length; ++i) {
                stats[i] = new JMXStatisticResource(this.mbs, names[i]);
            }
            return stats;
        }
        catch (Exception ex) {
            String s = "While calling manageStats";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public StatisticResource[] getStat(String statisticsTypeName) throws AdminException {
        try {
            Object[] params = new String[]{"DistributionStats"};
            ObjectName[] names = (ObjectName[])this.mbs.invoke(this.objectName, "manageStat", params, new String[0]);
            StatisticResource[] stat = new JMXStatisticResource[names.length];
            for (int i = 0; i < names.length; ++i) {
                stat[i] = new JMXStatisticResource(this.mbs, names[i]);
            }
            return stat;
        }
        catch (Exception ex) {
            String s = "While calling manageStats";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean hasCache() throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "hasCache");
        }
        catch (Exception ex) {
            String s = "While calling getVersion";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberCache getCache() throws AdminException {
        if (!this.hasCache()) {
            return null;
        }
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            ObjectName name = (ObjectName)this.mbs.invoke(this.objectName, "manageCache", new Object[0], new String[0]);
            Assert.assertTrue((name != null ? 1 : 0) != 0);
            return new JMXSystemMemberCache(this.mbs, name);
        }
        catch (Exception ex) {
            String s = "While calling getCache";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public MBeanInfo getMBeanInfo() throws JMException, IOException {
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
        return this.mbs.getMBeanInfo(this.objectName);
    }

    public Object getAttribute(String attribute) throws JMException, IOException {
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
        return this.mbs.getAttribute(this.objectName, attribute);
    }

    public void setAttribute(String attribute, Object value) throws JMException, IOException {
        Attribute wrapper = new Attribute(attribute, value);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
        this.mbs.setAttribute(this.objectName, wrapper);
    }

    public String toString() {
        return this.getName() + " " + this.getId();
    }
}

