/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.RegionNotFoundException;
import com.gemstone.gemfire.admin.Statistic;
import com.gemstone.gemfire.admin.SystemMemberBridgeServer;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberCacheServer;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.admin.jmx.JMXSystemMemberBridgeServer;
import com.gemstone.gemfire.admin.jmx.JMXSystemMemberRegion;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.Assert;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXSystemMemberCache
extends JMXAdminImpl
implements SystemMemberCache {
    JMXSystemMemberCache(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    public String getName() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "name");
        }
        catch (Exception ex) {
            String s = "While calling getName on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public int getId() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "id");
        }
        catch (Exception ex) {
            String s = "While calling getId on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean isClosed() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "closed");
        }
        catch (Exception ex) {
            String s = "While calling isClosed on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public int getLockTimeout() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "lockTimeout");
        }
        catch (Exception ex) {
            String s = "While calling getLockTimeout on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void setLockTimeout(int seconds) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("lockTimeout", new Integer(seconds)));
        }
        catch (MBeanException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof AdminException) {
                throw (AdminException)cause;
            }
            String s = "While calling setLockTimeout on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (Exception ex) {
            String s = "While calling setLockTimeout on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public int getLockLease() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "lockLease");
        }
        catch (Exception ex) {
            String s = "While calling getLockLease on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void setLockLease(int seconds) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("lockLease", new Integer(seconds)));
        }
        catch (MBeanException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof AdminException) {
                throw (AdminException)cause;
            }
            String s = "While calling setLockLease on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (Exception ex) {
            String s = "While calling setLockLease on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public int getSearchTimeout() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "searchTimeout");
        }
        catch (Exception ex) {
            String s = "While calling getSearchTimeout on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void setSearchTimeout(int seconds) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("searchTimeout", new Integer(seconds)));
        }
        catch (MBeanException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof AdminException) {
                throw (AdminException)cause;
            }
            String s = "While calling setSearchTimeout on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (Exception ex) {
            String s = "While calling setSearchTimeout on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public int getUpTime() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "upTime");
        }
        catch (Exception ex) {
            String s = "While calling upTime on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public Set getRootRegionNames() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Set)this.mbs.getAttribute(this.objectName, "rootRegionNames");
        }
        catch (Exception ex) {
            String s = "While calling rootRegionNames on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public Statistic[] getStatistics() {
        try {
            Statistic[] stats = (Statistic[])this.mbs.invoke(this.objectName, "getStatistics", new Object[0], new String[0]);
            return stats;
        }
        catch (MBeanException ex) {
            String s = "While calling getStatistics on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String s = "While calling getStatistics on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberRegion getRegion(String path) throws AdminException {
        try {
            ObjectName name = (ObjectName)this.mbs.invoke(this.objectName, "manageRegion", new Object[]{path}, new String[]{String.class.getName()});
            return new JMXSystemMemberRegion(this.mbs, name);
        }
        catch (MBeanException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof AdminException) {
                if (cause.getMessage().indexOf("does not contain") != -1) {
                    return null;
                }
            } else {
                if (cause instanceof RegionNotFoundException) {
                    return null;
                }
                if (cause instanceof RegionDestroyedException) {
                    return null;
                }
            }
            String s = "While calling manageRegion on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String s = "While calling manageRegion on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberRegion createRegion(String name, RegionAttributes attrs) throws AdminException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public SystemMemberRegion createVMRegion(String name, RegionAttributes attrs) throws AdminException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void refresh() {
        try {
            this.mbs.invoke(this.objectName, "refresh", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While calling refresh() on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberBridgeServer addBridgeServer() throws AdminException {
        try {
            ObjectName name = (ObjectName)this.mbs.invoke(this.objectName, "manageBridgeServer", new Object[0], new String[0]);
            Assert.assertTrue((name != null ? 1 : 0) != 0);
            return new JMXSystemMemberBridgeServer(this.mbs, name);
        }
        catch (MBeanException ex) {
            String s = "While calling manageBridgeServer on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String s = "While calling manageBridgeServer on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberCacheServer addCacheServer() throws AdminException {
        try {
            ObjectName name = (ObjectName)this.mbs.invoke(this.objectName, "manageCacheServer", new Object[0], new String[0]);
            Assert.assertTrue((name != null ? 1 : 0) != 0);
            return new JMXSystemMemberBridgeServer(this.mbs, name);
        }
        catch (MBeanException ex) {
            String s = "While calling manageCacheServer on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String s = "While calling manageCacheServer on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberBridgeServer[] getBridgeServers() throws AdminException {
        try {
            ObjectName[] names = (ObjectName[])this.mbs.invoke(this.objectName, "manageBridgeServers", new Object[0], new String[0]);
            SystemMemberBridgeServer[] bridges = new SystemMemberBridgeServer[names.length];
            for (int i = 0; i < names.length; ++i) {
                Assert.assertTrue((names[i] != null ? 1 : 0) != 0);
                bridges[i] = new JMXSystemMemberBridgeServer(this.mbs, names[i]);
            }
            return bridges;
        }
        catch (MBeanException ex) {
            String s = "While calling manageBridgeServers on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String s = "While calling manageBridgeServers on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public SystemMemberCacheServer[] getCacheServers() throws AdminException {
        try {
            ObjectName[] names = (ObjectName[])this.mbs.invoke(this.objectName, "manageCacheServers", new Object[0], new String[0]);
            SystemMemberCacheServer[] bridges = new SystemMemberCacheServer[names.length];
            for (int i = 0; i < names.length; ++i) {
                Assert.assertTrue((names[i] != null ? 1 : 0) != 0);
                bridges[i] = new JMXSystemMemberBridgeServer(this.mbs, names[i]);
            }
            return bridges;
        }
        catch (MBeanException ex) {
            String s = "While calling manageCacheServers on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String s = "While calling manageCacheServers on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean isServer() throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "server");
        }
        catch (Exception ex) {
            String s = "While calling isServer on: " + this.objectName;
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }
}

