/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class JmxClientStatResourcesCleanupDUnitTest
extends AdminDUnitTestCase {
    private static final long serialVersionUID = 1L;
    private static final int CACHE_VM = 0;
    private static final int CLIENT_VM = 2;
    protected static final String REGION_NAME = "JmxClientStatResourcesCleanupDUnitTest_REGION";
    private static LogWriter logWriter = JmxClientStatResourcesCleanupDUnitTest.getLogWriter();
    private static int PAUSE_TIME = 15;
    private static ObjectName distributedSystem;
    private static MBeanServerConnection mbsc;
    private static AtomicInteger notificationCount;
    private static Connection clientConn;
    private static final Properties props;
    private int mcastPort;

    public JmxClientStatResourcesCleanupDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    public void testCleanUp() throws Exception {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.testCleanUp");
        logWriter.fine("JmxClientStatResourcesCleanupDUnitTest.testCleanUp#urlString :: " + this.urlString);
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        this.startCache(this.mcastPort, serverPort);
        JmxClientStatResourcesCleanupDUnitTest.pause(1000 * PAUSE_TIME);
        ObjectName member = JmxClientStatResourcesCleanupDUnitTest.manageSystemMembers();
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        int count0 = JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount();
        this.connectClient(serverPort);
        JmxClientStatResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        this.disConnectClient();
        JmxClientStatResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        count0 = JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount();
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.testCleanUp : After manageSystemMembers and before stopCache: stats resource count0 :: " + count0);
        this.connectClient(serverPort);
        JmxClientStatResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        int count1 = JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount();
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.testCleanUp# count1 : " + count1);
        JmxClientStatResourcesCleanupDUnitTest.assertTrue((String)"Client Stat resources were not created", (count1 > count0 ? 1 : 0) != 0);
        this.disConnectClient();
        JmxClientStatResourcesCleanupDUnitTest.pause(1000 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        final int count0_2 = count0;
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Wait for clean up to be done ...";
            }

            @Override
            public boolean done() {
                try {
                    int statResourceCount = JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount();
                    return statResourceCount == count0_2;
                }
                catch (Exception e) {
                    return true;
                }
            }
        };
        JmxClientStatResourcesCleanupDUnitTest.waitForCriterion(wc, 30000L, 1000L, false);
        int count2 = JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount();
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.testCleanUp# count2 : " + count2);
        JmxClientStatResourcesCleanupDUnitTest.assertTrue((String)"Client Stat resources were not removed.", (count2 == count0 ? 1 : 0) != 0);
        this.stopCache();
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.testCleanUp");
    }

    public void testClientMembership() throws Exception {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.testClientMembership");
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        this.startCache(this.mcastPort, serverPort);
        JmxClientStatResourcesCleanupDUnitTest.pause(1000 * PAUSE_TIME);
        ObjectName member = JmxClientStatResourcesCleanupDUnitTest.manageSystemMembers();
        JmxClientStatResourcesCleanupDUnitTest.addClientNotifListener(member);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        int count0 = JmxClientStatResourcesCleanupDUnitTest.getNotificationCount();
        this.connectClient(serverPort);
        JmxClientStatResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        this.disConnectClient();
        JmxClientStatResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        int count1 = JmxClientStatResourcesCleanupDUnitTest.getNotificationCount();
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.testClientMembership# count1 : " + count1);
        JmxClientStatResourcesCleanupDUnitTest.assertTrue((String)"Client Membership Notifications were not received.", (count1 > count0 ? 1 : 0) != 0);
        this.connectClient(serverPort);
        JmxClientStatResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        int count2 = JmxClientStatResourcesCleanupDUnitTest.getNotificationCount();
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.testClientMembership# count2 : " + count2);
        JmxClientStatResourcesCleanupDUnitTest.assertTrue((String)"Client Membership Notifications were not received.", (count2 > count1 ? 1 : 0) != 0);
        this.disConnectClient();
        JmxClientStatResourcesCleanupDUnitTest.pause(1000 * PAUSE_TIME);
        JmxClientStatResourcesCleanupDUnitTest.manageStats(member);
        int count3 = JmxClientStatResourcesCleanupDUnitTest.getNotificationCount();
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.testClientMembership# count3 : " + count3);
        JmxClientStatResourcesCleanupDUnitTest.assertTrue((String)"Client Membership Notifications were not received.", (count3 > count2 ? 1 : 0) != 0);
        this.stopCache();
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.testClientMembership");
    }

    private static void addClientNotifListener(ObjectName objName) throws Exception {
        mbsc.addNotificationListener(objName, new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                notificationCount.incrementAndGet();
            }
        }, new NotificationFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                boolean isThisNotificationEnabled = false;
                if (notification.getType().equals("gemfire.distributedsystem.cache.client.joined") || notification.getType().equals("gemfire.distributedsystem.cache.client.left") || notification.getType().equals("gemfire.distributedsystem.cache.client.crashed")) {
                    isThisNotificationEnabled = true;
                }
                return isThisNotificationEnabled;
            }
        }, null);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        return props;
    }

    public static void initDSProperties(int mcastPort) {
        props.clear();
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        props.setProperty("locators", "");
    }

    private void startCache(final int mcastPort, final int serverPort) {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.startCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-startCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                JmxClientStatResourcesCleanupDUnitTest.initDSProperties(mcastPort);
                Cache cacheInstance = JmxClientStatResourcesCleanupDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                RegionAttributes attrs = factory.create();
                cacheInstance.createRegion(JmxClientStatResourcesCleanupDUnitTest.REGION_NAME, attrs);
                CacheServer server = cacheInstance.addCacheServer();
                server.setPort(serverPort);
                try {
                    server.start();
                }
                catch (IOException e) {
                    throw new CacheException("Exception occurred while starting server.", e){
                        private static final long serialVersionUID = 1L;
                    };
                }
                logWriter.info("JmxClientStatResourcesCleanupDUnitTest.startCache :: Created cache & started server in cacheVM(VM#0) at port:" + serverPort);
            }
        });
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.startCache");
    }

    private static ObjectName manageSystemMembers() throws Exception {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.manageSystemMembers");
        Object[] params = new String[]{};
        String[] signature = new String[]{};
        ObjectName[] memberApplications = (ObjectName[])mbsc.invoke(distributedSystem, "manageSystemMemberApplications", params, signature);
        JmxClientStatResourcesCleanupDUnitTest.assertNotNull((String)"manageSystemMemberApplications invocation results are null.", (Object)memberApplications);
        JmxClientStatResourcesCleanupDUnitTest.assertEquals((String)("manageSystemMemberApplications invocation returned " + memberApplications.length + " while expected is 1"), (int)1, (int)memberApplications.length);
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.manageSystemMembers : Total Member Apps :: " + memberApplications.length);
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.manageSystemMembers");
        return memberApplications[0];
    }

    private static void manageStats(ObjectName member) throws Exception {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.manageStats");
        Object[] params = new String[]{};
        String[] signature = new String[]{};
        mbsc.invoke(member, "manageStats", params, signature);
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.manageStats");
    }

    private void connectClient(final int serverPort) {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.connectClient");
        final Host host = Host.getHost(0);
        VM clientVM = host.getVM(2);
        clientVM.invoke(new CacheSerializableRunnable(this.getName() + "-connectClient"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                JmxClientStatResourcesCleanupDUnitTest.this.createLonerCache();
                Cache cacheInstance = JmxClientStatResourcesCleanupDUnitTest.this.getCache();
                PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
                pf.addServer(host.getHostName(), serverPort);
                pf.setSubscriptionEnabled(true);
                pf.setReadTimeout(10000);
                pf.setSubscriptionRedundancy(0);
                PoolImpl p = (PoolImpl)pf.create("JmxClientStatResourcesCleanupDUnitTest");
                AttributesFactory factory = new AttributesFactory();
                factory.setPoolName(p.getName());
                factory.setScope(Scope.LOCAL);
                RegionAttributes attrs = factory.create();
                Region region = cacheInstance.createRegion(JmxClientStatResourcesCleanupDUnitTest.REGION_NAME, attrs);
                TestCase.assertNotNull((String)"Region in cache is is null.", (Object)region);
                clientConn = p.acquireConnection();
                TestCase.assertNotNull((String)"Acquired client connecttion is null.", (Object)clientConn);
            }
        });
        logWriter.info("JmxClientStatResourcesCleanupDUnitTest.connectClient :: Started client in clientVM(VM#2) & connected to cacheVM(VM#0).");
    }

    private void disConnectClient() {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.stopCache");
        Host host = Host.getHost(0);
        VM clientVM = host.getVM(2);
        clientVM.invoke(new CacheSerializableRunnable(this.getName() + "-disConnectClient"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                JmxClientStatResourcesCleanupDUnitTest.this.getCache().close();
                CacheTestCase.disconnectFromDS();
                clientConn.destroy();
            }
        });
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.stopCache");
    }

    private void stopCache() {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.stopCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-stopCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
            }
        });
        logWriter.fine("Exited JmxClientStatResourcesCleanupDUnitTest.stopCache");
    }

    private static int getStatResourceCount() throws Exception {
        logWriter.fine("Entered JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount");
        String domainString = "GemFire.Statistic:*";
        Set<ObjectName> queryMBeans = mbsc.queryNames(null, new ObjectName(domainString));
        JmxClientStatResourcesCleanupDUnitTest.assertNotNull((String)("Query on beans under domain '" + domainString + "' returned null."), queryMBeans);
        logWriter.fine("Exiting JmxClientStatResourcesCleanupDUnitTest.getStatResourceCount");
        return queryMBeans.size();
    }

    private static int getNotificationCount() throws Exception {
        return notificationCount.get();
    }

    @Override
    public void setUp() throws Exception {
        JmxClientStatResourcesCleanupDUnitTest.disconnectAllFromDS();
        this.mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        JmxClientStatResourcesCleanupDUnitTest.initDSProperties(this.mcastPort);
        super.setUp();
        mbsc = this.agent.getMBeanServer();
        JmxClientStatResourcesCleanupDUnitTest.assertNotNull((Object)mbsc);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        distributedSystem = (ObjectName)mbsc.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
        JmxClientStatResourcesCleanupDUnitTest.assertNotNull((Object)distributedSystem);
        notificationCount.set(0);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        JmxClientStatResourcesCleanupDUnitTest.disconnectAllFromDS();
        notificationCount.set(0);
    }

    static {
        notificationCount = new AtomicInteger();
        props = new Properties();
    }
}

