/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.RegionSubRegionSnapshot;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class JmxRegionResourcesCleanupDUnitTest
extends AdminDUnitTestCase {
    private static final long serialVersionUID = 1L;
    private static final int CACHE_VM = 0;
    protected static final String REGION_NAME1 = "JmxRegionResourcesCleanupDUnitTest_REGION1";
    protected static final String REGION_NAME2 = "JmxRegionResourcesCleanupDUnitTest_REGION2";
    private static LogWriter logWriter = JmxRegionResourcesCleanupDUnitTest.getLogWriter();
    private static int PAUSE_TIME = 15;
    private static ObjectName distributedSystem;
    private static MBeanServerConnection mbsc;
    protected static final Map<String, String> regionPaths;
    private static final Properties props;

    public JmxRegionResourcesCleanupDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    public void testCleanUp() throws Exception {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.testCleanUp");
        logWriter.fine("JmxRegionResourcesCleanupDUnitTest.testCleanUp#urlString :: " + this.urlString);
        JmxRegionResourcesCleanupDUnitTest.initDSProperties();
        this.startCache();
        JmxRegionResourcesCleanupDUnitTest.pause(1000 * PAUSE_TIME);
        ObjectName memberObjectName = JmxRegionResourcesCleanupDUnitTest.manageSystemMembers();
        ObjectName cacheObjectName = JmxRegionResourcesCleanupDUnitTest.manageCache(memberObjectName);
        JmxRegionResourcesCleanupDUnitTest.manageRegions(cacheObjectName);
        int count0 = JmxRegionResourcesCleanupDUnitTest.getRegionResourceCount();
        logWriter.info("No. of region JMX resources - initial count :: " + count0);
        this.createRegion(REGION_NAME1);
        JmxRegionResourcesCleanupDUnitTest.manageRegions(cacheObjectName);
        int count1 = JmxRegionResourcesCleanupDUnitTest.getRegionResourceCount();
        logWriter.info("No. of region JMX resources - after creating 1 region - count :: " + count1);
        this.createRegion(REGION_NAME2);
        JmxRegionResourcesCleanupDUnitTest.manageRegions(cacheObjectName);
        int count2 = JmxRegionResourcesCleanupDUnitTest.getRegionResourceCount();
        logWriter.info("No. of region JMX resources - after creating 2 regions - count :: " + count2);
        JmxRegionResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        this.destroyRegion(REGION_NAME1);
        this.destroyRegion(REGION_NAME2);
        JmxRegionResourcesCleanupDUnitTest.pause(500 * PAUSE_TIME);
        int count3 = JmxRegionResourcesCleanupDUnitTest.getRegionResourceCount();
        logWriter.info("No. of region JMX resources - after destroying all(2) regions - count :: " + count3);
        JmxRegionResourcesCleanupDUnitTest.assertTrue((String)"Region resources were not removed.", (count3 == count0 ? 1 : 0) != 0);
        this.stopCache();
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.testCleanUp");
    }

    @Override
    public Properties getDistributedSystemProperties() {
        return props;
    }

    public static void initDSProperties() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.clear();
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        props.setProperty("locators", "");
    }

    private void startCache() {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.startCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-startCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cacheInstance = JmxRegionResourcesCleanupDUnitTest.this.getCache();
                TestCase.assertNotNull((String)"Cache was not created.", (Object)cacheInstance);
                logWriter.info("JmxRegionResourcesCleanupDUnitTest.startCache :: Created cache & started server in cacheVM(VM#0)");
            }
        });
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.startCache");
    }

    private void createRegion(final String regionName) {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.createRegion");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-createRegion-" + regionName){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cacheInstance = JmxRegionResourcesCleanupDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                RegionAttributes attributes = factory.create();
                Region region = cacheInstance.createRegion(regionName, attributes);
                TestCase.assertNotNull((String)("Region with name '" + regionName + "' was not created"), (Object)region);
                regionPaths.put(regionName, region.getFullPath());
                logWriter.info("JmxRegionResourcesCleanupDUnitTest.createRegion :: Created region: '" + region.getFullPath() + "' in cacheVM(VM#" + 0 + ")");
            }
        });
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.createRegion");
    }

    private void destroyRegion(final String regionName) {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.destroyRegion");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-destroyRegion-" + regionName){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cacheInstance = JmxRegionResourcesCleanupDUnitTest.this.getCache();
                String regionPath = regionPaths.get(regionName);
                TestCase.assertNotNull((Object)("Regin Path not known for region name:" + regionName));
                Region region = cacheInstance.getRegion(regionPath);
                region.destroyRegion();
                logWriter.info("JmxRegionResourcesCleanupDUnitTest.destroyRegion :: Destroyed region: '" + region.getFullPath() + "' in cacheVM(VM#" + 0 + ")");
            }
        });
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.destroyRegion");
    }

    private static ObjectName manageSystemMembers() throws Exception {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.manageSystemMembers");
        Object[] params = new String[]{};
        String[] signature = new String[]{};
        ObjectName[] memberApplications = (ObjectName[])mbsc.invoke(distributedSystem, "manageSystemMemberApplications", params, signature);
        JmxRegionResourcesCleanupDUnitTest.assertNotNull((String)"manageSystemMemberApplications invocation results are null.", (Object)memberApplications);
        JmxRegionResourcesCleanupDUnitTest.assertEquals((String)("manageSystemMemberApplications invocation returned " + memberApplications.length + " while expected is 1"), (int)1, (int)memberApplications.length);
        logWriter.info("JmxRegionResourcesCleanupDUnitTest.manageSystemMembers : Total Member Apps :: " + memberApplications.length);
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.manageSystemMembers");
        return memberApplications[0];
    }

    private static ObjectName manageCache(ObjectName member) throws Exception {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.manageCache");
        Object[] params = new String[]{};
        String[] signature = new String[]{};
        ObjectName cache = (ObjectName)mbsc.invoke(member, "manageCache", params, signature);
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.manageCache");
        return cache;
    }

    private static void manageRegions(ObjectName cacheON) throws Exception {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.manageRegions");
        Object[] params = new String[]{};
        String[] signature = new String[]{};
        RegionSubRegionSnapshot regionsSnap = (RegionSubRegionSnapshot)mbsc.invoke(cacheON, "getRegionSnapshot", params, signature);
        JmxRegionResourcesCleanupDUnitTest.assertNotNull((String)"Regions Snapshot is null.", (Object)regionsSnap);
        String rootPath = regionsSnap.getFullPath();
        Set subRegionSnapshots = regionsSnap.getSubRegionSnapshots();
        params = new String[1];
        signature = new String[]{"java.lang.String"};
        for (RegionSubRegionSnapshot subRegionSnap : subRegionSnapshots) {
            String fullPath = subRegionSnap.getFullPath();
            fullPath = fullPath.substring(rootPath.length());
            params[0] = fullPath;
            mbsc.invoke(cacheON, "manageRegion", params, signature);
        }
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.manageRegions");
    }

    private void stopCache() {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.stopCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-stopCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
            }
        });
        logWriter.fine("Exited JmxRegionResourcesCleanupDUnitTest.stopCache");
    }

    private static int getRegionResourceCount() throws Exception {
        logWriter.fine("Entered JmxRegionResourcesCleanupDUnitTest.getRegionResourceCount");
        String domainString = "GemFire.Cache:*,type=Region";
        Set<ObjectName> queryMBeans = mbsc.queryNames(null, new ObjectName(domainString));
        JmxRegionResourcesCleanupDUnitTest.assertNotNull((String)("Query on beans under domain '" + domainString + "' returned null."), queryMBeans);
        logWriter.fine("Exiting JmxRegionResourcesCleanupDUnitTest.getRegionResourceCount");
        return queryMBeans.size();
    }

    @Override
    public void setUp() throws Exception {
        JmxRegionResourcesCleanupDUnitTest.disconnectAllFromDS();
        super.setUp();
        mbsc = this.agent.getMBeanServer();
        JmxRegionResourcesCleanupDUnitTest.assertNotNull((Object)mbsc);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        distributedSystem = (ObjectName)mbsc.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
        JmxRegionResourcesCleanupDUnitTest.assertNotNull((Object)distributedSystem);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        JmxRegionResourcesCleanupDUnitTest.disconnectAllFromDS();
    }

    static {
        regionPaths = new HashMap<String, String>();
        props = new Properties();
    }
}

