/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JmxStatResourcesCleanupDUnitTest
extends AdminDUnitTestCase {
    private static final long serialVersionUID = 1L;
    private static final int CACHE_VM = 0;
    private static LogWriter logWriter = JmxStatResourcesCleanupDUnitTest.getLogWriter();
    private static int PAUSE_TIME = 15;
    private static ObjectName distributedSystem;
    private static MBeanServerConnection mbsc;

    public JmxStatResourcesCleanupDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    public void testCleanUp() throws Exception {
        logWriter.fine("Entered JmxStatResourcesCleanupDUnitTest.testCleanUp");
        logWriter.fine("JmxStatResourcesCleanupDUnitTest.testCleanUp#urlString :: " + this.urlString);
        this.startCache();
        JmxStatResourcesCleanupDUnitTest.pause(1000 * PAUSE_TIME);
        JmxStatResourcesCleanupDUnitTest.manageSystemMembers(this.urlString);
        logWriter.info("JmxStatResourcesCleanupDUnitTest.testCleanUp : After manageSystemMembers and before stopCache: stats resource count :: " + JmxStatResourcesCleanupDUnitTest.getStatResourceCount());
        this.stopCache();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Wait for clean up to be done ...";
            }

            @Override
            public boolean done() {
                try {
                    int statResourceCount = JmxStatResourcesCleanupDUnitTest.getStatResourceCount();
                    return statResourceCount == 0;
                }
                catch (Exception e) {
                    return true;
                }
            }
        };
        JmxStatResourcesCleanupDUnitTest.waitForCriterion(wc, 30000L, 1000L, false);
        logWriter.info("JmxStatResourcesCleanupDUnitTest.testCleanUp : After stopCache: stats resource count :: " + JmxStatResourcesCleanupDUnitTest.getStatResourceCount());
        boolean cleanUpDone = this.checkCleanUp();
        JmxStatResourcesCleanupDUnitTest.assertTrue((String)"MBeans clean up wasn't done properly.", (boolean)cleanUpDone);
        logWriter.fine("Exited JmxStatResourcesCleanupDUnitTest.testCleanUp");
    }

    private void startCache() {
        logWriter.fine("Entered JmxStatResourcesCleanupDUnitTest.startCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-startCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                JmxStatResourcesCleanupDUnitTest.this.getCache();
                logWriter.info("JmxStatResourcesCleanupDUnitTest.startCache :: Cache created in cacheVM(VM#0).");
            }
        });
        logWriter.fine("Exited JmxStatResourcesCleanupDUnitTest.startCache");
    }

    private static void manageSystemMembers(String urlString) throws Exception {
        logWriter.fine("Entered JmxStatResourcesCleanupDUnitTest.manageSystemMembers");
        Object[] params = new String[]{};
        String[] signature = new String[]{};
        ObjectName[] memberApplications = (ObjectName[])mbsc.invoke(distributedSystem, "manageSystemMemberApplications", params, signature);
        JmxStatResourcesCleanupDUnitTest.assertNotNull((String)"manageSystemMemberApplications invocation results are null.", (Object)memberApplications);
        JmxStatResourcesCleanupDUnitTest.assertEquals((String)("manageSystemMemberApplications invocation returned " + memberApplications.length + " while expected is 1"), (int)1, (int)memberApplications.length);
        logWriter.info("JmxStatResourcesCleanupDUnitTest.manageSystemMembers : Total Member Apps :: " + memberApplications.length);
        ObjectName systemMemberApp = memberApplications[0];
        mbsc.invoke(systemMemberApp, "manageStats", params, signature);
        logWriter.fine("Exited JmxStatResourcesCleanupDUnitTest.manageSystemMembers");
    }

    private void stopCache() {
        logWriter.fine("Entered JmxStatResourcesCleanupDUnitTest.stopCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-stopCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
            }
        });
        logWriter.fine("Exited JmxStatResourcesCleanupDUnitTest.stopCache");
    }

    private static int getStatResourceCount() throws Exception {
        logWriter.fine("Entered JmxStatResourcesCleanupDUnitTest.getStatResourceCount");
        String domainString = "GemFire.Statistic:*";
        Set<ObjectName> queryMBeans = mbsc.queryNames(null, new ObjectName(domainString));
        JmxStatResourcesCleanupDUnitTest.assertNotNull((String)("Query on beans under domain '" + domainString + "' returned null."), queryMBeans);
        logWriter.fine("Exiting JmxStatResourcesCleanupDUnitTest.getStatResourceCount");
        return queryMBeans.size();
    }

    private boolean checkCleanUp() throws Exception {
        logWriter.fine("Entered JmxStatResourcesCleanupDUnitTest.checkCleanUp");
        boolean cleanUpDone = JmxStatResourcesCleanupDUnitTest.getStatResourceCount() == 0;
        logWriter.fine("Exiting JmxStatResourcesCleanupDUnitTest.checkCleanUp");
        return cleanUpDone;
    }

    @Override
    public void setUp() throws Exception {
        JmxStatResourcesCleanupDUnitTest.disconnectAllFromDS();
        super.setUp();
        mbsc = this.agent.getMBeanServer();
        JmxStatResourcesCleanupDUnitTest.assertNotNull((Object)mbsc);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        distributedSystem = (ObjectName)mbsc.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
        JmxStatResourcesCleanupDUnitTest.assertNotNull((Object)distributedSystem);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        JmxStatResourcesCleanupDUnitTest.disconnectAllFromDS();
    }
}

