/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.admin.remote.ClientHealthStats;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import junit.framework.TestCase;

public class MemberInfoWithStatsMBeanGFEValidationDUnitTest
extends AdminDUnitTestCase {
    private static final long serialVersionUID = 1L;
    private static final String KEY_CLIENTS_MAP = "gemfire.member.clients.map";
    private static final String KEY_REGIONS_MAP = "gemfire.member.regions.map";
    private static final String KEY_GATEWAY_COLLECTION = "gemfire.member.gatewayhub.gateways.collection";
    private static final String KEY_GATEWAYENDPOINTS_COLLECTION = "gemfire.member.gateway.endpoints.collection";
    private static final String TYPE_NAME_CACHESERVER = "Cache Server";
    private static final String TYPE_NAME_APPLICATION = "Application Peer";
    private static final String TYPE_NAME_GATEWAYHUB = "Gateway Hub";
    private static final String KEY_MEMBER_ID = "gemfire.member.id.string";
    private static final String KEY_MEMBER_NAME = "gemfire.member.name.string";
    private static final String KEY_MEMBER_HOST = "gemfire.member.host.string";
    private static final String KEY_MEMBER_PORT = "gemfire.member.port.int";
    private static final String KEY_MEMBER_UPTIME = "gemfire.member.uptime.long";
    private static final String KEY_MEMBER_TYPE = "gemfire.member.type.string";
    private static final String KEY_MEMBER_IS_SERVER = "gemfire.member.isserver.boolean";
    private static final String KEY_MEMBER_IS_GATEWAY = "gemfire.member.isgateway.boolean";
    private static final String KEY_MEMBER_STATSAMPLING_ENABLED = "gemfire.member.config.statsamplingenabled.boolean";
    private static final String KEY_MEMBER_TIME_STATS_ENABLED = "gemfire.member.config.timestatsenabled.boolean";
    private static final String KEY_STATS_PROCESSCPUTIME = "gemfire.member.stat.processcputime.long";
    private static final String KEY_STATS_CPUS = "gemfire.member.stat.cpus.int";
    private static final String KEY_STATS_USEDMEMORY = "gemfire.member.stat.usedmemory.long";
    private static final String KEY_STATS_MAXMEMORY = "gemfire.member.stat.maxmemory.long";
    private static final String KEY_STATS_GETS = "gemfire.member.stat.gets.int";
    private static final String KEY_STATS_GETTIME = "gemfire.member.stat.gettime.long";
    private static final String KEY_STATS_PUTS = "gemfire.member.stat.puts.int";
    private static final String KEY_STATS_PUTTIME = "gemfire.member.stat.puttime.long";
    private static final String KEY_GATEWAYHUB_ID = "gemfire.member.gatewayhub.id.string";
    private static final String KEY_GATEWAYHUB_ISPRIMARY = "gemfire.member.gatewayhub.isprimary.boolean";
    private static final String KEY_GATEWAYHUB_LISTENINGPORT = "gemfire.member.gatewayhub.listeningport.int";
    private static final String KEY_GATEWAY_ID = "gemfire.member.gateway.id.string";
    private static final String KEY_GATEWAY_QUEUESIZE = "gemfire.member.gateway.queuesize.int";
    private static final String KEY_GATEWAY_ISCONNECTED = "gemfire.member.gateway.isconnected.boolean";
    private static final String KEY_GATEWAYENDPOINT_ID = "gemfire.member.gateway.endpoint.id.string";
    private static final String KEY_GATEWAYENDPOINT_HOST = "gemfire.member.gateway.endpoint.host.string";
    private static final String KEY_GATEWAYENDPOINT_PORT = "gemfire.member.gateway.endpoint.port.int";
    private static final String KEY_CLIENT_ID = "gemfire.client.id.string";
    private static final String KEY_CLIENT_HOST = "gemfire.client.host.string";
    private static final String KEY_CLIENT_QUEUESIZE = "gemfire.client.queuesize.int";
    private static final String KEY_CLIENT_STATS_GETS = "gemfire.client.stats.gets.int";
    private static final String KEY_CLIENT_STATS_PUTS = "gemfire.client.stats.puts.int";
    private static final String KEY_CLIENT_STATS_CACHEMISSES = "gemfire.client.stats.cachemisses.int";
    private static final String KEY_CLIENT_STATS_CPUUSAGE = "gemfire.client.stats.cpuusage.long";
    private static final String KEY_CLIENT_STATS_CPUS = "gemfire.client.stats.cpus.int";
    private static final String KEY_CLIENT_STATS_UPDATETIME = "gemfire.client.stats.updatetime.long";
    private static final String KEY_CLIENT_STATS_THREADS = "gemfire.client.stats.threads.int";
    private static final String KEY_REGION_NAME = "gemfire.region.name.string";
    private static final String KEY_REGION_PATH = "gemfire.region.path.string";
    private static final String KEY_REGION_SCOPE = "gemfire.region.scope.string";
    private static final String KEY_REGION_DATAPOLICY = "gemfire.region.datapolicy.string";
    private static final String KEY_REGION_INTERESTPOLICY = "gemfire.region.interestpolicy.string";
    private static final String KEY_REGION_ENTRYCOUNT = "gemfire.region.entrycount.int";
    private static final String KEY_REGION_DISKATTRS = "gemfire.region.diskattrs.string";
    private static final String[] KEYS_MEMBERS = new String[]{"gemfire.member.config.statsamplingenabled.boolean", "gemfire.member.config.timestatsenabled.boolean", "gemfire.member.host.string", "gemfire.member.id.string", "gemfire.member.isgateway.boolean", "gemfire.member.isserver.boolean", "gemfire.member.name.string", "gemfire.member.port.int", "gemfire.member.stat.cpus.int", "gemfire.member.stat.gets.int", "gemfire.member.stat.gettime.long", "gemfire.member.stat.maxmemory.long", "gemfire.member.stat.processcputime.long", "gemfire.member.stat.puts.int", "gemfire.member.stat.puttime.long", "gemfire.member.stat.usedmemory.long", "gemfire.member.type.string", "gemfire.member.uptime.long"};
    private static LogWriter logWriter = MemberInfoWithStatsMBeanGFEValidationDUnitTest.getLogWriter();
    private static ObjectName distributedSystem;
    private static MBeanServerConnection mbsc;
    private boolean shouldDoGatewayHubCleanup = false;
    private static String earlierSlowStartTime;
    private static final long DEFAULT_SLOW_STARTING_TIME = 5000L;
    private static final Set<String> UNPREDICTABLES;
    private static final Set<String> INCREASING_VALUES;
    private static final Properties props;
    private int[] freeUDPPorts = new int[0];
    private static final String WAN_REGION_NAME = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_WAN_Root";
    private static final String DS_REGION1_NAME = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_DS_Root";
    private static final String DS_REGION2_NAME = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_DS_Root_2";
    private static final int GATEWAYHUB_VM = 1;
    private VM[] vmsDS0 = new VM[0];
    private VM[] vmsDS1 = new VM[0];
    private static final int HOST0 = 0;
    private static final int HOST1 = 1;
    private static final int CACHE_VM = 0;
    private static final int CLIENT_VM = 2;
    private static final int CLIENT_VM2 = 1;
    private static final int CLIENT_STATS_INTERVAL = 5000;
    private static Connection clientConn;

    public MemberInfoWithStatsMBeanGFEValidationDUnitTest(String name) {
        super(name);
    }

    private static void initIgnorableProperties() {
        INCREASING_VALUES.add(KEY_MEMBER_UPTIME);
        INCREASING_VALUES.add(KEY_STATS_GETTIME);
        INCREASING_VALUES.add(KEY_STATS_PUTTIME);
        INCREASING_VALUES.add(KEY_STATS_PUTS);
        INCREASING_VALUES.add(KEY_STATS_GETS);
        INCREASING_VALUES.add(KEY_STATS_PROCESSCPUTIME);
        UNPREDICTABLES.add(KEY_STATS_USEDMEMORY);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    public void testGatewayHubDetails() throws Exception {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.testGatewayDetails");
        this.setUpForGatewayTest();
        ObjectName wrapper = ObjectName.getInstance("GemFire:type=MemberInfoWithStatsMBean");
        String[] members = this.commonTestCode(wrapper);
        for (int i = 0; i < members.length; ++i) {
            Map memberDetailsJMX = this.getDetailsByJMX(wrapper, members[i]);
            Boolean isGateway = (Boolean)memberDetailsJMX.get(KEY_MEMBER_IS_GATEWAY);
            Map memberDetailsDirect = this.getMemberDetailsDirect(0, isGateway != false ? 1 : 0);
            this.compareMemberDetails(memberDetailsJMX, memberDetailsDirect);
            if (!isGateway.booleanValue()) continue;
            Map<String, Number> gatewaysAndQueuesBefore = this.verifyGatewayDetails(memberDetailsJMX, 0, 1);
            this.doWANRegionPuts("testGatewayHubDetails", 100, 0, 1);
            this.waitForAgentAutoRefresh();
            memberDetailsJMX = this.getDetailsByJMX(wrapper, members[i]);
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.testGatewayDetails");
        this.shouldDoGatewayHubCleanup = true;
    }

    public void testRegionAndClientDetailsWithOps() throws Exception {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.testRegionAndClientDetails");
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        int numberOfOps = 1000;
        String prefix = "testRegionAndClientDetailsWithOps";
        this.startCache(serverPort, 0, 0);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.connectClient(serverPort, 0, 2);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        ObjectName wrapper = ObjectName.getInstance("GemFire:type=MemberInfoWithStatsMBean");
        String[] members = this.commonTestCode(wrapper);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"No. of members are expected be more than zero.", (members.length != 0 ? 1 : 0) != 0);
        Map<?, ?> oldData = null;
        Map<?, ?> currentData = null;
        oldData = this.verifyRegionAndClientDetails(wrapper, members[0], 1, 0, 0);
        this.doPuts("testRegionAndClientDetailsWithOps", 1000, 0, 0);
        this.doGetsPutsToUpdateStats("testRegionAndClientDetailsWithOps", 1000, 0, 0, true, false);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.waitForAgentAutoRefresh();
        currentData = this.verifyRegionAndClientDetails(wrapper, members[0], 1, 0, 0);
        this.verifyVariationWithOldData(oldData, currentData);
        oldData = currentData;
        this.doDeletes("testRegionAndClientDetailsWithOps", 1000, 0, 0);
        this.doGetsPutsToUpdateStats("testRegionAndClientDetailsWithOps", 1000, 0, 0, true, true);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.waitForAgentAutoRefresh();
        currentData = this.verifyRegionAndClientDetails(wrapper, members[0], 1, 0, 0);
        this.verifyVariationWithOldData(oldData, currentData);
        this.addRegion(DS_REGION2_NAME, "testRegionAndClientDetailsWithOps", 100, 0, 0);
        this.waitForAgentAutoRefresh();
        this.verifyRegionAndClientDetails(wrapper, members[0], 2, 0, 0);
        this.deleteRegion(DS_REGION2_NAME, 0, 0);
        this.waitForAgentAutoRefresh();
        this.verifyRegionAndClientDetails(wrapper, members[0], 1, 0, 0);
        this.disConnectClient(0, 2);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.stopCache(0, 0);
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.testRegionAndClientDetails");
        this.shouldDoGatewayHubCleanup = false;
    }

    public void testVaryingValues() throws Exception {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.testVaryingValues");
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        int slowStartTime = 40000;
        int total = 10000;
        String keyPrefix = "testVaryingValues";
        this.doSetSlowStart(0, 0, 40000);
        this.startCache(serverPort, 0, 0);
        long cacheStartTime = System.currentTimeMillis();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        ObjectName wrapper = ObjectName.getInstance("GemFire:type=MemberInfoWithStatsMBean");
        String[] members = this.commonTestCode(wrapper);
        CachedMemberData cd = new CachedMemberData();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"No. of members are expected be more than zero.", (members.length != 0 ? 1 : 0) != 0);
        this.verifyEntriesAndMemoryVariation(cd, wrapper, members[0]);
        this.connectClient(serverPort, 0, 2);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.doPuts("testVaryingValues", 10000, 0, 0);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.waitForAgentAutoRefresh();
        this.verifyEntriesAndMemoryVariation(cd, wrapper, members[0]);
        this.waitForAgentAutoRefresh();
        Map mapThroughJmx = this.getDetailsByJMX(wrapper, members[0]);
        this.verifyClientQueueSize(mapThroughJmx, 0, 0);
        int clientMissesBefore = this.verifyClientMisses(mapThroughJmx, 0, 0, false);
        long[] clientStatsBefore = this.verifyClientStatsVariation(mapThroughJmx, 0, 0);
        int elapsed = (int)(System.currentTimeMillis() - cacheStartTime);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(40000 - elapsed + 10000);
        this.doClientLocalInvalidateGetsPuts("testVaryingValues", 1000, 0, 2);
        this.waitForAgentAutoRefresh();
        mapThroughJmx = this.getDetailsByJMX(wrapper, members[0]);
        int clientMissesLater = this.verifyClientMisses(mapThroughJmx, 0, 0, true);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Misses Stat value obtained (" + clientMissesLater + ") should be more than earlier value (" + clientMissesBefore + ")"), (clientMissesLater > clientMissesBefore ? 1 : 0) != 0);
        long[] clientStatsLater = this.verifyClientStatsVariation(mapThroughJmx, 0, 0);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Gets Stat value obtained (" + clientStatsLater[0] + ") should be more than earlier value (" + clientStatsBefore[0] + ")"), (clientStatsLater[0] > clientStatsBefore[0] ? 1 : 0) != 0);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Puts Stat value obtained (" + clientStatsLater[1] + ") should be more than earlier value (" + clientStatsBefore[1] + ")"), (clientStatsLater[1] > clientStatsBefore[1] ? 1 : 0) != 0);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Process Cpu Time Stat value obtained (" + clientStatsLater[2] + ") should be more than earlier value (" + clientStatsBefore[2] + ")"), (clientStatsLater[2] > clientStatsBefore[2] ? 1 : 0) != 0);
        this.doDeletes("testVaryingValues", 10000, 0, 0);
        this.waitForAgentAutoRefresh();
        this.verifyEntriesAndMemoryVariation(cd, wrapper, members[0]);
        mapThroughJmx = this.getDetailsByJMX(wrapper, members[0]);
        Map clientsMap = (Map)mapThroughJmx.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("No. of clients value expected to be 1 but actually it is:" + clientsMap.size()), (clientsMap.size() == 1 ? 1 : 0) != 0);
        this.connectClient(serverPort, 0, 1);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.waitForAgentAutoRefresh();
        mapThroughJmx = this.getDetailsByJMX(wrapper, members[0]);
        clientsMap = (Map)mapThroughJmx.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("No. of clients value expected to be 2 but actually it is:" + clientsMap.size()), (clientsMap.size() == 2 ? 1 : 0) != 0);
        this.disConnectClient(0, 1);
        this.disConnectClient(0, 2);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(5000);
        this.waitForAgentAutoRefresh();
        mapThroughJmx = this.getDetailsByJMX(wrapper, members[0]);
        clientsMap = (Map)mapThroughJmx.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("No. of clients value expected to be 0 but actually it is:" + clientsMap.size()), (clientsMap.size() == 0 ? 1 : 0) != 0);
        this.stopCache(0, 0);
        this.doUnsetSlowStart(0, 0);
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.testVaryingValues");
        this.shouldDoGatewayHubCleanup = false;
    }

    private void verifyVariationWithOldData(Map<?, ?> oldData, Map<?, ?> currentData) {
        for (String prop : INCREASING_VALUES) {
            Object oldVal = oldData.get(prop);
            Object newVal = currentData.get(prop);
            if (prop.equals(KEY_STATS_PROCESSCPUTIME)) {
                Object oldDirect = oldData.get("gemfire.member.stat.processcputime.longDIRECT");
                Object newDirect = currentData.get("gemfire.member.stat.processcputime.longDIRECT");
                MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Old val (" + oldVal + " & old DIRECT [" + oldDirect + "]) expected to be different than new val(" + newVal + " & new DIRECT [" + newDirect + "]) but they are the same for : " + prop), (newVal != null && newVal != oldVal && !newVal.equals(oldVal) ? 1 : 0) != 0);
                continue;
            }
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Old val (" + oldVal + ") expected to be different than new val(" + newVal + ") but they are the same for : " + prop), (newVal != null && newVal != oldVal && !newVal.equals(oldVal) ? 1 : 0) != 0);
        }
    }

    private Map<?, ?> verifyRegionAndClientDetails(ObjectName wrapper, String memberId, int numOfRegions, int hostIndex, int vmIndex) throws Exception {
        Map memberDetailsJMX = this.verifyMemberDetails(wrapper, memberId, hostIndex, vmIndex);
        this.verifyClientsDetails(memberDetailsJMX, hostIndex, vmIndex);
        this.verifyRegionsDetails(memberDetailsJMX, numOfRegions, hostIndex, vmIndex);
        return memberDetailsJMX;
    }

    private String[] commonTestCode(ObjectName wrapper) throws Exception {
        boolean isInitialized = this.isMBeanInitialized(wrapper);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertFalse((String)"MemberInfoWithStatsMBean initialized without first call to getMembers operation.", (boolean)isInitialized);
        Object[] members = this.invokeGetMembers(wrapper);
        logWriter.info("MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGetMembers(): ids :: " + Arrays.toString(members));
        isInitialized = this.isMBeanInitialized(wrapper);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"MemberInfoWithStatsMBean not initialized even after the first call to getMembers operation.", (boolean)isInitialized);
        this.verifyAttributes(wrapper);
        this.verifyGetMembers((String[])members);
        return members;
    }

    private void verifyClientsDetails(Map memberDetailsJMX, int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientsDetails() ...");
        Map clientsJmx = (Map)memberDetailsJMX.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("MemberInfoWithStatsMBean returned map of clients information has size: " + clientsJmx.size() + ", but expected is 1."), (clientsJmx.size() == 1 ? 1 : 0) != 0);
        Map clientJmx = new HashMap();
        Iterator iterator = clientsJmx.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            clientJmx = (Map)entry.getValue();
        }
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"MemberInfoWithStatsMBean returned map of clients information was null.", clientJmx);
        Host host = Host.getHost(hostIndex);
        VM cacheVM = host.getVM(vmIndex);
        Object result = cacheVM.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                return new GemFireMemberStatus(MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache());
            }
        });
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"Object returned was null.", (Object)result);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"Object returned is not a GemFireMemberStatus.", (boolean)(result instanceof GemFireMemberStatus));
        GemFireMemberStatus status = (GemFireMemberStatus)result;
        String clientId = (String)clientJmx.get(KEY_CLIENT_ID);
        String clientHost = (String)clientJmx.get(KEY_CLIENT_HOST);
        int clientQueueSize = (Integer)clientJmx.get(KEY_CLIENT_QUEUESIZE);
        int clientStatsGets = (Integer)clientJmx.get(KEY_CLIENT_STATS_GETS);
        int clientStatsPuts = (Integer)clientJmx.get(KEY_CLIENT_STATS_PUTS);
        int clientStatsMisses = (Integer)clientJmx.get(KEY_CLIENT_STATS_CACHEMISSES);
        long clientStatsCpuUsage = (Long)clientJmx.get(KEY_CLIENT_STATS_CPUUSAGE);
        int clientStatsCpus = (Integer)clientJmx.get(KEY_CLIENT_STATS_CPUS);
        long clientStatsUpdateTime = (Long)clientJmx.get(KEY_CLIENT_STATS_UPDATETIME);
        int clientStatsThreads = (Integer)clientJmx.get(KEY_CLIENT_STATS_THREADS);
        Set connectedClients = status.getConnectedClients();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertEquals((String)("No. of clients connected are expected to be 1 but in actual there are:" + connectedClients.size()), (int)connectedClients.size(), (int)1);
        for (String clientIdActual : connectedClients) {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client ids are not identical. Actual:" + clientIdActual + " but Mbean returned:" + clientId), (clientIdActual != null && clientId != null && clientIdActual.equals(clientId) ? 1 : 0) != 0);
            String clientHostActual = status.getClientHostName(clientIdActual);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client host names are not identical. Actual:" + clientHostActual + " but Mbean returned:" + clientHost), (clientHost != null && clientHostActual != null && clientHostActual.equals(clientHost) ? 1 : 0) != 0);
            int clientQueueSizeActual = status.getClientQueueSize(clientIdActual);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Queuesizes are not identical. Actual:" + clientQueueSizeActual + " but Mbean returned:" + clientQueueSize), (clientQueueSize == clientQueueSizeActual ? 1 : 0) != 0);
            ClientHealthStats clientHealthStats = (ClientHealthStats)status.getClientHealthStats(clientIdActual);
            if (clientHealthStats == null) continue;
            int getsActual = clientHealthStats.getNumOfGets();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client gets Statistics are not identical. Actual:" + getsActual + " but Mbean returned:" + clientStatsGets), (getsActual == clientStatsGets ? 1 : 0) != 0);
            int putsActual = clientHealthStats.getNumOfPuts();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client puts Statistics are not identical. Actual:" + putsActual + " but Mbean returned:" + clientStatsPuts), (putsActual == clientStatsPuts ? 1 : 0) != 0);
            int missesActual = clientHealthStats.getNumOfMisses();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client misses Statistics are not identical. Actual:" + missesActual + " but Mbean returned:" + clientStatsMisses), (missesActual == clientStatsMisses ? 1 : 0) != 0);
            long cpuUsageActual = clientHealthStats.getProcessCpuTime();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client CPU Usage Statistics are not as expected - (obtained directly from server) should be >= (obtained from JMX earlier). Actual:" + cpuUsageActual + " but Mbean returned:" + clientStatsCpuUsage), (cpuUsageActual >= clientStatsCpuUsage ? 1 : 0) != 0);
            int cpusActual = clientHealthStats.getCpus();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client cpus Statistics are not identical. Actual:" + cpusActual + " but Mbean returned:" + clientStatsCpus), (cpusActual == clientStatsCpus ? 1 : 0) != 0);
            long updateTimeActual = clientHealthStats.getUpdateTime().getTime();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client updateTime Statistics are not as expected - (obtained directly from server) should be >= (obtained from JMX earlier). Actual:" + updateTimeActual + " but Mbean returned:" + clientStatsUpdateTime), (updateTimeActual >= clientStatsUpdateTime ? 1 : 0) != 0);
            int threadsActual = clientHealthStats.getNumOfThreads();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client threads Statistics are either not identical or are zero. Actual:" + threadsActual + " but Mbean returned:" + clientStatsThreads), (threadsActual == clientStatsThreads && threadsActual != 0 ? 1 : 0) != 0);
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientsDetails() ...");
    }

    private void verifyRegionsDetails(Map memberDetailsJMX, final int numOfRegions, int hostIndex, int vmIndex) throws Exception {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyRegionsDetails() ...");
        Map regionsJmx = (Map)memberDetailsJMX.get(KEY_REGIONS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"Region info through MemberInfoWithStatsMBean is null.", (Object)regionsJmx);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertEquals((String)("No of regions expected is: 1, but MemberInfoWithStatsMBean returned: " + regionsJmx.size()), (int)regionsJmx.size(), (int)numOfRegions);
        Host host = Host.getHost(hostIndex);
        VM cacheVM = host.getVM(vmIndex);
        Map[] regionDetailsMaps = (Map[])cacheVM.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                Map[] maps = new Map[numOfRegions];
                int i = 0;
                Set rootRegions = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache().rootRegions();
                for (Region region : rootRegions) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_NAME, region.getName());
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_PATH, region.getFullPath() + "/");
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_ENTRYCOUNT, region.entrySet().size());
                    RegionAttributes attributes = region.getAttributes();
                    Scope scope = attributes.getScope();
                    DataPolicy dataPolicy = attributes.getDataPolicy();
                    SubscriptionAttributes subscriptionAttributes = attributes.getSubscriptionAttributes();
                    InterestPolicy interestPolicy = subscriptionAttributes.getInterestPolicy();
                    DiskWriteAttributes diskWriteAttributes = attributes.getDiskWriteAttributes();
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_SCOPE, scope.toString());
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_DATAPOLICY, dataPolicy.toString());
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_INTERESTPOLICY, interestPolicy.toString());
                    map.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_REGION_DISKATTRS, diskWriteAttributes.toString());
                    maps[i] = map;
                    ++i;
                }
                return maps;
            }
        });
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"Returned object is expected to be of type Map[].", (boolean)(regionDetailsMaps instanceof Map[]));
        for (int i = 0; i < regionDetailsMaps.length; ++i) {
            Map regionDetails = regionDetailsMaps[0];
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"regionDetails returned is null.", (Object)regionDetails);
            String nameActual = (String)regionDetails.get(KEY_REGION_NAME);
            String fullPathActual = (String)regionDetails.get(KEY_REGION_PATH);
            int entryCountActual = (Integer)regionDetails.get(KEY_REGION_ENTRYCOUNT);
            String scope = (String)regionDetails.get(KEY_REGION_SCOPE);
            String dataPolicy = (String)regionDetails.get(KEY_REGION_DATAPOLICY);
            String interestPolicy = (String)regionDetails.get(KEY_REGION_INTERESTPOLICY);
            String diskAttrs = (String)regionDetails.get(KEY_REGION_DISKATTRS);
            scope = scope != null ? scope : "";
            dataPolicy = dataPolicy != null ? dataPolicy : "";
            interestPolicy = interestPolicy != null ? interestPolicy : "";
            diskAttrs = diskAttrs != null ? diskAttrs : "";
            Map regionsInfo = (Map)regionsJmx.get(fullPathActual);
            Object regionNameJmx = regionsInfo.get(KEY_REGION_NAME);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region Name is not identical. Actual:" + nameActual + " but Mbean returned:" + regionNameJmx), (boolean)nameActual.equals(regionNameJmx));
            Object regionPathJmx = regionsInfo.get(KEY_REGION_PATH);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region Path is not identical. Actual:" + fullPathActual + " but Mbean returned:" + regionPathJmx), (boolean)fullPathActual.equals(regionPathJmx));
            Number entryCountJmx = (Number)regionsInfo.get(KEY_REGION_ENTRYCOUNT);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region entry count is not identical. Actual:" + entryCountActual + " but Mbean returned:" + entryCountJmx), (entryCountJmx != null && entryCountJmx.intValue() == entryCountActual ? 1 : 0) != 0);
            Object scopeJmx = regionsInfo.get(KEY_REGION_SCOPE);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region Attribute: Scope is not identical. Actual:" + scope + " but Mbean returned:" + scopeJmx), (boolean)scope.equals(scopeJmx));
            Object dataPolicyJmx = regionsInfo.get(KEY_REGION_DATAPOLICY);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region Attribute: Scope is not identical. Actual:" + dataPolicy + " but Mbean returned:" + dataPolicyJmx), (boolean)dataPolicy.equals(dataPolicyJmx));
            Object interestPolicyJmx = regionsInfo.get(KEY_REGION_INTERESTPOLICY);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region Attribute: Interest Policy is not identical. Actual:" + interestPolicy + " but Mbean returned:" + interestPolicyJmx), (boolean)interestPolicy.equals(interestPolicyJmx));
            Object diskAttrsJmx = regionsInfo.get(KEY_REGION_DISKATTRS);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Region Attribute: Disk Attributes is not identical. Actual:" + diskAttrs + " but Mbean returned:" + diskAttrsJmx), (boolean)diskAttrs.equals(diskAttrsJmx));
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyRegionsDetails() ...");
    }

    private boolean isMBeanInitialized(ObjectName wrapper) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.isMBeanInitialized() ...");
        Integer refreshInterval = (Integer)mbsc.getAttribute(wrapper, "RefreshInterval");
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.isMBeanInitialized() ...");
        return adminDS.getConfig().getRefreshInterval() == refreshInterval.intValue();
    }

    private String[] invokeGetMembers(ObjectName wrapper) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.invokeGetMembers() ...");
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        String[] memberIds = (String[])mbsc.invoke(wrapper, "getMembers", params, signature);
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.invokeGetMembers() ...");
        return memberIds;
    }

    private void verifyAttributes(ObjectName wrapper) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyAttributes() ...");
        String id = (String)mbsc.getAttribute(wrapper, "Id");
        String version = (String)mbsc.getAttribute(wrapper, "Version");
        Integer refreshInterval = (Integer)mbsc.getAttribute(wrapper, "RefreshInterval");
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        String actualId = adminDS.getId();
        String actualVersion = GemFireVersion.getGemFireVersion();
        int actualRefreshInterval = adminDS.getConfig().getRefreshInterval();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("AdminDistributedSystem id shown by MemberInfoWithStatsMBean (as: " + id + ") and actual (as: " + actualId + ") do not match."), (boolean)actualId.equals(id));
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("GemFire Version shown by MemberInfoWithStatsMBean (as: " + version + ") and actual(as: " + actualVersion + ") do not match."), (boolean)actualVersion.equals(version));
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Refresh Interval shown by MemberInfoWithStatsMBean (as: " + refreshInterval + ") and actual (as :" + actualRefreshInterval + ") do not match."), (actualRefreshInterval == refreshInterval ? 1 : 0) != 0);
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyAttributes() ...");
    }

    private void verifyGetMembers(String[] ids) throws AdminException {
        int i;
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGetMembers() ...");
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        SystemMember[] appVms = adminDS.getSystemMemberApplications();
        CacheVm[] cacheVms = adminDS.getCacheVms();
        int actualMembers = appVms.length + cacheVms.length;
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("No. of members returned by MemberInfoWithStatsMBean are " + ids.length + " but in actual are " + actualMembers), (ids.length == actualMembers ? 1 : 0) != 0);
        List<String> memberIds = Arrays.asList(ids);
        boolean allIdsValid = true;
        for (i = 0; i < cacheVms.length; ++i) {
            if (memberIds.contains(cacheVms[i].getId())) continue;
            allIdsValid = false;
            break;
        }
        if (allIdsValid) {
            for (i = 0; i < appVms.length; ++i) {
                if (memberIds.contains(appVms[i].getId())) continue;
                allIdsValid = false;
                break;
            }
        }
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"All member ids of existing members do not match with member ids given by GatewayHubMemberInfoWithStatsMBean.", (boolean)allIdsValid);
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGetMembers() ...");
    }

    private Map getDetailsByJMX(ObjectName wrapper, String memberId) throws AdminException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.getMemberDetailsJMX() ...");
        Object[] params = new Object[]{memberId};
        String[] signature = new String[]{String.class.getName()};
        Map memberDetails = (Map)mbsc.invoke(wrapper, "getMemberDetails", params, signature);
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.getMemberDetailsJMX() ...");
        return memberDetails;
    }

    private Map verifyMemberDetails(ObjectName wrapper, String memberId, int hostIndex, int vmIndex) throws Exception {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyMemberDetails(ObjectName,String,int) ...");
        Map mapDirect = this.getMemberDetailsDirect(hostIndex, vmIndex);
        this.waitForAgentAutoRefresh();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(1000);
        Map mapThroughJmx = this.getDetailsByJMX(wrapper, memberId);
        this.compareMemberDetails(mapDirect, mapThroughJmx);
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyMemberDetails(ObjectName,String,int) ...");
        return mapThroughJmx;
    }

    private Map getMemberDetailsDirect(int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.getDirectDetails(int) ...");
        Host host = Host.getHost(hostIndex);
        VM cacheVM = host.getVM(vmIndex);
        Map mapDirect = (Map)cacheVM.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                Cache cache2 = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                HashMap<String, Object> m = new HashMap<String, Object>();
                DistributedSystem ds = cache2.getDistributedSystem();
                InternalDistributedSystem internalDS = (InternalDistributedSystem)ds;
                DistributedMember member = ds.getDistributedMember();
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_ID, member.getId());
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_NAME, ds.getName());
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_HOST, member.getHost());
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_UPTIME, System.currentTimeMillis() - internalDS.getStartTime());
                List gatewayHubs = cache2.getGatewayHubs();
                boolean isGatewayHub = gatewayHubs != null && !gatewayHubs.isEmpty();
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_IS_GATEWAY, isGatewayHub);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_IS_SERVER, cache2.isServer());
                List cacheServers = cache2.getCacheServers();
                int cacheServerPort = 0;
                if (cacheServers != null && !cacheServers.isEmpty()) {
                    cacheServerPort = ((CacheServer)cacheServers.get(0)).getPort();
                }
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_PORT, cacheServerPort);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_STATSAMPLING_ENABLED, internalDS.getConfig().getStatisticSamplingEnabled());
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_TIME_STATS_ENABLED, internalDS.getConfig().getEnableTimeStatistics());
                String memberType = MemberInfoWithStatsMBeanGFEValidationDUnitTest.TYPE_NAME_APPLICATION;
                if (isGatewayHub) {
                    memberType = MemberInfoWithStatsMBeanGFEValidationDUnitTest.TYPE_NAME_GATEWAYHUB;
                } else if (CacheServerLauncher.isDedicatedCacheServer) {
                    memberType = MemberInfoWithStatsMBeanGFEValidationDUnitTest.TYPE_NAME_CACHESERVER;
                }
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_MEMBER_TYPE, memberType);
                StatisticsType vmStatsType = internalDS.findType("VMStats");
                StatisticsType vmMemoryUsageStatsType = internalDS.findType("VMMemoryUsageStats");
                StatisticsType cachePerfStatsType = internalDS.findType("CachePerfStats");
                Statistics[] vmStats = internalDS.findStatisticsByType(vmStatsType);
                Statistics[] vmMemoryUsageStats = internalDS.findStatisticsByType(vmMemoryUsageStatsType);
                Statistics[] cachePerfStats = internalDS.findStatisticsByType(cachePerfStatsType);
                Integer gets = null;
                Long getTime = null;
                Integer puts = null;
                Long putTime = null;
                for (int i = 0; i < cachePerfStats.length; ++i) {
                    if (!cachePerfStats[i].getTextId().equals("cachePerfStats")) continue;
                    Number number = cachePerfStats[i].get("gets");
                    if (number != null) {
                        gets = number.intValue();
                    }
                    if ((number = cachePerfStats[i].get("getTime")) != null) {
                        getTime = number.longValue();
                    }
                    if ((number = cachePerfStats[i].get("puts")) != null) {
                        puts = number.intValue();
                    }
                    if ((number = cachePerfStats[i].get("putTime")) == null) break;
                    putTime = number.longValue();
                    break;
                }
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_GETS, gets);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_PUTS, puts);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_GETTIME, getTime);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_PUTTIME, putTime);
                Long maxMemory = null;
                Long usedMemory = null;
                for (int i = 0; i < vmMemoryUsageStats.length; ++i) {
                    if (!vmMemoryUsageStats[i].getTextId().equals("vmHeapMemoryStats")) continue;
                    Number number = vmMemoryUsageStats[i].get("maxMemory");
                    if (number != null) {
                        maxMemory = number.longValue();
                    }
                    if ((number = vmMemoryUsageStats[i].get("usedMemory")) == null) break;
                    usedMemory = number.longValue();
                    break;
                }
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_MAXMEMORY, maxMemory);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_USEDMEMORY, usedMemory);
                Long processCpuTime = null;
                Integer cpus = null;
                for (int i = 0; i < vmStats.length; ++i) {
                    if (!vmStats[i].getTextId().equals("vmStats")) continue;
                    Number number = vmStats[i].get("processCpuTime");
                    if (number != null) {
                        processCpuTime = number.longValue();
                    }
                    if ((number = vmStats[i].get("cpus")) == null) break;
                    cpus = number.intValue();
                    break;
                }
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_PROCESSCPUTIME, processCpuTime);
                m.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_STATS_CPUS, cpus);
                OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
                if (osBean != null) {
                    Object cpuTime = null;
                    try {
                        Method method = osBean.getClass().getMethod("getProcessCpuTime", new Class[0]);
                        if (method != null) {
                            cpuTime = method.invoke((Object)osBean, new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cpuTime != null) {
                        m.put("gemfire.member.stat.processcputime.longDIRECT", cpuTime);
                    }
                }
                return m;
            }
        });
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.getDirectDetails(int) ...");
        return mapDirect;
    }

    private void compareMemberDetails(Map<?, ?> mapDirect, Map<?, ?> mapThroughJmx) throws Exception {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyMemberDetails(Map, Map) ...");
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"Object returned is null.", mapDirect);
        Object jmxVal = null;
        Object dirVal = null;
        boolean areEqual = false;
        for (int i = 0; i < KEYS_MEMBERS.length; ++i) {
            jmxVal = mapThroughJmx.get(KEYS_MEMBERS[i]);
            dirVal = mapDirect.get(KEYS_MEMBERS[i]);
            boolean isOneNullAndOtherNot = jmxVal != null && dirVal == null || jmxVal == null && dirVal != null;
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertFalse((String)("Member information obtained directly & through JMX is not the same for " + KEYS_MEMBERS[i] + "."), (boolean)isOneNullAndOtherNot);
            areEqual = jmxVal.equals(dirVal);
            if (!areEqual) {
                if (INCREASING_VALUES.contains(KEYS_MEMBERS[i])) {
                    double overJmx = ((Number)jmxVal).doubleValue();
                    double directFromMem = ((Number)dirVal).doubleValue();
                    MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Value obtained through JMX (which is: " + overJmx + ") is expected to be greater than or equal to the value obtained directly (which is: " + directFromMem + ") for: " + KEYS_MEMBERS[i]), (overJmx >= directFromMem ? 1 : 0) != 0);
                    continue;
                }
                if (UNPREDICTABLES.contains(KEYS_MEMBERS[i])) {
                    logWriter.info("Ignorable as this can change with time: Values obtained through JMX (which is: " + jmxVal + ") & directly (which is: " + dirVal + ") are not the same for: " + KEYS_MEMBERS[i]);
                    continue;
                }
            }
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Values obtained through JMX (which is: " + jmxVal + ") & directly (which is: " + dirVal + ") are not the same for: " + KEYS_MEMBERS[i]), (boolean)areEqual);
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyMemberDetails() ...");
    }

    private Map<String, Number> verifyGatewayDetails(Map memberDetailsJMX, int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGatewayDetails() ...");
        HashMap<String, Number> gatewayQueueSizes = new HashMap<String, Number>();
        List gatewaysJmxCol = (List)memberDetailsJMX.get(KEY_GATEWAY_COLLECTION);
        Boolean isGateway = (Boolean)memberDetailsJMX.get(KEY_MEMBER_IS_GATEWAY);
        if (gatewaysJmxCol == null) {
            String memberId = (String)memberDetailsJMX.get(KEY_MEMBER_ID);
            logWriter.info("No gateway information available for: " + memberId);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertFalse((String)(memberId + " is a GatewayHub but does not have Gateway details."), (boolean)isGateway);
            return null;
        }
        Host host = Host.getHost(hostIndex);
        VM gatewayHubVM = host.getVM(vmIndex);
        Map hubDetails = (Map)gatewayHubVM.invoke(new SerializableCallable("MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGatewayDetails()"){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                HashMap<String, Object> details = new HashMap<String, Object>();
                List gatewayHubs = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub gatewayHub = (GatewayHub)gatewayHubs.get(0);
                details.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYHUB_ID, gatewayHub.getId());
                details.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYHUB_LISTENINGPORT, gatewayHub.getPort());
                details.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYHUB_ISPRIMARY, gatewayHub.isPrimary());
                List gateways = gatewayHub.getGateways();
                ArrayList gatewayDetailsCollected = new ArrayList();
                for (Gateway gateway : gateways) {
                    HashMap<String, Object> gatewayDetails = new HashMap<String, Object>();
                    gatewayDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAY_ISCONNECTED, gateway.isConnected());
                    gatewayDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAY_QUEUESIZE, gateway.getQueueSize());
                    gatewayDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAY_ID, gateway.getId());
                    List endpoints = gateway.getEndpoints();
                    ArrayList endpointDetailsCollected = new ArrayList();
                    for (Gateway.Endpoint endpoint : endpoints) {
                        HashMap<String, Object> endpointDetails = new HashMap<String, Object>();
                        endpointDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYENDPOINT_ID, endpoint.getId());
                        endpointDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYENDPOINT_HOST, endpoint.getHost());
                        endpointDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYENDPOINT_PORT, endpoint.getPort());
                        endpointDetailsCollected.add(endpointDetails);
                    }
                    gatewayDetails.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAYENDPOINTS_COLLECTION, endpointDetailsCollected);
                    gatewayDetailsCollected.add(gatewayDetails);
                }
                details.put(MemberInfoWithStatsMBeanGFEValidationDUnitTest.KEY_GATEWAY_COLLECTION, gatewayDetailsCollected);
                return details;
            }
        });
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"Object returned is null.", (Object)hubDetails);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"GatewayHub info through MemberInfoWithStatsMBean is null.", (Object)gatewaysJmxCol);
        String hubIdJmx = (String)memberDetailsJMX.get(KEY_GATEWAYHUB_ID);
        Boolean hubIsPrimaryJmx = (Boolean)memberDetailsJMX.get(KEY_GATEWAYHUB_ISPRIMARY);
        Number listeningPortJmx = (Number)memberDetailsJMX.get(KEY_GATEWAYHUB_LISTENINGPORT);
        String hubIdActual = (String)hubDetails.get(KEY_GATEWAYHUB_ID);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Gateway Hub Id is not identical. Actual:" + hubIdActual + " but Mbean returned:" + hubIdJmx), (boolean)hubIdActual.equals(hubIdJmx));
        Boolean isPrimaryActual = (Boolean)hubDetails.get(KEY_GATEWAYHUB_ISPRIMARY);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Gateway Hub 'isPrimary' property is not same. Actual:" + isPrimaryActual + " but Mbean returned:" + hubIsPrimaryJmx), (boolean)isPrimaryActual.equals(hubIsPrimaryJmx));
        Integer listeningPortActual = (Integer)hubDetails.get(KEY_GATEWAYHUB_LISTENINGPORT);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Gateway Hub listening port is not identical. Actual:" + listeningPortActual + " but Mbean returned:" + listeningPortJmx), (boolean)listeningPortActual.equals(listeningPortJmx));
        List gatewaysDirectCol = (List)hubDetails.get(KEY_GATEWAY_COLLECTION);
        for (int i = 0; i < gatewaysJmxCol.size(); ++i) {
            Map gatewaysJmx = (Map)gatewaysJmxCol.get(i);
            Map gatewaysDirect = (Map)gatewaysDirectCol.get(i);
            Set entrySetJmx = gatewaysJmx.entrySet();
            Set entrySetDirect = gatewaysDirect.entrySet();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Gateway details do not match. Details retrieved thro JMX as: \n" + gatewaysJmx + " \n and directly as: \n" + gatewaysDirect), (boolean)entrySetJmx.equals(entrySetDirect));
            this.verifyGatewayEndpointsDetails((List)gatewaysJmx.get(KEY_GATEWAYENDPOINTS_COLLECTION), (List)gatewaysDirect.get(KEY_GATEWAYENDPOINTS_COLLECTION));
            gatewayQueueSizes.put((String)gatewaysJmx.get(KEY_GATEWAY_ID), (Number)gatewaysJmx.get(KEY_GATEWAY_QUEUESIZE));
        }
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGatewayDetails() ...");
        return gatewayQueueSizes;
    }

    private void doWANRegionPuts(final String keyPrefix, final int total, int hostIndex, int hubVmIndex) {
        Host host = Host.getHost(hostIndex);
        VM gatewayHubVM = host.getVM(hubVmIndex);
        int unitSize = 1000;
        gatewayHubVM.invokeAsync(new CacheSerializableRunnable("WAN region puts"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Region region = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache().getRegion("/MemberInfoWithStatsMBeanGFEValidationDUnitTest_WAN_Root");
                DistributedTestCase.pause(11625);
                for (int i = 0; i < total; ++i) {
                    byte[] arr = new byte[1000];
                    region.put((Object)(keyPrefix + "-" + i), (Object)arr);
                }
            }
        });
    }

    private void doClientLocalInvalidateGetsPuts(final String keyPrefix, final int totalToInvalidateAndGet, int hostIndex, int hubVmIndex) {
        Host host = Host.getHost(hostIndex);
        VM clientVM = host.getVM(hubVmIndex);
        clientVM.invoke(new CacheSerializableRunnable("Do localInvalidate, gets & puts"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() {
                int i;
                Region region = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache().getRegion("/MemberInfoWithStatsMBeanGFEValidationDUnitTest_DS_Root");
                for (i = 0; i < totalToInvalidateAndGet; ++i) {
                    if (!region.containsKey((Object)(keyPrefix + "-" + i))) continue;
                    region.localInvalidate((Object)(keyPrefix + "-" + i));
                }
                for (i = 0; i < totalToInvalidateAndGet; ++i) {
                    region.get((Object)(keyPrefix + "-" + i));
                }
                for (i = 0; i < totalToInvalidateAndGet / 10; ++i) {
                    byte[] arr = new byte[100];
                    region.put((Object)(keyPrefix + "-" + i), (Object)arr);
                }
            }
        });
    }

    private void doSetSlowStart(int hostIndex, int vmIndex, final int slowStartTime) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        vm.invoke(new CacheSerializableRunnable("doSetlowStart ..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                CacheClientProxy.isSlowStartForTesting = true;
                earlierSlowStartTime = System.setProperty("slowStartTimeForTesting", String.valueOf(slowStartTime));
            }
        });
    }

    private void doUnsetSlowStart(int hostIndex, int vmIndex) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        vm.invoke(new CacheSerializableRunnable("doSetlowStart ..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                CacheClientProxy.isSlowStartForTesting = false;
                earlierSlowStartTime = earlierSlowStartTime != null ? earlierSlowStartTime : "5000";
                System.setProperty("slowStartTimeForTesting", earlierSlowStartTime);
            }
        });
    }

    private void verifyGatewayEndpointsDetails(List<Map> endpointsJMX, List<Map> endpointsDirect) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGatewayEndpointsDetails() ...");
        boolean isOneNullAndOtherNot = endpointsJMX != null && endpointsDirect == null || endpointsJMX == null && endpointsDirect != null;
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertFalse((String)"Gateway endpoints information obtained directly & through JMX is not the same.", (boolean)isOneNullAndOtherNot);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertFalse((String)"Gateway does not have Endpoint details.", (endpointsJMX == null ? 1 : 0) != 0);
        for (int i = 0; i < endpointsJMX.size(); ++i) {
            Map map1 = endpointsJMX.get(i);
            Map map2 = endpointsDirect.get(i);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Gateway endpoint information at index: " + i + " obtained " + "directly & through JMX is not the same."), (boolean)map1.entrySet().equals(map2.entrySet()));
        }
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyGatewayEndpointsDetails() ...");
    }

    private void verifyClientQueueSize(Map memberDetailsJMX, int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientQueueSize() ...");
        Map clientsJmx = (Map)memberDetailsJMX.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("MemberInfoWithStatsMBean returned map of clients information has size: " + clientsJmx.size() + ", but expected is 1."), (clientsJmx.size() == 1 ? 1 : 0) != 0);
        Map clientJmx = new HashMap();
        Iterator iterator = clientsJmx.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            clientJmx = (Map)entry.getValue();
        }
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"MemberInfoWithStatsMBean returned map of clients information was null.", clientJmx);
        GemFireMemberStatus status = this.getGFMemberStatus(hostIndex, vmIndex);
        int clientQueueSize = (Integer)clientJmx.get(KEY_CLIENT_QUEUESIZE);
        String clientIdJmx = (String)clientJmx.get(KEY_CLIENT_ID);
        Set connectedClients = status.getConnectedClients();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertEquals((String)("No. of clients connected are expected to be 1 but in actual there are:" + connectedClients.size()), (int)connectedClients.size(), (int)1);
        for (String clientIdActual : connectedClients) {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client ids are not identical. Actual:" + clientIdActual + " but Mbean returned:" + clientIdJmx), (clientIdActual != null && clientIdJmx != null && clientIdActual.equals(clientIdJmx) ? 1 : 0) != 0);
            int clientQueueSizeActual = status.getClientQueueSize(clientIdActual);
            boolean areEqualNonZero = clientQueueSize == clientQueueSizeActual && clientQueueSize != 0;
            areEqualNonZero = areEqualNonZero || clientQueueSize != 0 && clientQueueSizeActual != 0;
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Queuesize values are not as expected - should be non-zero. Actual:" + clientQueueSizeActual + " but Mbean returned:" + clientQueueSize), (boolean)areEqualNonZero);
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientQueueSize() ...");
    }

    private int verifyClientMisses(Map memberDetailsJMX, int hostIndex, int vmIndex, boolean nonZeroCheck) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientQueueSize() ...");
        Map clientsJmx = (Map)memberDetailsJMX.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("MemberInfoWithStatsMBean returned map of clients information has size: " + clientsJmx.size() + ", but expected is 1."), (clientsJmx.size() == 1 ? 1 : 0) != 0);
        Map clientJmx = new HashMap();
        Iterator iterator = clientsJmx.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            clientJmx = (Map)entry.getValue();
        }
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"MemberInfoWithStatsMBean returned map of clients information was null.", clientJmx);
        GemFireMemberStatus status = this.getGFMemberStatus(hostIndex, vmIndex);
        int clientCacheMisses = (Integer)clientJmx.get(KEY_CLIENT_STATS_CACHEMISSES);
        String clientIdJmx = (String)clientJmx.get(KEY_CLIENT_ID);
        Set connectedClients = status.getConnectedClients();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertEquals((String)("No. of clients connected are expected to be 1 but in actual there are:" + connectedClients.size()), (int)connectedClients.size(), (int)1);
        for (String clientIdActual : connectedClients) {
            boolean areEqualNonZero;
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client ids are not identical. Actual:" + clientIdActual + " but Mbean returned:" + clientIdJmx), (clientIdActual != null && clientIdJmx != null && clientIdActual.equals(clientIdJmx) ? 1 : 0) != 0);
            int clientCacheMissesActual = ((ClientHealthStats)status.getClientHealthStats(clientIdActual)).getNumOfMisses();
            boolean bl = areEqualNonZero = clientCacheMisses == clientCacheMissesActual;
            if (nonZeroCheck) {
                areEqualNonZero = areEqualNonZero && clientCacheMisses != 0;
            }
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Cache Misses are not identical. Actual:" + clientCacheMissesActual + " but Mbean returned:" + clientCacheMisses), (boolean)areEqualNonZero);
        }
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientQueueSize() ...");
        return clientCacheMisses;
    }

    private GemFireMemberStatus getGFMemberStatus(int hostIndex, int vmIndex) {
        Host host = Host.getHost(hostIndex);
        VM cacheVM = host.getVM(vmIndex);
        Object result = cacheVM.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                return new GemFireMemberStatus(MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache());
            }
        });
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"Object returned was null.", (Object)result);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)"Object returned is not a GemFireMemberStatus.", (boolean)(result instanceof GemFireMemberStatus));
        return (GemFireMemberStatus)result;
    }

    private long[] verifyClientStatsVariation(Map memberDetailsJMX, int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientQueueSize() ...");
        Map clientsJmx = (Map)memberDetailsJMX.get(KEY_CLIENTS_MAP);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("MemberInfoWithStatsMBean returned map of clients information has size: " + clientsJmx.size() + ", but expected is 1."), (clientsJmx.size() == 1 ? 1 : 0) != 0);
        Map clientJmx = new HashMap();
        Iterator iterator = clientsJmx.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            clientJmx = (Map)entry.getValue();
        }
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((String)"MemberInfoWithStatsMBean returned map of clients information was null.", clientJmx);
        GemFireMemberStatus status = this.getGFMemberStatus(hostIndex, vmIndex);
        int clientCacheGets = (Integer)clientJmx.get(KEY_CLIENT_STATS_GETS);
        int clientCachePuts = (Integer)clientJmx.get(KEY_CLIENT_STATS_PUTS);
        long clientProcessCpuTime = (Long)clientJmx.get(KEY_CLIENT_STATS_CPUUSAGE);
        String clientIdJmx = (String)clientJmx.get(KEY_CLIENT_ID);
        Set connectedClients = status.getConnectedClients();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertEquals((String)("No. of clients connected are expected to be 1 but in actual there are:" + connectedClients.size()), (int)connectedClients.size(), (int)1);
        for (String clientIdActual : connectedClients) {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client ids are not identical. Actual:" + clientIdActual + " but Mbean returned:" + clientIdJmx), (clientIdActual != null && clientIdJmx != null && clientIdActual.equals(clientIdJmx) ? 1 : 0) != 0);
            int clientCacheGetsActual = ((ClientHealthStats)status.getClientHealthStats(clientIdActual)).getNumOfGets();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Cache Gets are not identical. Actual:" + clientCacheGetsActual + " but Mbean returned:" + clientCacheGets), (clientCacheGets == clientCacheGetsActual ? 1 : 0) != 0);
            int clientCachePutsActual = ((ClientHealthStats)status.getClientHealthStats(clientIdActual)).getNumOfPuts();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client Cache Puts are not identical. Actual:" + clientCachePutsActual + " but Mbean returned:" + clientCachePuts), (clientCachePuts == clientCachePutsActual ? 1 : 0) != 0);
            long clientProcessCpuTimeActual = ((ClientHealthStats)status.getClientHealthStats(clientIdActual)).getProcessCpuTime();
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Client CPU Usage Statistics are not as expected - (obtained directly from server) should be >= (obtained from JMX earlier). Actual:" + clientProcessCpuTimeActual + " but Mbean returned:" + clientProcessCpuTime), (clientProcessCpuTimeActual >= clientProcessCpuTime ? 1 : 0) != 0);
        }
        logWriter.fine("Exiting MemberInfoWithStatsMBeanGFEValidationDUnitTest.verifyClientQueueSize() ...");
        return new long[]{clientCacheGets, clientCachePuts, clientProcessCpuTime};
    }

    private void verifyEntriesAndMemoryVariation(CachedMemberData data, ObjectName wrapper, String memberId) throws Exception {
        Map mapThroughJmx = this.getDetailsByJMX(wrapper, memberId);
        long newValMax = ((Number)mapThroughJmx.get(KEY_STATS_MAXMEMORY)).longValue();
        long newValUsed = ((Number)mapThroughJmx.get(KEY_STATS_USEDMEMORY)).longValue();
        long newUptime = ((Number)mapThroughJmx.get(KEY_MEMBER_UPTIME)).longValue();
        Map regionsMap = (Map)mapThroughJmx.get(KEY_REGIONS_MAP);
        Set entrySet = regionsMap.entrySet();
        int totalEntryCount = 0;
        for (Map.Entry entry : entrySet) {
            Map regionDetails = (Map)entry.getValue();
            Number regionEntryCount = (Number)regionDetails.get(KEY_REGION_ENTRYCOUNT);
            totalEntryCount += regionEntryCount.intValue();
        }
        logWriter.info("CachedMemberData :: " + data + " and new is :: " + newValUsed + "/" + newValMax + ", entryCount=" + totalEntryCount + ", uptime=" + newUptime);
        if (data.maxMem == Long.MIN_VALUE) {
            data.maxMem = newValMax;
        }
        if (data.usedMem == Long.MIN_VALUE) {
            data.usedMem = newValUsed;
        } else {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("UsedMemory: Old val (" + data.usedMem + ") is expected to be different than new val(" + newValUsed + ")."), (data.usedMem != newValUsed ? 1 : 0) != 0);
            data.usedMem = newValUsed;
        }
        if (data.entryCount == Integer.MIN_VALUE) {
            data.entryCount = totalEntryCount;
        } else {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("EntryCount: Old val (" + data.entryCount + ") is expected to be different than new val(" + totalEntryCount + ")."), (data.entryCount != totalEntryCount ? 1 : 0) != 0);
            data.entryCount = totalEntryCount;
        }
        if (data.uptime == Long.MIN_VALUE) {
            data.uptime = newUptime;
        } else {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertTrue((String)("Uptime: Old val (" + data.uptime + ") is expected less than new val(" + newUptime + ")."), (data.uptime < newUptime ? 1 : 0) != 0);
            data.uptime = newUptime;
        }
    }

    private void setUpSystems(int[] freeUDPPorts) throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.vmsDS0 = new VM[]{vm0, vm1};
        this.vmsDS1 = new VM[]{vm2, vm3};
        String hostName = MemberInfoWithStatsMBeanGFEValidationDUnitTest.getServerHostName(host);
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int dsPortDS0 = freeUDPPorts[0];
        int dsPortDS1 = freeUDPPorts[1];
        int hubPortDS0 = freeTCPPorts[0];
        int hubPortDS1 = freeTCPPorts[1];
        this.setUpDS("ds0", dsPortDS0, this.vmsDS0, hubPortDS0, "ds1", hostName, hubPortDS1);
        this.setUpDS("ds1", dsPortDS1, this.vmsDS1, hubPortDS1, "ds0", hostName, hubPortDS0);
    }

    private void setUpDS(final String dsName, final int dsPort, VM[] vms, final int hubPortLocal, final String dsNameRemote, final String hostNameRemote, final int hubPortRemote) throws Exception {
        final Properties propsDS = new Properties();
        propsDS.setProperty("mcast-port", String.valueOf(dsPort));
        propsDS.setProperty("locators", "");
        int i = 0;
        while (i < vms.length) {
            final int whichvm = i++;
            VM vm = vms[whichvm];
            vm.invoke(new CacheSerializableRunnable("Set up " + dsName){
                private static final long serialVersionUID = 1L;

                @Override
                public void run2() throws CacheException {
                    String vmName = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_" + dsName + "_vm" + whichvm;
                    propsDS.setProperty("name", vmName);
                    MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getSystem(propsDS);
                    DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanGFEValidationDUnitTest] " + vmName + " has joined " + dsName + " with port " + String.valueOf(dsPort));
                    Cache cache = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    factory.setEnableGateway(true);
                    RegionFactory regionFactory = cache.createRegionFactory(factory.create());
                    regionFactory.create(MemberInfoWithStatsMBeanGFEValidationDUnitTest.WAN_REGION_NAME);
                    factory.setEnableGateway(false);
                    regionFactory = cache.createRegionFactory(factory.create());
                    regionFactory.create(MemberInfoWithStatsMBeanGFEValidationDUnitTest.DS_REGION1_NAME);
                    DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanGFEValidationDUnitTest] " + vmName + " has created both regions");
                }
            });
        }
        final int whichvm = vms.length - 1;
        VM vm = vms[whichvm];
        vm.invoke(new CacheSerializableRunnable("Set up gateway in " + dsName){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                String vmName = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_" + dsName + "_vm" + whichvm;
                String hubName = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_" + dsName;
                String gatewayName = "MemberInfoWithStatsMBeanGFEValidationDUnitTest_" + dsNameRemote;
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanGFEValidationDUnitTest] " + vmName + " is creating " + hubName + " with gateway to " + gatewayName);
                Cache cache = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                GatewayHub hub = cache.addGatewayHub(hubName, hubPortLocal);
                Gateway gateway = hub.addGateway(gatewayName);
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanGFEValidationDUnitTest] " + vmName + " adding endpoint [" + gatewayName + ", " + hostNameRemote + ", " + hubPortRemote + "] to " + gatewayName);
                gateway.addEndpoint(gatewayName, hostNameRemote, hubPortRemote);
                File d = new File(gatewayName + "_overflow_" + ProcessMgr.getProcessId());
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanGFEValidationDUnitTest] " + vmName + " creating queue in " + d + " for " + gatewayName);
                GatewayQueueAttributes queueAttributes = new GatewayQueueAttributes(d.toString(), 100, 500, 20000, false, false, 0);
                queueAttributes.setEnablePersistence(true);
                queueAttributes.setDiskStoreName(MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getUniqueName());
                File overflowDirectory = new File("overflow_dir_" + dsName + "_vm_" + whichvm);
                overflowDirectory.mkdir();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File[] dirs1 = new File[]{overflowDirectory};
                dsf.setDiskDirs(dirs1).create(MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getUniqueName());
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hubName + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hubName + " threw " + e, e);
                }
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanGFEValidationDUnitTest] " + vmName + " has created " + hubName + " with gateway to " + gatewayName);
            }
        });
    }

    public static void destroyWanQueues() {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            for (GatewayHub hub : cache.getGatewayHubs()) {
                for (Gateway gateway : hub.getGateways()) {
                    String rq = new StringBuffer(gateway.getGatewayHubId()).append('_').append(gateway.getId()).append("_EVENT_QUEUE").toString();
                    Region wbcl = cache.getRegion(rq);
                    if (wbcl == null) continue;
                    wbcl.localDestroyRegion();
                }
            }
            Set rootRegions = cache.rootRegions();
            if (rootRegions != null) {
                for (Region region : rootRegions) {
                    region.clear();
                }
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void setUpForGatewayTest() throws Exception {
        this.setUpSystems(this.freeUDPPorts);
    }

    private void tearDownForGatewayTest() {
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.destroyWanQueues();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(MemberInfoWithStatsMBeanGFEValidationDUnitTest.class, "destroyWanQueues");
            }
        }
    }

    private void startCache(final int serverPort, int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.startCache");
        Host host = Host.getHost(hostIndex);
        VM cacheVM = host.getVM(vmIndex);
        final Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getDistributedSystemProperties());
        props.put("name", "MemberInfoWithStatsMBeanGFEValidationDUnitTest_vm0");
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-startCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getSystem(props);
                Cache cacheInstance = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                RegionAttributes attrs = factory.create();
                RegionFactory regionFactory = cacheInstance.createRegionFactory(attrs);
                regionFactory.create(MemberInfoWithStatsMBeanGFEValidationDUnitTest.DS_REGION1_NAME);
                CacheServer server = cacheInstance.addCacheServer();
                server.setPort(serverPort);
                try {
                    server.start();
                }
                catch (IOException e) {
                    throw new CacheException("Exception occurred while starting server.", e){
                        private static final long serialVersionUID = 1L;
                    };
                }
                logWriter.info("MemberInfoWithStatsMBeanGFEValidationDUnitTest.startCache :: Created cache & started server in cacheVM(VM#0) at port:" + serverPort);
            }
        });
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.startCache");
    }

    private void addRegion(final String regionName, final String keyPrefix, final int total, int hostIndex, int vmIndex) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        vm.invoke(new CacheSerializableRunnable("Adding region ..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cacheInstance = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                RegionAttributes attrs = factory.create();
                RegionFactory regionFactory = cacheInstance.createRegionFactory(attrs);
                Region region = regionFactory.create(regionName);
                for (int i = 0; i < total; ++i) {
                    byte[] arr = new byte[100];
                    region.put((Object)(keyPrefix + "-" + i), (Object)arr);
                }
            }
        });
    }

    private void deleteRegion(final String regionName, int hostIndex, int vmIndex) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        vm.invoke(new CacheSerializableRunnable("Removing region ..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cacheInstance = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                Region region = cacheInstance.getRegion("/" + regionName);
                region.destroyRegion();
            }
        });
    }

    private void doPuts(final String keyPrefix, final int total, int hostIndex, int vmIndex) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        int unitSize = 2000;
        vm.invoke(new CacheSerializableRunnable("Doing puts ..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cache2 = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                Region region = cache2.getRegion("/MemberInfoWithStatsMBeanGFEValidationDUnitTest_DS_Root");
                for (int i = 0; i < total; ++i) {
                    Byte[] arr = new Byte[2000];
                    region.put((Object)(keyPrefix + "-" + i), (Object)arr);
                }
                DistributedTestCase.pause(1100);
            }
        });
    }

    private void doGetsPutsToUpdateStats(final String keyPrefix, final int total, int hostIndex, int vmIndex, final boolean doGets, final boolean doPuts) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        if (doGets || doPuts) {
            vm.invoke(new CacheSerializableRunnable("Doing GetsPutsToUpdateStats ..."){
                private static final long serialVersionUID = 1L;

                @Override
                public void run2() throws CacheException {
                    Cache cache2 = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                    Region region = cache2.getRegion("/MemberInfoWithStatsMBeanGFEValidationDUnitTest_DS_Root");
                    if (doGets) {
                        for (int i = 0; i < total; ++i) {
                            region.get((Object)(keyPrefix + "-" + i));
                        }
                    }
                    if (doPuts) {
                        int unitSize = 2000;
                        for (int i = 0; i < total; ++i) {
                            Byte[] arr = new Byte[unitSize];
                            region.put((Object)(keyPrefix + "-" + i), (Object)arr);
                        }
                    }
                    DistributedTestCase.pause(1100);
                }
            });
        }
    }

    private void doDeletes(final String keyPrefix, final int total, int hostIndex, int vmIndex) {
        Host h = Host.getHost(hostIndex);
        VM vm = h.getVM(vmIndex);
        vm.invoke(new CacheSerializableRunnable("Doing deletes ..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Cache cache2 = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                Region region = cache2.getRegion("/MemberInfoWithStatsMBeanGFEValidationDUnitTest_DS_Root");
                for (int i = 0; i < total; ++i) {
                    region.remove((Object)(keyPrefix + "-" + i));
                }
                DistributedTestCase.pause(1100);
            }
        });
    }

    private void stopCache(int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.stopCache");
        Host host = Host.getHost(hostIndex);
        VM cacheVM = host.getVM(vmIndex);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-stopCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Set rootRegions = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache().rootRegions();
                if (rootRegions != null) {
                    for (Region region : rootRegions) {
                        region.clear();
                    }
                }
                CacheTestCase.disconnectFromDS();
            }
        });
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.stopCache");
    }

    private void connectClient(final int serverPort, int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.connectClient");
        final Host host = Host.getHost(hostIndex);
        VM clientVM = host.getVM(vmIndex);
        clientVM.invoke(new CacheSerializableRunnable(this.getName() + "-connectClient"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.createLonerCache();
                Cache cacheInstance = MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache();
                PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
                pf.addServer(host.getHostName(), serverPort);
                pf.setSubscriptionEnabled(true);
                pf.setReadTimeout(10000);
                pf.setSubscriptionRedundancy(0);
                pf.setStatisticInterval(5000);
                PoolImpl p = (PoolImpl)pf.create("MemberInfoWithStatsMBeanGFEValidationDUnitTest");
                AttributesFactory factory = new AttributesFactory();
                factory.setPoolName(p.getName());
                factory.setScope(Scope.LOCAL);
                RegionAttributes attrs = factory.create();
                RegionFactory regionFactory = cacheInstance.createRegionFactory(attrs);
                Region region = regionFactory.create(MemberInfoWithStatsMBeanGFEValidationDUnitTest.DS_REGION1_NAME);
                TestCase.assertNotNull((String)"Region in cache is null.", (Object)region);
                clientConn = p.acquireConnection();
                TestCase.assertNotNull((String)"Acquired client connecttion is null.", (Object)clientConn);
                region.registerInterest((Object)"ALL_KEYS");
            }
        });
        logWriter.info("MemberInfoWithStatsMBeanGFEValidationDUnitTest.connectClient :: Started client in clientVM(VM#2) & connected to cacheVM(VM#2).");
    }

    private void disConnectClient(int hostIndex, int vmIndex) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanGFEValidationDUnitTest.stopCache");
        Host host = Host.getHost(hostIndex);
        VM clientVM = host.getVM(vmIndex);
        clientVM.invoke(new CacheSerializableRunnable(this.getName() + "-disConnectClient"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                MemberInfoWithStatsMBeanGFEValidationDUnitTest.this.getCache().close();
                CacheTestCase.disconnectFromDS();
                clientConn.destroy();
            }
        });
        logWriter.fine("Exited MemberInfoWithStatsMBeanGFEValidationDUnitTest.stopCache");
    }

    @Override
    public Properties getDistributedSystemProperties() {
        return props;
    }

    public static void initDSProperties(int mcastPort) {
        props.clear();
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        props.setProperty("locators", "");
    }

    @Override
    public void setUp() throws Exception {
        boolean failedSetUp = true;
        try {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.disconnectAllFromDS();
            this.freeUDPPorts = AvailablePortHelper.getRandomAvailableUDPPorts(2);
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.initDSProperties(this.freeUDPPorts[0]);
            super.setUp();
            failedSetUp = false;
        }
        catch (Exception e) {
            if (failedSetUp) {
                MemberInfoWithStatsMBeanGFEValidationDUnitTest.disconnectAllFromDS();
            }
            e.printStackTrace();
        }
        mbsc = this.agent.getMBeanServer();
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((Object)mbsc);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        distributedSystem = (ObjectName)mbsc.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.assertNotNull((Object)distributedSystem);
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.initIgnorableProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            if (this.shouldDoGatewayHubCleanup) {
                this.tearDownForGatewayTest();
            }
        }
        finally {
            MemberInfoWithStatsMBeanGFEValidationDUnitTest.disconnectAllFromDS();
        }
    }

    void waitForAgentAutoRefresh() {
        MemberInfoWithStatsMBeanGFEValidationDUnitTest.pause(15500);
    }

    static {
        UNPREDICTABLES = new HashSet<String>();
        INCREASING_VALUES = new HashSet<String>();
        props = new Properties();
    }

    static class CachedMemberData {
        long usedMem = Long.MIN_VALUE;
        long maxMem = Long.MIN_VALUE;
        int entryCount = Integer.MIN_VALUE;
        long uptime = Long.MIN_VALUE;

        CachedMemberData() {
        }

        public String toString() {
            return this.usedMem + "/" + this.maxMem + ", entryCount=" + this.entryCount + ", uptime=" + this.uptime;
        }
    }
}

