/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.memberstatus;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberBridgeServer;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheImpl;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class GemFireMemberStatusDUnitTest
extends AdminDUnitTestCase {
    public static final int MEM_VM = 0;
    protected SystemMemberCache cache;
    private Set initedVMs = new LinkedHashSet();

    public GemFireMemberStatusDUnitTest(String name) {
        super(name);
    }

    protected VM getMemberVM() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    public void testStatusSerialization() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberStatusDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                GemFireMemberStatusDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberStatusDUnitTest.pause(2000);
        GemFireMemberStatusDUnitTest.getLogWriter().info("Test: Created DS");
        AdminDistributedSystem system = this.tcSystem;
        SystemMember[] members = system.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            GemFireMemberStatusDUnitTest.fail((String)sb.toString());
        }
        GemFireMemberStatusDUnitTest.getLogWriter().info("Test: Created Member");
        this.cache = members[0].getCache();
        GemFireMemberStatusDUnitTest.assertNull((Object)this.cache);
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)GemFireMemberStatusDUnitTest.this.getSystem());
            }
        });
        GemFireMemberStatusDUnitTest.getLogWriter().info("Test: Created Cache");
        this.cache = members[0].getCache();
        GemFireMemberStatusDUnitTest.assertNotNull((Object)this.cache);
        GemFireMemberStatus status = ((SystemMemberCacheImpl)this.cache).getSnapshot();
        GemFireMemberStatusDUnitTest.assertNotNull((Object)status);
        GemFireMemberStatusDUnitTest.assertFalse((boolean)status.getIsServer());
    }

    public void testStatusSerializationForServerAndPeer() throws Exception {
        final String testName = this.getName();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberStatusDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName + 0);
                GemFireMemberStatusDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberStatusDUnitTest.pause(2000);
        VM vm2 = host.getVM(1);
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberStatusDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName + 1);
                GemFireMemberStatusDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberStatusDUnitTest.pause(2000);
        GemFireMemberStatusDUnitTest.getLogWriter().info("Test: Created DS in both VMs");
        AdminDistributedSystem system = this.tcSystem;
        SystemMember[] members = system.getSystemMemberApplications();
        if (members.length != 2) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 2 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            GemFireMemberStatusDUnitTest.fail((String)sb.toString());
        }
        GemFireMemberStatusDUnitTest.getLogWriter().info("Test: Created Members");
        SystemMemberCache cache1 = members[0].getCache();
        GemFireMemberStatusDUnitTest.assertNull((Object)cache1);
        SystemMemberCache cache2 = members[1].getCache();
        GemFireMemberStatusDUnitTest.assertNull((Object)cache2);
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)GemFireMemberStatusDUnitTest.this.getSystem());
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)GemFireMemberStatusDUnitTest.this.getSystem());
            }
        });
        GemFireMemberStatusDUnitTest.getLogWriter().info("Test: Created Caches");
        cache1 = members[0].getCache();
        GemFireMemberStatusDUnitTest.assertNotNull((Object)cache1);
        cache2 = members[1].getCache();
        GemFireMemberStatusDUnitTest.assertNotNull((Object)cache2);
        SystemMemberBridgeServer bridge = cache2.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        bridge.setPort(port);
        bridge.start();
        GemFireMemberStatusDUnitTest.assertEquals((int)port, (int)bridge.getPort());
        GemFireMemberStatus status = ((SystemMemberCacheImpl)cache2).getSnapshot();
        GemFireMemberStatusDUnitTest.assertNotNull((Object)status);
        GemFireMemberStatusDUnitTest.assertTrue((boolean)status.getIsServer());
        GemFireMemberStatusDUnitTest.assertTrue((status.getConnectedPeers().size() == 1 ? 1 : 0) != 0);
    }

    public void testInit() throws Exception {
        String testName = this.getName();
        this.initSystem(testName);
        this.initCache(testName);
        this.checkGFMemberStatus();
    }

    protected void initSystem(String testName) {
        SerializableRunnable runnable = new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberStatusDUnitTest.this.getDistributedSystemProperties();
                Object object = props.get("name");
                if (object == null) {
                    GemFireMemberStatusDUnitTest.this.getSystem(props);
                } else {
                    GemFireMemberStatusDUnitTest.this.getSystem();
                }
            }
        };
        int hostCount = Host.getHostCount();
        for (int i = 0; i < hostCount; ++i) {
            int j;
            Host host = Host.getHost(i);
            int noOfVMs = host.getVMCount();
            for (j = 0; j < noOfVMs; ++j) {
                VM vm = host.getVM(j);
                vm.invoke(runnable);
                this.initedVMs.add(vm);
            }
            GemFireMemberStatusDUnitTest.getLogWriter().info(j + " VMs initalized for host# " + i);
        }
    }

    private void initCache(String testName) throws AdminException {
        SystemMemberCache cache;
        SystemMember member;
        AdminDistributedSystem ads = this.tcSystem;
        SystemMember[] applnMembers = ads.getSystemMemberApplications();
        for (int i = 0; i < applnMembers.length; ++i) {
            member = applnMembers[i];
            cache = member.getCache();
            GemFireMemberStatusDUnitTest.assertNull((String)("Cache already created for member:" + member.getId()), (Object)cache);
        }
        for (VM vm : this.initedVMs) {
            vm.invoke(new CacheSerializableRunnable(testName){

                @Override
                public void run2() {
                    CacheFactory.create((DistributedSystem)GemFireMemberStatusDUnitTest.this.getSystem());
                }
            });
        }
        for (int i = 0; i < applnMembers.length; ++i) {
            member = applnMembers[i];
            cache = member.getCache();
            GemFireMemberStatusDUnitTest.assertNotNull((String)("Cache not created yet for member: " + member.getId()), (Object)cache);
        }
    }

    private void checkGFMemberStatus() throws AdminException, InterruptedException {
        int serverIndex = this.startBridgeServer();
        int serverCount = this.checkActiveBridgeServerCount();
        GemFireMemberStatusDUnitTest.assertEquals((String)"No. of actual servers are not same as expected.", (int)1, (int)serverCount);
        this.stopBridgeServer(serverIndex);
        GemFireMemberStatusDUnitTest.pause(6000);
        serverCount = this.checkActiveBridgeServerCount();
        GemFireMemberStatusDUnitTest.assertEquals((String)"No. of actual servers are not same as expected.", (int)1, (int)serverCount);
    }

    private int startBridgeServer() throws AdminException, InterruptedException {
        AdminDistributedSystem ads = this.tcSystem;
        SystemMember[] applnMembers = ads.getSystemMemberApplications();
        int cacheIndex = (int)(Math.random() * (double)applnMembers.length);
        for (int i = 0; i < applnMembers.length; ++i) {
            SystemMember member = applnMembers[i];
            SystemMemberCache cache = member.getCache();
            if (cacheIndex != i) continue;
            cache.addBridgeServer();
            GemFireMemberStatusDUnitTest.pause(5000);
        }
        return cacheIndex;
    }

    private int checkActiveBridgeServerCount() throws AdminException {
        AdminDistributedSystem ads = this.tcSystem;
        SystemMember[] applnMembers = ads.getSystemMemberApplications();
        int serverCount = 0;
        for (int i = 0; i < applnMembers.length; ++i) {
            SystemMemberCache cache = applnMembers[i].getCache();
            GemFireMemberStatus status = ((SystemMemberCacheImpl)cache).getSnapshot();
            String snapShotString = status.toString();
            GemFireMemberStatusDUnitTest.assertNotNull((String)"String representation for GemFireMemberStatus is null.", (Object)snapShotString);
            GemFireMemberStatusDUnitTest.assertNotSame((String)"Inappropriate string representation for GemFireMemberStatus", (Object)snapShotString, (Object)"");
            if (!status.getIsServer() || !status.getIsConnected()) continue;
            Set connectedPeers = status.getConnectedPeers();
            GemFireMemberStatusDUnitTest.assertEquals((String)("Connected Peers for the server: " + applnMembers[i].getName() + " are inappropriate."), (int)(applnMembers.length - 1), (int)connectedPeers.size());
            ++serverCount;
        }
        return serverCount;
    }

    private void stopBridgeServer(int cacheIndex) throws AdminException, InterruptedException {
        AdminDistributedSystem ads = this.tcSystem;
        SystemMember[] applnMembers = ads.getSystemMemberApplications();
        SystemMemberBridgeServer[] bridgeServers = applnMembers[cacheIndex].getCache().getBridgeServers();
        GemFireMemberStatusDUnitTest.getLogWriter().info("No of Bridge Servers:: " + bridgeServers.length);
        for (int i = 0; i < bridgeServers.length; ++i) {
            SystemMemberBridgeServer server = bridgeServers[i];
            server.stop();
            server.refresh();
        }
        applnMembers[cacheIndex].getCache().refresh();
        GemFireMemberStatusDUnitTest.pause(5000);
    }
}

