/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.statalerts;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.StatAlertsManager;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class StatAlertManagerDUnitTest
extends AdminDUnitTestCase {
    public static final int REFRESH_INTERVAL = 10;
    public static final int MEM_VM = 0;
    protected static Cache cache = null;

    public StatAlertManagerDUnitTest(String name) {
        super(name);
    }

    @Override
    public boolean isJMX() {
        return true;
    }

    public void testStatAlertManagerSingletonBehavion() throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        final String testName = this.getName();
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() throws CacheException {
                Properties props = StatAlertManagerDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                StatAlertManagerDUnitTest.this.getSystem(props);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)"interrupted");
                }
                DistributionManager dm = (DistributionManager)DistributedTestCase.system.getDistributionManager();
                StatAlertsManager firstInstance = StatAlertsManager.getInstance((DistributionManager)dm);
                StatAlertsManager secondInstance = StatAlertsManager.getInstance((DistributionManager)dm);
                TestCase.assertEquals((String)"Stat alert manager should have only one instance", (Object)firstInstance, (Object)secondInstance);
            }
        });
    }

    public void testRefreshTimeInterval() throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        final String testName = this.getName();
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = StatAlertManagerDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                StatAlertManagerDUnitTest.this.getSystem(props);
            }
        });
        StatAlertManagerDUnitTest.pause(2000);
        AdminDistributedSystemJmxImpl adminDS = (AdminDistributedSystemJmxImpl)this.agent.getDistributedSystem();
        StatAlertManagerDUnitTest.assertNotNull((String)" instance of AdminDistributedSystemJmxImpl cannot be null ", (Object)adminDS);
        adminDS.setRefreshIntervalForStatAlerts(10);
        Thread.sleep(20L);
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                DistributionManager dm = (DistributionManager)DistributedTestCase.system.getDistributionManager();
                long actualInterval = StatAlertsManager.getInstance((DistributionManager)dm).getRefreshTimeInterval();
                TestCase.assertEquals((String)"refresh time interval of stat alert manager should be same as refresh time interval set by AdminDistributedSystemJmxImpl ", (long)10000L, (long)actualInterval);
            }
        });
    }
}

