/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.statalerts;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.StatAlertNotification;
import com.gemstone.gemfire.admin.statalerts.StatAlertDefinitionDUnitTest;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.statalerts.DummyStatisticInfoImpl;
import com.gemstone.gemfire.internal.admin.statalerts.FunctionHelper;
import com.gemstone.gemfire.internal.admin.statalerts.StatisticInfo;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.management.Notification;
import javax.management.NotificationListener;
import junit.framework.TestCase;

public class StatAlertNotificationDUnitTest
extends StatAlertDefinitionDUnitTest {
    private static final int MEM_VM = 0;
    private static final int NUM_OPS = 10;
    private static final int REFRESH_INTERVAL = 20000;
    protected static final StatAlertDefinition[] definitions = new StatAlertDefinition[4];
    protected static MyNotificationListener listener = new MyNotificationListener();
    protected static Cache cache = null;

    public StatAlertNotificationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String name = "def1";
        StatisticInfo[] statInfo = new StatisticInfo[]{new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "puts")};
        Integer threshold = new Integer(10);
        StatAlertNotificationDUnitTest.definitions[0] = this.prepareStatAlertDefinition(name, statInfo, false, (short)-1, null, threshold);
        name = "def2";
        statInfo = new StatisticInfo[]{new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "misses")};
        Integer minvalue = new Integer(10);
        Integer maxvalue = new Integer(20);
        StatAlertNotificationDUnitTest.definitions[1] = this.prepareStatAlertDefinition(name, statInfo, false, (short)-1, minvalue, maxvalue);
        name = "def3";
        statInfo = new StatisticInfo[]{new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "misses"), new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "gets")};
        short functionId = FunctionHelper.getFunctionIdentifier((String)"Sum");
        Integer threshold2 = new Integer(40);
        StatAlertNotificationDUnitTest.definitions[2] = this.prepareStatAlertDefinition(name, statInfo, true, functionId, null, threshold2);
        name = "def4";
        statInfo = new StatisticInfo[]{new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "puts"), new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "gets")};
        functionId = FunctionHelper.getFunctionIdentifier((String)"Sum");
        Integer minvalue2 = new Integer(10);
        Integer maxvalue2 = new Integer(30);
        StatAlertNotificationDUnitTest.definitions[3] = this.prepareStatAlertDefinition(name, statInfo, true, functionId, minvalue2, maxvalue2);
        mbsc.addNotificationListener(systemName, listener, null, new Object());
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            mbsc.removeNotificationListener(systemName, listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown2();
        cache = null;
        StatAlertNotificationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public void testStatAlertNotifications() throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                int i;
                cache = CacheFactory.create((DistributedSystem)StatAlertNotificationDUnitTest.this.getSystem());
                AttributesFactory factory = new AttributesFactory();
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion("Region1", attrs);
                for (i = 0; i < 30; ++i) {
                    region.get((Object)("nokey" + i));
                }
                for (i = 0; i < 20; ++i) {
                    region.put((Object)("key" + i), (Object)("value" + i));
                }
                for (i = 0; i < 20; ++i) {
                    region.get((Object)("key" + i));
                }
                for (i = 0; i < 20; ++i) {
                    region.put((Object)("key" + i), (Object)("value" + i));
                }
                DistributedTestCase.getLogWriter().info("Data populated...");
            }
        });
        StatAlertNotificationDUnitTest.registerStatAlertDefinition(definitions[0]);
        StatAlertNotificationDUnitTest.registerStatAlertDefinition(definitions[1]);
        StatAlertNotificationDUnitTest.registerStatAlertDefinition(definitions[2]);
        StatAlertNotificationDUnitTest.registerStatAlertDefinition(definitions[3]);
        StatAlertNotificationDUnitTest.getLogWriter().info("Successfully registered statalert definitions.");
        StatAlertNotificationDUnitTest.pause(20000);
        AdminDistributedSystemJmxImpl adminDS = (AdminDistributedSystemJmxImpl)this.agent.getDistributedSystem();
        StatAlertNotificationDUnitTest.assertNotNull((String)" instance of AdminDistributedSystemJmxImpl cannot be null ", (Object)adminDS);
        adminDS.setRefreshIntervalForStatAlerts(20000);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                for (int i = 0; i < 4; ++i) {
                    if (listener.isNotificationReceived(i)) continue;
                    this.excuse = "Notification " + i + " not received";
                    return false;
                }
                return true;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 140000L, 1000L, true);
    }

    protected static class MyNotificationListener
    implements NotificationListener {
        protected volatile boolean[] notif_recvd = new boolean[4];

        protected MyNotificationListener() {
        }

        public boolean isNotificationReceived(int index) {
            return this.notif_recvd[index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification arg0, Object arg1) {
            FilterInputStream ioStr = null;
            try {
                String type = arg0.getType();
                if (type.equals("gemfire.distributedsystem.statalert")) {
                    byte[] notifBytes = (byte[])arg0.getUserData();
                    ByteArrayInputStream byteArrIOStr = new ByteArrayInputStream(notifBytes);
                    ioStr = new DataInputStream(byteArrIOStr);
                    ArrayList notifs = DataSerializer.readArrayList((DataInput)((Object)ioStr));
                    for (StatAlertNotification notification : notifs) {
                        this.verifyNotification(notification);
                    }
                }
            }
            catch (IOException ioEx) {
                DistributedTestCase.getLogWriter().error("IOException while de-serializing ", (Throwable)ioEx);
                TestCase.fail((String)("IOException while de-serializing " + ioEx.getMessage()));
            }
            catch (ClassNotFoundException cnfEx) {
                DistributedTestCase.getLogWriter().error("ClassNotFoundException while de-serializing. Test setup issue ", (Throwable)cnfEx);
                TestCase.fail((String)("ClassNotFoundException while de-serializing " + cnfEx.getMessage()));
            }
            finally {
                if (ioStr != null) {
                    try {
                        ioStr.close();
                    }
                    catch (IOException ioEx) {}
                }
            }
        }

        protected void verifyNotification(StatAlertNotification notif) {
            DistributedTestCase.getLogWriter().info("Received notification " + notif.toString());
            if (notif.getDefinitionId() == definitions[0].getId()) {
                this.notif_recvd[0] = true;
                DistributedTestCase.getLogWriter().info("verifyNotification 0");
                TestCase.assertTrue((boolean)definitions[0].evaluate(notif.getValues()));
                return;
            }
            if (notif.getDefinitionId() == definitions[1].getId()) {
                this.notif_recvd[1] = true;
                DistributedTestCase.getLogWriter().info("verifyNotification 1");
                TestCase.assertTrue((boolean)definitions[1].evaluate(notif.getValues()));
                return;
            }
            if (notif.getDefinitionId() == definitions[2].getId()) {
                this.notif_recvd[2] = true;
                DistributedTestCase.getLogWriter().info("verifyNotification 2");
                TestCase.assertTrue((boolean)definitions[2].evaluate(notif.getValues()));
                return;
            }
            if (notif.getDefinitionId() == definitions[3].getId()) {
                this.notif_recvd[3] = true;
                DistributedTestCase.getLogWriter().info("verifyNotification 3");
                TestCase.assertTrue((boolean)definitions[3].evaluate(notif.getValues()));
                return;
            }
            TestCase.fail((String)("Unknown notification " + notif.getDefinitionId()));
        }
    }
}

