/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.stats;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.StatisticResource;
import com.gemstone.gemfire.admin.SystemMember;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class GemFireMemberStatsDUnitTest
extends AdminDUnitTestCase {
    public GemFireMemberStatsDUnitTest(String name) {
        super(name);
    }

    protected SystemMember getMember() throws Exception {
        GemFireMemberStatsDUnitTest.getLogWriter().info("[testGetMemberStats]");
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberStatsDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                GemFireMemberStatsDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberStatsDUnitTest.pause(2000);
        GemFireMemberStatsDUnitTest.getLogWriter().info("Test: Created DS");
        AdminDistributedSystem system = this.tcSystem;
        SystemMember[] members = system.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            GemFireMemberStatsDUnitTest.fail((String)sb.toString());
        }
        GemFireMemberStatsDUnitTest.getLogWriter().info("Test: Created Member");
        return members[0];
    }

    public void testGetMemberStats() throws Exception {
        GemFireMemberStatsDUnitTest.getLogWriter().info("[testGetMemberStats]");
        StatisticResource[] statRes = this.getMember().getStat("distributionStats");
        GemFireMemberStatsDUnitTest.assertNull((Object)statRes);
        statRes = this.getMember().getStat("DistributionStats");
        GemFireMemberStatsDUnitTest.assertNotNull((Object)statRes);
    }
}

