/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.LocatorTestBase;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionResponse;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionResponse;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.server.ServerLoadProbeAdapter;
import com.gemstone.gemfire.cache.server.ServerMetrics;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

public class LocatorLoadBalancingDUnitTest
extends LocatorTestBase {
    private static final int ALLOWABLE_ERROR_IN_COUNT = 1;
    protected static final long MAX_WAIT = 60000L;

    public LocatorLoadBalancingDUnitTest(String name) {
        super(name);
    }

    public void testDiscovery() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = this.getLocatorString(host, locatorPort);
        int serverPort = this.startBridgeServerInVM(vm1, new String[]{"a", "b"}, locators);
        ServerLoad expectedLoad = new ServerLoad(0.0f, 0.00125f, 0.0f, 1.0f);
        ServerLocation expectedLocation = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(vm0.getHost()), serverPort);
        HashMap<ServerLocation, ServerLoad> expected = new HashMap<ServerLocation, ServerLoad>();
        expected.put(expectedLocation, expectedLoad);
        this.checkLocatorLoad(vm0, expected);
        int serverPort2 = this.startBridgeServerInVM(vm2, new String[]{"a", "b"}, locators);
        ServerLocation expectedLocation2 = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(vm0.getHost()), serverPort2);
        expected.put(expectedLocation2, expectedLoad);
        this.checkLocatorLoad(vm0, expected);
    }

    public void testEstimation() throws UnknownHostException, IOException, ClassNotFoundException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = this.getLocatorString(host, locatorPort);
        int serverPort = this.startBridgeServerInVM(vm1, new String[]{"a", "b"}, locators);
        ServerLoad expectedLoad = new ServerLoad(0.0025f, 0.00125f, 0.0f, 1.0f);
        ServerLocation expectedLocation = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(host), serverPort);
        HashMap<ServerLocation, ServerLoad> expected = new HashMap<ServerLocation, ServerLoad>();
        expected.put(expectedLocation, expectedLoad);
        ClientConnectionResponse response = (ClientConnectionResponse)TcpClient.requestToServer((InetAddress)InetAddress.getByName(LocatorLoadBalancingDUnitTest.getServerHostName(host)), (int)locatorPort, (Object)new ClientConnectionRequest(Collections.EMPTY_SET, null), (int)10000);
        Assert.assertEquals((Object)expectedLocation, (Object)response.getServer());
        response = (ClientConnectionResponse)TcpClient.requestToServer((InetAddress)InetAddress.getByName(LocatorLoadBalancingDUnitTest.getServerHostName(host)), (int)locatorPort, (Object)new ClientConnectionRequest(Collections.EMPTY_SET, null), (int)10000, (boolean)true);
        Assert.assertEquals((Object)expectedLocation, (Object)response.getServer());
        this.checkLocatorLoad(vm0, expected);
        QueueConnectionResponse response2 = (QueueConnectionResponse)TcpClient.requestToServer((InetAddress)InetAddress.getByName(LocatorLoadBalancingDUnitTest.getServerHostName(host)), (int)locatorPort, (Object)new QueueConnectionRequest(null, 2, Collections.EMPTY_SET, null, false), (int)10000, (boolean)true);
        Assert.assertEquals(Collections.singletonList(expectedLocation), (Object)response2.getServers());
        response2 = (QueueConnectionResponse)TcpClient.requestToServer((InetAddress)InetAddress.getByName(LocatorLoadBalancingDUnitTest.getServerHostName(host)), (int)locatorPort, (Object)new QueueConnectionRequest(null, 5, Collections.EMPTY_SET, null, false), (int)10000, (boolean)true);
        Assert.assertEquals(Collections.singletonList(expectedLocation), (Object)response2.getServers());
        expectedLoad.setSubscriptionConnectionLoad(2.0f);
        this.checkLocatorLoad(vm0, expected);
    }

    public void testLoadMessaging() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = this.getLocatorString(host, locatorPort);
        int serverPort = this.startBridgeServerInVM(vm1, new String[]{"a", "b"}, locators);
        HashMap<ServerLocation, ServerLoad> expected = new HashMap<ServerLocation, ServerLoad>();
        ServerLocation expectedLocation = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(host), serverPort);
        ServerLoad expectedLoad = new ServerLoad(0.0f, 0.00125f, 0.0f, 1.0f);
        expected.put(expectedLocation, expectedLoad);
        this.checkLocatorLoad(vm0, expected);
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addServer(LocatorLoadBalancingDUnitTest.getServerHostName(host), serverPort);
        pf.setMinConnections(8);
        pf.setMaxConnections(8);
        pf.setSubscriptionEnabled(true);
        this.startBridgeClientInVM(vm2, (Pool)pf.getPoolAttributes(), new String[]{"A_REGION"});
        expectedLoad = new ServerLoad(0.01f, 0.00125f, 1.0f, 1.0f);
        expected.put(expectedLocation, expectedLoad);
        this.checkLocatorLoad(vm0, expected);
        this.stopBridgeMemberVM(vm2);
        expectedLoad = new ServerLoad(0.0f, 0.00125f, 0.0f, 1.0f);
        expected.put(expectedLocation, expectedLoad);
        this.checkLocatorLoad(vm0, expected);
    }

    public void testBalancing() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = this.getLocatorString(host, locatorPort);
        this.startBridgeServerInVM(vm1, new String[]{"a", "b"}, locators);
        this.startBridgeServerInVM(vm2, new String[]{"a", "b"}, locators);
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addLocator(LocatorLoadBalancingDUnitTest.getServerHostName(host), locatorPort);
        pf.setMinConnections(80);
        pf.setMaxConnections(80);
        pf.setSubscriptionEnabled(false);
        pf.setIdleTimeout(-1L);
        this.startBridgeClientInVM(vm3, (Pool)pf.getPoolAttributes(), new String[]{"A_REGION"});
        this.waitForPrefilledConnections(vm3, 80);
        this.checkConnectionCount(vm1, 40);
        this.checkConnectionCount(vm2, 40);
    }

    private void checkConnectionCount(VM vm, final int count) {
        SerializableRunnable checkConnectionCount = new SerializableRunnable("checkConnectionCount"){

            @Override
            public void run() {
                Cache cache = (Cache)LocatorTestBase.remoteObjects.get("CACHE");
                final BridgeServerImpl server = (BridgeServerImpl)cache.getBridgeServers().get(0);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        int sz = server.getAcceptor().getStats().getCurrentClientConnections();
                        if (Math.abs(sz - count) <= 1) {
                            return true;
                        }
                        this.excuse = "Found " + sz + " connections, expected " + count;
                        return false;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 300000L, 1000L, true);
            }
        };
        vm.invoke(checkConnectionCount);
    }

    private void waitForPrefilledConnections(VM vm, int count) {
        this.waitForPrefilledConnections(vm, count, "daPool");
    }

    private void waitForPrefilledConnections(VM vm, final int count, final String poolName) {
        SerializableRunnable runnable = new SerializableRunnable("waitForPrefilledConnections"){

            @Override
            public void run() {
                final PoolImpl pool = (PoolImpl)PoolManager.getAll().get(poolName);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectionCount() >= count;
                    }

                    @Override
                    public String description() {
                        return "connection count never reached " + count;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            }
        };
        if (vm == null) {
            runnable.run();
        } else {
            vm.invoke(runnable);
        }
    }

    public void testIntersectingServerGroups() {
        int i;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = this.getLocatorString(host, locatorPort);
        int serverPort1 = this.startBridgeServerInVM(vm1, new String[]{"a"}, locators);
        this.startBridgeServerInVM(vm2, new String[]{"a", "b"}, locators);
        this.startBridgeServerInVM(vm3, new String[]{"b"}, locators);
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addLocator(LocatorLoadBalancingDUnitTest.getServerHostName(host), locatorPort);
        pf.setMinConnections(12);
        pf.setSubscriptionEnabled(false);
        pf.setServerGroup("a");
        pf.setIdleTimeout(-1L);
        this.startBridgeClientInVM(null, (Pool)pf.getPoolAttributes(), new String[]{"A_REGION"});
        this.waitForPrefilledConnections(null, 12);
        this.checkConnectionCount(vm1, 6);
        this.checkConnectionCount(vm2, 6);
        this.checkConnectionCount(vm3, 0);
        LocatorLoadBalancingDUnitTest.getLogWriter().info("pool1 prefilled");
        PoolFactoryImpl pf2 = (PoolFactoryImpl)PoolManager.createFactory();
        pf2.init((Pool)pf.getPoolAttributes());
        pf2.setServerGroup("b");
        PoolImpl pool2 = (PoolImpl)pf2.create("testPool2");
        this.waitForPrefilledConnections(null, 12, "testPool2");
        this.checkConnectionCount(vm1, 6);
        this.checkConnectionCount(vm2, 9);
        this.checkConnectionCount(vm3, 9);
        LocatorLoadBalancingDUnitTest.getLogWriter().info("pool2 prefilled");
        ServerLocation location1 = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(host), serverPort1);
        PoolImpl pool1 = (PoolImpl)PoolManager.getAll().get("daPool");
        Assert.assertEquals((String)"a", (String)pool1.getServerGroup());
        for (i = 0; i < 15; ++i) {
            pool1.acquireConnection();
        }
        LocatorLoadBalancingDUnitTest.getLogWriter().info("aquired 15 connections in pool1");
        this.checkConnectionCount(vm1, 9);
        this.checkConnectionCount(vm2, 9);
        this.checkConnectionCount(vm3, 9);
        for (i = 0; i < 12; ++i) {
            pool2.acquireConnection();
        }
        LocatorLoadBalancingDUnitTest.getLogWriter().info("aquired 12 connections in pool2");
        for (i = 0; i < 6; ++i) {
            pool1.acquireConnection();
            pool2.acquireConnection();
        }
        LocatorLoadBalancingDUnitTest.getLogWriter().info("interleaved 6 connections from pool1 with 6 connections from pool2");
        this.checkConnectionCount(vm1, 13);
        this.checkConnectionCount(vm2, 13);
        this.checkConnectionCount(vm3, 13);
    }

    public void testCustomLoadProbe() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = this.getLocatorString(host, locatorPort);
        ServerLoad load1 = new ServerLoad(0.3f, 0.01f, 0.44f, 4564.0f);
        ServerLoad load2 = new ServerLoad(23.2f, 1.1f, 22.3f, 0.3f);
        int serverPort1 = this.startBridgeServerInVM(vm1, null, locators, new String[]{"A_REGION"}, (ServerLoadProbe)new MyLoadProbe(load1));
        int serverPort2 = this.startBridgeServerInVM(vm2, null, locators, new String[]{"A_REGION"}, (ServerLoadProbe)new MyLoadProbe(load2));
        HashMap<ServerLocation, ServerLoad> expected = new HashMap<ServerLocation, ServerLoad>();
        ServerLocation l1 = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(host), serverPort1);
        ServerLocation l2 = new ServerLocation(LocatorLoadBalancingDUnitTest.getServerHostName(host), serverPort2);
        expected.put(l1, load1);
        expected.put(l2, load2);
        this.checkLocatorLoad(vm0, expected);
        load1.setConnectionLoad(25.0f);
        this.changeLoad(vm1, load1);
        load2.setSubscriptionConnectionLoad(3.5f);
        this.changeLoad(vm2, load2);
        this.checkLocatorLoad(vm0, expected);
        load1 = new ServerLoad(1.0f, 0.1f, 0.0f, 1.0f);
        load2 = new ServerLoad(2.0f, 5.0f, 0.0f, 2.0f);
        expected.put(l1, load1);
        expected.put(l2, load2);
        this.changeLoad(vm1, load1);
        this.changeLoad(vm2, load2);
        this.checkLocatorLoad(vm0, expected);
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addLocator(LocatorLoadBalancingDUnitTest.getServerHostName(host), locatorPort);
        pf.setMinConnections(20);
        pf.setSubscriptionEnabled(true);
        pf.setIdleTimeout(-1L);
        this.startBridgeClientInVM(null, (Pool)pf.getPoolAttributes(), new String[]{"A_REGION"});
        this.waitForPrefilledConnections(null, 20);
        this.checkConnectionCount(vm1, 19);
        this.checkConnectionCount(vm2, 1);
    }

    public void checkLocatorLoad(VM vm, final Map expected) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                List locators = Locator.getLocators();
                Assert.assertEquals((int)1, (int)locators.size());
                InternalLocator locator = (InternalLocator)locators.get(0);
                final ServerLocator sl = locator.getServerLocatorAdvisee();
                LocalLogWriter log = new LocalLogWriter(300, System.out);
                sl.getDistributionAdvisor().dumpProfiles((LogWriterI18n)log, "PROFILES= ");
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return expected.equals(sl.getLoadMap());
                    }

                    @Override
                    public String description() {
                        return "load map never became equal to " + expected + " (current = " + sl.getLoadMap() + ')';
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            }
        });
    }

    private void changeLoad(VM vm, final ServerLoad newLoad) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = (Cache)LocatorTestBase.remoteObjects.get("CACHE");
                BridgeServer server = (BridgeServer)cache.getBridgeServers().get(0);
                MyLoadProbe probe = (MyLoadProbe)server.getLoadProbe();
                probe.setLoad(newLoad);
            }
        });
    }

    private static class MyLoadProbe
    extends ServerLoadProbeAdapter
    implements Serializable {
        private ServerLoad load;

        public MyLoadProbe(ServerLoad load) {
            this.load = load;
        }

        public ServerLoad getLoad(ServerMetrics metrics) {
            float connectionLoad = this.load.getConnectionLoad() + (float)metrics.getConnectionCount() * this.load.getLoadPerConnection();
            float queueLoad = this.load.getSubscriptionConnectionLoad() + (float)metrics.getSubscriptionConnectionCount() * this.load.getLoadPerSubscriptionConnection();
            return new ServerLoad(connectionLoad, this.load.getLoadPerConnection(), queueLoad, this.load.getLoadPerSubscriptionConnection());
        }

        public void setLoad(ServerLoad load) {
            this.load = load;
        }
    }
}

