/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.AsyncInvocation;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class RegionRecoveryDUnitTest
extends CacheTestCase {
    public RegionRecoveryDUnitTest(String name) {
        super(name);
    }

    public void testbasicRestart() throws Exception {
        RegionRecoveryDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String homeDir = "./testGetFromHDFS";
        this.createServerRegion(vm0, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.createServerRegion(vm1, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.createServerRegion(vm2, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.createServerRegion(vm3, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.doPuts(vm0, "testGetFromHDFS", 1, 50);
        this.doPuts(vm1, "testGetFromHDFS", 40, 100);
        this.doPuts(vm2, "testGetFromHDFS", 40, 100);
        this.doPuts(vm3, "testGetFromHDFS", 90, 150);
        this.cacheClose(vm0, true);
        this.cacheClose(vm1, true);
        this.cacheClose(vm2, true);
        this.cacheClose(vm3, true);
        this.createServerRegion(vm0, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.createServerRegion(vm1, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.createServerRegion(vm2, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.createServerRegion(vm3, 11, 1, 500, 500, homeDir, "testGetFromHDFS");
        this.verifyGetsForValue(vm0, "testGetFromHDFS", 1, 50, false);
        this.verifyGetsForValue(vm1, "testGetFromHDFS", 40, 100, false);
        this.verifyGetsForValue(vm2, "testGetFromHDFS", 40, 100, false);
        this.verifyGetsForValue(vm3, "testGetFromHDFS", 90, 150, false);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        this.cacheClose(vm2, false);
        this.cacheClose(vm3, false);
        RegionRecoveryDUnitTest.disconnectFromDS();
    }

    public void DISABLED_testPersistedAsyncQueue_Restart() throws Exception {
        RegionRecoveryDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String homeDir = "./testPersistedAsyncQueue_Restart";
        this.createPersistedServerRegion(vm0, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        this.createPersistedServerRegion(vm1, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        this.createPersistedServerRegion(vm2, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        this.createPersistedServerRegion(vm3, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        AsyncInvocation a0 = this.doAsyncPuts(vm0, "testPersistedAsyncQueue_Restart", 1, 50);
        AsyncInvocation a1 = this.doAsyncPuts(vm1, "testPersistedAsyncQueue_Restart", 40, 100);
        AsyncInvocation a2 = this.doAsyncPuts(vm2, "testPersistedAsyncQueue_Restart", 40, 100);
        AsyncInvocation a3 = this.doAsyncPuts(vm3, "testPersistedAsyncQueue_Restart", 90, 150);
        a3.join();
        a2.join();
        a1.join();
        a0.join();
        this.cacheClose(vm0, true);
        this.cacheClose(vm1, true);
        this.cacheClose(vm2, true);
        this.cacheClose(vm3, true);
        a3 = this.createAsyncPersistedServerRegion(vm3, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        a2 = this.createAsyncPersistedServerRegion(vm2, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        a1 = this.createAsyncPersistedServerRegion(vm1, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        a0 = this.createAsyncPersistedServerRegion(vm0, 11, 1, 2000, 5, homeDir, "testPersistedAsyncQueue_Restart");
        a3.join();
        a2.join();
        a1.join();
        a0.join();
        this.verifyGetsForValue(vm0, "testPersistedAsyncQueue_Restart", 1, 50, false);
        this.verifyGetsForValue(vm1, "testPersistedAsyncQueue_Restart", 40, 100, false);
        this.verifyGetsForValue(vm2, "testPersistedAsyncQueue_Restart", 40, 100, false);
        this.verifyGetsForValue(vm3, "testPersistedAsyncQueue_Restart", 90, 150, false);
        this.verifyGetsForValue(vm0, "testPersistedAsyncQueue_Restart", 1, 50, true);
        this.verifyGetsForValue(vm1, "testPersistedAsyncQueue_Restart", 40, 100, true);
        this.verifyGetsForValue(vm2, "testPersistedAsyncQueue_Restart", 40, 100, true);
        this.verifyGetsForValue(vm3, "testPersistedAsyncQueue_Restart", 90, 150, true);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        this.cacheClose(vm2, false);
        this.cacheClose(vm3, false);
        RegionRecoveryDUnitTest.disconnectFromDS();
    }

    public void testPersistedAsyncQueue_ServerRestart() throws Exception {
        RegionRecoveryDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String homeDir = "testPAQ_ServerRestart";
        this.createPersistedServerRegion(vm0, 11, 1, 2000, 5, homeDir, "testPAQ_ServerRestart");
        this.createPersistedServerRegion(vm1, 11, 1, 2000, 5, homeDir, "testPAQ_ServerRestart");
        this.createPersistedServerRegion(vm2, 11, 1, 2000, 5, homeDir, "testPAQ_ServerRestart");
        this.createPersistedServerRegion(vm3, 11, 1, 2000, 5, homeDir, "testPAQ_ServerRestart");
        AsyncInvocation a0 = this.doAsyncPuts(vm0, "testPAQ_ServerRestart", 1, 50);
        AsyncInvocation a1 = this.doAsyncPuts(vm1, "testPAQ_ServerRestart", 50, 75);
        AsyncInvocation a2 = this.doAsyncPuts(vm2, "testPAQ_ServerRestart", 75, 100);
        AsyncInvocation a3 = this.doAsyncPuts(vm3, "testPAQ_ServerRestart", 100, 150);
        a3.join();
        a2.join();
        a1.join();
        a0.join();
        this.cacheClose(vm0, false);
        this.verifyGetsForValue(vm1, "testPAQ_ServerRestart", 1, 50, false);
        this.verifyGetsForValue(vm2, "testPAQ_ServerRestart", 40, 100, false);
        this.verifyGetsForValue(vm3, "testPAQ_ServerRestart", 70, 150, false);
        this.verifyGetsForValue(vm2, "testPAQ_ServerRestart", 1, 100, true);
        this.verifyGetsForValue(vm3, "testPAQ_ServerRestart", 40, 150, true);
        this.cacheClose(vm1, false);
        this.cacheClose(vm2, false);
        this.cacheClose(vm3, false);
        RegionRecoveryDUnitTest.disconnectFromDS();
    }

    private int createPersistedServerRegion(VM vm, int totalnumOfBuckets, int batchSize, int batchInterval, int maximumEntries, String folderPath, String uniqueName) {
        return (Integer)vm.invoke(new PersistedRegionCreation(vm, totalnumOfBuckets, batchSize, batchInterval, maximumEntries, folderPath, uniqueName));
    }

    private AsyncInvocation createAsyncPersistedServerRegion(VM vm, int totalnumOfBuckets, int batchSize, int batchInterval, int maximumEntries, String folderPath, String uniqueName) {
        return vm.invokeAsync(new PersistedRegionCreation(vm, totalnumOfBuckets, batchSize, batchInterval, maximumEntries, folderPath, uniqueName));
    }

    private Cache createCacheForHDFS(Integer locPort) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = this.getSystem(props);
        return CacheFactory.create((DistributedSystem)ds);
    }

    private int createServerRegion(VM vm, final int totalnumOfBuckets, final int batchSize, final int batchInterval, final int maximumEntries, final String folderPath, final String uniqueName) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(totalnumOfBuckets);
                paf.setRedundantCopies(1);
                af.setPartitionAttributes(paf.create());
                HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
                hqf.setBatchSizeMB(batchSize);
                hqf.setBatchTimeInterval(batchInterval);
                hqf.setPersistent(false);
                hqf.setMaximumQueueMemory(1);
                HDFSStoreFactory hsf = RegionRecoveryDUnitTest.this.getCache().createHDFSStoreFactory();
                hsf.setHDFSEventQueueAttributes(hqf.create());
                hsf.setHomeDir(folderPath);
                hsf.create(uniqueName);
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                af.setHDFSWriteOnly(false);
                af.setHDFSStoreName(uniqueName);
                RegionRecoveryDUnitTest.this.createRootRegion(uniqueName, af.create());
                return 0;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void cacheClose(VM vm, final boolean sleep) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (sleep) {
                    Thread.sleep(2000L);
                }
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Cache close in progress ");
                RegionRecoveryDUnitTest.this.getCache().close();
                RegionRecoveryDUnitTest.this.getCache().getDistributedSystem().disconnect();
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Cache closed");
                return null;
            }
        });
    }

    private AsyncInvocation cacheAsyncClose(VM vm) {
        return vm.invokeAsync(new SerializableCallable(){

            public Object call() throws Exception {
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Cache close in progress ");
                RegionRecoveryDUnitTest.this.getCache().close();
                RegionRecoveryDUnitTest.this.getCache().getDistributedSystem().disconnect();
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Cache closed");
                return null;
            }
        });
    }

    private Integer createFirstLocatorWithDSId(int dsId) {
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        this.getSystem(props);
        return port;
    }

    private void doPuts(VM vm, final String regionName, final int start, final int end) throws Exception {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionRecoveryDUnitTest.this.getRootRegion(regionName);
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Putting entries ");
                for (int i = start; i < end; ++i) {
                    r.put((Object)("K" + i), (Object)("V" + i));
                }
                return null;
            }
        });
    }

    private AsyncInvocation doAsyncPuts(VM vm, final String regionName, final int start, final int end) throws Exception {
        return vm.invokeAsync(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionRecoveryDUnitTest.this.getRootRegion(regionName);
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Putting entries ");
                for (int i = start; i < end; ++i) {
                    r.put((Object)("K" + i), (Object)("V" + i));
                }
                return null;
            }
        });
    }

    private void verifyGetsForValue(VM vm, final String regionName, final int start, final int end, final boolean sleep) throws Exception {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (sleep) {
                    Thread.sleep(2000L);
                }
                RegionRecoveryDUnitTest.this.getCache().getLogger().info("Getting entries ");
                Region r = RegionRecoveryDUnitTest.this.getRootRegion(regionName);
                for (int i = start; i < end; ++i) {
                    String k = "K" + i;
                    Object s = r.get((Object)k);
                    String v = "V" + i;
                    TestCase.assertTrue((String)("The expected key " + v + " didn't match the received value " + s), (boolean)v.equals(s));
                }
                return null;
            }
        });
    }

    class PersistedRegionCreation
    extends SerializableCallable {
        private VM vm;
        private int totalnumOfBuckets;
        private int batchSize;
        private int maximumEntries;
        private String folderPath;
        private String uniqueName;
        private int batchInterval;

        PersistedRegionCreation(VM vm, int totalnumOfBuckets, int batchSize, int batchInterval, int maximumEntries, String folderPath, String uniqueName) {
            this.vm = vm;
            this.totalnumOfBuckets = totalnumOfBuckets;
            this.batchSize = batchSize;
            this.maximumEntries = maximumEntries;
            this.folderPath = folderPath;
            this.uniqueName = uniqueName;
            this.batchInterval = batchInterval;
        }

        public Object call() throws Exception {
            AttributesFactory af = new AttributesFactory();
            af.setDataPolicy(DataPolicy.HDFS_PARTITION);
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setTotalNumBuckets(this.totalnumOfBuckets);
            paf.setRedundantCopies(1);
            af.setPartitionAttributes(paf.create());
            HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
            hqf.setBatchSizeMB(this.batchSize);
            hqf.setBatchTimeInterval(this.batchInterval);
            hqf.setPersistent(true);
            hqf.setDiskStoreName(this.uniqueName + this.vm.getPid());
            HDFSStoreFactory hsf = RegionRecoveryDUnitTest.this.getCache().createHDFSStoreFactory();
            hsf.setHomeDir(this.folderPath);
            hsf.setHDFSEventQueueAttributes(hqf.create());
            DiskStore ds = RegionRecoveryDUnitTest.this.getCache().createDiskStoreFactory().create(this.uniqueName + this.vm.getPid());
            af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)this.maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
            af.setHDFSStoreName(this.uniqueName);
            af.setHDFSWriteOnly(false);
            hsf.create(this.uniqueName);
            RegionRecoveryDUnitTest.this.createRootRegion(this.uniqueName, af.create());
            return 0;
        }
    }
}

