/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.RegionWithHDFSTestBase;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalDataView;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RegionWithHDFSBasicDUnitTest
extends RegionWithHDFSTestBase {
    public RegionWithHDFSBasicDUnitTest(String name) {
        super(name);
    }

    @Override
    protected SerializableCallable getCreateRegionCallable(final int totalnumOfBuckets, final int batchSizeMB, final int maximumEntries, final String folderPath, final String uniqueName, final int batchInterval, final boolean queuePersistent, final boolean writeonly, final long timeForRollover, final long maxFileSize) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(totalnumOfBuckets);
                paf.setRedundantCopies(1);
                HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
                hqf.setBatchSizeMB(batchSizeMB);
                hqf.setPersistent(queuePersistent);
                hqf.setMaximumQueueMemory(3);
                hqf.setBatchTimeInterval(batchInterval);
                af.setHDFSStoreName(uniqueName);
                af.setPartitionAttributes(paf.create());
                HDFSStoreFactory hsf = RegionWithHDFSBasicDUnitTest.this.getCache().createHDFSStoreFactory();
                String homeDir = RegionWithHDFSBasicDUnitTest.this.tmpDir + "/" + folderPath;
                hsf.setHomeDir(homeDir);
                hsf.setHDFSEventQueueAttributes(hqf.create());
                if (timeForRollover != -1L) {
                    hsf.setFileRolloverInterval((int)timeForRollover);
                    System.setProperty("gemfire.HDFSRegionDirector.FILE_ROLLOVER_TASK_INTERVAL_SECONDS", "1");
                }
                if (maxFileSize != -1L) {
                    hsf.setMaxFileSize((int)maxFileSize);
                }
                hsf.create(uniqueName);
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                af.setHDFSWriteOnly(writeonly);
                Region r = RegionWithHDFSBasicDUnitTest.this.createRootRegion(uniqueName, af.create());
                ((LocalRegion)r).setIsTest();
                return 0;
            }
        };
        return createRegion;
    }

    @Override
    protected void doPuts(String uniqueName, int start, int end) {
        Region r = this.getRootRegion(uniqueName);
        for (int i = start; i < end; ++i) {
            r.put((Object)("K" + i), (Object)("V" + i));
        }
    }

    @Override
    protected void doPutAll(String uniqueName, Map map) {
        Region r = this.getRootRegion(uniqueName);
        r.putAll(map);
    }

    @Override
    protected void doDestroys(String uniqueName, int start, int end) {
        Region r = this.getRootRegion(uniqueName);
        for (int i = start; i < end; ++i) {
            r.destroy((Object)("K" + i));
        }
    }

    @Override
    protected void checkWithGet(String uniqueName, int start, int end, boolean expectValue) {
        Region r = this.getRootRegion(uniqueName);
        for (int i = start; i < end; ++i) {
            String expected = expectValue ? "V" + i : null;
            RegionWithHDFSBasicDUnitTest.assertEquals((String)("Mismatch on key " + i), (Object)expected, (Object)r.get((Object)("K" + i)));
        }
    }

    @Override
    protected void checkWithGetAll(String uniqueName, ArrayList arrayl) {
        Region r = this.getRootRegion(uniqueName);
        Map map = r.getAll((Collection)arrayl);
        this.getCache().getLogger().info("Read entries " + map.size());
        for (Object e : map.keySet()) {
            String v = e.toString().replaceFirst("K", "V");
            RegionWithHDFSBasicDUnitTest.assertTrue((String)("Reading entries failed for key " + e + " where value = " + map.get(e)), (boolean)v.equals(map.get(e)));
        }
    }

    public void testValueFetchedFromLocal() {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int port0 = this.createServerRegion(vm0, 7, 1, 50, "./testValueFetchedFromLocal", "testValueFetchedFromLocal", 1000);
        int port1 = this.createServerRegion(vm1, 7, 1, 50, "./testValueFetchedFromLocal", "testValueFetchedFromLocal", 1000);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testValueFetchedFromLocal");
                for (int i = 0; i < 25; ++i) {
                    r.put((Object)("K" + i), (Object)("V" + i));
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testValueFetchedFromLocal");
                for (int i = 0; i < 25; ++i) {
                    String s = null;
                    String k = "K" + i;
                    s = (String)r.get((Object)k);
                    String v = "V" + i;
                    TestCase.assertTrue((String)("The expected key " + v + " didn't match the received value " + s), (boolean)v.equals(s));
                }
                TestCase.assertTrue((String)"gets should always go to primary, ", (((LocalRegion)r).getCountNotFoundInLocal() != 0 ? 1 : 0) != 0);
                return null;
            }
        });
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testValueFetchedFromLocal");
                TestCase.assertTrue((String)("HDFS queue or HDFS should not have been accessed. They were accessed " + ((LocalRegion)r).getCountNotFoundInLocal() + " times"), (((LocalRegion)r).getCountNotFoundInLocal() == 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    public void testHDFSQueueSizeTest() {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int port0 = this.createServerRegion(vm0, 1, 10, 50, "./testHDFSQueueSize", "testHDFSQueueSize", 100000);
        int port1 = this.createServerRegion(vm1, 1, 10, 50, "./testHDFSQueueSize", "testHDFSQueueSize", 100000);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testHDFSQueueSize");
                byte[] b = new byte[1024];
                byte[] k = new byte[1];
                for (int i = 0; i < 1; ++i) {
                    r.put((Object)k, (Object)b);
                }
                ConcurrentParallelGatewaySenderQueue hdfsqueue = (ConcurrentParallelGatewaySenderQueue)((PartitionedRegion)r).getHDFSEventQueue().getSender().getQueue();
                HDFSBucketRegionQueue hdfsBQ = (HDFSBucketRegionQueue)((PartitionedRegion)hdfsqueue.getRegion()).getDataStore().getLocalBucketById(Integer.valueOf(0));
                if (hdfsBQ.getBucketAdvisor().isPrimary()) {
                    TestCase.assertTrue((String)("size should not as expected on primary " + hdfsBQ.queueSizeInBytes.get()), (hdfsBQ.queueSizeInBytes.get() > 1024L && hdfsBQ.queueSizeInBytes.get() < 1150L ? 1 : 0) != 0);
                } else {
                    TestCase.assertTrue((String)"size should be 0 on secondary", (hdfsBQ.queueSizeInBytes.get() == 0L ? 1 : 0) != 0);
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testHDFSQueueSize");
                ConcurrentParallelGatewaySenderQueue hdfsqueue = (ConcurrentParallelGatewaySenderQueue)((PartitionedRegion)r).getHDFSEventQueue().getSender().getQueue();
                HDFSBucketRegionQueue hdfsBQ = (HDFSBucketRegionQueue)((PartitionedRegion)hdfsqueue.getRegion()).getDataStore().getLocalBucketById(Integer.valueOf(0));
                if (hdfsBQ.getBucketAdvisor().isPrimary()) {
                    TestCase.assertTrue((String)("size should not as expected on primary " + hdfsBQ.queueSizeInBytes.get()), (hdfsBQ.queueSizeInBytes.get() > 1024L && hdfsBQ.queueSizeInBytes.get() < 1150L ? 1 : 0) != 0);
                } else {
                    TestCase.assertTrue((String)"size should be 0 on secondary", (hdfsBQ.queueSizeInBytes.get() == 0L ? 1 : 0) != 0);
                }
                return null;
            }
        });
    }

    public void testBasicPutsForWriteOnlyHDFSStore() {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int port0 = this.createServerRegion(vm0, 7, 1, 20, "./testPutsForWriteOnlyHDFSStore", "testPutsForWriteOnlyHDFSStore", 100, true, false);
        int port1 = this.createServerRegion(vm1, 7, 1, 20, "./testPutsForWriteOnlyHDFSStore", "testPutsForWriteOnlyHDFSStore", 100, true, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testPutsForWriteOnlyHDFSStore");
                for (int i = 0; i < 200; ++i) {
                    r.put((Object)("K" + i), (Object)("V" + i));
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testPutsForWriteOnlyHDFSStore");
                for (int i = 200; i < 400; ++i) {
                    r.put((Object)("K" + i), (Object)("V" + i));
                }
                return null;
            }
        });
    }

    public void testDelta() {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int port0 = this.createServerRegion(vm0, 7, 1, 20, "./testDelta", "testDelta", 100);
        int port1 = this.createServerRegion(vm1, 7, 1, 20, "./testDelta", "testDelta", 100);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int i;
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testDelta");
                for (i = 0; i < 100; ++i) {
                    r.put((Object)("K" + i), (Object)new CustomerDelta("V" + i, "address"));
                }
                for (i = 0; i < 50; ++i) {
                    CustomerDelta cd = new CustomerDelta("V" + i, "address");
                    cd.setAddress("updated address");
                    r.put((Object)("K" + i), (Object)cd);
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int i;
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testDelta");
                for (i = 100; i < 200; ++i) {
                    r.put((Object)("K" + i), (Object)new CustomerDelta("V" + i, "address"));
                }
                for (i = 100; i < 150; ++i) {
                    CustomerDelta cd = new CustomerDelta("V" + i, "address");
                    cd.setAddress("updated address");
                    r.put((Object)("K" + i), (Object)cd);
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CustomerDelta s;
                String k;
                CustomerDelta custDela;
                int i;
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testDelta");
                for (i = 0; i < 50; ++i) {
                    custDela = new CustomerDelta("V" + i, "updated address");
                    k = "K" + i;
                    s = (CustomerDelta)r.get((Object)k);
                    TestCase.assertTrue((String)("The expected value " + custDela + " didn't match the received value " + s), (boolean)custDela.equals(s));
                }
                for (i = 50; i < 100; ++i) {
                    custDela = new CustomerDelta("V" + i, "address");
                    k = "K" + i;
                    s = (CustomerDelta)r.get((Object)k);
                    TestCase.assertTrue((String)("The expected value " + custDela + " didn't match the received value " + s), (boolean)custDela.equals(s));
                }
                for (i = 100; i < 150; ++i) {
                    custDela = new CustomerDelta("V" + i, "updated address");
                    k = "K" + i;
                    s = (CustomerDelta)r.get((Object)k);
                    TestCase.assertTrue((String)("The expected value " + custDela + " didn't match the received value " + s), (boolean)custDela.equals(s));
                }
                for (i = 150; i < 200; ++i) {
                    custDela = new CustomerDelta("V" + i, "address");
                    k = "K" + i;
                    s = (CustomerDelta)r.get((Object)k);
                    TestCase.assertTrue((String)("The expected value " + custDela + " didn't match the received value " + s), (boolean)custDela.equals(s));
                }
                return null;
            }
        });
    }

    public void testByteArrays() {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int port0 = this.createServerRegion(vm0, 7, 1, 20, "./testByteArrays", "testByteArrays", 100);
        int port1 = this.createServerRegion(vm1, 7, 1, 20, "./testByteArrays", "testByteArrays", 100);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testByteArrays");
                byte[] b1 = new byte[]{17, 68, 119};
                byte[] b2 = new byte[]{34, 85};
                byte[] b3 = new byte[]{51};
                for (int i = 0; i < 100; ++i) {
                    int x = i % 3;
                    if (x == 0) {
                        r.put((Object)("K" + i), (Object)b1);
                        continue;
                    }
                    if (x == 1) {
                        r.put((Object)("K" + i), (Object)b2);
                        continue;
                    }
                    r.put((Object)("K" + i), (Object)b3);
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testByteArrays");
                byte[] b1 = new byte[]{17, 68, 119};
                byte[] b2 = new byte[]{34, 85};
                byte[] b3 = new byte[]{51};
                for (int i = 100; i < 200; ++i) {
                    int x = i % 3;
                    if (x == 0) {
                        r.put((Object)("K" + i), (Object)b1);
                        continue;
                    }
                    if (x == 1) {
                        r.put((Object)("K" + i), (Object)b2);
                        continue;
                    }
                    r.put((Object)("K" + i), (Object)b3);
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testByteArrays");
                byte[] b1 = new byte[]{17, 68, 119};
                byte[] b2 = new byte[]{34, 85};
                byte[] b3 = new byte[]{51};
                for (int i = 0; i < 200; ++i) {
                    int x = i % 3;
                    String k = "K" + i;
                    byte[] s = (byte[])r.get((Object)k);
                    if (x == 0) {
                        TestCase.assertTrue((String)"The expected value didn't match the received value of byte array", (boolean)Arrays.equals(b1, s));
                        continue;
                    }
                    if (x == 1) {
                        TestCase.assertTrue((String)"The expected value didn't match the received value of byte array", (boolean)Arrays.equals(b2, s));
                        continue;
                    }
                    TestCase.assertTrue((String)"The expected value didn't match the received value of byte array", (boolean)Arrays.equals(b3, s));
                }
                return null;
            }
        });
    }

    public void testClearRegionDataInQueue() throws Throwable {
        this.doTestClearRegion(100000, false);
    }

    public void testClearRegionDataInHDFS() throws Throwable {
        this.doTestClearRegion(1, true);
    }

    public void doTestClearRegion(int batchInterval, boolean waitForWriteToHDFS) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numEntries = 400;
        String name = this.getName();
        String folderPath = this.tmpDir + "/" + name;
        String uniqueName = name;
        int port0 = this.createServerRegion(vm0, 7, 31, 40, folderPath, uniqueName, batchInterval, false, true);
        int port1 = this.createServerRegion(vm1, 7, 31, 40, folderPath, uniqueName, batchInterval, false, true);
        this.doPuts(vm0, uniqueName, 400);
        if (waitForWriteToHDFS) {
            this.verifyDataInHDFS(vm0, uniqueName, true, true, waitForWriteToHDFS, 400);
        }
        this.simulateClear(uniqueName, vm0, vm1);
        this.validateEmpty(vm0, 400, uniqueName);
        this.validateEmpty(vm1, 400, uniqueName);
        this.verifyDataInHDFS(vm0, uniqueName, false, false, waitForWriteToHDFS, 400);
        this.verifyDataInHDFS(vm1, uniqueName, false, false, waitForWriteToHDFS, 400);
        this.closeCache(vm0);
        this.closeCache(vm1);
        AsyncInvocation async0 = this.createServerRegionAsync(vm0, 7, 31, 200, folderPath, uniqueName, 100000, false, true);
        AsyncInvocation async1 = this.createServerRegionAsync(vm1, 7, 31, 200, folderPath, uniqueName, 100000, false, true);
        async0.getResult();
        async1.getResult();
        this.validateEmpty(vm0, 400, uniqueName);
        this.validateEmpty(vm1, 400, uniqueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateClear(final String name, VM ... vms) throws Throwable {
        this.setGfxdSystem(true);
        try {
            int i;
            SerializableCallable clear = new SerializableCallable("clear"){

                public Object call() throws Exception {
                    PartitionedRegion r = (PartitionedRegion)RegionWithHDFSBasicDUnitTest.this.getRootRegion(name);
                    r.clearLocalPrimaries();
                    return null;
                }
            };
            AsyncInvocation[] async = new AsyncInvocation[vms.length];
            for (i = 0; i < vms.length; ++i) {
                async[i] = vms[i].invokeAsync(clear);
            }
            for (i = 0; i < async.length; ++i) {
                async[i].getResult();
            }
        }
        finally {
            this.setGfxdSystem(false);
        }
    }

    protected void setGfxdSystem(final boolean isGfxd) {
        SerializableRunnable setGfxd = new SerializableRunnable(){

            @Override
            public void run() {
                if (isGfxd) {
                    GemFireCacheImpl.setGFXDSystemForTests();
                } else {
                    GemFireCacheImpl.setGFXDSystem((boolean)false);
                }
            }
        };
        setGfxd.run();
        RegionWithHDFSBasicDUnitTest.invokeInEveryVM(setGfxd);
    }

    public void DISABLED_testLocalDestroy() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numEntries = 200;
        String folderPath = this.tmpDir + "/testLocalDestroy";
        String uniqueName = "testLocalDestroy";
        this.createServerRegion(vm0, 7, 31, 40, folderPath, "testLocalDestroy", 1, false, true);
        this.createServerRegion(vm1, 7, 31, 40, folderPath, "testLocalDestroy", 1, false, true);
        this.doPuts(vm0, "testLocalDestroy", numEntries);
        this.verifyDataInHDFS(vm0, "testLocalDestroy", true, true, true, numEntries);
        this.validate(vm0, "testLocalDestroy", numEntries);
        SerializableCallable localDestroy = new SerializableCallable("local destroy"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testLocalDestroy");
                r.localDestroyRegion();
                return null;
            }
        };
        vm0.invoke(localDestroy);
        this.verifyNoQOrPR(vm0);
        this.validate(vm1, "testLocalDestroy", numEntries);
        vm1.invoke(localDestroy);
        this.verifyNoQOrPR(vm1);
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.createServerRegion(vm0, 7, 31, 40, folderPath, "testLocalDestroy", 1, false, true);
        this.validate(vm0, "testLocalDestroy", numEntries);
    }

    public void testGlobalDestroyWithHDFSData() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String folderPath = this.tmpDir + "/testGlobalDestroyWithHDFSData";
        String uniqueName = "testGlobalDestroyWithHDFSData";
        int numEntries = 200;
        int port0 = this.createServerRegion(vm0, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        int port1 = this.createServerRegion(vm1, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        this.doPuts(vm0, "testGlobalDestroyWithHDFSData", numEntries);
        this.verifyDataInHDFS(vm0, "testGlobalDestroyWithHDFSData", true, true, false, numEntries);
        SerializableCallable globalDestroy = new SerializableCallable("destroy"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testGlobalDestroyWithHDFSData");
                r.destroyRegion();
                return null;
            }
        };
        vm0.invoke(globalDestroy);
        this.verifyNoQOrPR(vm0);
        this.verifyNoQOrPR(vm1);
        this.verifyNoHDFSData(vm0, "testGlobalDestroyWithHDFSData");
        this.verifyNoHDFSData(vm1, "testGlobalDestroyWithHDFSData");
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.createServerRegion(vm0, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        this.createServerRegion(vm1, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        this.validateEmpty(vm0, numEntries, "testGlobalDestroyWithHDFSData");
        this.validateEmpty(vm1, numEntries, "testGlobalDestroyWithHDFSData");
    }

    public void testGlobalDestroyWithQueueData() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String folderPath = this.tmpDir + "/testGlobalDestroyWithQueueData";
        String uniqueName = "testGlobalDestroyWithQueueData";
        int numEntries = 200;
        int port0 = this.createServerRegion(vm0, 7, 31, 40, folderPath, "testGlobalDestroyWithQueueData", 10000, false, true);
        int port1 = this.createServerRegion(vm1, 7, 31, 40, folderPath, "testGlobalDestroyWithQueueData", 10000, false, true);
        this.doPuts(vm0, "testGlobalDestroyWithQueueData", numEntries);
        SerializableCallable globalDestroy = new SerializableCallable("destroy"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testGlobalDestroyWithQueueData");
                r.destroyRegion();
                return null;
            }
        };
        vm0.invoke(globalDestroy);
        this.verifyNoQOrPR(vm0);
        this.verifyNoQOrPR(vm1);
        this.verifyNoHDFSData(vm0, "testGlobalDestroyWithQueueData");
        this.verifyNoHDFSData(vm1, "testGlobalDestroyWithQueueData");
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.createServerRegion(vm0, 7, 31, 40, folderPath, "testGlobalDestroyWithQueueData", 1, false, true);
        this.createServerRegion(vm1, 7, 31, 40, folderPath, "testGlobalDestroyWithQueueData", 1, false, true);
        this.validateEmpty(vm0, numEntries, "testGlobalDestroyWithQueueData");
        this.validateEmpty(vm1, numEntries, "testGlobalDestroyWithQueueData");
    }

    public void verifyNoQOrPR(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)RegionWithHDFSBasicDUnitTest.this.getCache();
                TestCase.assertEquals((Object)Collections.EMPTY_SET, (Object)cache.getAsyncEventQueues());
                TestCase.assertEquals((Object)Collections.EMPTY_SET, (Object)cache.getPartitionedRegions());
            }
        });
    }

    public void verifyNoHDFSData(final VM vm, final String uniqueName) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws IOException {
                Path path;
                HDFSStoreImpl hdfsStore = (HDFSStoreImpl)RegionWithHDFSBasicDUnitTest.this.getCache().findHDFSStore(uniqueName);
                FileSystem fs = hdfsStore.getFileSystem();
                if (fs.exists(path = new Path(hdfsStore.getHomeDir(), uniqueName))) {
                    RegionWithHDFSBasicDUnitTest.this.dumpFiles(vm, uniqueName);
                    TestCase.fail((String)("Found files in " + path));
                }
                return null;
            }
        });
    }

    @Override
    protected AsyncInvocation doAsyncPuts(VM vm, String regionName, int start, int end, String suffix) throws Exception {
        return this.doAsyncPuts(vm, regionName, start, end, suffix, "");
    }

    protected AsyncInvocation doAsyncPuts(VM vm, final String regionName, final int start, final int end, final String suffix, final String value) throws Exception {
        return vm.invokeAsync(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion(regionName);
                String v = "V";
                if (!value.equals("")) {
                    v = value;
                }
                RegionWithHDFSBasicDUnitTest.this.getCache().getLogger().info("Putting entries ");
                for (int i = start; i < end; ++i) {
                    r.put((Object)("K" + i), (Object)(v + i + suffix));
                }
                return null;
            }
        });
    }

    public void testGlobalDestroyFromAccessor() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String folderPath = this.tmpDir + "/testGlobalDestroyWithHDFSData";
        String uniqueName = "testGlobalDestroyWithHDFSData";
        int numEntries = 200;
        int port0 = this.createServerRegion(vm0, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        int port1 = this.createServerRegion(vm1, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        this.createServerAccessor(vm2, 7, 40, "testGlobalDestroyWithHDFSData");
        this.doPuts(vm0, "testGlobalDestroyWithHDFSData", numEntries);
        this.verifyDataInHDFS(vm0, "testGlobalDestroyWithHDFSData", true, true, false, numEntries);
        SerializableCallable globalDestroy = new SerializableCallable("destroy"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getRootRegion("testGlobalDestroyWithHDFSData");
                r.destroyRegion();
                return null;
            }
        };
        vm2.invoke(globalDestroy);
        this.verifyNoQOrPR(vm0);
        this.verifyNoQOrPR(vm1);
        this.verifyNoHDFSData(vm0, "testGlobalDestroyWithHDFSData");
        this.verifyNoHDFSData(vm1, "testGlobalDestroyWithHDFSData");
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        this.createServerRegion(vm0, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        this.createServerRegion(vm1, 7, 31, 40, folderPath, "testGlobalDestroyWithHDFSData", 1, false, true);
        this.validateEmpty(vm0, numEntries, "testGlobalDestroyWithHDFSData");
        this.validateEmpty(vm1, numEntries, "testGlobalDestroyWithHDFSData");
    }

    public void testWOFileSizeParam() throws Throwable {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String homeDir = "./testWOConfigParams";
        String uniqueName = this.getName();
        String value = "V";
        for (int i = 0; i < 20; ++i) {
            value = value + value;
        }
        this.createServerRegion(vm0, 1, 1, 500, homeDir, uniqueName, 5, true, false, 2000L, 2L);
        this.createServerRegion(vm1, 1, 1, 500, homeDir, uniqueName, 5, true, false, 2000L, 2L);
        AsyncInvocation a1 = this.doAsyncPuts(vm0, uniqueName, 1, 3, "vm0", value);
        AsyncInvocation a2 = this.doAsyncPuts(vm1, uniqueName, 2, 4, "vm1", value);
        a1.join();
        a2.join();
        Thread.sleep(4000L);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        AsyncInvocation async1 = this.createServerRegionAsync(vm0, 1, 1, 500, homeDir, uniqueName, 5, true, false, 2000L, 2L);
        AsyncInvocation async2 = this.createServerRegionAsync(vm1, 1, 1, 500, homeDir, uniqueName, 5, true, false, 2000L, 2L);
        async1.getResult();
        async2.getResult();
        this.verifyTwoHDFSFilesWithTwoEntries(vm0, uniqueName, value);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
    }

    public void testWOTimeForRollOverParam() throws Throwable {
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String homeDir = "./testWOConfigParams";
        String uniqueName = this.getName();
        this.createServerRegion(vm0, 1, 1, 500, homeDir, uniqueName, 5, true, false, 4L, 1L);
        this.createServerRegion(vm1, 1, 1, 500, homeDir, uniqueName, 5, true, false, 4L, 1L);
        AsyncInvocation a1 = this.doAsyncPuts(vm0, uniqueName, 1, 8, "vm0");
        AsyncInvocation a2 = this.doAsyncPuts(vm1, uniqueName, 4, 10, "vm1");
        a1.join();
        a2.join();
        Thread.sleep(8000L);
        a1 = this.doAsyncPuts(vm0, uniqueName, 10, 18, "vm0");
        a2 = this.doAsyncPuts(vm1, uniqueName, 14, 20, "vm1");
        a1.join();
        a2.join();
        Thread.sleep(8000L);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        AsyncInvocation async1 = this.createServerRegionAsync(vm0, 1, 1, 500, homeDir, uniqueName, 5, true, false, 4L, 1L);
        AsyncInvocation async2 = this.createServerRegionAsync(vm1, 1, 1, 500, homeDir, uniqueName, 5, true, false, 4L, 1L);
        async1.getResult();
        async2.getResult();
        this.verifyTwoHDFSFiles(vm0, uniqueName);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        RegionWithHDFSBasicDUnitTest.disconnectFromDS();
    }

    private void createServerAccessor(VM vm, final int totalnumOfBuckets, final int maximumEntries, final String uniqueName) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(totalnumOfBuckets);
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                af.setPartitionAttributes(paf.create());
                Region r = RegionWithHDFSBasicDUnitTest.this.createRootRegion(uniqueName, af.create());
                TestCase.assertTrue((!((PartitionedRegion)r).isDataStore() ? 1 : 0) != 0);
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    @Override
    protected void verifyHDFSData(VM vm, String uniqueName) throws Exception {
        HashMap<String, HashMap<String, String>> filesToEntriesMap = this.createFilesAndEntriesMap(vm, uniqueName, uniqueName);
        HashMap<String, String> entriesMap = new HashMap<String, String>();
        for (HashMap<String, String> v : filesToEntriesMap.values()) {
            entriesMap.putAll(v);
        }
        this.verifyInEntriesMap(entriesMap, 1, 50, "vm0");
        this.verifyInEntriesMap(entriesMap, 40, 100, "vm1");
        this.verifyInEntriesMap(entriesMap, 40, 100, "vm2");
        this.verifyInEntriesMap(entriesMap, 90, 150, "vm3");
    }

    protected void verifyTwoHDFSFiles(VM vm, String uniqueName) throws Exception {
        HashMap<String, HashMap<String, String>> filesToEntriesMap = this.createFilesAndEntriesMap(vm, uniqueName, uniqueName);
        RegionWithHDFSBasicDUnitTest.assertTrue((String)("there should be exactly two files, but there are " + filesToEntriesMap.size()), (filesToEntriesMap.size() == 2 ? 1 : 0) != 0);
        long timestamp = Long.MAX_VALUE;
        String olderFile = null;
        Object newFile = null;
        for (Map.Entry<String, HashMap<String, String>> e : filesToEntriesMap.entrySet()) {
            String fileName = e.getKey().substring(0, e.getKey().length() - ".shop".length());
            long newTimeStamp = Long.parseLong(fileName.substring(fileName.indexOf("-") + 1, fileName.lastIndexOf("-")));
            if (newTimeStamp >= timestamp) continue;
            olderFile = e.getKey();
            timestamp = newTimeStamp;
        }
        this.verifyInEntriesMap(filesToEntriesMap.get(olderFile), 1, 8, "vm0");
        this.verifyInEntriesMap(filesToEntriesMap.get(olderFile), 4, 10, "vm1");
        filesToEntriesMap.remove(olderFile);
        this.verifyInEntriesMap(filesToEntriesMap.values().iterator().next(), 10, 18, "vm0");
        this.verifyInEntriesMap(filesToEntriesMap.values().iterator().next(), 14, 20, "vm1");
    }

    protected void verifyTwoHDFSFilesWithTwoEntries(VM vm, String uniqueName, String value) throws Exception {
        HashMap<String, HashMap<String, String>> filesToEntriesMap = this.createFilesAndEntriesMap(vm, uniqueName, uniqueName);
        RegionWithHDFSBasicDUnitTest.assertTrue((String)("there should be exactly two files, but there are " + filesToEntriesMap.size()), (filesToEntriesMap.size() == 2 ? 1 : 0) != 0);
        HashMap<String, String> entriesMap = new HashMap<String, String>();
        for (HashMap<String, String> v : filesToEntriesMap.values()) {
            entriesMap.putAll(v);
        }
        RegionWithHDFSBasicDUnitTest.assertTrue((String)("Expected key K1 received  " + (String)entriesMap.get(value + "1vm0")), (boolean)((String)entriesMap.get(value + "1vm0")).equals("K1"));
        RegionWithHDFSBasicDUnitTest.assertTrue((String)("Expected key K2 received  " + (String)entriesMap.get(value + "2vm0")), (boolean)((String)entriesMap.get(value + "2vm0")).equals("K2"));
        RegionWithHDFSBasicDUnitTest.assertTrue((String)("Expected key K2 received  " + (String)entriesMap.get(value + "2vm1")), (boolean)((String)entriesMap.get(value + "2vm1")).equals("K2"));
        RegionWithHDFSBasicDUnitTest.assertTrue((String)("Expected key K3 received  " + (String)entriesMap.get(value + "3vm1")), (boolean)((String)entriesMap.get(value + "3vm1")).equals("K3"));
    }

    public void testPRAccessor() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM accessor2 = host.getVM(3);
        final String regionName = this.getName();
        final String storeName = "store_" + regionName;
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                HDFSStoreFactory storefactory = RegionWithHDFSBasicDUnitTest.this.getCache().createHDFSStoreFactory();
                storefactory.setHomeDir("./" + regionName);
                storefactory.create(storeName);
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                af.setHDFSStoreName(storeName);
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().createRegionFactory(af.create()).create(regionName);
                r.put((Object)"key1", (Object)"value1");
                return null;
            }
        };
        SerializableCallable createAccessorRegion = new SerializableCallable(){

            public Object call() throws Exception {
                HDFSStoreFactory storefactory = RegionWithHDFSBasicDUnitTest.this.getCache().createHDFSStoreFactory();
                storefactory.setHomeDir("./" + regionName);
                storefactory.create(storeName);
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setLocalMaxMemory(0);
                af.setPartitionAttributes(paf.create());
                af.setHDFSStoreName(storeName);
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().createRegionFactory(af.create()).create(regionName);
                r.localDestroyRegion();
                af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                af.setPartitionAttributes(paf.create());
                RegionWithHDFSBasicDUnitTest.this.getCache().createRegionFactory(af.create()).create(regionName);
                return null;
            }
        };
        datastore1.invoke(createRegion);
        accessor.invoke(createAccessorRegion);
        datastore2.invoke(createRegion);
        accessor2.invoke(createAccessorRegion);
    }

    public void testPUTDMLSupport() {
        this.doPUTDMLWork(false);
    }

    public void testPUTDMLBulkSupport() {
        this.doPUTDMLWork(true);
    }

    private void doPUTDMLWork(final boolean isPutAll) {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        final String regionName = this.getName();
        this.createServerRegion(vm1, 7, 1, 50, "./" + regionName, regionName, 1000);
        this.createServerRegion(vm2, 7, 1, 50, "./" + regionName, regionName, 1000);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                LocalRegion lr = (LocalRegion)r;
                SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                long readsFromHDFS = stats.getRead().getCount();
                TestCase.assertEquals((long)0L, (long)readsFromHDFS);
                if (isPutAll) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("key0", "value0");
                    DistributedPutAllOperation ev = lr.newPutAllOperation(m);
                    lr.basicPutAll(m, ev, null);
                    m.clear();
                    for (int i = 1; i < 100; ++i) {
                        m.put("key" + i, "value" + i);
                    }
                    ev = lr.newPutAllOperation(m);
                    lr.basicPutAll(m, ev, null);
                } else {
                    for (int i = 0; i < 100; ++i) {
                        r.put((Object)("key" + i), (Object)("value" + i));
                    }
                }
                return null;
            }
        });
        SerializableCallable getHDFSReadCount = new SerializableCallable(){

            public Object call() throws Exception {
                SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                return stats.getRead().getCount();
            }
        };
        long vm1Count = (Long)vm1.invoke(getHDFSReadCount);
        long vm2Count = (Long)vm2.invoke(getHDFSReadCount);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)100L, (long)(vm1Count + vm2Count));
        RegionWithHDFSBasicDUnitTest.pause(10000);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion lr = (LocalRegion)RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                if (isPutAll) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("key0", "value0");
                    DistributedPutAllOperation ev = lr.newPutAllForPUTDmlOperation(m);
                    lr.basicPutAll(m, ev, null);
                    m.clear();
                    for (int i = 1; i < 200; ++i) {
                        m.put("key" + i, "value" + i);
                    }
                    ev = lr.newPutAllForPUTDmlOperation(m);
                    lr.basicPutAll(m, ev, null);
                } else {
                    for (int i = 0; i < 200; ++i) {
                        EntryEventImpl ev = lr.newPutEntryEvent((Object)("key" + i), (Object)("value" + i), null);
                        lr.validatedPut(ev, System.currentTimeMillis());
                    }
                }
                return null;
            }
        });
        vm1Count = (Long)vm1.invoke(getHDFSReadCount);
        vm2Count = (Long)vm2.invoke(getHDFSReadCount);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)100L, (long)(vm1Count + vm2Count));
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 0; i < 200; ++i) {
                    TestCase.assertEquals((Object)("value" + i), (Object)r.get((Object)("key" + i)));
                }
                return null;
            }
        });
    }

    public void testGetOperationalData() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        final String regionName = this.getName();
        this.createServerRegion(vm1, 7, 1, 50, "./" + regionName, regionName, 1000);
        this.createServerRegion(vm2, 7, 1, 50, "./" + regionName, regionName, 1000);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                long readsFromHDFS = stats.getRead().getCount();
                TestCase.assertEquals((long)0L, (long)readsFromHDFS);
                for (int i = 0; i < 100; ++i) {
                    r.getCache().getLogger().info("SWAP:DOING PUT:key" + i);
                    r.put((Object)("key" + i), (Object)("value" + i));
                }
                return null;
            }
        });
        SerializableCallable getHDFSReadCount = new SerializableCallable(){

            public Object call() throws Exception {
                SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                return stats.getRead().getCount();
            }
        };
        long vm1Count = (Long)vm1.invoke(getHDFSReadCount);
        long vm2Count = (Long)vm2.invoke(getHDFSReadCount);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)100L, (long)(vm1Count + vm2Count));
        RegionWithHDFSBasicDUnitTest.pause(10000);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 0; i < 200; ++i) {
                    if (i < 100) {
                        r.getCache().getLogger().info("SWAP:DOING GET:key" + i);
                        TestCase.assertEquals((Object)("value" + i), (Object)r.get((Object)("key" + i)));
                        continue;
                    }
                    TestCase.assertNull((Object)r.get((Object)("key" + i)));
                }
                return null;
            }
        });
        vm1Count = (Long)vm1.invoke(getHDFSReadCount);
        vm2Count = (Long)vm2.invoke(getHDFSReadCount);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)250L, (long)(vm1Count + vm2Count));
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                LocalRegion lr = (LocalRegion)r;
                int numEntries = 0;
                for (int i = 0; i < 200; ++i) {
                    r.getCache().getLogger().info("SWAP:DOING GET NO READ:key" + i);
                    Object val = lr.get((Object)("key" + i), null, true, false, false, null, lr.discoverJTA(), null, null, false, false);
                    if (val == null) continue;
                    ++numEntries;
                }
                TestCase.assertEquals((int)50, (int)numEntries);
                return null;
            }
        });
        vm1Count = (Long)vm1.invoke(getHDFSReadCount);
        vm2Count = (Long)vm2.invoke(getHDFSReadCount);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)250L, (long)(vm1Count + vm2Count));
        SerializableCallable getUsingDataView = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                LocalRegion lr = (LocalRegion)r;
                PartitionedRegion pr = (PartitionedRegion)lr;
                long numEntries = 0L;
                for (int i = 0; i < 200; ++i) {
                    InternalDataView idv = lr.getDataView();
                    lr.getLogWriterI18n().fine("SWAP:DATAVIEW");
                    Object val = idv.getLocally((Object)("key" + i), null, PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Object)("key" + i)), lr, true, true, null, null, false, false);
                    if (val == null) continue;
                    ++numEntries;
                }
                return numEntries;
            }
        };
        vm1Count = (Long)vm1.invoke(getUsingDataView);
        vm2Count = (Long)vm2.invoke(getUsingDataView);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)100L, (long)(vm1Count + vm2Count));
        vm1Count = (Long)vm1.invoke(getHDFSReadCount);
        vm2Count = (Long)vm2.invoke(getHDFSReadCount);
        RegionWithHDFSBasicDUnitTest.assertEquals((long)250L, (long)(vm1Count + vm2Count));
    }

    public void testSizeEstimate() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        this.createServerRegion(vm1, 7, 1, 50, "./" + regionName, regionName, 1000);
        this.createServerRegion(vm2, 7, 1, 50, "./" + regionName, regionName, 1000);
        this.createServerRegion(vm3, 7, 1, 50, "./" + regionName, regionName, 1000);
        int size = 226;
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                LocalRegion lr = (LocalRegion)r;
                for (int i = 0; i < 226; ++i) {
                    r.put((Object)("key" + i), (Object)("value" + i));
                }
                return null;
            }
        });
        RegionWithHDFSBasicDUnitTest.pause(10000);
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                LocalRegion lr = (LocalRegion)r;
                lr.getLogWriterI18n().fine("SWAP:callingsizeEstimate");
                long estimate = lr.sizeEstimate();
                double err = (double)Math.abs(estimate - 226L) / 226.0;
                System.out.println("SWAP:estimate:" + estimate);
                TestCase.assertTrue((err < 0.2 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    public void testForceAsyncMajorCompaction() throws Exception {
        this.doForceCompactionTest(true, false);
    }

    public void testForceSyncMajorCompaction() throws Exception {
        this.doForceCompactionTest(true, true);
    }

    private void doForceCompactionTest(final boolean isMajor, final boolean isSynchronous) throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        this.createServerRegion(vm1, 7, 1, 50, "./" + regionName, regionName, 1000);
        this.createServerRegion(vm2, 7, 1, 50, "./" + regionName, regionName, 1000);
        this.createServerRegion(vm3, 7, 1, 50, "./" + regionName, regionName, 1000);
        SerializableCallable noCompaction = new SerializableCallable(){

            public Object call() throws Exception {
                SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                if (isMajor) {
                    TestCase.assertEquals((long)0L, (long)stats.getMajorCompaction().getCount());
                } else {
                    TestCase.assertEquals((long)0L, (long)stats.getMinorCompaction().getCount());
                }
                return null;
            }
        };
        vm1.invoke(noCompaction);
        vm2.invoke(noCompaction);
        vm3.invoke(noCompaction);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 0; i < 500; ++i) {
                    r.put((Object)("key" + i), (Object)("value" + i));
                    if (i % 100 != 0) continue;
                    DistributedTestCase.pause(3000);
                }
                DistributedTestCase.pause(3000);
                PartitionedRegion pr = (PartitionedRegion)r;
                long lastCompactionTS = pr.lastMajorHDFSCompaction();
                TestCase.assertEquals((long)0L, (long)lastCompactionTS);
                long beforeCompact = System.currentTimeMillis();
                pr.forceHDFSCompaction(true, Integer.valueOf(isSynchronous ? 0 : 1));
                if (isSynchronous) {
                    SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                    TestCase.assertTrue((stats.getMajorCompaction().getCount() > 0L ? 1 : 0) != 0);
                    TestCase.assertTrue((pr.lastMajorHDFSCompaction() >= beforeCompact ? 1 : 0) != 0);
                }
                return null;
            }
        });
        if (!isSynchronous) {
            SerializableCallable verifyCompactionStat = new SerializableCallable(){

                public Object call() throws Exception {
                    final SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return stats.getMajorCompaction().getCount() > 0L;
                        }

                        @Override
                        public String description() {
                            return "Major compaction stat not > 0";
                        }
                    }, 30000L, 1000L, true);
                    return null;
                }
            };
            vm1.invoke(verifyCompactionStat);
            vm2.invoke(verifyCompactionStat);
            vm3.invoke(verifyCompactionStat);
        } else {
            SerializableCallable verifyCompactionStat = new SerializableCallable(){

                public Object call() throws Exception {
                    SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/" + regionName);
                    TestCase.assertTrue((stats.getMajorCompaction().getCount() > 0L ? 1 : 0) != 0);
                    return null;
                }
            };
            vm2.invoke(verifyCompactionStat);
            vm3.invoke(verifyCompactionStat);
        }
    }

    public void testFlushQueue() throws Exception {
        this.doFlushQueue(false);
    }

    public void testFlushQueueWO() throws Exception {
        this.doFlushQueue(true);
    }

    private void doFlushQueue(boolean wo) throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        this.createServerRegion(vm1, 7, 1, 50, "./" + regionName, regionName, 300000, wo, false);
        this.createServerRegion(vm2, 7, 1, 50, "./" + regionName, regionName, 300000, wo, false);
        this.createServerRegion(vm3, 7, 1, 50, "./" + regionName, regionName, 300000, wo, false);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 0; i < 500; ++i) {
                    pr.put((Object)("key" + i), (Object)("value" + i));
                }
                pr.flushHDFSQueue(0);
                return null;
            }
        });
        SerializableCallable verify = new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)RegionWithHDFSBasicDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertEquals((int)0, (int)pr.getHDFSEventQueueStats().getEventQueueSize());
                return null;
            }
        };
        vm1.invoke(verify);
        vm2.invoke(verify);
        vm3.invoke(verify);
    }

    private static class CustomerDelta
    implements Serializable,
    Delta {
        private String name;
        private String address;
        private boolean nameChanged;
        private boolean addressChanged;

        public CustomerDelta(CustomerDelta o) {
            this.address = o.address;
            this.name = o.name;
        }

        public CustomerDelta(String name, String address) {
            this.name = name;
            this.address = address;
        }

        public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
            boolean addressC;
            boolean nameC = in.readBoolean();
            if (nameC) {
                this.name = in.readUTF();
            }
            if (addressC = in.readBoolean()) {
                this.address = in.readUTF();
            }
        }

        public boolean hasDelta() {
            return this.nameChanged || this.addressChanged;
        }

        public void toDelta(DataOutput out) throws IOException {
            out.writeBoolean(this.nameChanged);
            if (this.nameChanged) {
                out.writeUTF(this.name);
            }
            out.writeBoolean(this.addressChanged);
            if (this.addressChanged) {
                out.writeUTF(this.address);
            }
        }

        public void setName(String name) {
            this.nameChanged = true;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAddress(String address) {
            this.addressChanged = true;
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CustomerDelta)) {
                return false;
            }
            CustomerDelta other = (CustomerDelta)obj;
            return this.name.equals(other.name) && this.address.equals(other.address);
        }

        public int hashCode() {
            return this.address.hashCode() + this.name.hashCode();
        }

        public String toString() {
            return "name=" + this.name + "address=" + this.address;
        }
    }
}

