/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.internal.RegionWithHDFSBasicDUnitTest;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapTestUtil;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import java.util.Properties;

public class RegionWithHDFSOffHeapBasicDUnitTest
extends RegionWithHDFSBasicDUnitTest {
    public RegionWithHDFSOffHeapBasicDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        SerializableRunnable checkOrphans = new SerializableRunnable(){

            @Override
            public void run() {
                if (CacheTestCase.hasCache()) {
                    OffHeapTestUtil.checkOrphans();
                }
            }
        };
        checkOrphans.run();
        RegionWithHDFSOffHeapBasicDUnitTest.invokeInEveryVM(checkOrphans);
        super.tearDown2();
    }

    @Override
    public void testDelta() {
    }

    @Override
    protected SerializableCallable getCreateRegionCallable(final int totalnumOfBuckets, final int batchSizeMB, final int maximumEntries, final String folderPath, final String uniqueName, final int batchInterval, final boolean queuePersistent, final boolean writeonly, final long timeForRollover, final long maxFileSize) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(totalnumOfBuckets);
                paf.setRedundantCopies(1);
                HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
                hqf.setBatchSizeMB(batchSizeMB);
                hqf.setPersistent(queuePersistent);
                hqf.setMaximumQueueMemory(3);
                hqf.setBatchTimeInterval(batchInterval);
                af.setHDFSStoreName(uniqueName);
                af.setPartitionAttributes(paf.create());
                HDFSStoreFactory hsf = RegionWithHDFSOffHeapBasicDUnitTest.this.getCache().createHDFSStoreFactory();
                String homeDir = RegionWithHDFSOffHeapBasicDUnitTest.this.tmpDir + "/" + folderPath;
                hsf.setHomeDir(homeDir);
                hsf.setHDFSEventQueueAttributes(hqf.create());
                if (timeForRollover != -1L) {
                    hsf.setFileRolloverInterval((int)timeForRollover);
                    System.setProperty("gemfire.HDFSRegionDirector.FILE_ROLLOVER_TASK_INTERVAL_SECONDS", "1");
                }
                if (maxFileSize != -1L) {
                    hsf.setMaxFileSize((int)maxFileSize);
                }
                hsf.create(uniqueName);
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                af.setHDFSWriteOnly(writeonly);
                af.setEnableOffHeapMemory(true);
                Region r = RegionWithHDFSOffHeapBasicDUnitTest.this.createRootRegion(uniqueName, af.create());
                ((LocalRegion)r).setIsTest();
                return 0;
            }
        };
        return createRegion;
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = super.getDistributedSystemProperties();
        props.setProperty("off-heap-memory-size", "50m");
        return props;
    }

    static {
        System.setProperty("gemfire.trackOffHeapRefCounts", "true");
    }
}

