/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.management;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.LocalStatListener;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.control.ResourceAdvisor;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.control.TestMemoryThresholdListener;
import com.gemstone.gemfire.internal.concurrent.AI;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import util.TestException;

public class MemoryThresholdsDUnitTest
extends BridgeTestCase {
    final String expectedEx = LocalizedStrings.MemoryMonitor_MEMBER_ABOVE_CRITICAL_THRESHOLD.getRawText().replaceAll("\\{[0-9]+\\}", ".*?");
    final String addExpectedExString = "<ExpectedException action=add>" + this.expectedEx + "</ExpectedException>";
    final String removeExpectedExString = "<ExpectedException action=remove>" + this.expectedEx + "</ExpectedException>";
    final String expectedBelow = LocalizedStrings.MemoryMonitor_MEMBER_BELOW_CRITICAL_THRESHOLD.getRawText().replaceAll("\\{[0-9]+\\}", ".*?");
    final String addExpectedBelow = "<ExpectedException action=add>" + this.expectedBelow + "</ExpectedException>";
    final String removeExpectedBelow = "<ExpectedException action=remove>" + this.expectedBelow + "</ExpectedException>";
    final String expectedFunctionEx = " cannot be executed";
    final String addExpectedFunctionExString = "<ExpectedException action=add> cannot be executed</ExpectedException>";
    final String removeExpectedFunctionExString = "<ExpectedException action=remove> cannot be executed</ExpectedException>";
    SerializableCallable getDistributedMember = new SerializableCallable(){

        public Object call() throws Exception {
            return ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getMyId();
        }
    };
    private SerializableCallable setHeapMemoryMonitorTestMode = new SerializableCallable(){

        public Object call() throws Exception {
            HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
            return null;
        }
    };
    private SerializableCallable resetResourceManager = new SerializableCallable(){

        public Object call() throws Exception {
            InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager();
            Set listeners = irm.getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY);
            for (ResourceListener l : listeners) {
                if (!(l instanceof TestMemoryThresholdListener)) continue;
                ((TestMemoryThresholdListener)l).resetThresholdCalls();
            }
            irm.getHeapMonitor().setTestMaxMemoryBytes(0L);
            HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
            return null;
        }
    };
    private SerializableCallable resetQueryMonitor = new SerializableCallable(){

        public Object call() throws Exception {
            QueryMonitor.clearLowMemory();
            DefaultQuery.testHook = null;
            return null;
        }
    };
    private SerializableRunnable addExpectedException = new SerializableRunnable("addExpectedEx"){

        @Override
        public void run() {
            MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
        }
    };
    private SerializableRunnable removeExpectedException = new SerializableRunnable("removeExpectedException"){

        @Override
        public void run() {
            MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
        }
    };
    private SerializableRunnable addExpectedFunctionException = new SerializableRunnable("addExpectedFunctionException"){

        @Override
        public void run() {
            MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
        }
    };
    private SerializableRunnable removeExpectedFunctionException = new SerializableRunnable("removeExpectedFunctionException"){

        @Override
        public void run() {
            MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
        }
    };

    public MemoryThresholdsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        MemoryThresholdsDUnitTest.invokeInEveryVM(this.setHeapMemoryMonitorTestMode);
    }

    @Override
    public void tearDown2() throws Exception {
        MemoryThresholdsDUnitTest.invokeInEveryVM(this.resetResourceManager);
        super.tearDown2();
        MemoryThresholdsDUnitTest.invokeInEveryVM(this.resetQueryMonitor);
    }

    public void testPRClientPutRejection() throws Exception {
        this.doClientServerTest("parRegReject", true);
    }

    public void testDistributedRegionClientPutRejection() throws Exception {
        this.doClientServerTest("distrReject", false);
    }

    private void doClientServerTest(String regionName, boolean createPR) throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        ServerPorts ports = this.startCacheServer(server, 0.0f, 90.0f, regionName, createPR, false, 0);
        this.startClient(client, server, ports.getPort(), regionName);
        this.doPuts(client, regionName, false, false);
        this.doPutAlls(client, regionName, false, false, Range.DEFAULT);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager();
                irm.setCriticalHeapPercentage(90.0f);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
                irm.getHeapMonitor().updateStateAndSendEvent(950L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
                return null;
            }
        });
        this.doPuts(client, regionName, true, false);
        this.doPutAlls(client, regionName, true, false, new Range(Range.DEFAULT, Range.DEFAULT.width() + 1));
    }

    public void testDistributedRegionRemotePutRejectionLocalDestroy() throws Exception {
        this.doDistributedRegionRemotePutRejection(true, false);
    }

    public void testDistributedRegionRemotePutRejectionCacheClose() throws Exception {
        this.doDistributedRegionRemotePutRejection(false, true);
    }

    public void testDistributedRegionRemotePutRejectionBelowThreshold() throws Exception {
        this.doDistributedRegionRemotePutRejection(false, false);
    }

    private void doDistributedRegionRemotePutRejection(boolean localDestroy, boolean cacheClose) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        String regionName = "rejectRemoteOp";
        ServerPorts ports1 = this.startCacheServer(server1, 0.0f, 0.0f, "rejectRemoteOp", false, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 0.0f, 90.0f, "rejectRemoteOp", false, false, 0);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.doPuts(server1, "rejectRemoteOp", false, false);
        this.doPutAlls(server1, "rejectRemoteOp", false, false, Range.DEFAULT);
        this.setUsageAboveCriticalThreshold(server2);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.doPuts(server1, "rejectRemoteOp", false, true);
        Range r1 = new Range(Range.DEFAULT, Range.DEFAULT.width() + 1);
        this.doPutAlls(server1, "rejectRemoteOp", false, true, r1);
        if (localDestroy) {
            server2.invoke(new SerializableCallable("local destroy"){

                public Object call() throws Exception {
                    Region r = MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("rejectRemoteOp");
                    r.localDestroyRegion();
                    return null;
                }
            });
        } else if (cacheClose) {
            server2.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    MemoryThresholdsDUnitTest.this.getCache().close();
                    return null;
                }
            });
        } else {
            this.setUsageBelowEviction(server2);
        }
        server1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "remote localRegionDestroyed message not received";
                    }

                    @Override
                    public boolean done() {
                        DistributedRegion dr = (DistributedRegion)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("rejectRemoteOp");
                        return dr.getMemoryThresholdReachedMembers().size() == 0;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
        this.doPuts(server1, "rejectRemoteOp", false, false);
        Range r2 = new Range(r1, r1.width() + 1);
        this.doPutAlls(server1, "rejectRemoteOp", false, false, r2);
    }

    public void testBug45513() {
        ResourceManager rm = this.getCache().getResourceManager();
        MemoryThresholdsDUnitTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(rm.getCriticalHeapPercentage()));
        MemoryThresholdsDUnitTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(rm.getEvictionHeapPercentage()));
        rm.setEvictionHeapPercentage(50.0f);
        rm.setCriticalHeapPercentage(90.0f);
        MemoryThresholdsDUnitTest.assertEquals((Object)Float.valueOf(50.0f), (Object)Float.valueOf(rm.getEvictionHeapPercentage()));
        MemoryThresholdsDUnitTest.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(rm.getCriticalHeapPercentage()));
        this.getCache().createRegionFactory(RegionShortcut.REPLICATE_HEAP_LRU).create(this.getName());
        MemoryThresholdsDUnitTest.assertEquals((Object)Float.valueOf(50.0f), (Object)Float.valueOf(rm.getEvictionHeapPercentage()));
        MemoryThresholdsDUnitTest.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(rm.getCriticalHeapPercentage()));
    }

    public void testDistributedRegionRemoteClientPutRejection() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        String regionName = "rejectRemoteClientOp";
        ServerPorts ports1 = this.startCacheServer(server1, 0.0f, 0.0f, "rejectRemoteClientOp", false, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 0.0f, 90.0f, "rejectRemoteClientOp", false, false, 0);
        this.startClient(client, server1, ports1.getPort(), "rejectRemoteClientOp");
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.doPuts(client, "rejectRemoteClientOp", false, false);
        this.doPutAlls(client, "rejectRemoteClientOp", false, false, Range.DEFAULT);
        this.setUsageAboveCriticalThreshold(server2);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.doPuts(client, "rejectRemoteClientOp", true, false);
        this.doPutAlls(client, "rejectRemoteClientOp", true, false, new Range(Range.DEFAULT, Range.DEFAULT.width() + 1));
    }

    public void testDisabledThresholds() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        String regionName = "disableThresholdPr";
        ServerPorts ports1 = this.startCacheServer(server1, 0.0f, 0.0f, "disableThresholdPr", true, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 0.0f, 0.0f, "disableThresholdPr", true, false, 0);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.setUsageAboveEvictionThreshold(server1);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 0, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 0, true);
        this.setThresholds(server1, 80.0f, 0.0f);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 1, true);
        this.setUsageAboveCriticalThreshold(server1);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 0, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 0, true);
        this.setThresholds(server1, 0.0f, 0.0f);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION_DISABLED, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION_DISABLED, 1, true);
        this.setThresholds(server1, 0.0f, 90.0f);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager();
                TestCase.assertEquals((int)0, (int)irm.getStats().getEvictionStartEvents());
                TestCase.assertEquals((int)0, (int)irm.getStats().getHeapCriticalEvents());
                TestCase.assertEquals((long)0L, (long)irm.getStats().getCriticalThreshold());
                TestCase.assertEquals((long)0L, (long)irm.getStats().getEvictionThreshold());
                return null;
            }
        });
    }

    public void testEventDelivery() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        String regionName = "testEventDelivery";
        ServerPorts ports1 = this.startCacheServer(server1, 0.0f, 0.0f, "testEventDelivery", false, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 80.0f, 90.0f, "testEventDelivery", false, false, 0);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl gfCache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(950L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 1, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 0, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl gfCache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(850L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 2, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 0, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl gfCache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(840L);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 2, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 0, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl gfCache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(750L);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 2, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 1, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl gfCache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(950L);
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(750L);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 2, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 3, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 2, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl gfCache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                gfCache.getResourceManager().getHeapMonitor().updateStateAndSendEvent(850L);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 2, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 4, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 2, true);
    }

    public void testCleanAdvisorClose() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        String regionName = "testEventOrger";
        ServerPorts ports1 = this.startCacheServer(server1, 0.0f, 0.0f, "testEventOrger", false, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 0.0f, 0.0f, "testEventOrger", false, false, 0);
        this.verifyProfiles(server1, 1);
        this.verifyProfiles(server2, 1);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        });
        this.verifyProfiles(server1, 0);
        this.startCacheServer(server3, ports1.getMcastPort(), 0.0f, 0.0f, "testEventOrger", false, false, 0);
        this.verifyProfiles(server1, 1);
        this.verifyProfiles(server3, 1);
    }

    public void testPR_RemotePutRejectionLocalDestroy() throws Exception {
        this.prRemotePutRejection(false, true, false);
    }

    public void testPR_RemotePutRejectionCacheClose() throws Exception {
        this.prRemotePutRejection(true, false, false);
    }

    public void testPR_RemotePutRejection() throws Exception {
        this.prRemotePutRejection(false, false, false);
    }

    public void testPR_RemotePutRejectionLocalDestroyWithTx() throws Exception {
        this.prRemotePutRejection(false, true, true);
    }

    public void testPR_RemotePutRejectionCacheCloseWithTx() throws Exception {
        this.prRemotePutRejection(true, false, true);
    }

    public void testPR_RemotePutRejectionWithTx() throws Exception {
        this.prRemotePutRejection(false, false, true);
    }

    private void prRemotePutRejection(boolean cacheClose, boolean localDestroy, final boolean useTx) throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM server3 = host.getVM(3);
        String regionName = "testPrRejection";
        boolean redundancy = true;
        final ServerPorts ports1 = this.startCacheServer(server1, 80.0f, 90.0f, "testPrRejection", true, false, 1);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 80.0f, 90.0f, "testPrRejection", true, false, 1);
        ServerPorts ports3 = this.startCacheServer(server3, ports1.getMcastPort(), 80.0f, 90.0f, "testPrRejection", true, false, 1);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getSystem(MemoryThresholdsDUnitTest.this.getServerProperties(ports1.getMcastPort()));
                MemoryThresholdsDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                paf.setTotalNumBuckets(11);
                factory.setPartitionAttributes(paf.create());
                MemoryThresholdsDUnitTest.this.createRegion("testPrRejection", factory.create());
                return null;
            }
        });
        this.doPuts(accessor, "testPrRejection", false, false);
        Range r1 = Range.DEFAULT;
        this.doPutAlls(accessor, "testPrRejection", false, false, r1);
        SerializableCallable getMyId = new SerializableCallable(){

            public Object call() throws Exception {
                return ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getMyId();
            }
        };
        final DistributedMember server1Id = (DistributedMember)server1.invoke(getMyId);
        this.setUsageAboveCriticalThreshold(server1);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                final PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("testPrRejection");
                String regionPath = MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("testPrRejection").getFullPath();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "remote bucket not marked sick";
                    }

                    @Override
                    public boolean done() {
                        boolean keyFoundOnSickMember = false;
                        boolean caughtException = false;
                        for (int i = 0; i < 20; ++i) {
                            Integer key = i;
                            int hKey = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)key, null, null);
                            Set owners = pr.getRegionAdvisor().getBucketOwners(hKey);
                            if (owners.contains(server1Id)) {
                                keyFoundOnSickMember = true;
                                try {
                                    if (useTx) {
                                        MemoryThresholdsDUnitTest.this.getCache().getCacheTransactionManager().begin();
                                    }
                                    pr.getCache().getLogger().fine("SWAP:putting in tx:" + useTx);
                                    pr.put((Object)key, (Object)"value");
                                    if (!useTx) continue;
                                    MemoryThresholdsDUnitTest.this.getCache().getCacheTransactionManager().commit();
                                }
                                catch (LowMemoryException ex) {
                                    caughtException = true;
                                    if (!useTx) continue;
                                    MemoryThresholdsDUnitTest.this.getCache().getCacheTransactionManager().rollback();
                                }
                                continue;
                            }
                            pr.put((Object)key, (Object)"value");
                        }
                        return keyFoundOnSickMember && caughtException;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
        Range r2 = new Range(r1, r1.width() + 1);
        this.doPutAlls(accessor, "testPrRejection", false, true, r2);
        if (localDestroy) {
            server1.invoke(new SerializableCallable("local destroy sick member"){

                public Object call() throws Exception {
                    Region r = MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("testPrRejection");
                    DistributedTestCase.getLogWriter().info("PRLocalDestroy");
                    r.localDestroyRegion();
                    return null;
                }
            });
        } else if (cacheClose) {
            server1.invoke(new SerializableCallable("close cache sick member"){

                public Object call() throws Exception {
                    MemoryThresholdsDUnitTest.this.getCache().close();
                    return null;
                }
            });
        } else {
            this.setUsageBelowEviction(server1);
        }
        accessor.invoke(new SerializableCallable("Put in a loop"){

            public Object call() throws Exception {
                final Region r = MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("testPrRejection");
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "pr should have gone un-critical";
                    }

                    @Override
                    public boolean done() {
                        boolean done = true;
                        for (int i = 0; i < 20; ++i) {
                            try {
                                r.put((Object)i, (Object)"value");
                                continue;
                            }
                            catch (LowMemoryException e) {
                                done = false;
                            }
                        }
                        return done;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
        this.doPutAlls(accessor, "testPrRejection", false, false, r1);
    }

    public void testTxCommitInCritical() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM server3 = host.getVM(3);
        String regionName = "testPrRejection";
        boolean redundancy = true;
        final ServerPorts ports1 = this.startCacheServer(server1, 80.0f, 90.0f, "testPrRejection", true, false, 1);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 80.0f, 90.0f, "testPrRejection", true, false, 1);
        ServerPorts ports3 = this.startCacheServer(server3, ports1.getMcastPort(), 80.0f, 90.0f, "testPrRejection", true, false, 1);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.registerTestMemoryThresholdListener(server3);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getSystem(MemoryThresholdsDUnitTest.this.getServerProperties(ports1.getMcastPort()));
                MemoryThresholdsDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                paf.setTotalNumBuckets(11);
                factory.setPartitionAttributes(paf.create());
                MemoryThresholdsDUnitTest.this.createRegion("testPrRejection", factory.create());
                return null;
            }
        });
        this.doPuts(accessor, "testPrRejection", false, false);
        Range r1 = Range.DEFAULT;
        this.doPutAlls(accessor, "testPrRejection", false, false, r1);
        SerializableCallable getMyId = new SerializableCallable(){

            public Object call() throws Exception {
                return ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getMyId();
            }
        };
        final DistributedMember server1Id = (DistributedMember)server1.invoke(getMyId);
        final Integer lastKey = (Integer)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("testPrRejection");
                MemoryThresholdsDUnitTest.this.getCache().getCacheTransactionManager().begin();
                for (int i = 0; i < 20; ++i) {
                    Integer key = i;
                    int hKey = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Object)key);
                    Set owners = pr.getRegionAdvisor().getBucketOwners(hKey);
                    if (!owners.contains(server1Id)) continue;
                    pr.put((Object)key, (Object)"txTest");
                    return i;
                }
                return null;
            }
        });
        MemoryThresholdsDUnitTest.assertNotNull((Object)lastKey);
        this.setUsageAboveCriticalThreshold(server1);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("testPrRejection");
                TestCase.assertTrue((boolean)MemoryThresholdsDUnitTest.this.getCache().getCacheTransactionManager().exists());
                boolean exceptionThrown = false;
                for (int i = lastKey.intValue(); i < 20; ++i) {
                    Integer key = i;
                    int hKey = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Object)key);
                    Set owners = pr.getRegionAdvisor().getBucketOwners(hKey);
                    if (!owners.contains(server1Id)) continue;
                    try {
                        pr.put((Object)key, (Object)"txTest");
                        continue;
                    }
                    catch (LowMemoryException e) {
                        exceptionThrown = true;
                        break;
                    }
                }
                if (!exceptionThrown) {
                    TestCase.fail((String)"expected exception not thrown");
                }
                MemoryThresholdsDUnitTest.this.getCache().getCacheTransactionManager().commit();
                int seenCount = 0;
                for (int i = 0; i < 20; ++i) {
                    if (!"txTest".equals(pr.get((Object)i))) continue;
                    ++seenCount;
                }
                TestCase.assertEquals((int)1, (int)seenCount);
                return null;
            }
        });
    }

    public void testDRFunctionExecutionRejection() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        String regionName = "drFuncRej";
        ServerPorts ports1 = this.startCacheServer(server1, 80.0f, 90.0f, "drFuncRej", false, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 80.0f, 90.0f, "drFuncRej", false, false, 0);
        this.startClient(client, server1, ports1.getPort(), "drFuncRej");
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        final RejectFunction function = new RejectFunction();
        final RejectFunction function2 = new RejectFunction("noRejFunc", false);
        MemoryThresholdsDUnitTest.invokeInEveryVM(new SerializableCallable("register function"){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)function);
                FunctionService.registerFunction((Function)function2);
                return null;
            }
        });
        this.doPutAlls(server1, "drFuncRej", false, false, Range.DEFAULT);
        this.doPuts(server1, "drFuncRej", false, false);
        server1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function);
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function2);
                return null;
            }
        });
        server1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function);
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function2);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function).getResult(30L, TimeUnit.SECONDS);
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function2).getResult(30L, TimeUnit.SECONDS);
                return null;
            }
        });
        this.setUsageAboveCriticalThreshold(server2);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        server1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
                    FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function);
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
                    TestCase.fail((String)"expected low memory exception was not thrown");
                }
                catch (LowMemoryException lowMemoryException) {
                    // empty catch block
                }
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function2);
                return null;
            }
        });
        server1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
                    FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function);
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
                    TestCase.fail((String)"expected low memory exception was not thrown");
                }
                catch (LowMemoryException lowMemoryException) {
                    // empty catch block
                }
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function2);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                block2: {
                    try {
                        MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
                        FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function);
                        MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
                        TestCase.fail((String)"expected low memory exception was not thrown");
                    }
                    catch (FunctionException e) {
                        if (e.getCause().getCause() instanceof LowMemoryException) break block2;
                        DistributedTestCase.fail("unexpected exception ", e);
                    }
                }
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("drFuncRej")).execute((Function)function2);
                return null;
            }
        });
    }

    public void testPRFunctionExecutionRejection() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        String regionName = "prFuncRej";
        final ServerPorts ports1 = this.startCacheServer(server1, 80.0f, 90.0f, "prFuncRej", true, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 80.0f, 90.0f, "prFuncRej", true, false, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getSystem(MemoryThresholdsDUnitTest.this.getServerProperties(ports1.getMcastPort()));
                MemoryThresholdsDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setLocalMaxMemory(0);
                paf.setTotalNumBuckets(11);
                factory.setPartitionAttributes(paf.create());
                MemoryThresholdsDUnitTest.this.createRegion("prFuncRej", factory.create());
                return null;
            }
        });
        this.startClient(client, server1, ports1.getPort(), "prFuncRej");
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        final RejectFunction function = new RejectFunction();
        final RejectFunction function2 = new RejectFunction("noRejFunc", false);
        MemoryThresholdsDUnitTest.invokeInEveryVM(new SerializableCallable("register function"){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)function);
                FunctionService.registerFunction((Function)function2);
                return null;
            }
        });
        this.doPutAlls(accessor, "prFuncRej", false, false, Range.DEFAULT);
        this.doPuts(accessor, "prFuncRej", false, false);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function);
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function2);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function);
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function2);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function);
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function2);
                return null;
            }
        });
        this.setUsageAboveCriticalThreshold(server2);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
                    FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function);
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
                    TestCase.fail((String)"expected low memory exception was not thrown");
                }
                catch (LowMemoryException lowMemoryException) {
                    // empty catch block
                }
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function2);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
                    FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function);
                    MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
                    TestCase.fail((String)"expected low memory exception was not thrown");
                }
                catch (LowMemoryException lowMemoryException) {
                    // empty catch block
                }
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function2);
                return null;
            }
        });
        server1.invoke(this.addExpectedFunctionException);
        server2.invoke(this.addExpectedFunctionException);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                block2: {
                    try {
                        FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function);
                        TestCase.fail((String)"expected low memory exception was not thrown");
                    }
                    catch (FunctionException e) {
                        if (e.getCause().getCause() instanceof LowMemoryException) break block2;
                        DistributedTestCase.fail("unexpected exception", e);
                    }
                }
                FunctionService.onRegion((Region)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej")).execute((Function)function2);
                return null;
            }
        });
        server1.invoke(this.removeExpectedFunctionException);
        server2.invoke(this.removeExpectedFunctionException);
        final DistributedMember server2Id = (DistributedMember)server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getMyId();
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion("prFuncRej");
                Integer sickKey1 = null;
                Integer sickKey2 = null;
                Integer healthyKey = null;
                for (int i = 0; i < 20; ++i) {
                    Execution e;
                    HashSet<Integer> s;
                    Integer key = i;
                    DistributedMember m = pr.getMemberOwning((Object)key);
                    if (m.equals(server2Id)) {
                        if (sickKey1 == null) {
                            sickKey1 = key;
                            s = new HashSet();
                            s.add(sickKey1);
                            e = FunctionService.onRegion((Region)pr);
                            try {
                                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=add> cannot be executed</ExpectedException>");
                                e.withFilter(s).withArgs((Object)s).execute((Function)function);
                                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine("<ExpectedException action=remove> cannot be executed</ExpectedException>");
                                TestCase.fail((String)"expected LowMemoryExcception was not thrown");
                            }
                            catch (LowMemoryException lowMemoryException) {}
                        } else if (sickKey2 == null) {
                            sickKey2 = key;
                            s = new HashSet();
                            s.add(sickKey1);
                            s.add(sickKey2);
                            e = FunctionService.onRegion((Region)pr);
                            try {
                                e.withFilter(s).withArgs((Object)s).execute((Function)function);
                                TestCase.fail((String)"expected LowMemoryExcception was not thrown");
                            }
                            catch (LowMemoryException lowMemoryException) {}
                        }
                    } else {
                        healthyKey = key;
                        s = new HashSet<Integer>();
                        s.add(healthyKey);
                        e = FunctionService.onRegion((Region)pr);
                        e.withFilter(s).withArgs((Object)s).execute((Function)function);
                    }
                    if (sickKey1 != null && sickKey2 != null && healthyKey != null) break;
                }
                return null;
            }
        });
    }

    public void testFunctionExecutionRejection() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        String regionName = "FuncRej";
        ServerPorts ports1 = this.startCacheServer(server1, 80.0f, 90.0f, "FuncRej", false, false, 0);
        ServerPorts ports2 = this.startCacheServer(server2, ports1.getMcastPort(), 80.0f, 90.0f, "FuncRej", false, false, 0);
        this.startClient(client, server1, ports1.getPort(), "FuncRej");
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        final RejectFunction function = new RejectFunction();
        final RejectFunction function2 = new RejectFunction("noRejFunc", false);
        MemoryThresholdsDUnitTest.invokeInEveryVM(new SerializableCallable("register function"){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)function);
                FunctionService.registerFunction((Function)function2);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Pool p = PoolManager.find((String)"pool1");
                TestCase.assertTrue((p != null ? 1 : 0) != 0);
                FunctionService.onServers((Pool)p).execute((Function)function);
                FunctionService.onServers((Pool)p).execute((Function)function2);
                return null;
            }
        });
        final DistributedMember s1 = (DistributedMember)server1.invoke(this.getDistributedMember);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function);
                FunctionService.onMember((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem(), (DistributedMember)s1).execute((Function)function);
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function2);
                FunctionService.onMember((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem(), (DistributedMember)s1).execute((Function)function2);
                return null;
            }
        });
        this.setUsageAboveCriticalThreshold(server1);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        server1.invoke(this.addExpectedFunctionException);
        server2.invoke(this.addExpectedFunctionException);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Pool p;
                block2: {
                    p = PoolManager.find((String)"pool1");
                    TestCase.assertTrue((p != null ? 1 : 0) != 0);
                    try {
                        FunctionService.onServers((Pool)p).execute((Function)function);
                        TestCase.fail((String)"expected LowMemoryExcception was not thrown");
                    }
                    catch (ServerOperationException e) {
                        if (e.getCause().getMessage().matches(".*low.*memory.*")) break block2;
                        DistributedTestCase.fail("unexpected exception", e);
                    }
                }
                FunctionService.onServers((Pool)p).execute((Function)function2);
                return null;
            }
        });
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function);
                    TestCase.fail((String)"expected LowMemoryExcception was not thrown");
                }
                catch (LowMemoryException lowMemoryException) {
                    // empty catch block
                }
                try {
                    FunctionService.onMember((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem(), (DistributedMember)s1).execute((Function)function);
                    TestCase.fail((String)"expected LowMemoryExcception was not thrown");
                }
                catch (LowMemoryException lowMemoryException) {
                    // empty catch block
                }
                FunctionService.onMembers((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem()).execute((Function)function2);
                FunctionService.onMember((DistributedSystem)MemoryThresholdsDUnitTest.this.getSystem(), (DistributedMember)s1).execute((Function)function2);
                return null;
            }
        });
        server1.invoke(this.removeExpectedFunctionException);
        server2.invoke(this.removeExpectedFunctionException);
    }

    private ServerPorts startCacheServer(VM server, final int mcastPort, final float evictionThreshold, final float criticalThreshold, final String regionName, final boolean createPR, final boolean notifyBySubscription, final int prRedundancy) throws Exception {
        return (ServerPorts)server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getSystem(MemoryThresholdsDUnitTest.this.getServerProperties(mcastPort));
                GemFireCacheImpl cache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                InternalResourceManager irm = cache.getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                hmm.setTestMaxMemoryBytes(1000L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)500L);
                irm.setEvictionHeapPercentage(evictionThreshold);
                irm.setCriticalHeapPercentage(criticalThreshold);
                AttributesFactory factory = new AttributesFactory();
                if (createPR) {
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(prRedundancy);
                    paf.setTotalNumBuckets(11);
                    factory.setPartitionAttributes(paf.create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = MemoryThresholdsDUnitTest.this.createRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
                CacheServer cacheServer = MemoryThresholdsDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPorts(1)[0];
                cacheServer.setPort(port);
                cacheServer.setNotifyBySubscription(notifyBySubscription);
                cacheServer.start();
                return new ServerPorts(port, mcastPort);
            }
        });
    }

    private ServerPorts startCacheServer(VM server, final float evictionThreshold, final float criticalThreshold, final String regionName, final boolean createPR, final boolean notifyBySubscription, final int prRedundancy) throws Exception {
        return (ServerPorts)server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
                MemoryThresholdsDUnitTest.this.getSystem(MemoryThresholdsDUnitTest.this.getServerProperties(mcastPort));
                GemFireCacheImpl cache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                InternalResourceManager irm = cache.getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                hmm.setTestMaxMemoryBytes(1000L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)500L);
                irm.setEvictionHeapPercentage(evictionThreshold);
                irm.setCriticalHeapPercentage(criticalThreshold);
                AttributesFactory factory = new AttributesFactory();
                if (createPR) {
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(prRedundancy);
                    paf.setTotalNumBuckets(11);
                    factory.setPartitionAttributes(paf.create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = MemoryThresholdsDUnitTest.this.createRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
                CacheServer cacheServer = MemoryThresholdsDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPorts(1)[0];
                cacheServer.setPort(port);
                cacheServer.setNotifyBySubscription(notifyBySubscription);
                cacheServer.start();
                return new ServerPorts(port, mcastPort);
            }
        });
    }

    private void startClient(VM client, final VM server, final int serverPort, final String regionName) {
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getSystem(MemoryThresholdsDUnitTest.this.getClientProps());
                MemoryThresholdsDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(server.getHost()), serverPort);
                pf.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.LOCAL);
                af.setPoolName("pool1");
                MemoryThresholdsDUnitTest.this.createRegion(regionName, af.create());
                return null;
            }
        });
    }

    private void doPuts(VM vm, final String regionName, final boolean catchServerException, final boolean catchLowMemoryException) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                block6: {
                    Region r = MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion(regionName);
                    try {
                        r.put((Object)0, (Object)"value-1");
                        if (catchServerException || catchLowMemoryException) {
                            TestCase.fail((String)"An expected ResourceException was not thrown");
                        }
                    }
                    catch (ServerOperationException ex) {
                        if (!catchServerException) {
                            DistributedTestCase.fail("Unexpected exception: ", ex);
                        }
                        if (!(ex.getCause() instanceof LowMemoryException)) {
                            DistributedTestCase.fail("Unexpected exception: ", ex);
                        }
                    }
                    catch (LowMemoryException low) {
                        if (catchLowMemoryException) break block6;
                        DistributedTestCase.fail("Unexpected exception: ", low);
                    }
                }
                return null;
            }
        });
    }

    private void doPutAlls(VM vm, final String regionName, final boolean catchServerException, final boolean catchLowMemoryException, final Range rng) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = MemoryThresholdsDUnitTest.this.getRootRegion().getSubregion(regionName);
                HashMap<Integer, String> temp = new HashMap<Integer, String>();
                for (int i = rng.start; i < rng.end; ++i) {
                    Integer k = i;
                    temp.put(k, "value-" + i);
                }
                try {
                    r.putAll(temp);
                    if (catchServerException || catchLowMemoryException) {
                        TestCase.fail((String)"An expected ResourceException was not thrown");
                    }
                    for (Map.Entry me : temp.entrySet()) {
                        TestCase.assertEquals(me.getValue(), (Object)r.get(me.getKey()));
                    }
                }
                catch (ServerOperationException ex) {
                    if (!catchServerException) {
                        DistributedTestCase.fail("Unexpected exception: ", ex);
                    }
                    if (!(ex.getCause() instanceof LowMemoryException)) {
                        DistributedTestCase.fail("Unexpected exception: ", ex);
                    }
                    for (Integer me : temp.keySet()) {
                        TestCase.assertFalse((String)("Key " + me + " should not exist"), (boolean)r.containsKey((Object)me));
                    }
                }
                catch (LowMemoryException low) {
                    DistributedTestCase.getLogWriter().info("Caught LowMemoryException", (Throwable)low);
                    if (!catchLowMemoryException) {
                        DistributedTestCase.fail("Unexpected exception: ", low);
                    }
                    for (Integer me : temp.keySet()) {
                        TestCase.assertFalse((String)("Key " + me + " should not exist"), (boolean)r.containsKey((Object)me));
                    }
                }
                return null;
            }
        });
    }

    private void setUsageAboveCriticalThreshold(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
                ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager().getHeapMonitor().updateStateAndSendEvent(950L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)950L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
                return null;
            }
        });
    }

    private void setUsageAboveEvictionThreshold(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)850L);
                ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager().getHeapMonitor().updateStateAndSendEvent(850L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                return null;
            }
        });
    }

    private void setUsageBelowEviction(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager().getHeapMonitor().updateStateAndSendEvent(750L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                return null;
            }
        });
    }

    private void setThresholds(VM server, final float evictionThreshold, final float criticalThreshold) {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ResourceManager irm = MemoryThresholdsDUnitTest.this.getCache().getResourceManager();
                irm.setCriticalHeapPercentage(criticalThreshold);
                irm.setEvictionHeapPercentage(evictionThreshold);
                return null;
            }
        });
    }

    private void registerTestMemoryThresholdListener(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TestMemoryThresholdListener listener = new TestMemoryThresholdListener();
                InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager();
                irm.addResourceListener(InternalResourceManager.ResourceType.HEAP_MEMORY, (ResourceListener)listener);
                TestCase.assertTrue((boolean)irm.getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY).contains(listener));
                return null;
            }
        });
    }

    private void verifyListenerValue(VM vm, final MemoryThresholds.MemoryState state, final int value, final boolean useWaitCriterion) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = null;
                Set listeners = MemoryThresholdsDUnitTest.this.getGemfireCache().getResourceManager().getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY);
                TestMemoryThresholdListener tmp_listener = null;
                for (ResourceListener l : listeners) {
                    if (!(l instanceof TestMemoryThresholdListener)) continue;
                    tmp_listener = (TestMemoryThresholdListener)l;
                    break;
                }
                final TestMemoryThresholdListener listener = tmp_listener == null ? null : tmp_listener;
                switch (state) {
                    case CRITICAL: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote CRITICAL assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getCriticalThresholdCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getCriticalThresholdCalls());
                        break;
                    }
                    case CRITICAL_DISABLED: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote CRITICAL_DISABLED assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getCriticalDisabledCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getCriticalDisabledCalls());
                        break;
                    }
                    case EVICTION: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote EVICTION assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getEvictionThresholdCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getEvictionThresholdCalls());
                        break;
                    }
                    case EVICTION_DISABLED: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote EVICTION_DISABLED assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getEvictionDisabledCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getEvictionDisabledCalls());
                        break;
                    }
                    case NORMAL: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote NORMAL assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getNormalCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getNormalCalls());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown memory state");
                    }
                }
                if (useWaitCriterion) {
                    DistributedTestCase.waitForCriterion(wc, 5000L, 100L, true);
                }
                return null;
            }
        });
    }

    private void verifyProfiles(VM vm, final int numberOfProfiles) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache()).getResourceManager();
                final ResourceAdvisor ra = irm.getResourceAdvisor();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify profiles failed. Current profiles: " + ra.adviseGeneric();
                    }

                    @Override
                    public boolean done() {
                        return numberOfProfiles == ra.adviseGeneric().size();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
    }

    protected Properties getClientProps() {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("locators", "");
        return p;
    }

    protected Properties getServerProperties(int mcastPort) {
        Properties p = new Properties();
        p.setProperty("mcast-port", mcastPort + "");
        p.setProperty("locators", "");
        return p;
    }

    public void testLocalStatListenerRegistration() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        Cache cache = this.getCache();
        InternalDistributedSystem internalSystem = (InternalDistributedSystem)cache.getDistributedSystem();
        final GemFireStatSampler sampler = internalSystem.getStatSampler();
        sampler.waitForInitialization(10000L);
        final LocalStatListener l = new LocalStatListener(){

            public void statValueChanged(double value) {
                latch.countDown();
            }
        };
        final String tenuredPoolName = HeapMemoryMonitor.getTenuredMemoryPoolMXBean().getName();
        MemoryThresholdsDUnitTest.getLogWriter().info("TenuredPoolName:" + tenuredPoolName);
        final List list = internalSystem.getStatsList();
        MemoryThresholdsDUnitTest.assertFalse((boolean)list.isEmpty());
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean done() {
                int i = 0;
                List list2 = list;
                synchronized (list2) {
                    for (Object o : list) {
                        DistributedTestCase.getLogWriter().info("List:" + ++i + ":" + o);
                        if (!(o instanceof StatisticsImpl)) continue;
                        StatisticsImpl si = (StatisticsImpl)o;
                        DistributedTestCase.getLogWriter().info("stat:" + si.getTextId());
                        if (!si.getTextId().contains(tenuredPoolName)) continue;
                        sampler.addLocalStatListener(l, (Statistics)si, "currentUsedMemory");
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String description() {
                return "Waiting for " + tenuredPoolName + " statistics to be added to create listener for";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 5000L, 10L, true);
        MemoryThresholdsDUnitTest.assertTrue((String)("expected at least one stat listener, found " + sampler.getLocalListeners().size()), (sampler.getLocalListeners().size() > 0 ? 1 : 0) != 0);
        long maxTenuredMemory = HeapMemoryMonitor.getTenuredPoolMaxMemory() + HeapMemoryMonitor.getEdenAndSurvivorPoolMaxMemory();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        Region r = this.createRegion(this.getUniqueName() + "region", factory.create());
        int count = 0;
        do {
            if (++count > 75) {
                throw new TestException("Did not receive a stat listener callback");
            }
            byte[] value = new byte[(int)((double)maxTenuredMemory * 0.01)];
            r.put((Object)("key-" + count), (Object)value);
        } while (!latch.await(50L, TimeUnit.MILLISECONDS));
        r.close();
    }

    public void testLRLoadRejection() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(2);
        final String rName = this.getUniqueName();
        float criticalHeapThresh = 0.9f;
        int fakeHeapMaxSize = 1000;
        vm.invoke(DistributedTestCase.class, "disconnectFromDS");
        vm.invoke(new CacheSerializableRunnable("test LocalRegion load passthrough when critical"){

            @Override
            public void run2() throws CacheException {
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                long fakeHeapUsage = Math.round(399.99997f);
                TestCase.assertTrue((boolean)true);
                irm.getHeapMonitor().setTestMaxMemoryBytes(1000L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)fakeHeapUsage);
                irm.setCriticalHeapPercentage(90.0f);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.LOCAL);
                final AI numLoaderInvocations = CFactory.createAI();
                af.setCacheLoader((CacheLoader)new CacheLoader<Integer, String>(){

                    public String load(LoaderHelper<Integer, String> helper) throws CacheLoaderException {
                        numLoaderInvocations.incrementAndGet();
                        return ((Integer)helper.getKey()).toString();
                    }

                    public void close() {
                    }
                });
                Region r = MemoryThresholdsDUnitTest.this.getCache().createRegion(rName, af.create());
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                int expectedInvocations = 0;
                TestCase.assertEquals((int)expectedInvocations++, (int)numLoaderInvocations.get());
                Integer k = new Integer(1);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k)));
                TestCase.assertEquals((int)expectedInvocations++, (int)numLoaderInvocations.get());
                ++expectedInvocations;
                r.getAll(MemoryThresholdsDUnitTest.createRanges(10, 12));
                int n = ++expectedInvocations;
                ++expectedInvocations;
                TestCase.assertEquals((int)n, (int)numLoaderInvocations.get());
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
                fakeHeapUsage = Math.round(1000.0f);
                TestCase.assertTrue((fakeHeapUsage > 0L ? 1 : 0) != 0);
                TestCase.assertTrue((fakeHeapUsage <= 1000L ? 1 : 0) != 0);
                hmm.updateStateAndSendEvent(fakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
                TestCase.assertTrue((boolean)hmm.getState().isCritical());
                k = new Integer(2);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k)));
                TestCase.assertEquals((int)expectedInvocations++, (int)numLoaderInvocations.get());
                ++expectedInvocations;
                r.getAll(MemoryThresholdsDUnitTest.createRanges(13, 15));
                int n2 = ++expectedInvocations;
                TestCase.assertEquals((int)n2, (int)numLoaderInvocations.get());
                fakeHeapUsage = Math.round(599.99994f);
                TestCase.assertTrue((boolean)true);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                hmm.updateStateAndSendEvent(fakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                k = new Integer(3);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k)));
                int n3 = ++expectedInvocations;
                ++expectedInvocations;
                TestCase.assertEquals((int)n3, (int)numLoaderInvocations.get());
                ++expectedInvocations;
                r.getAll(MemoryThresholdsDUnitTest.createRanges(16, 18));
                TestCase.assertEquals((int)(++expectedInvocations), (int)numLoaderInvocations.get());
                for (Integer i : MemoryThresholdsDUnitTest.createRanges(2, 2, 13, 15)) {
                    if (r.containsKey((Object)i)) {
                        TestCase.fail((String)("Expected containsKey return false for key" + i));
                    }
                    if (r.getEntry((Object)i) == null) continue;
                    TestCase.fail((String)("Expected getEntry to return null for key" + i));
                }
            }
        });
    }

    public static List<Integer> createRanges(int ... startEnds) {
        assert (startEnds.length % 2 == 0);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int si = 0; si < startEnds.length; ++si) {
            int start = startEnds[si++];
            int end = startEnds[si];
            assert (end >= start);
            ret.ensureCapacity(ret.size() + (end - start + 1));
            for (int i = start; i <= end; ++i) {
                ret.add(new Integer(i));
            }
        }
        return ret;
    }

    public void testDRLoadRejection() throws Exception {
        Host host = Host.getHost(0);
        VM replicate1 = host.getVM(2);
        VM replicate2 = host.getVM(3);
        final String rName = this.getUniqueName();
        float criticalHeapThresh = 0.9f;
        int fakeHeapMaxSize = 1000;
        AsyncInvocation d1 = replicate1.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        AsyncInvocation d2 = replicate2.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        d1.join();
        MemoryThresholdsDUnitTest.assertFalse((boolean)d1.exceptionOccurred());
        d2.join();
        MemoryThresholdsDUnitTest.assertFalse((boolean)d2.exceptionOccurred());
        CacheSerializableRunnable establishConnectivity = new CacheSerializableRunnable("establishcConnectivity"){

            @Override
            public void run2() throws CacheException {
                MemoryThresholdsDUnitTest.this.getSystem();
            }
        };
        replicate1.invoke(establishConnectivity);
        replicate2.invoke(establishConnectivity);
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("create DistributedRegion"){

            @Override
            public void run2() throws CacheException {
                InternalDistributedSystem ds = MemoryThresholdsDUnitTest.this.getSystem();
                TestCase.assertTrue((ds.getDistributionManager().getNormalDistributionManagerIds().size() >= 1 ? 1 : 0) != 0);
                long fakeHeapUsage = Math.round(399.99997f);
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                TestCase.assertTrue((boolean)true);
                hmm.setTestMaxMemoryBytes(1000L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)fakeHeapUsage);
                irm.setCriticalHeapPercentage(90.0f);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                MemoryThresholdsDUnitTest.this.getCache().createRegion(rName, af.create());
            }
        };
        replicate1.invoke(createRegion);
        replicate2.invoke(createRegion);
        replicate1.invoke(this.addExpectedException);
        replicate2.invoke(this.addExpectedException);
        final Integer expected = (Integer)replicate1.invoke(new SerializableCallable("test Local DistributedRegion Load"){

            public Object call() throws Exception {
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                AttributesMutator am = r.getAttributesMutator();
                am.setCacheLoader((CacheLoader)new CacheLoader<Integer, String>(){
                    final AI numLoaderInvocations = CFactory.createAI();

                    public String load(LoaderHelper<Integer, String> helper) throws CacheLoaderException {
                        Integer expectedInvocations = (Integer)helper.getArgument();
                        int actualInvocations = this.numLoaderInvocations.getAndIncrement();
                        if (expectedInvocations != actualInvocations) {
                            throw new CacheLoaderException("Expected " + expectedInvocations + " invocations, actual is " + actualInvocations);
                        }
                        return ((Integer)helper.getKey()).toString();
                    }

                    public void close() {
                    }
                });
                int expectedInvocations = 0;
                HeapMemoryMonitor hmm = ((InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager()).getHeapMonitor();
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                Integer k = new Integer(1);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)new Integer(expectedInvocations++))));
                long newfakeHeapUsage = Math.round(1000.0f);
                TestCase.assertTrue((newfakeHeapUsage > 0L ? 1 : 0) != 0);
                TestCase.assertTrue((newfakeHeapUsage <= 1000L ? 1 : 0) != 0);
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                TestCase.assertTrue((boolean)hmm.getState().isCritical());
                Integer k2 = new Integer(2);
                TestCase.assertEquals((String)k2.toString(), (String)((String)r.get((Object)k2, (Object)new Integer(expectedInvocations++))));
                newfakeHeapUsage = Math.round(599.99994f);
                TestCase.assertTrue((boolean)true);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                k2 = new Integer(3);
                TestCase.assertEquals((String)k2.toString(), (String)((String)r.get((Object)k2, (Object)new Integer(expectedInvocations++))));
                return new Integer(expectedInvocations);
            }
        });
        CacheSerializableRunnable validateData1 = new CacheSerializableRunnable("Validate data 1"){

            @Override
            public void run2() throws CacheException {
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                Integer i1 = new Integer(1);
                TestCase.assertTrue((boolean)r.containsKey((Object)i1));
                TestCase.assertNotNull((Object)r.getEntry((Object)i1));
                Integer i2 = new Integer(2);
                TestCase.assertFalse((boolean)r.containsKey((Object)i2));
                TestCase.assertNull((Object)r.getEntry((Object)i2));
                Integer i3 = new Integer(3);
                TestCase.assertTrue((boolean)r.containsKey((Object)i3));
                TestCase.assertNotNull((Object)r.getEntry((Object)i3));
            }
        };
        replicate1.invoke(validateData1);
        replicate2.invoke(validateData1);
        replicate2.invoke(new SerializableCallable("test DistributedRegion netLoad"){

            public Object call() throws Exception {
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                HeapMemoryMonitor hmm = ((InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager()).getHeapMonitor();
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                int expectedInvocations = expected;
                Integer k = new Integer(4);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)new Integer(expectedInvocations++))));
                long newfakeHeapUsage = Math.round(1000.0f);
                TestCase.assertTrue((newfakeHeapUsage > 0L ? 1 : 0) != 0);
                TestCase.assertTrue((newfakeHeapUsage <= 1000L ? 1 : 0) != 0);
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                TestCase.assertTrue((boolean)hmm.getState().isCritical());
                Integer k2 = new Integer(5);
                TestCase.assertEquals((String)k2.toString(), (String)((String)r.get((Object)k2, (Object)new Integer(expectedInvocations++))));
                newfakeHeapUsage = Math.round(599.99994f);
                TestCase.assertTrue((boolean)true);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                k2 = new Integer(6);
                TestCase.assertEquals((String)k2.toString(), (String)((String)r.get((Object)k2, (Object)new Integer(expectedInvocations++))));
                return new Integer(expectedInvocations);
            }
        });
        replicate1.invoke(this.removeExpectedException);
        replicate2.invoke(this.removeExpectedException);
        CacheSerializableRunnable validateData2 = new CacheSerializableRunnable("Validate data 2"){

            @Override
            public void run2() throws CacheException {
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                Integer i4 = new Integer(4);
                TestCase.assertTrue((boolean)r.containsKey((Object)i4));
                TestCase.assertNotNull((Object)r.getEntry((Object)i4));
                Integer i5 = new Integer(5);
                TestCase.assertFalse((boolean)r.containsKey((Object)i5));
                TestCase.assertNull((Object)r.getEntry((Object)i5));
                Integer i6 = new Integer(6);
                TestCase.assertTrue((boolean)r.containsKey((Object)i6));
                TestCase.assertNotNull((Object)r.getEntry((Object)i6));
            }
        };
        replicate1.invoke(validateData2);
        replicate2.invoke(validateData2);
    }

    public void testPRLoadRejection() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(1);
        VM ds1 = host.getVM(2);
        final String rName = this.getUniqueName();
        float criticalHeapThresh = 0.9f;
        int fakeHeapMaxSize = 1000;
        AsyncInvocation d0 = accessor.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        AsyncInvocation d1 = ds1.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        d0.join();
        MemoryThresholdsDUnitTest.assertFalse((boolean)d0.exceptionOccurred());
        d1.join();
        MemoryThresholdsDUnitTest.assertFalse((boolean)d1.exceptionOccurred());
        CacheSerializableRunnable establishConnectivity = new CacheSerializableRunnable("establishcConnectivity"){

            @Override
            public void run2() throws CacheException {
                MemoryThresholdsDUnitTest.this.getSystem();
            }
        };
        ds1.invoke(establishConnectivity);
        accessor.invoke(establishConnectivity);
        ds1.invoke(this.createPR(rName, false, 1000, 0.9f));
        accessor.invoke(this.createPR(rName, true, 1000, 0.9f));
        final AtomicInteger expectedInvocations = new AtomicInteger(0);
        Integer ex = (Integer)accessor.invoke(new SerializableCallable("Invoke loader from accessor, non-critical"){

            public Object call() throws Exception {
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                Integer k = new Integer(1);
                Integer expectedInvocations0 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations0)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                Integer expectedInvocations1 = new Integer(expectedInvocations.get());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations1)));
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations1)));
                return expectedInvocations1;
            }
        });
        expectedInvocations.set(ex);
        ex = (Integer)ds1.invoke(new SerializableCallable("Invoke loader from datastore, non-critical"){

            public Object call() throws Exception {
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                Integer k = new Integer(2);
                Integer expectedInvocations1 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations1)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                Integer expectedInvocations2 = new Integer(expectedInvocations.get());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations2)));
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations2)));
                String oldVal = (String)r.remove((Object)k);
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                TestCase.assertEquals((String)k.toString(), (String)oldVal);
                return expectedInvocations2;
            }
        });
        expectedInvocations.set(ex);
        accessor.invoke(this.addExpectedException);
        ds1.invoke(this.addExpectedException);
        ex = (Integer)ds1.invoke(new SerializableCallable("Set critical state, assert local load behavior"){

            public Object call() throws Exception {
                long newfakeHeapUsage = Math.round(1000.0f);
                TestCase.assertTrue((newfakeHeapUsage > 0L ? 1 : 0) != 0);
                TestCase.assertTrue((newfakeHeapUsage <= 1000L ? 1 : 0) != 0);
                HeapMemoryMonitor hmm = ((InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager()).getHeapMonitor();
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                TestCase.assertTrue((boolean)hmm.getState().isCritical());
                Integer k = new Integer(2);
                Integer expectedInvocations3 = new Integer(expectedInvocations.getAndIncrement());
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations3)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                Integer expectedInvocations4 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations4)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                Integer expectedInvocations5 = new Integer(expectedInvocations.get());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations5)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                return expectedInvocations5;
            }
        });
        expectedInvocations.set(ex);
        ex = (Integer)accessor.invoke(new SerializableCallable("During critical state on datastore, assert accesor load behavior"){

            public Object call() throws Exception {
                Integer k = new Integer(2);
                Integer expectedInvocations6 = new Integer(expectedInvocations.incrementAndGet());
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations6)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                Integer expectedInvocations7 = new Integer(expectedInvocations.incrementAndGet());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations7)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                return expectedInvocations7;
            }
        });
        expectedInvocations.set(ex);
        ex = (Integer)ds1.invoke(new SerializableCallable("Set safe state on datastore, assert local load behavior"){

            public Object call() throws Exception {
                HeapMemoryMonitor hmm = ((InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager()).getHeapMonitor();
                int newfakeHeapUsage = Math.round(599.99994f);
                TestCase.assertTrue((boolean)true);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                hmm.updateStateAndSendEvent((long)newfakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                Integer k = new Integer(3);
                Integer expectedInvocations8 = new Integer(expectedInvocations.incrementAndGet());
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations8)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                return expectedInvocations8;
            }
        });
        expectedInvocations.set(ex);
        accessor.invoke(new SerializableCallable("Data store in safe state, assert load behavior, accessor sets critical state, assert load behavior"){

            public Object call() throws Exception {
                HeapMemoryMonitor hmm = ((InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager()).getHeapMonitor();
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                Integer k = new Integer(4);
                Integer expectedInvocations9 = new Integer(expectedInvocations.incrementAndGet());
                Region r = MemoryThresholdsDUnitTest.this.getCache().getRegion(rName);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations9)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations9)));
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
                long newfakeHeapUsage = Math.round(1000.0f);
                TestCase.assertTrue((newfakeHeapUsage > 0L ? 1 : 0) != 0);
                TestCase.assertTrue((newfakeHeapUsage <= 1000L ? 1 : 0) != 0);
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
                TestCase.assertTrue((boolean)hmm.getState().isCritical());
                k = new Integer(5);
                Integer expectedInvocations10 = new Integer(expectedInvocations.incrementAndGet());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations10)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations10)));
                newfakeHeapUsage = Math.round(599.99994f);
                TestCase.assertTrue((boolean)true);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                hmm.updateStateAndSendEvent(newfakeHeapUsage);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                return expectedInvocations10;
            }
        });
        accessor.invoke(this.removeExpectedException);
        ds1.invoke(this.removeExpectedException);
    }

    private CacheSerializableRunnable createPR(final String rName, final boolean accessor, final int fakeHeapMaxSize, final float criticalHeapThresh) {
        return new CacheSerializableRunnable("create PR accessor"){

            @Override
            public void run2() throws CacheException {
                InternalDistributedSystem ds = MemoryThresholdsDUnitTest.this.getSystem();
                TestCase.assertTrue((ds.getDistributionManager().getNormalDistributionManagerIds().size() >= 2 ? 1 : 0) != 0);
                long fakeHeapUsage = Math.round((float)fakeHeapMaxSize * (criticalHeapThresh - 0.5f));
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsDUnitTest.this.getCache().getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                TestCase.assertTrue((fakeHeapMaxSize > 0 ? 1 : 0) != 0);
                hmm.setTestMaxMemoryBytes((long)fakeHeapMaxSize);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)fakeHeapUsage);
                irm.setCriticalHeapPercentage(criticalHeapThresh * 100.0f);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                AttributesFactory af = new AttributesFactory();
                if (!accessor) {
                    af.setCacheLoader((CacheLoader)new CacheLoader<Integer, String>(){
                        final AI numLoaderInvocations = CFactory.createAI();

                        public String load(LoaderHelper<Integer, String> helper) throws CacheLoaderException {
                            Integer expectedInvocations = (Integer)helper.getArgument();
                            int actualInvocations = this.numLoaderInvocations.getAndIncrement();
                            if (expectedInvocations != actualInvocations) {
                                throw new CacheLoaderException("Expected " + expectedInvocations + " invocations, actual is " + actualInvocations);
                            }
                            return ((Integer)helper.getKey()).toString();
                        }

                        public void close() {
                        }
                    });
                    af.setPartitionAttributes(new PartitionAttributesFactory().create());
                } else {
                    af.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).create());
                }
                MemoryThresholdsDUnitTest.this.getCache().createRegion(rName, af.create());
            }
        };
    }

    public void testCriticalMemoryEventTolerance() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
                int defaultTolerance = HeapMemoryMonitor.memoryStateChangeTolerance;
                GemFireCacheImpl cache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                InternalResourceManager irm = cache.getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                hmm.setTestMaxMemoryBytes(100L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)1L);
                irm.setCriticalHeapPercentage(95.0f);
                for (int i = 0; i < defaultTolerance; ++i) {
                    hmm.updateStateAndSendEvent(96L);
                    TestCase.assertFalse((boolean)hmm.getState().isCritical());
                }
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedExString);
                hmm.updateStateAndSendEvent(96L);
                TestCase.assertTrue((boolean)hmm.getState().isCritical());
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedExString);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.addExpectedBelow);
                hmm.updateStateAndSendEvent(92L);
                MemoryThresholdsDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsDUnitTest.this.removeExpectedBelow);
                TestCase.assertFalse((boolean)hmm.getState().isCritical());
                HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
                return null;
            }
        });
    }

    public void testEvictionMemoryEventTolerance() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
                int defaultTolerance = HeapMemoryMonitor.memoryStateChangeTolerance;
                GemFireCacheImpl cache = (GemFireCacheImpl)MemoryThresholdsDUnitTest.this.getCache();
                InternalResourceManager irm = cache.getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                hmm.setTestMaxMemoryBytes(100L);
                HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)1L);
                irm.setEvictionHeapPercentage(50.0f);
                for (int i = 0; i < defaultTolerance; ++i) {
                    hmm.updateStateAndSendEvent(55L);
                    TestCase.assertFalse((boolean)hmm.getState().isEviction());
                }
                hmm.updateStateAndSendEvent(55L);
                TestCase.assertTrue((boolean)hmm.getState().isEviction());
                hmm.updateStateAndSendEvent(45L);
                TestCase.assertFalse((boolean)hmm.getState().isEviction());
                HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
                return null;
            }
        });
    }

    private static final class ServerPorts
    implements Serializable {
        private final int port;
        private final int mcastPort;

        ServerPorts(int port, int mcastPort) {
            this.port = port;
            this.mcastPort = mcastPort;
        }

        int getPort() {
            return this.port;
        }

        int getMcastPort() {
            return this.mcastPort;
        }
    }

    private class RejectFunction
    extends FunctionAdapter {
        private boolean optimizeForWrite = true;
        private String id = "RejectFunction";

        public RejectFunction() {
        }

        public RejectFunction(String id, boolean optimizeForWrite) {
            this.id = id;
            this.optimizeForWrite = optimizeForWrite;
        }

        public void execute(FunctionContext context) {
            if (context instanceof RegionFunctionContext) {
                RegionFunctionContext regionContext = (RegionFunctionContext)context;
                Region dataSet = regionContext.getDataSet();
                dataSet.get((Object)1);
                regionContext.getResultSender().lastResult((Object)"executed");
            } else {
                context.getResultSender().lastResult((Object)"executed");
            }
        }

        public String getId() {
            return this.id;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return this.optimizeForWrite;
        }

        public void setOptimizeForWrite(boolean optimizeForWrite) {
            this.optimizeForWrite = optimizeForWrite;
        }

        public boolean isHA() {
            return false;
        }
    }

    public static class Range
    implements Serializable {
        public static final Range DEFAULT = new Range(0, 20);
        public final int start;
        public final int end;

        public Range(int s, int e) {
            this.start = s;
            this.end = e;
        }

        public Range(Range r, int shift) {
            this.start = r.start + shift;
            this.end = r.end + shift;
        }

        public int width() {
            return this.end - this.start;
        }
    }
}

