/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.management;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceEvent;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.partitioned.BecomePrimaryBucketMessage;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.DeposePrimaryBucketMessage;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPRInfo;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPartitionDetails;
import com.gemstone.gemfire.internal.cache.partitioned.PRLoad;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveBucketMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;

public class ResourceManagerDUnitTest
extends CacheTestCase {
    public static final int SYSTEM_LISTENERS = 1;

    public ResourceManagerDUnitTest(String name) {
        super(name);
    }

    public void testResourceManagerBasics() {
        Cache cache = this.getCache();
        ResourceManager manager = cache.getResourceManager();
        ResourceManagerDUnitTest.assertNotNull((Object)manager);
        Set detailsSet = PartitionRegionHelper.getPartitionRegionInfo((Cache)cache);
        ResourceManagerDUnitTest.assertNotNull((Object)detailsSet);
        ResourceManagerDUnitTest.assertEquals(Collections.emptySet(), (Object)detailsSet);
        ResourceListener listener = new ResourceListener(){

            public void onEvent(ResourceEvent event) {
            }
        };
        InternalResourceManager internalManager = (InternalResourceManager)manager;
        internalManager.addResourceListener(listener);
        Set listeners = internalManager.getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY);
        ResourceManagerDUnitTest.assertNotNull((Object)listeners);
        ResourceManagerDUnitTest.assertEquals((int)2, (int)listeners.size());
        ResourceManagerDUnitTest.assertTrue((boolean)listeners.contains(listener));
        internalManager.addResourceListener(InternalResourceManager.ResourceType.HEAP_MEMORY, listener);
        listeners = internalManager.getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY);
        ResourceManagerDUnitTest.assertEquals((int)2, (int)listeners.size());
        internalManager.removeResourceListener(listener);
        listeners = internalManager.getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY);
        ResourceManagerDUnitTest.assertEquals((int)listeners.size(), (int)1);
    }

    public void testGetPartitionedRegionDetails() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0", this.getUniqueName() + "-PR-1"};
        final int[] numBuckets = new int[]{100, 90};
        final int[] redundantCopies = new int[]{1, 0};
        final int[] localMaxMemory = new int[]{50, 100, 0};
        Integer[] bucketKeys = new Integer[]{0, 42, 76};
        ResourceManagerDUnitTest.assertEquals((int)0, (int)bucketKeys[0].hashCode());
        ResourceManagerDUnitTest.assertEquals((int)42, (int)bucketKeys[1].hashCode());
        ResourceManagerDUnitTest.assertEquals((int)76, (int)bucketKeys[2].hashCode());
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], localMaxMemory[0], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], localMaxMemory[1], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], localMaxMemory[2], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[1], localMaxMemory[0], numBuckets[1], redundantCopies[1]);
        byte[] value = new byte[0x200000];
        this.createBuckets(0, regionPath[0], bucketKeys, value);
        final InternalDistributedMember[] members = new InternalDistributedMember[3];
        final long[] memberSizes = new long[members.length];
        final int[] memberBucketCounts = new int[members.length];
        final int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int i = 0;
        while (i < localMaxMemory.length) {
            final int vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Set detailsSet = PartitionRegionHelper.getPartitionRegionInfo((Cache)ResourceManagerDUnitTest.this.getCache());
                    if (vm == 0) {
                        TestCase.assertEquals((int)2, (int)detailsSet.size());
                    } else {
                        TestCase.assertEquals((int)1, (int)detailsSet.size());
                    }
                    for (PartitionRegionInfo details : detailsSet) {
                        Set memberDetails;
                        TestCase.assertTrue((String)("Unknown regionPath=" + details.getRegionPath()), (details.getRegionPath().contains(regionPath[0]) || details.getRegionPath().contains(regionPath[1]) ? 1 : 0) != 0);
                        if (details.getRegionPath().contains(regionPath[0])) {
                            TestCase.assertEquals((int)numBuckets[0], (int)details.getConfiguredBucketCount());
                            TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                            TestCase.assertEquals((int)redundantCopies[0], (int)details.getConfiguredRedundantCopies());
                            TestCase.assertEquals((int)redundantCopies[0], (int)details.getActualRedundantCopies());
                            TestCase.assertNull((Object)details.getColocatedWith());
                            memberDetails = details.getPartitionMemberInfo();
                            TestCase.assertNotNull((Object)memberDetails);
                            TestCase.assertEquals((int)(localMaxMemory.length - 1), (int)memberDetails.size());
                            for (PartitionMemberInfo mbrDetails : memberDetails) {
                                TestCase.assertNotNull((Object)mbrDetails);
                                DistributedMember mbr = mbrDetails.getDistributedMember();
                                TestCase.assertNotNull((Object)mbr);
                                int membersIdx = -1;
                                for (int idx = 0; idx < members.length; ++idx) {
                                    if (!mbr.equals(members[idx])) continue;
                                    membersIdx = idx;
                                }
                                TestCase.assertEquals((long)((long)localMaxMemory[membersIdx] * 0x100000L), (long)mbrDetails.getConfiguredMaxMemory());
                                TestCase.assertEquals((long)memberSizes[membersIdx], (long)mbrDetails.getSize());
                                TestCase.assertEquals((int)memberBucketCounts[membersIdx], (int)mbrDetails.getBucketCount());
                                TestCase.assertEquals((int)memberPrimaryCounts[membersIdx], (int)mbrDetails.getPrimaryCount());
                                if (!mbr.equals(ResourceManagerDUnitTest.this.getSystem().getDistributedMember())) continue;
                                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(details.getRegionPath());
                                TestCase.assertEquals((long)((long)pr.getLocalMaxMemory() * 0x100000L), (long)mbrDetails.getConfiguredMaxMemory());
                                PartitionedRegionDataStore ds = pr.getDataStore();
                                TestCase.assertNotNull((Object)ds);
                                TestCase.assertEquals((long)ResourceManagerDUnitTest.this.getSize(ds), (long)mbrDetails.getSize());
                                TestCase.assertEquals((int)ds.getBucketsManaged(), (int)mbrDetails.getBucketCount());
                                TestCase.assertEquals((int)ds.getNumberOfPrimaryBucketsManaged(), (int)mbrDetails.getPrimaryCount());
                            }
                            continue;
                        }
                        TestCase.assertEquals((int)numBuckets[1], (int)details.getConfiguredBucketCount());
                        TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                        TestCase.assertEquals((int)redundantCopies[1], (int)details.getConfiguredRedundantCopies());
                        TestCase.assertEquals((int)redundantCopies[1], (int)details.getActualRedundantCopies());
                        TestCase.assertNull((Object)details.getColocatedWith());
                        memberDetails = details.getPartitionMemberInfo();
                        TestCase.assertNotNull((Object)memberDetails);
                        TestCase.assertEquals((int)1, (int)memberDetails.size());
                        PartitionMemberInfo mbrDetails = (PartitionMemberInfo)memberDetails.iterator().next();
                        TestCase.assertEquals((Object)ResourceManagerDUnitTest.this.getSystem().getDistributedMember(), (Object)mbrDetails.getDistributedMember());
                        PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(details.getRegionPath());
                        TestCase.assertEquals((long)((long)pr.getLocalMaxMemory() * 0x100000L), (long)mbrDetails.getConfiguredMaxMemory());
                        PartitionedRegionDataStore ds = pr.getDataStore();
                        TestCase.assertNotNull((Object)ds);
                        TestCase.assertEquals((long)ResourceManagerDUnitTest.this.getSize(ds), (long)mbrDetails.getSize());
                        TestCase.assertEquals((int)ds.getBucketsManaged(), (int)mbrDetails.getBucketCount());
                        TestCase.assertEquals((int)ds.getNumberOfPrimaryBucketsManaged(), (int)mbrDetails.getPrimaryCount());
                    }
                }
            });
        }
        this.destroyRegions(0, regionPath);
    }

    public void testGetInternalPRDetails() {
        int vm;
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0", this.getUniqueName() + "-PR-1"};
        final int[] numBuckets = new int[]{100, 90};
        final int[] redundantCopies = new int[]{1, 0};
        final int[] localMaxMemory = new int[]{50, 100, 0};
        Integer[] bucketKeys = new Integer[]{0, 42, 76};
        ResourceManagerDUnitTest.assertEquals((int)0, (int)bucketKeys[0].hashCode());
        ResourceManagerDUnitTest.assertEquals((int)42, (int)bucketKeys[1].hashCode());
        ResourceManagerDUnitTest.assertEquals((int)76, (int)bucketKeys[2].hashCode());
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], localMaxMemory[0], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], localMaxMemory[1], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], localMaxMemory[2], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[1], localMaxMemory[0], numBuckets[1], redundantCopies[1]);
        byte[] value = new byte[0x200000];
        this.createBuckets(0, regionPath[0], bucketKeys, value);
        final InternalDistributedMember[] members = new InternalDistributedMember[3];
        final long[] memberSizes = new long[members.length];
        final int[] memberBucketCounts = new int[members.length];
        final int[] memberPrimaryCounts = new int[members.length];
        int i = 0;
        while (i < members.length) {
            vm = i++;
            members[vm] = (InternalDistributedMember)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    return ResourceManagerDUnitTest.this.getSystem().getDistributedMember();
                }
            });
            memberSizes[vm] = (Long)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                    PartitionedRegionDataStore ds = pr.getDataStore();
                    if (ds == null) {
                        return 0L;
                    }
                    return ResourceManagerDUnitTest.this.getSize(ds);
                }
            });
            memberBucketCounts[vm] = (Integer)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                    PartitionedRegionDataStore ds = pr.getDataStore();
                    if (ds == null) {
                        return new Integer(0);
                    }
                    return new Integer(ds.getBucketsManaged());
                }
            });
            memberPrimaryCounts[vm] = (Integer)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                    PartitionedRegionDataStore ds = pr.getDataStore();
                    if (ds == null) {
                        return new Integer(0);
                    }
                    return new Integer(ds.getNumberOfPrimaryBucketsManaged());
                }
            });
        }
        i = 0;
        while (i < localMaxMemory.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    HashSet<InternalPRInfo> detailsSet = new HashSet<InternalPRInfo>();
                    GemFireCacheImpl cache = (GemFireCacheImpl)ResourceManagerDUnitTest.this.getCache();
                    for (PartitionedRegion pr : cache.getPartitionedRegions()) {
                        InternalPRInfo info = pr.getRedundancyProvider().buildPartitionedRegionInfo(true, cache.getResourceManager().getLoadProbe());
                        detailsSet.add(info);
                    }
                    if (vm == 0) {
                        TestCase.assertEquals((int)2, (int)detailsSet.size());
                    } else {
                        TestCase.assertEquals((int)1, (int)detailsSet.size());
                    }
                    for (InternalPRInfo details : detailsSet) {
                        Set memberDetails;
                        TestCase.assertTrue((String)("Unknown regionPath=" + details.getRegionPath()), (details.getRegionPath().contains(regionPath[0]) || details.getRegionPath().contains(regionPath[1]) ? 1 : 0) != 0);
                        if (details.getRegionPath().contains(regionPath[0])) {
                            TestCase.assertEquals((int)numBuckets[0], (int)details.getConfiguredBucketCount());
                            TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                            TestCase.assertEquals((int)redundantCopies[0], (int)details.getConfiguredRedundantCopies());
                            TestCase.assertEquals((int)redundantCopies[0], (int)details.getActualRedundantCopies());
                            TestCase.assertNull((Object)details.getColocatedWith());
                            memberDetails = details.getInternalPartitionDetails();
                            TestCase.assertNotNull((Object)memberDetails);
                            TestCase.assertEquals((int)(localMaxMemory.length - 1), (int)memberDetails.size());
                            for (InternalPartitionDetails mbrDetails : memberDetails) {
                                TestCase.assertNotNull((Object)mbrDetails);
                                DistributedMember mbr = mbrDetails.getDistributedMember();
                                TestCase.assertNotNull((Object)mbr);
                                int membersIdx = -1;
                                for (int idx = 0; idx < members.length; ++idx) {
                                    if (!mbr.equals(members[idx])) continue;
                                    membersIdx = idx;
                                }
                                TestCase.assertEquals((long)(localMaxMemory[membersIdx] * 1024 * 1024), (long)mbrDetails.getConfiguredMaxMemory());
                                TestCase.assertEquals((long)memberSizes[membersIdx], (long)mbrDetails.getSize());
                                TestCase.assertEquals((int)memberBucketCounts[membersIdx], (int)mbrDetails.getBucketCount());
                                TestCase.assertEquals((int)memberPrimaryCounts[membersIdx], (int)mbrDetails.getPrimaryCount());
                                PRLoad load = mbrDetails.getPRLoad();
                                TestCase.assertNotNull((Object)load);
                                TestCase.assertEquals((Object)Float.valueOf(localMaxMemory[membersIdx]), (Object)Float.valueOf(load.getWeight()));
                                int totalBucketBytes = 0;
                                int primaryCount = 0;
                                for (int bid = 0; bid < numBuckets[0]; ++bid) {
                                    long bucketBytes = mbrDetails.getBucketSize(bid);
                                    TestCase.assertTrue((bucketBytes >= 0L ? 1 : 0) != 0);
                                    totalBucketBytes = (int)((long)totalBucketBytes + bucketBytes);
                                    TestCase.assertEquals((Object)Float.valueOf(bucketBytes), (Object)Float.valueOf(load.getReadLoad(bid)));
                                    if (!(load.getWriteLoad(bid) > 0.0f)) continue;
                                    ++primaryCount;
                                }
                                TestCase.assertEquals((int)memberPrimaryCounts[membersIdx], (int)primaryCount);
                                if (!mbr.equals(ResourceManagerDUnitTest.this.getSystem().getDistributedMember())) continue;
                                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(details.getRegionPath());
                                TestCase.assertEquals((long)((long)pr.getLocalMaxMemory() * 0x100000L), (long)mbrDetails.getConfiguredMaxMemory());
                                PartitionedRegionDataStore ds = pr.getDataStore();
                                TestCase.assertNotNull((Object)ds);
                                TestCase.assertEquals((long)ResourceManagerDUnitTest.this.getSize(ds), (long)mbrDetails.getSize());
                                TestCase.assertEquals((int)ds.getBucketsManaged(), (int)mbrDetails.getBucketCount());
                                TestCase.assertEquals((int)ds.getNumberOfPrimaryBucketsManaged(), (int)mbrDetails.getPrimaryCount());
                            }
                            continue;
                        }
                        TestCase.assertEquals((int)numBuckets[1], (int)details.getConfiguredBucketCount());
                        TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                        TestCase.assertEquals((int)redundantCopies[1], (int)details.getConfiguredRedundantCopies());
                        TestCase.assertEquals((int)redundantCopies[1], (int)details.getActualRedundantCopies());
                        TestCase.assertNull((Object)details.getColocatedWith());
                        memberDetails = details.getPartitionMemberInfo();
                        TestCase.assertNotNull((Object)memberDetails);
                        TestCase.assertEquals((int)1, (int)memberDetails.size());
                        PartitionMemberInfo mbrDetails = (PartitionMemberInfo)memberDetails.iterator().next();
                        TestCase.assertEquals((Object)ResourceManagerDUnitTest.this.getSystem().getDistributedMember(), (Object)mbrDetails.getDistributedMember());
                        PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(details.getRegionPath());
                        TestCase.assertEquals((long)((long)pr.getLocalMaxMemory() * 0x100000L), (long)mbrDetails.getConfiguredMaxMemory());
                        PartitionedRegionDataStore ds = pr.getDataStore();
                        TestCase.assertNotNull((Object)ds);
                        TestCase.assertEquals((long)ResourceManagerDUnitTest.this.getSize(ds), (long)mbrDetails.getSize());
                        TestCase.assertEquals((int)ds.getBucketsManaged(), (int)mbrDetails.getBucketCount());
                        TestCase.assertEquals((int)ds.getNumberOfPrimaryBucketsManaged(), (int)mbrDetails.getPrimaryCount());
                    }
                }
            });
        }
        this.destroyRegions(0, regionPath);
    }

    private void createRegion(VM whichVm, final String regionPath, final int localMaxMemory, final int numBuckets, final int redundantCopies, final String colocatedWith) {
        whichVm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(numBuckets).setRedundantCopies(redundantCopies).setColocatedWith(colocatedWith).create());
                RegionAttributes attrs = factory.create();
                Region pr = ResourceManagerDUnitTest.this.createRootRegion(regionPath, attrs);
                TestCase.assertNotNull((Object)pr);
            }
        });
    }

    private void createRegion(VM whichVm, String regionPath, int localMaxMemory, int numBuckets, int redundantCopies) {
        this.createRegion(whichVm, regionPath, localMaxMemory, numBuckets, redundantCopies, null);
    }

    private void createBucket(int vm, String regionPath, Integer bucketKey, byte[] value) {
        this.createBuckets(vm, regionPath, new Integer[]{bucketKey}, value);
    }

    private void createBuckets(int vm, String regionPath, Integer[] bucketKeys, Object value) {
        this.performPuts(vm, regionPath, bucketKeys, value);
    }

    private void performPuts(int vm, final String regionPath, final Integer[] bucketKeys, final Object value) {
        Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region pr = ResourceManagerDUnitTest.this.getCache().getRegion(regionPath);
                for (int i = 0; i < bucketKeys.length; ++i) {
                    pr.put((Object)bucketKeys[i], value);
                }
            }
        });
    }

    private void fillValidationArrays(InternalDistributedMember[] members, long[] memberSizes, int[] memberBucketCounts, int[] memberPrimaryCounts, final String regionPath) {
        int i = 0;
        while (i < members.length) {
            int vm = i++;
            members[vm] = (InternalDistributedMember)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    return ResourceManagerDUnitTest.this.getSystem().getDistributedMember();
                }
            });
            memberSizes[vm] = (Long)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath);
                    PartitionedRegionDataStore ds = pr.getDataStore();
                    if (ds == null) {
                        return 0L;
                    }
                    return ResourceManagerDUnitTest.this.getSize(ds);
                }
            });
            memberBucketCounts[vm] = (Integer)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath);
                    PartitionedRegionDataStore ds = pr.getDataStore();
                    if (ds == null) {
                        return new Integer(0);
                    }
                    return new Integer(ds.getBucketsManaged());
                }
            });
            memberPrimaryCounts[vm] = (Integer)Host.getHost(0).getVM(vm).invoke(new SerializableCallable(){

                public Object call() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath);
                    PartitionedRegionDataStore ds = pr.getDataStore();
                    if (ds == null) {
                        return new Integer(0);
                    }
                    return new Integer(ds.getNumberOfPrimaryBucketsManaged());
                }
            });
        }
    }

    private long getSize(PartitionedRegionDataStore ds) {
        long size = 0L;
        int totalNumBuckets = ds.getPartitionedRegion().getPartitionAttributes().getTotalNumBuckets();
        for (int i = 0; i < totalNumBuckets; ++i) {
            size += ds.getBucketSize(i);
        }
        return size;
    }

    private void destroyRegions(int vm, final String[] regionPath) {
        Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    Region pr = ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    pr.destroyRegion();
                }
            }
        });
    }

    public void testDeposePrimaryBucketMessage() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0"};
        int[] numBuckets = new int[]{1};
        int[] redundantCopies = new int[]{1};
        int[] localMaxMemory = new int[]{100, 100};
        Integer[] bucketKeys = new Integer[]{0};
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], localMaxMemory[0], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], localMaxMemory[1], numBuckets[0], redundantCopies[0]);
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKeys[0], value);
        InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        boolean deposedPrimary = (Boolean)Host.getHost(0).getVM(otherVM).invoke(new SerializableCallable(){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                InternalDistributedMember primaryMember = pr.getRegionAdvisor().getBucketAdvisor(0).getPrimary();
                DeposePrimaryBucketMessage.DeposePrimaryBucketResponse response = DeposePrimaryBucketMessage.send((InternalDistributedMember)primaryMember, (PartitionedRegion)pr, (int)0);
                if (response != null) {
                    response.waitForRepliesUninterruptibly();
                    return true;
                }
                return Boolean.FALSE;
            }
        });
        ResourceManagerDUnitTest.assertTrue((boolean)deposedPrimary);
    }

    public void testBecomePrimaryBucketMessage() {
        int vm;
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0"};
        int[] numBuckets = new int[]{1};
        int[] redundantCopies = new int[]{1};
        int[] localMaxMemory = new int[]{100, 100, 0};
        Integer[] bucketKeys = new Integer[]{0};
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], localMaxMemory[0], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], localMaxMemory[1], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], localMaxMemory[2], numBuckets[0], redundantCopies[0]);
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKeys[0], value);
        final InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        int accessorVM = 2;
        ResourceManagerDUnitTest.assertTrue((accessorVM != primaryVM && accessorVM != otherVM ? 1 : 0) != 0);
        final int finalOtherVM = otherVM;
        boolean becamePrimary = (Boolean)Host.getHost(0).getVM(accessorVM).invoke(new SerializableCallable(){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                BecomePrimaryBucketMessage.BecomePrimaryBucketResponse response = BecomePrimaryBucketMessage.send((InternalDistributedMember)members[finalOtherVM], (PartitionedRegion)pr, (int)0, (boolean)false);
                if (response != null) {
                    return response.waitForResponse();
                }
                return Boolean.FALSE;
            }
        });
        ResourceManagerDUnitTest.assertTrue((boolean)becamePrimary);
        int i = 0;
        while (i < localMaxMemory.length) {
            vm = i++;
            this.performPuts(vm, regionPath[0], bucketKeys, value);
        }
        i = 0;
        while (i < localMaxMemory.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                    BucketAdvisor advisor = pr.getRegionAdvisor().getBucketAdvisor(0);
                    TestCase.assertEquals((Object)members[finalOtherVM], (Object)advisor.getPrimary());
                }
            });
        }
    }

    private void doOpDuringBucketRemove(final OpDuringBucketRemove op) {
        final String[] regionPath = new String[]{this.getUniqueName() + "_PR_0"};
        int[] numBuckets = new int[]{1};
        int[] redundantCopies = new int[]{1};
        int[] localMaxMemory = new int[]{100, 100};
        final Integer KEY = 69;
        Integer[] bucketKeys = new Integer[]{KEY};
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], localMaxMemory[0], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], localMaxMemory[1], numBuckets[0], redundantCopies[0]);
        String VALUE = "doOpDuringBucketRemove.VALUE";
        this.createBuckets(0, regionPath[0], bucketKeys, "doOpDuringBucketRemove.VALUE");
        InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertTrue((String)"Target member is not hosting bucket to remove", (boolean)bucket.isHosting());
                TestCase.assertNotNull((String)"Bucket is null on target member", (Object)bucket);
                TestCase.assertNotNull((String)"BucketRegion is null on target member", (Object)bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion());
                EntrySnapshot re = (EntrySnapshot)pr.getEntry((Object)KEY);
                TestCase.assertEquals((boolean)true, (boolean)re.wasInitiallyLocal());
                TestCase.assertEquals((boolean)false, (boolean)re.isLocal());
                TestCase.assertEquals((Object)"doOpDuringBucketRemove.VALUE", (Object)re.getValue());
            }
        });
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                final boolean[] invoked = new boolean[]{false};
                final PartitionedRegionDataStore prds = pr.getDataStore();
                prds.setBucketReadHook(new Runnable(){

                    @Override
                    public void run() {
                        invoked[0] = true;
                        pr.getLogWriterI18n().info(LocalizedStrings.DEBUG, (Object)"in bucketReadHook");
                        prds.removeBucket(0, false);
                    }
                });
                try {
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    TestCase.assertTrue((String)"Target member is not hosting bucket to remove", (boolean)bucket.isHosting());
                    TestCase.assertNotNull((String)"Bucket is null on target member", (Object)bucket);
                    TestCase.assertNotNull((String)"BucketRegion is null on target member", (Object)bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion());
                    TestCase.assertEquals((boolean)false, (boolean)invoked[0]);
                    op.runit(pr, KEY, "doOpDuringBucketRemove.VALUE");
                    TestCase.assertEquals((boolean)true, (boolean)invoked[0]);
                }
                finally {
                    prds.setBucketReadHook(null);
                }
            }
        });
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertFalse((String)"Target member is still hosting removed bucket", (boolean)bucket.isHosting());
                TestCase.assertNull((Object)bucketRegion);
                EntrySnapshot re = (EntrySnapshot)pr.getEntry((Object)KEY);
                TestCase.assertEquals((boolean)false, (boolean)re.wasInitiallyLocal());
                TestCase.assertEquals((boolean)false, (boolean)re.isLocal());
                TestCase.assertEquals((Object)"doOpDuringBucketRemove.VALUE", (Object)re.getValue());
            }
        });
    }

    public void testRemoveDuringGetEntry() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                Region.Entry re = pr.getEntry(key);
                TestCase.assertNotNull((String)"region entry should have existed", (Object)re);
                TestCase.assertEquals((boolean)false, (boolean)re.isLocal());
                TestCase.assertEquals((Object)value, (Object)re.getValue());
            }
        });
    }

    public void testRemoveDuringGet() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                TestCase.assertEquals((Object)value, (Object)pr.get(key));
            }
        });
    }

    public void testRemoveDuringContainsKey() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                TestCase.assertEquals((boolean)true, (boolean)pr.containsKey(key));
            }
        });
    }

    public void testRemoveDuringContainsValueForKey() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                TestCase.assertEquals((boolean)true, (boolean)pr.containsValueForKey(key));
            }
        });
    }

    public void testRemoveDuringKeySet() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                TestCase.assertEquals(Collections.singleton(key), (Object)pr.keySet());
            }
        });
    }

    public void testRemoveDuringValues() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                TestCase.assertEquals(Collections.singleton(value), (Object)pr.values());
            }
        });
    }

    public void testRemoveDuringEntrySet() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                Iterator it = pr.entrySet(false).iterator();
                Region.Entry re = (Region.Entry)it.next();
                TestCase.assertEquals((Object)value, (Object)re.getValue());
                TestCase.assertEquals((Object)key, (Object)re.getKey());
                TestCase.assertEquals((boolean)false, (boolean)it.hasNext());
            }
        });
    }

    public void testRemoveDuringQuery() {
        this.doOpDuringBucketRemove(new OpDuringBucketRemove(){

            @Override
            public void runit(PartitionedRegion pr, Object key, Object value) {
                try {
                    SelectResults sr = pr.query("toString()='doOpDuringBucketRemove.VALUE'");
                    TestCase.assertEquals((int)1, (int)sr.size());
                    TestCase.assertEquals((Object)value, sr.iterator().next());
                }
                catch (QueryException ex) {
                    DistributedTestCase.fail("didn't expect a QueryException", ex);
                }
                catch (QueryInvalidException ex2) {
                    DistributedTestCase.fail("didn't expect QueryInvalidException", ex2);
                }
            }
        });
    }

    public void testRemoveBucketMessage() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0"};
        int[] numBuckets = new int[]{1};
        int[] redundantCopies = new int[]{1};
        int[] localMaxMemory = new int[]{100, 100};
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], localMaxMemory[0], numBuckets[0], redundantCopies[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], localMaxMemory[1], numBuckets[0], redundantCopies[0]);
        Integer bucketKey = 0;
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKey, value);
        final InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        final int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertTrue((String)"Target member is not hosting bucket to remove", (boolean)bucket.isHosting());
                TestCase.assertNotNull((String)"Bucket is null on target member", (Object)bucket);
                TestCase.assertNotNull((String)"BucketRegion is null on target member", (Object)bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion());
            }
        });
        boolean sentRemoveBucket = (Boolean)Host.getHost(0).getVM(primaryVM).invoke(new SerializableCallable(){

            public Object call() {
                InternalDistributedMember recipient = members[finalOtherVM];
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                RemoveBucketMessage.RemoveBucketResponse response = RemoveBucketMessage.send((InternalDistributedMember)recipient, (PartitionedRegion)pr, (int)0, (boolean)false);
                if (response != null) {
                    response.waitForRepliesUninterruptibly();
                    return true;
                }
                return Boolean.FALSE;
            }
        });
        ResourceManagerDUnitTest.assertTrue((String)"Failed to get reply to RemoveBucketMessage", (boolean)sentRemoveBucket);
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertFalse((String)"Target member is still hosting removed bucket", (boolean)bucket.isHosting());
                TestCase.assertNull((String)"BucketRegion is not null on target member", (Object)bucketRegion);
            }
        });
    }

    public void testRemoveColocatedBuckets() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0", this.getUniqueName() + "-PR-1", this.getUniqueName() + "-PR-2"};
        boolean numBuckets = true;
        boolean redundantCopies = true;
        int localMaxMemory = 100;
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[2], 100, 1, 1, regionPath[1]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[2], 100, 1, 1, regionPath[1]);
        Integer bucketKey = 0;
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKey, value);
        this.createBucket(0, regionPath[1], bucketKey, value);
        this.createBucket(0, regionPath[2], bucketKey, value);
        final InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        final int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    TestCase.assertTrue((String)("Target member is not hosting bucket to remove for " + regionPath[i]), (boolean)bucket.isHosting());
                    TestCase.assertNotNull((String)("Bucket is null on target member for " + regionPath[i]), (Object)bucket);
                    TestCase.assertNotNull((String)("BucketRegion is null on target member for " + regionPath[i]), (Object)bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion());
                }
            }
        });
        boolean sentRemoveBucket = (Boolean)Host.getHost(0).getVM(primaryVM).invoke(new SerializableCallable(){

            public Object call() {
                InternalDistributedMember recipient = members[finalOtherVM];
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                RemoveBucketMessage.RemoveBucketResponse response = RemoveBucketMessage.send((InternalDistributedMember)recipient, (PartitionedRegion)pr, (int)0, (boolean)false);
                if (response != null) {
                    response.waitForRepliesUninterruptibly();
                    return true;
                }
                return Boolean.FALSE;
            }
        });
        ResourceManagerDUnitTest.assertTrue((String)"Failed to get reply to RemoveBucketMessage", (boolean)sentRemoveBucket);
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                    TestCase.assertFalse((String)("Target member is still hosting removed bucket for " + regionPath[i]), (boolean)bucket.isHosting());
                    TestCase.assertNull((String)("BucketRegion is not null on target member for " + regionPath[i]), (Object)bucketRegion);
                }
            }
        });
    }

    public void testCreateRedundantBucket() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0"};
        boolean numBuckets = true;
        boolean redundantCopies = true;
        int localMaxMemory = 100;
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], 100, 1, 1);
        Integer bucketKey = 0;
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKey, value);
        InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertNotNull((String)"Bucket is null on SRC member", (Object)bucket);
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertTrue((String)"SRC member is not hosting bucket", (boolean)bucket.isHosting());
                TestCase.assertNotNull((String)"BucketRegion is null on SRC member", (Object)bucketRegion);
                int redundancy = bucket.getBucketAdvisor().getBucketRedundancy();
                TestCase.assertEquals((String)("SRC member reports redundancy " + redundancy), (int)1, (int)redundancy);
            }
        });
        int finalNewVM = 2;
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], 100, 1, 1);
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                TestCase.assertEquals((Object)PartitionedRegionDataStore.CreateBucketResult.CREATED, (Object)pr.getDataStore().createRedundantBucket(0, false, new InternalDistributedMember()));
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertNotNull((String)"Bucket is null on DST member", (Object)bucket);
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertTrue((String)"DST member is not hosting bucket", (boolean)bucket.isHosting());
                TestCase.assertNotNull((String)"BucketRegion is null on DST member", (Object)bucketRegion);
                TestCase.assertEquals((int)2, (int)bucket.getBucketAdvisor().getBucketRedundancy());
            }
        });
    }

    public void testCreateRedundantColocatedBuckets() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0", this.getUniqueName() + "-PR-1", this.getUniqueName() + "-PR-2"};
        boolean numBuckets = true;
        boolean redundantCopies = true;
        int localMaxMemory = 100;
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[2], 100, 1, 1, regionPath[1]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[2], 100, 1, 1, regionPath[1]);
        Integer bucketKey = 0;
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKey, value);
        this.createBucket(0, regionPath[1], bucketKey, value);
        this.createBucket(0, regionPath[2], bucketKey, value);
        InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    TestCase.assertNotNull((String)("Bucket is null on SRC member for " + regionPath[i]), (Object)bucket);
                    BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                    TestCase.assertTrue((String)("SRC member is not hosting bucket for " + regionPath[i]), (boolean)bucket.isHosting());
                    TestCase.assertNotNull((String)("BucketRegion is null on SRC member for " + regionPath[i]), (Object)bucketRegion);
                    int redundancy = bucket.getBucketAdvisor().getBucketRedundancy();
                    TestCase.assertEquals((String)("SRC member reports redundancy " + redundancy + " for " + regionPath[i]), (int)1, (int)redundancy);
                }
            }
        });
        int finalNewVM = 2;
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[2], 100, 1, 1, regionPath[1]);
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    if (i == 0) {
                        pr.getDataStore().createRedundantBucket(0, false, new InternalDistributedMember());
                    }
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    TestCase.assertNotNull((String)"Bucket is null on DST member", (Object)bucket);
                    BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                    TestCase.assertTrue((String)"DST member is not hosting bucket", (boolean)bucket.isHosting());
                    TestCase.assertNotNull((String)"BucketRegion is null on DST member", (Object)bucketRegion);
                    TestCase.assertEquals((int)2, (int)bucket.getBucketAdvisor().getBucketRedundancy());
                }
            }
        });
    }

    public void testMoveBucket() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0"};
        boolean numBuckets = true;
        boolean redundantCopies = true;
        int localMaxMemory = 100;
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], 100, 1, 1);
        Integer bucketKey = 0;
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKey, value);
        final InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        final int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertNotNull((String)"Bucket is null on SRC member", (Object)bucket);
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertTrue((String)"SRC member is not hosting bucket", (boolean)bucket.isHosting());
                TestCase.assertNotNull((String)"BucketRegion is null on SRC member", (Object)bucketRegion);
                int redundancy = bucket.getBucketAdvisor().getBucketRedundancy();
                TestCase.assertEquals((String)("SRC member reports redundancy " + redundancy), (int)1, (int)redundancy);
            }
        });
        int finalNewVM = 2;
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], 100, 1, 1);
        boolean movedBucket = (Boolean)Host.getHost(0).getVM(2).invoke(new SerializableCallable(){

            public Object call() {
                InternalDistributedMember recipient = members[finalOtherVM];
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                return pr.getDataStore().moveBucket(0, recipient, true);
            }
        });
        ResourceManagerDUnitTest.assertTrue((String)"Failed in call to moveBucket", (boolean)movedBucket);
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertFalse((String)"SRC member is still hosting moved bucket", (boolean)bucket.isHosting());
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertNull((String)"BucketRegion is not null on SRC member", (Object)bucketRegion);
            }
        });
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[0]);
                Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                TestCase.assertNotNull((String)"Bucket is null on DST member", (Object)bucket);
                BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                TestCase.assertTrue((String)"DST member is not hosting bucket", (boolean)bucket.isHosting());
                TestCase.assertNotNull((String)"BucketRegion is null on DST member", (Object)bucketRegion);
                TestCase.assertEquals((int)1, (int)bucket.getBucketAdvisor().getBucketRedundancy());
            }
        });
    }

    public void testMoveColocatedBuckets() {
        final String[] regionPath = new String[]{this.getUniqueName() + "-PR-0", this.getUniqueName() + "-PR-1", this.getUniqueName() + "-PR-2"};
        boolean numBuckets = true;
        boolean redundantCopies = true;
        int localMaxMemory = 100;
        this.createRegion(Host.getHost(0).getVM(0), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(0), regionPath[2], 100, 1, 1, regionPath[1]);
        this.createRegion(Host.getHost(0).getVM(1), regionPath[2], 100, 1, 1, regionPath[1]);
        Integer bucketKey = 0;
        byte[] value = new byte[1];
        this.createBucket(0, regionPath[0], bucketKey, value);
        this.createBucket(0, regionPath[1], bucketKey, value);
        this.createBucket(0, regionPath[2], bucketKey, value);
        InternalDistributedMember[] members = new InternalDistributedMember[2];
        long[] memberSizes = new long[members.length];
        int[] memberBucketCounts = new int[members.length];
        int[] memberPrimaryCounts = new int[members.length];
        this.fillValidationArrays(members, memberSizes, memberBucketCounts, memberPrimaryCounts, regionPath[0]);
        int primaryVM = -1;
        int otherVM = -1;
        for (int i = 0; i < memberPrimaryCounts.length; ++i) {
            if (memberPrimaryCounts[i] == 0) {
                otherVM = i;
                continue;
            }
            if (memberPrimaryCounts[i] != 1) continue;
            primaryVM = i;
        }
        ResourceManagerDUnitTest.assertTrue((primaryVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((otherVM > -1 ? 1 : 0) != 0);
        ResourceManagerDUnitTest.assertTrue((primaryVM != otherVM ? 1 : 0) != 0);
        int finalOtherVM = otherVM;
        Host.getHost(0).getVM(otherVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    TestCase.assertNotNull((String)"Bucket is null on SRC member", (Object)bucket);
                    BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                    TestCase.assertTrue((String)"SRC member is not hosting bucket", (boolean)bucket.isHosting());
                    TestCase.assertNotNull((String)"BucketRegion is null on SRC member", (Object)bucketRegion);
                    int redundancy = bucket.getBucketAdvisor().getBucketRedundancy();
                    TestCase.assertEquals((String)("SRC member reports redundancy " + redundancy), (int)1, (int)redundancy);
                }
            }
        });
        int finalNewVM = 2;
        this.createRegion(Host.getHost(0).getVM(2), regionPath[0], 100, 1, 1);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[1], 100, 1, 1, regionPath[0]);
        this.createRegion(Host.getHost(0).getVM(2), regionPath[2], 100, 1, 1, regionPath[1]);
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                for (int i = 0; i < regionPath.length; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)ResourceManagerDUnitTest.this.getCache().getRegion(regionPath[i]);
                    if (i == 0) {
                        TestCase.assertEquals((Object)PartitionedRegionDataStore.CreateBucketResult.CREATED, (Object)pr.getDataStore().createRedundantBucket(0, false, new InternalDistributedMember()));
                    }
                    Bucket bucket = pr.getRegionAdvisor().getBucket(0);
                    TestCase.assertNotNull((String)"Bucket is null on DST member", (Object)bucket);
                    BucketRegion bucketRegion = bucket.getBucketAdvisor().getProxyBucketRegion().getHostedBucketRegion();
                    TestCase.assertTrue((String)"DST member is not hosting bucket", (boolean)bucket.isHosting());
                    TestCase.assertNotNull((String)"BucketRegion is null on DST member", (Object)bucketRegion);
                    TestCase.assertEquals((int)2, (int)bucket.getBucketAdvisor().getBucketRedundancy());
                }
            }
        });
    }

    private static interface OpDuringBucketRemove
    extends Serializable {
        public void runit(PartitionedRegion var1, Object var2, Object var3);
    }
}

